package eu.isas.reporter.gui.settings;

import eu.isas.reporter.gui.settings.quantification.NormalizationSettingsDialog;
import eu.isas.reporter.gui.settings.quantification.ReporterIonSelectionSettingsDialog;
import eu.isas.reporter.gui.settings.quantification.RatioEstimationSettingsDialog;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import eu.isas.reporter.settings.NormalizationSettings;
import eu.isas.reporter.settings.RatioEstimationSettings;
import eu.isas.reporter.settings.ReporterIonSelectionSettings;
import eu.isas.reporter.settings.ReporterSettings;
import javax.swing.JDialog;

/**
 * The preferences dialog.
 *
 * @author Marc Vaudel
 * @author Harald Barsnes
 */
public class ReporterSettingsDialog extends javax.swing.JDialog {

    /**
     * Boolean indicating whether the editing of the settings has been canceled.
     */
    private boolean canceled = false;
    /**
     * The reporter method used.
     */
    private ReporterMethod reporterMethod = null;
    /**
     * The modification parameters of the search.
     */
    private ModificationParameters modificationParameters;
    /**
     * The settings for the selection of the reporter ions in spectra
     */
    private ReporterIonSelectionSettings reporterIonSelectionSettings;
    /**
     * The ratio estimation settings
     */
    private RatioEstimationSettings ratioEstimationSettings;
    /**
     * The normalization settings.
     */
    private NormalizationSettings normalizationSettings;
    /**
     * Boolean indicating whether the user can edit the settings.
     */
    private boolean editable;

    /**
     * Creates a new PreferencesDialog.
     *
     * @param parentDialog the parent dialog
     * @param reporterSettings the reporter settings to display
     * @param modificationParameters the modification parameters of the search
     * @param reporterMethod the reporter method used
     * @param editable boolean indicating whether the settings can be edited
     */
    public ReporterSettingsDialog(
            JDialog parentDialog,
            ReporterSettings reporterSettings,
            ModificationParameters modificationParameters,
            ReporterMethod reporterMethod,
            boolean editable
    ) {

        super(parentDialog, true);
        this.reporterIonSelectionSettings = reporterSettings.getReporterIonSelectionSettings();
        this.ratioEstimationSettings = reporterSettings.getRatioEstimationSettings();
        this.normalizationSettings = reporterSettings.getNormalizationSettings();
        this.modificationParameters = modificationParameters;
        this.reporterMethod = reporterMethod;
        this.editable = editable;
        initComponents();
        setLocationRelativeTo(parentDialog);
        setVisible(true);

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        settingsPanel = new javax.swing.JPanel();
        reporterIonSelectionButton = new javax.swing.JButton();
        ratioEstimationButton = new javax.swing.JButton();
        normalizationButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Quantification Advanced Settings");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        backgroundPanel.setBackground(new java.awt.Color(230, 230, 230));

        settingsPanel.setBackground(new java.awt.Color(230, 230, 230));
        settingsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Reporter Ion Quantification Settings"));

        reporterIonSelectionButton.setFont(reporterIonSelectionButton.getFont().deriveFont(reporterIonSelectionButton.getFont().getStyle() | java.awt.Font.BOLD, reporterIonSelectionButton.getFont().getSize()+3));
        reporterIonSelectionButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/RatioPencil.png"))); // NOI18N
        reporterIonSelectionButton.setText("Reporter Ions");
        reporterIonSelectionButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        reporterIonSelectionButton.setIconTextGap(40);
        reporterIonSelectionButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reporterIonSelectionButtonActionPerformed(evt);
            }
        });

        ratioEstimationButton.setFont(ratioEstimationButton.getFont().deriveFont(ratioEstimationButton.getFont().getStyle() | java.awt.Font.BOLD, ratioEstimationButton.getFont().getSize()+3));
        ratioEstimationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/RatioRuler.png"))); // NOI18N
        ratioEstimationButton.setText("Ratio Estimation");
        ratioEstimationButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        ratioEstimationButton.setIconTextGap(38);
        ratioEstimationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ratioEstimationButtonActionPerformed(evt);
            }
        });

        normalizationButton.setFont(normalizationButton.getFont().deriveFont(normalizationButton.getFont().getStyle() | java.awt.Font.BOLD, normalizationButton.getFont().getSize()+3));
        normalizationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/RatioCalculator.png"))); // NOI18N
        normalizationButton.setText("Normalization");
        normalizationButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        normalizationButton.setIconTextGap(40);
        normalizationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                normalizationButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout settingsPanelLayout = new javax.swing.GroupLayout(settingsPanel);
        settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(
            settingsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(settingsPanelLayout.createSequentialGroup()
                .addGap(45, 45, 45)
                .addGroup(settingsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(reporterIonSelectionButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(ratioEstimationButton, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .addComponent(normalizationButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(45, 45, 45))
        );
        settingsPanelLayout.setVerticalGroup(
            settingsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(settingsPanelLayout.createSequentialGroup()
                .addGap(25, 25, 25)
                .addComponent(reporterIonSelectionButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ratioEstimationButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(normalizationButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(25, Short.MAX_VALUE))
        );

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(settingsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(cancelButton)))
                .addContainerGap())
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(settingsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Open the ReporterIonSelectionSettingsDialog.
     *
     * @param evt
     */
    private void reporterIonSelectionButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reporterIonSelectionButtonActionPerformed

        ReporterIonSelectionSettingsDialog reporterIonSelectionSettingsDialog
                = new ReporterIonSelectionSettingsDialog(
                        this,
                        reporterIonSelectionSettings,
                        reporterMethod,
                        editable
                );

        if (!reporterIonSelectionSettingsDialog.isCanceled()) {
            reporterIonSelectionSettings = reporterIonSelectionSettingsDialog.getReporterIonSelectionSettings();
        }

    }//GEN-LAST:event_reporterIonSelectionButtonActionPerformed

    /**
     * Open the RatioEstimationSettingsDialog.
     *
     * @param evt
     */
    private void ratioEstimationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ratioEstimationButtonActionPerformed

        RatioEstimationSettingsDialog ratioEstimationSettingsDialog
                = new RatioEstimationSettingsDialog(
                        this,
                        ratioEstimationSettings,
                        modificationParameters,
                        editable
                );

        if (!ratioEstimationSettingsDialog.isCanceled()) {
            ratioEstimationSettings = ratioEstimationSettingsDialog.getRatioEstimationSettings();
        }

    }//GEN-LAST:event_ratioEstimationButtonActionPerformed

    /**
     * Open the NormalizationSettingsDialog.
     *
     * @param evt
     */
    private void normalizationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_normalizationButtonActionPerformed

        NormalizationSettingsDialog normalizationSettingsDialog
                = new NormalizationSettingsDialog(
                        this,
                        normalizationSettings,
                        editable
                );

        if (!normalizationSettingsDialog.isCanceled()) {
            normalizationSettings = normalizationSettingsDialog.getNormalizationSettings();
        }

    }//GEN-LAST:event_normalizationButtonActionPerformed

    /**
     * Close the dialog without saving the settings.
     *
     * @param evt
     */
    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        canceled = true;
    }//GEN-LAST:event_formWindowClosing

    /**
     * Close the dialog and cancel the changes.
     * 
     * @param evt 
     */
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed

        canceled = true;
        dispose();

    }//GEN-LAST:event_cancelButtonActionPerformed

    /**
     * Close the dialog.
     *
     * @param evt
     */
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton normalizationButton;
    private javax.swing.JButton okButton;
    private javax.swing.JButton ratioEstimationButton;
    private javax.swing.JButton reporterIonSelectionButton;
    private javax.swing.JPanel settingsPanel;
    // End of variables declaration//GEN-END:variables

    /**
     * Indicates whether the user canceled the editing.
     *
     * @return a boolean indicating whether the user canceled the editing
     */
    public boolean isCanceled() {
        return canceled;
    }

    /**
     * Returns the reporter settings as set by the user.
     *
     * @return the reporter settings as set by the user
     */
    public ReporterSettings getReporterSettings() {

        ReporterSettings reporterSettings = new ReporterSettings();
        reporterSettings.setReporterIonSelectionSettings(reporterIonSelectionSettings);
        reporterSettings.setRatioEstimationSettings(ratioEstimationSettings);
        reporterSettings.setNormalizationSettings(normalizationSettings);

        return reporterSettings;

    }
}
