/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation;

import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.quantification.reporterion.Reagent;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.calculation.CorrectionMatrix;
import java.util.ArrayList;
import java.util.HashMap;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Ginv;

public class Deisotoper {
    private HashMap<String, CorrectionMatrix> correctionMatrices;
    private ReporterMethod method;

    public Deisotoper(ReporterMethod method, double tolerance) {
        this.method = method;
        this.estimateCorrectionFactors(tolerance);
    }

    private void estimateCorrectionFactors(double tolerance) {
        this.correctionMatrices = new HashMap();
        ArrayList labels = new ArrayList(this.method.getReagentNames());
        HashMap<Double, String> massesToLabelMap = new HashMap<Double, String>(labels.size());
        for (String label : labels) {
            double mass = this.method.getReporterIon(label).getTheoreticMass();
            if (massesToLabelMap.containsKey(mass)) {
                throw new IllegalArgumentException("Two labels were found at the same mass (" + mass + ").");
            }
            massesToLabelMap.put(mass, label);
        }
        while (!labels.isEmpty()) {
            Double maxMass = null;
            Double minMass = null;
            for (Double mass : massesToLabelMap.keySet()) {
                if (!labels.contains(massesToLabelMap.get(mass))) continue;
                if (maxMass == null || mass > maxMass) {
                    maxMass = mass;
                }
                if (minMass != null && !(mass < minMass)) continue;
                minMass = mass;
            }
            HashMap<Integer, String> isotopes = new HashMap<Integer, String>();
            int isotopeCount = 2;
            int isotopeMax = 2;
            for (double isotopeMass = minMass.doubleValue(); isotopeMass <= maxMass + tolerance; isotopeMass += Atom.C.getDifferenceToMonoisotopic(1)) {
                for (Double mass : massesToLabelMap.keySet()) {
                    if (!labels.contains(massesToLabelMap.get(mass)) || !(Math.abs(mass - isotopeMass) < tolerance)) continue;
                    if (isotopes.containsKey(isotopeCount)) {
                        throw new IllegalArgumentException("More than one reagent correspond to the mass " + isotopeMass + " using the given tolerance (" + tolerance + ")");
                    }
                    String label = (String)massesToLabelMap.get(mass);
                    isotopes.put(isotopeCount, label);
                    labels.remove(label);
                    isotopeMax = isotopeCount;
                }
                ++isotopeCount;
            }
            double refMass = this.method.getReagent((String)isotopes.get(2)).getReporterIon().getTheoreticMass() - 2.0 * Atom.C.getDifferenceToMonoisotopic(1);
            double[][] coefficients = new double[isotopeCount += 2][isotopeCount];
            ArrayList<String> matrixLabels = new ArrayList<String>();
            for (int i = 2; i <= isotopeMax; ++i) {
                String label = (String)isotopes.get(i);
                if (label == null) continue;
                matrixLabels.add(label);
                Reagent reagent = this.method.getReagent(label);
                double totalIntensity = reagent.getMinus2() + reagent.getMinus1() + reagent.getRef() + reagent.getPlus1() + reagent.getPlus2();
                coefficients[i - 2][i] = reagent.getMinus2() / totalIntensity;
                coefficients[i - 1][i] = reagent.getMinus1() / totalIntensity;
                coefficients[i][i] = reagent.getRef() / totalIntensity;
                coefficients[i + 1][i] = reagent.getPlus1() / totalIntensity;
                coefficients[i + 2][i] = reagent.getPlus2() / totalIntensity;
            }
            coefficients = Ginv.inverse((double[][])coefficients).toDoubleArray();
            CorrectionMatrix matrix = new CorrectionMatrix(coefficients, isotopes, refMass);
            for (String label : matrixLabels) {
                this.correctionMatrices.put(label, matrix);
            }
        }
    }

    public HashMap<String, Double> deisotope(HashMap<String, IonMatch> ionMatches, Spectrum spectrum, double mzTolerance, boolean mostAccurate) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (String label : this.method.getReagentNames()) {
            IonMatch refMatch = ionMatches.get(label);
            if (refMatch != null && refMatch.peakIntensity > 0.0) {
                CorrectionMatrix correctionMatrix = this.correctionMatrices.get(label);
                HashMap<Integer, String> involvedReagents = correctionMatrix.getReagentsNames();
                int dimension = correctionMatrix.getDimension();
                double[] intensities = new double[dimension];
                int lineNumber = -1;
                for (int i = 0; i < dimension; ++i) {
                    double reagentMass;
                    ReporterIon tempIon;
                    IonMatch ionMatch;
                    String reagentName = involvedReagents.get(i);
                    if (reagentName != null && reagentName.equals(label)) {
                        lineNumber = i;
                    }
                    if ((ionMatch = Reporter.getBestReporterIonMatch(tempIon = new ReporterIon("tempIon", reagentMass = correctionMatrix.getReagentMass(i), false), 1, spectrum, mzTolerance, mostAccurate)) == null) continue;
                    intensities[i] = ionMatch.peakIntensity;
                }
                if (lineNumber == -1) {
                    throw new IllegalArgumentException("Index of reagent " + label + " not found in the isotope correction matrix.");
                }
                double resultInt = 0.0;
                for (int j = 0; j < intensities.length; ++j) {
                    resultInt += intensities[j] * correctionMatrix.getValueAt(lineNumber, j);
                }
                if (resultInt < 0.0) {
                    resultInt = 0.0;
                }
                result.put(label, resultInt);
                continue;
            }
            result.put(label, 0.0);
        }
        return result;
    }
}

