/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.calculation.Deisotoper;
import eu.isas.reporter.calculation.QuantificationFeaturesCache;
import eu.isas.reporter.quantificationdetails.PeptideQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinPtmQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinQuantificationDetails;
import eu.isas.reporter.quantificationdetails.PsmQuantificationDetails;
import eu.isas.reporter.quantificationdetails.SpectrumQuantificationDetails;
import eu.isas.reporter.settings.ReporterIonSelectionSettings;
import eu.isas.reporter.settings.ReporterSettings;
import java.io.IOException;
import java.sql.SQLException;

public class QuantificationFeaturesGenerator {
    private QuantificationFeaturesCache quantificationFeaturesCache;
    private Identification identification;
    private IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private Deisotoper deisotoper;
    private ReporterSettings reporterSettings;
    private ReporterIonQuantification reporterIonQuantification;
    private SearchParameters searchParameters;
    private SequenceMatchingParameters sequenceMatchingParameters;

    public QuantificationFeaturesGenerator(QuantificationFeaturesCache quantificationFeaturesCache, Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, ReporterSettings reporterSettings, ReporterIonQuantification reporterIonQuantification, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingParameters) {
        this.quantificationFeaturesCache = quantificationFeaturesCache;
        this.identification = identification;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.reporterSettings = reporterSettings;
        this.reporterIonQuantification = reporterIonQuantification;
        this.searchParameters = searchParameters;
        this.sequenceMatchingParameters = sequenceMatchingParameters;
    }

    public ProteinQuantificationDetails getProteinMatchQuantificationDetails(SpectrumProvider spectrumProvider, long matchKey, WaitingHandler waitingHandler) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(matchKey);
        int nPeptides = proteinMatch.getPeptideCount();
        ProteinQuantificationDetails result = this.quantificationFeaturesCache.getProteinMatchQuantificationDetails(nPeptides, matchKey);
        if (result == null) {
            result = Reporter.estimateProteinMatchQuantificationDetails(this.identification, spectrumProvider, this.identificationFeaturesGenerator, this, this.reporterSettings.getRatioEstimationSettings(), this.reporterIonQuantification, this.searchParameters, proteinMatch, waitingHandler);
            this.quantificationFeaturesCache.addProteinMatchQuantificationDetails(nPeptides, matchKey, result);
        }
        return result;
    }

    public ProteinPtmQuantificationDetails getPTMQuantificationDetails(SpectrumProvider spectrumProvider, String ptmName, long matchKey, int site, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        ProteinPtmQuantificationDetails result = this.quantificationFeaturesCache.getPtmQuantificationDetails(ptmName, matchKey, site);
        if (result == null) {
            result = Reporter.estimatePTMQuantificationDetails(this.identification, spectrumProvider, this, this.reporterSettings.getRatioEstimationSettings(), this.reporterIonQuantification, this.searchParameters, this.sequenceMatchingParameters, ptmName, matchKey, site, waitingHandler);
            this.quantificationFeaturesCache.addPtmQuantificationDetails(ptmName, matchKey, site, result);
        }
        return result;
    }

    public PeptideQuantificationDetails getPeptideMatchQuantificationDetails(SpectrumProvider spectrumProvider, PeptideMatch peptideMatch, WaitingHandler waitingHandler) {
        long matchKey;
        int nPsms = peptideMatch.getSpectrumCount();
        PeptideQuantificationDetails result = this.quantificationFeaturesCache.getPeptideMatchQuantificationDetails(nPsms, matchKey = peptideMatch.getKey());
        if (result == null) {
            result = Reporter.estimatePeptideMatchQuantificationDetails(this.identification, spectrumProvider, this, this.reporterSettings.getRatioEstimationSettings(), this.reporterIonQuantification, peptideMatch, waitingHandler);
            this.quantificationFeaturesCache.addPeptideMatchQuantificationDetails(nPsms, matchKey, result);
        }
        return result;
    }

    public PsmQuantificationDetails getPSMQuantificationDetails(SpectrumProvider spectrumProvider, Long matchKey) {
        String spectrumTitle;
        SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(matchKey.longValue());
        String spectrumFile = spectrumMatch.getSpectrumFile();
        PsmQuantificationDetails result = this.quantificationFeaturesCache.getPSMQuantificationDetails(spectrumFile, spectrumTitle = spectrumMatch.getSpectrumTitle());
        if (result == null) {
            result = Reporter.estimatePSMQuantificationDetails(this.identification, spectrumProvider, this, this.reporterSettings.getReporterIonSelectionSettings(), this.reporterSettings.getRatioEstimationSettings(), this.reporterIonQuantification, matchKey);
            this.quantificationFeaturesCache.addPSMQuantificationDetails(spectrumFile, spectrumTitle, result);
        }
        return result;
    }

    public SpectrumQuantificationDetails getSpectrumQuantificationDetails(SpectrumProvider spectrumProvider, ReporterIonQuantification reporterIonQuantification, ReporterIonSelectionSettings reporterIonSelectionSettings, SpectrumMatch aSpectrumMatch) {
        String spectrumTitle;
        String spectrumFile = aSpectrumMatch.getSpectrumFile();
        SpectrumQuantificationDetails result = this.quantificationFeaturesCache.getSpectrumQuantificationDetails(spectrumFile, spectrumTitle = aSpectrumMatch.getSpectrumTitle());
        if (result == null) {
            result = Reporter.estimateSpectrumQuantificationDetails(this.identification, spectrumProvider, this, reporterIonQuantification, reporterIonSelectionSettings, aSpectrumMatch);
            this.quantificationFeaturesCache.addSpectrumQuantificationDetails(spectrumFile, spectrumTitle, result);
        }
        return result;
    }

    public Deisotoper getDeisotoper(ReporterMethod reporterMethod, double reporterIonMassAccuracy) {
        if (this.deisotoper == null) {
            this.deisotoper = new Deisotoper(reporterMethod, reporterIonMassAccuracy);
        }
        return this.deisotoper;
    }

    public QuantificationFeaturesCache getQuantificationFeaturesCache() {
        return this.quantificationFeaturesCache;
    }

    public void setQuantificationFeaturesCache(QuantificationFeaturesCache quantificationFeaturesCache) {
        this.quantificationFeaturesCache = quantificationFeaturesCache;
    }
}

