/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation;

import com.compomics.util.math.BasicMathFunctions;
import eu.isas.reporter.settings.RatioEstimationSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.math.util.FastMath;

public class RatioEstimator {
    public static Double estimateRatios(RatioEstimationSettings ratioEstimationSettings, ArrayList<Double> ratios) {
        if (ratios == null || ratios.isEmpty()) {
            return 0.0;
        }
        if (ratios.size() < 6) {
            return BasicMathFunctions.median(ratios);
        }
        Collections.sort(ratios);
        int nZeros = 0;
        Double ratioMin = null;
        Double ratioMax = null;
        for (double ratio : ratios) {
            if (ratio == 0.0) {
                ++nZeros;
                continue;
            }
            if (ratioMin == null || ratioMin > ratio) {
                ratioMin = ratio;
            }
            if (ratioMax != null && !(ratioMax < ratio)) continue;
            ratioMax = ratio;
        }
        if (nZeros == ratios.size()) {
            return 0.0;
        }
        if (ratioMin.equals(ratioMax)) {
            return ratioMin;
        }
        int nLeft = ratios.size() - 2 * nZeros;
        if (nLeft < 6) {
            return BasicMathFunctions.median(ratios);
        }
        double[] logRatios = new double[nLeft];
        int index = nZeros;
        ratioMin = null;
        ratioMax = null;
        int i = 0;
        while (i < nLeft) {
            double ratio = ratios.get(index);
            double logRatio = FastMath.log10((double)ratio);
            if (ratioMin == null || logRatio < ratioMin) {
                ratioMin = logRatio;
            }
            if (ratioMax == null || logRatio > ratioMax) {
                ratioMax = logRatio;
            }
            logRatios[i] = logRatio;
            ++i;
            ++index;
        }
        if (ratioMax - ratioMin <= ratioEstimationSettings.getRatioResolution()) {
            return BasicMathFunctions.median(ratios);
        }
        double logResult = RatioEstimator.mEstimate(ratioEstimationSettings, logRatios);
        double result = FastMath.pow((double)10.0, (double)logResult);
        return result;
    }

    public static Double mEstimate(RatioEstimationSettings ratioEstimationSettings, double[] ratios) {
        int nRatios;
        double complement = (100.0 - ratioEstimationSettings.getPercentile()) / 200.0;
        if (complement < 0.0 || complement > 100.0) {
            throw new IllegalArgumentException("Incorrect complement window size of " + complement + ".");
        }
        double percentileLow = BasicMathFunctions.percentile((double[])ratios, (double)complement);
        double percentileHigh = BasicMathFunctions.percentile((double[])ratios, (double)(1.0 - complement));
        double window = percentileHigh - percentileLow;
        double halfWindow = window / 2.0;
        double resolution = ratioEstimationSettings.getRatioResolution();
        if (window == 0.0) {
            return BasicMathFunctions.median((double[])ratios);
        }
        double lastTest = ratios[0] - halfWindow;
        int nRatiosMax = 0;
        double step = Math.min(0.01 * window, resolution);
        for (double ratioRef : ratios) {
            if (!(ratioRef + halfWindow > lastTest)) continue;
            double start = Math.max(lastTest, ratioRef - halfWindow);
            lastTest = ratioRef + halfWindow;
            for (double r0 = start; r0 <= lastTest; r0 += step) {
                nRatios = 0;
                for (double ratio : ratios) {
                    if (!(Math.abs(ratio - r0) <= halfWindow)) continue;
                    ++nRatios;
                }
                if (nRatios <= nRatiosMax) continue;
                nRatiosMax = nRatios;
            }
        }
        double bestIntegral = -1.0;
        ArrayList<Double> bestRatios = new ArrayList<Double>();
        lastTest = ratios[0] - halfWindow;
        for (double ratioRef : ratios) {
            if (!(ratioRef + halfWindow > lastTest)) continue;
            double start = Math.max(lastTest, ratioRef - halfWindow);
            lastTest = ratioRef + halfWindow;
            for (double r0 = start; r0 <= lastTest; r0 += step) {
                double integral = 0.0;
                nRatios = 0;
                for (double r : ratios) {
                    if (!(Math.abs(r - r0) <= halfWindow)) continue;
                    ++nRatios;
                    integral += (r - r0) * Math.pow(1.0 - Math.pow((r - r0) / window, 2.0), 2.0);
                }
                if (!((double)nRatios > 0.9 * (double)nRatiosMax)) continue;
                if ((integral = Math.abs(integral)) == bestIntegral || bestIntegral == -1.0) {
                    bestRatios.add(r0);
                    continue;
                }
                if (!(integral < bestIntegral)) continue;
                bestIntegral = integral;
                bestRatios = new ArrayList();
                bestRatios.add(r0);
            }
        }
        if (bestRatios.isEmpty()) {
            throw new IllegalArgumentException("Best ratio not found for the given set of ratios.");
        }
        if (bestRatios.size() == 1) {
            return (Double)bestRatios.get(0);
        }
        double summ = 0.0;
        Iterator iterator = bestRatios.iterator();
        while (iterator.hasNext()) {
            double ratio = (Double)iterator.next();
            summ += ratio;
        }
        return summ /= (double)bestRatios.size();
    }
}

