/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation.clustering.keys;

import eu.isas.reporter.calculation.clustering.ClusterClassKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;

public class PeptideClusterClassKey
implements ClusterClassKey,
Serializable {
    private Boolean starred = false;
    private ArrayList<String> possiblePtms = null;
    private HashSet<String> possiblePtmsAsSet = null;
    private ArrayList<String> forbiddenPtms = null;
    private HashSet<String> forbiddenPtmsAsSet = null;
    private boolean notModified = false;
    private Boolean nTerm = false;
    private Boolean cTerm = false;

    public Boolean isStarred() {
        return this.starred;
    }

    public void setStarred(Boolean starred) {
        this.starred = starred;
    }

    public ArrayList<String> getPossiblePtms() {
        return this.possiblePtms;
    }

    public HashSet<String> getPossiblePtmsAsSet() {
        return this.possiblePtmsAsSet;
    }

    public void setPossiblePtms(ArrayList<String> possiblePtms) {
        this.possiblePtms = possiblePtms;
        this.possiblePtmsAsSet = new HashSet<String>(possiblePtms);
    }

    public ArrayList<String> getForbiddenPtms() {
        return this.forbiddenPtms;
    }

    public HashSet<String> getForbiddenPtmsAsSet() {
        return this.forbiddenPtmsAsSet;
    }

    public void setForbiddenPtms(ArrayList<String> forbiddenPtms) {
        this.forbiddenPtms = forbiddenPtms;
        this.forbiddenPtmsAsSet = new HashSet<String>(this.possiblePtms);
    }

    public boolean isNotModified() {
        return this.notModified;
    }

    public void setNotModified(boolean notModified) {
        this.notModified = notModified;
    }

    public Boolean isNTerm() {
        return this.nTerm;
    }

    public void setnTerm(Boolean nTerm) {
        this.nTerm = nTerm;
    }

    public Boolean isCTerm() {
        return this.cTerm;
    }

    public void setcTerm(Boolean cTerm) {
        this.cTerm = cTerm;
    }

    @Override
    public String getName() {
        StringBuilder name = new StringBuilder();
        if (this.nTerm.booleanValue()) {
            name.append("N-term");
        }
        if (this.cTerm.booleanValue()) {
            if (name.length() > 0) {
                name.append(" ");
            }
            name.append("C-term");
        }
        if (this.notModified) {
            if (name.length() > 0) {
                name.append(" ");
            }
            name.append("Not modified");
        }
        if (this.starred.booleanValue()) {
            if (name.length() > 0) {
                name.append(" ");
            }
            name.append("Starred");
        }
        if (this.possiblePtms != null || this.forbiddenPtms != null) {
            StringBuilder possible = new StringBuilder();
            if (this.possiblePtms != null) {
                for (String possiblePtm : this.possiblePtms) {
                    if (possible.length() > 0) {
                        possible.append(", ");
                    }
                    possible.append(possiblePtm);
                }
            }
            StringBuilder forbidden = new StringBuilder();
            if (this.forbiddenPtms != null) {
                for (String possiblePtm : this.forbiddenPtms) {
                    if (forbidden.length() > 0) {
                        forbidden.append(", ");
                    }
                    forbidden.append(possiblePtm);
                }
            }
            if (possible.length() > 0 && forbidden.length() > 0) {
                if (name.length() > 0) {
                    name.append(" ");
                }
                name.append((CharSequence)possible).append("; but not ").append((CharSequence)forbidden);
            } else if (possible.length() > 0) {
                if (name.length() > 0) {
                    name.append(" ");
                }
                name.append((CharSequence)possible);
            } else if (forbidden.length() > 0) {
                if (name.length() > 0) {
                    name.append(" ");
                }
                name.append((CharSequence)forbidden);
            }
        }
        if (name.length() == 0) {
            return "All";
        }
        return name.toString();
    }

    @Override
    public String getDescription() {
        StringBuilder description = new StringBuilder();
        if (this.starred.booleanValue()) {
            description.append("Starred ");
        } else if (this.nTerm.booleanValue()) {
            description.append("N-terminal ");
        } else if (this.cTerm.booleanValue()) {
            description.append("C-terminal ");
        } else if (this.notModified) {
            description.append("Not Modified ");
        } else {
            description.append("All ");
        }
        description.append("peptides");
        StringBuilder possible = new StringBuilder();
        for (String possiblePtm : this.possiblePtms) {
            if (possible.length() > 0) {
                possible.append(", ");
            }
            possible.append(possiblePtm);
        }
        StringBuilder forbidden = new StringBuilder();
        for (String possiblePtm : this.forbiddenPtms) {
            if (forbidden.length() > 0) {
                forbidden.append(", ");
            }
            forbidden.append(possiblePtm);
        }
        if (possible.length() > 0 && forbidden.length() > 0) {
            description.append(" carrying ").append((CharSequence)possible).append("; but not ").append((CharSequence)forbidden);
        } else if (possible.length() > 0) {
            description.append(" carrying ").append((CharSequence)possible);
        } else {
            description.append(" not carrying ").append((CharSequence)possible);
        }
        return description.toString();
    }

    public String toString() {
        return "Peptide_" + this.getName();
    }
}

