/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.software.settings.UtilitiesPathParameters;
import eu.isas.reporter.cli.PathSettingsCLIParams;
import eu.isas.reporter.preferences.ReporterPathPreferences;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;

public class PathSettingsCLIInputBean {
    private String tempFolder = "";
    private HashMap<String, String> paths = new HashMap();
    private File logFolder = null;
    private Boolean useLogFile = null;

    public PathSettingsCLIInputBean(CommandLine aLine) {
        String id;
        if (aLine.hasOption(PathSettingsCLIParams.USE_LOG_FOLDER.id)) {
            String input = aLine.getOptionValue(PathSettingsCLIParams.USE_LOG_FOLDER.id);
            int index = Integer.parseInt(input.trim());
            this.useLogFile = index == 1;
        }
        if (aLine.hasOption(PathSettingsCLIParams.LOG_FOLDER.id)) {
            this.logFolder = new File(aLine.getOptionValue(PathSettingsCLIParams.LOG_FOLDER.id));
        }
        if (aLine.hasOption(PathSettingsCLIParams.ALL.id)) {
            this.tempFolder = aLine.getOptionValue(PathSettingsCLIParams.ALL.id);
        }
        for (ReporterPathPreferences.ReporterPathKey reporterPathKey : ReporterPathPreferences.ReporterPathKey.values()) {
            id = reporterPathKey.getId();
            if (!aLine.hasOption(id)) continue;
            this.paths.put(id, aLine.getOptionValue(id));
        }
        for (ReporterPathPreferences.ReporterPathKey reporterPathKey : UtilitiesPathParameters.UtilitiesPathKey.values()) {
            id = reporterPathKey.getId();
            if (!aLine.hasOption(id)) continue;
            this.paths.put(id, aLine.getOptionValue(id));
        }
    }

    public String getTempFolder() {
        return this.tempFolder;
    }

    public HashMap<String, String> getPaths() {
        return this.paths;
    }

    public boolean hasInput() {
        return !this.tempFolder.equals("") || !this.paths.isEmpty() || this.logFolder != null || this.useLogFile != null;
    }

    public File getLogFolder() {
        return this.logFolder;
    }

    public boolean useLogFile() {
        if (this.useLogFile == null) {
            return true;
        }
        return this.useLogFile;
    }
}

