/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethodFactory;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.cmd.PeptideShakerCLI;
import eu.isas.peptideshaker.utils.PsdbParent;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.calculation.QuantificationFeaturesCache;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.cli.CLIExportMethods;
import eu.isas.reporter.cli.PathSettingsCLI;
import eu.isas.reporter.cli.ReportCLIInputBean;
import eu.isas.reporter.cli.ReportCLIParams;
import eu.isas.reporter.io.ProjectImporter;
import eu.isas.reporter.settings.ReporterSettings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class ReportCLI
extends PsdbParent {
    private ReportCLIInputBean reportCLIInputBean;
    private EnzymeFactory enzymeFactory;
    private WaitingHandler waitingHandler;
    private ModificationFactory modificationFactory;
    private ReporterMethodFactory methodsFactory = ReporterMethodFactory.getInstance();
    private UtilitiesUserParameters utilitiesUserParameters;
    private ArrayList<File> spectrumFiles = new ArrayList();

    public ReportCLI(ReportCLIInputBean reportCLIInputBean) {
        this.reportCLIInputBean = reportCLIInputBean;
    }

    public Object call() {
        String errorText;
        try {
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
            unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
        }
        catch (Throwable loggerClass) {
            // empty catch block
        }
        this.setDbFolder(PeptideShaker.getMatchesFolder());
        this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        PeptideShaker.instantiateFacories((UtilitiesUserParameters)this.utilitiesUserParameters);
        this.modificationFactory = ModificationFactory.getInstance();
        this.enzymeFactory = EnzymeFactory.getInstance();
        this.loadSpecies();
        try {
            this.methodsFactory.importMethods(Reporter.getMethodsFile());
        }
        catch (Exception e) {
            System.out.println("An error occurred while loading the methods.");
            e.printStackTrace();
            return 1;
        }
        this.waitingHandler = new WaitingHandlerCLIImpl();
        ProjectImporter projectImporter = new ProjectImporter();
        File selectedFile = this.reportCLIInputBean.getPsdbFile();
        this.setPsdbFile(selectedFile);
        try {
            projectImporter.importPeptideShakerProject(this, this.spectrumFiles, this.waitingHandler);
            projectImporter.importReporterProject(this, this.waitingHandler);
        }
        catch (OutOfMemoryError error) {
            System.out.println("Ran out of memory! (runtime.maxMemory(): " + Runtime.getRuntime().maxMemory() + ")");
            errorText = "Reporter used up all the available memory and had to be stopped.<br>Memory boundaries are changed in the the Welcome Dialog (Settings<br>& Help > Settings > Java Memory Settings) or in the Edit menu (Edit<br>Java Options). See also <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">JavaTroubleShooting</a>.";
            this.waitingHandler.appendReport(errorText, true, true);
            error.printStackTrace();
            return 1;
        }
        catch (Exception e) {
            errorText = "An error occurred while reading:\n" + selectedFile + ".\n\nPlease verify that the Reporter version used to create\nthe file is compatible with your version of Reporter.";
            this.waitingHandler.appendReport(errorText, true, true);
            e.printStackTrace();
            return 1;
        }
        String error = PeptideShaker.loadModifications((SearchParameters)this.getIdentificationParameters().getSearchParameters());
        if (error != null) {
            System.out.println(error);
        }
        ReporterSettings reporterSettings = projectImporter.getReporterSettings();
        ReporterIonQuantification reporterIonQuantification = projectImporter.getReporterIonQuantification();
        ReporterMethod selectedMethod = reporterIonQuantification.getReporterMethod();
        HashSet<String> ignoredPtms = reporterSettings.getRatioEstimationSettings().getExcludingPtms();
        if (ignoredPtms != null) {
            for (String string : ignoredPtms) {
                Modification ptm = this.modificationFactory.getModification(string);
                if (ptm != null) continue;
                System.out.println("PTM " + string + " not recognized.");
                return 1;
            }
        }
        QuantificationFeaturesGenerator quantificationFeaturesGenerator = new QuantificationFeaturesGenerator(new QuantificationFeaturesCache(), this.getIdentification(), this.getIdentificationFeaturesGenerator(), reporterSettings, reporterIonQuantification, this.identificationParameters.getSearchParameters(), this.identificationParameters.getSequenceMatchingParameters());
        if (this.reportCLIInputBean.exportNeeded()) {
            for (String reportType : this.reportCLIInputBean.getReportTypes()) {
                try {
                    CLIExportMethods.exportReport(this.reportCLIInputBean, reportType, this.projectParameters.getProjectUniqueName(), this.projectDetails, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.proteinDetailsProvider, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, this.identificationParameters, this.displayParameters.getnAASurroundingPeptides(), this.spectrumCountingParameters, this.waitingHandler);
                }
                catch (Exception e) {
                    this.waitingHandler.appendReport("An error occurred while exporting the " + reportType + ".", true, true);
                    e.printStackTrace();
                    this.waitingHandler.setRunCanceled();
                }
            }
        }
        if (this.reportCLIInputBean.documentationExportNeeded()) {
            for (String reportType : this.reportCLIInputBean.getReportTypes()) {
                try {
                    CLIExportMethods.exportDocumentation(this.reportCLIInputBean, reportType, this.waitingHandler);
                }
                catch (Exception e) {
                    this.waitingHandler.appendReport("An error occurred while exporting the documentation for " + reportType + ".", true, true);
                    e.printStackTrace();
                    this.waitingHandler.setRunCanceled();
                }
            }
        }
        try {
            PeptideShakerCLI.closePeptideShaker((Identification)this.identification);
        }
        catch (Exception exception) {
            this.waitingHandler.appendReport("An error occurred while closing Reporter.", true, true);
            exception.printStackTrace();
        }
        if (!this.waitingHandler.isRunCanceled()) {
            this.waitingHandler.appendReport("Report export completed.", true, true);
            System.exit(0);
            return 0;
        }
        System.exit(1);
        return 1;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The Reporter report command line takes a psdb file and generates various types of reports." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/reporter.html and https://compomics.github.io/projects/reporter/wiki/reportercli.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/reporter_software." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    private static boolean isValidStartup(CommandLine aLine) throws IOException {
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (!aLine.hasOption(ReportCLIParams.PSDB_FILE.id) || aLine.getOptionValue(ReportCLIParams.PSDB_FILE.id).equals("")) {
            System.out.println("\n" + ReportCLIParams.PSDB_FILE.description + " not specified.\n");
            return false;
        }
        String fileTxt = aLine.getOptionValue(ReportCLIParams.PSDB_FILE.id);
        File testFile = new File(fileTxt.trim());
        if (!testFile.exists()) {
            System.out.println("\n" + ReportCLIParams.PSDB_FILE.description + " '" + testFile.getAbsolutePath() + "' not found.\n");
            return false;
        }
        if (!aLine.hasOption(ReportCLIParams.EXPORT_FOLDER.id) || aLine.getOptionValue(ReportCLIParams.EXPORT_FOLDER.id).equals("")) {
            System.out.println("\n" + ReportCLIParams.EXPORT_FOLDER.description + " not specified.\n");
            return false;
        }
        fileTxt = aLine.getOptionValue(ReportCLIParams.EXPORT_FOLDER.id);
        testFile = new File(fileTxt.trim());
        if (!testFile.exists()) {
            System.out.println("\n" + ReportCLIParams.EXPORT_FOLDER.description + " '" + testFile.getAbsolutePath() + "' not found.\n");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            ReportCLIParams.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!ReportCLI.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "===============================================" + System.getProperty("line.separator"));
                lPrintWriter.print("Reporter Report Exporter - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("===============================================" + System.getProperty("line.separator"));
                lPrintWriter.print(ReportCLI.getHeader());
                lPrintWriter.print(ReportCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                ReportCLIInputBean lCLIBean = new ReportCLIInputBean(line);
                ReportCLI cli = new ReportCLI(lCLIBean);
                cli.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("<CompomicsError>Reporter used up all the memory and had to be stopped. See the Reporter log for details.</CompomicsError>");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            System.out.print("<CompomicsError>Reporter processing failed. See the Reporter log for details.</CompomicsError>");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public String toString() {
        return "FollowUpCLI{, cliInputBean=" + this.reportCLIInputBean + '}';
    }

    public void closePeptideShaker() throws IOException, SQLException, InterruptedException {
        this.identification.close(false);
        File matchFolder = PeptideShaker.getMatchesFolder();
        File[] tempFiles = matchFolder.listFiles();
        if (tempFiles != null) {
            for (File currentFile : tempFiles) {
                IoUtil.deleteDir((File)currentFile);
            }
        }
    }

    private void loadSpecies() {
        try {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            speciesFactory.initiate(Reporter.getConfigFolder());
        }
        catch (Exception e) {
            System.out.println("An error occurred while loading the species.");
            e.printStackTrace();
        }
    }
}

