/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.software.cli.CommandParameter;
import com.compomics.util.Util;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.exceptions.exception_handlers.CommandLineExceptionHandler;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.normalization.NormalizationFactors;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethodFactory;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.export.ProjectExport;
import eu.isas.peptideshaker.utils.PsdbParent;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.calculation.QuantificationFeaturesCache;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.calculation.normalization.NormalizationType;
import eu.isas.reporter.calculation.normalization.Normalizer;
import eu.isas.reporter.cli.CLIExportMethods;
import eu.isas.reporter.cli.PathSettingsCLI;
import eu.isas.reporter.cli.ReportCLIInputBean;
import eu.isas.reporter.cli.ReporterCLIInputBean;
import eu.isas.reporter.cli.ReporterCLIParameters;
import eu.isas.reporter.io.ProjectImporter;
import eu.isas.reporter.io.ProjectSaver;
import eu.isas.reporter.preferences.DisplayPreferences;
import eu.isas.reporter.settings.NormalizationSettings;
import eu.isas.reporter.settings.RatioEstimationSettings;
import eu.isas.reporter.settings.ReporterIonSelectionSettings;
import eu.isas.reporter.settings.ReporterIonsLocationType;
import eu.isas.reporter.settings.ReporterSettings;
import eu.isas.reporter.utils.Properties;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ReporterCLI
extends PsdbParent
implements Callable {
    private ReporterCLIInputBean reporterCLIInputBean;
    private ModificationFactory modificationFactory;
    private CommandLine line;
    private ReporterMethodFactory methodsFactory = ReporterMethodFactory.getInstance();
    private UtilitiesUserParameters utilitiesUserParameters;
    private ArrayList<File> spectrumFiles = new ArrayList();
    private ExceptionHandler exceptionHandler = new CommandLineExceptionHandler();

    private ReporterCLI(String[] args) throws ParseException {
        Options lOptions = new Options();
        ReporterCLIParameters.createOptionsCLI(lOptions);
        DefaultParser parser = new DefaultParser();
        this.line = parser.parse(lOptions, args);
    }

    public static boolean isValidCommandLine(CommandLine aLine) {
        String arg;
        String arg2;
        String arg22;
        String arg3;
        if (!aLine.hasOption(ReporterCLIParameters.ID.id) || aLine.getOptionValue(ReporterCLIParameters.ID.id).equals("")) {
            System.out.println(System.getProperty("line.separator") + "PeptideShaker file not specified." + System.getProperty("line.separator"));
            return false;
        }
        String arg32 = aLine.getOptionValue(ReporterCLIParameters.ID.id);
        HashSet<String> supportedFormats = new HashSet<String>(2);
        supportedFormats.add(".psdb");
        supportedFormats.add(".zip");
        if (!CommandParameter.fileExists((String)ReporterCLIParameters.ID.id, (String)arg32, supportedFormats)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.ISOTOPES.id)) {
            arg3 = aLine.getOptionValue(ReporterCLIParameters.ISOTOPES.id);
            supportedFormats = new HashSet(1);
            supportedFormats.add(".xml");
            if (!CommandParameter.fileExists((String)ReporterCLIParameters.ISOTOPES.id, (String)arg3, supportedFormats)) {
                return false;
            }
        }
        if (aLine.hasOption(ReporterCLIParameters.REFERENCE.id)) {
            arg3 = aLine.getOptionValue(ReporterCLIParameters.REFERENCE.id);
            try {
                ArrayList input = CommandLineUtils.getIntegerListFromString((String)arg3, (String)",");
                for (Integer reagent : input) {
                    if (CommandParameter.isPositiveInteger((String)ReporterCLIParameters.REFERENCE.id, (String)(reagent + ""), (boolean)false)) continue;
                    return false;
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "Error parsing the " + ReporterCLIParameters.REFERENCE.id + " option: not a comma separated list of integers." + System.getProperty("line.separator"));
                return false;
            }
        }
        if (aLine.hasOption(ReporterCLIParameters.THREADS.id) && !CommandParameter.isPositiveInteger((String)ReporterCLIParameters.THREADS.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.THREADS.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.ION_TOL.id) && !CommandParameter.isPositiveDouble((String)ReporterCLIParameters.ION_TOL.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.ION_TOL.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.MOST_ACCURATE.id) && !CommandParameter.isBooleanInput((String)ReporterCLIParameters.MOST_ACCURATE.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.MOST_ACCURATE.id)))) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.REPORTER_IONS_LOCATION.id)) {
            arg3 = aLine.getOptionValue(ReporterCLIParameters.REPORTER_IONS_LOCATION.id);
            ArrayList<String> reporterIonsLocationTypes = new ArrayList<String>(ReporterIonsLocationType.values().length);
            for (ReporterIonsLocationType reporterIonsLocationType : ReporterIonsLocationType.values()) {
                reporterIonsLocationTypes.add(reporterIonsLocationType.index + "");
            }
            if (!CommandParameter.isInList((String)ReporterCLIParameters.REPORTER_IONS_LOCATION.id, (String)arg3, reporterIonsLocationTypes)) {
                return false;
            }
        }
        if (aLine.hasOption(ReporterCLIParameters.PREC_WINDOW_MZ_TOL.id) && !CommandParameter.isPositiveDouble((String)ReporterCLIParameters.PREC_WINDOW_MZ_TOL.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.PREC_WINDOW_MZ_TOL.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.PREC_WINDOW_MZ_TOL_PPM.id) && !CommandParameter.isBooleanInput((String)ReporterCLIParameters.PREC_WINDOW_MZ_TOL_PPM.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.PREC_WINDOW_MZ_TOL_PPM.id)))) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.PREC_WINDOW_RT_TOL.id) && !CommandParameter.isPositiveDouble((String)ReporterCLIParameters.PREC_WINDOW_RT_TOL.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.PREC_WINDOW_RT_TOL.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.IGNORE_NULL.id) && !CommandParameter.isBooleanInput((String)ReporterCLIParameters.IGNORE_NULL.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.IGNORE_NULL.id)))) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.IGNORE_MC.id) && !CommandParameter.isBooleanInput((String)ReporterCLIParameters.IGNORE_MC.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.IGNORE_MC.id)))) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.PERCENTILE.id) && !CommandParameter.isPositiveDouble((String)ReporterCLIParameters.PERCENTILE.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.PERCENTILE.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.RESOLUTION.id) && !CommandParameter.isPositiveDouble((String)ReporterCLIParameters.RESOLUTION.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.RESOLUTION.id)), (boolean)false)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.MIN_UNIQUE.id) && !CommandParameter.isInteger((String)ReporterCLIParameters.MIN_UNIQUE.id, (String)(arg3 = aLine.getOptionValue(ReporterCLIParameters.MIN_UNIQUE.id)))) {
            return false;
        }
        ArrayList<String> validationLevels = new ArrayList<String>(3);
        validationLevels.add("0");
        validationLevels.add("1");
        validationLevels.add("2");
        if (aLine.hasOption(ReporterCLIParameters.VALIDATION_PSM.id) && !CommandParameter.isInList((String)ReporterCLIParameters.VALIDATION_PSM.id, (String)(arg22 = aLine.getOptionValue(ReporterCLIParameters.VALIDATION_PSM.id)), validationLevels)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.VALIDATION_PEPTIDE.id) && !CommandParameter.isInList((String)ReporterCLIParameters.VALIDATION_PEPTIDE.id, (String)(arg2 = aLine.getOptionValue(ReporterCLIParameters.VALIDATION_PEPTIDE.id)), validationLevels)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.VALIDATION_PROTEIN.id) && !CommandParameter.isInList((String)ReporterCLIParameters.VALIDATION_PROTEIN.id, (String)(arg2 = aLine.getOptionValue(ReporterCLIParameters.VALIDATION_PROTEIN.id)), validationLevels)) {
            return false;
        }
        ArrayList<String> normalizationTypes = new ArrayList<String>(NormalizationType.values().length);
        for (Enum enum_ : NormalizationType.values()) {
            normalizationTypes.add(((NormalizationType)enum_).index + "");
        }
        if (aLine.hasOption(ReporterCLIParameters.NORMALIZATION_PSM.id) && !CommandParameter.isInList((String)ReporterCLIParameters.NORMALIZATION_PSM.id, (String)(arg = aLine.getOptionValue(ReporterCLIParameters.NORMALIZATION_PSM.id)), normalizationTypes)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.NORMALIZATION_PEPTIDE.id) && !CommandParameter.isInList((String)ReporterCLIParameters.NORMALIZATION_PEPTIDE.id, (String)(arg = aLine.getOptionValue(ReporterCLIParameters.NORMALIZATION_PEPTIDE.id)), normalizationTypes)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.NORMALIZATION_PROTEIN.id) && !CommandParameter.isInList((String)ReporterCLIParameters.NORMALIZATION_PROTEIN.id, (String)(arg = aLine.getOptionValue(ReporterCLIParameters.NORMALIZATION_PROTEIN.id)), normalizationTypes)) {
            return false;
        }
        if (aLine.hasOption(ReporterCLIParameters.STABLE_PROTEINS.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.STABLE_PROTEINS.id);
            HashSet<String> supportedFormats2 = new HashSet<String>(1);
            supportedFormats2.add(".fasta");
            if (!CommandParameter.fileExists((String)ReporterCLIParameters.STABLE_PROTEINS.id, (String)arg, supportedFormats2)) {
                return false;
            }
        }
        if (aLine.hasOption(ReporterCLIParameters.CONTAMINANTS.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.CONTAMINANTS.id);
            HashSet<String> supportedFormats3 = new HashSet<String>(1);
            supportedFormats3.add(".fasta");
            if (!CommandParameter.fileExists((String)ReporterCLIParameters.CONTAMINANTS.id, (String)arg, supportedFormats3)) {
                return false;
            }
        }
        return true;
    }

    public Object call() throws IOException, ClassNotFoundException {
        File zipFile;
        File destinationFile;
        String specifiedMethodName;
        ArrayList<String> ignoredPtms;
        try {
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
            unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
        }
        catch (Throwable loggerClass) {
            // empty catch block
        }
        this.reporterCLIInputBean = new ReporterCLIInputBean(this.line);
        ReporterCLI reporterCLI = this;
        this.utilitiesUserParameters = reporterCLI.utilitiesUserParameters.loadUserParameters();
        PeptideShaker.instantiateFacories((UtilitiesUserParameters)this.utilitiesUserParameters);
        try {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            speciesFactory.initiate(Reporter.getConfigFolder());
        }
        catch (Exception e) {
            System.out.println("An error occurred while loading the species.");
            e.printStackTrace();
        }
        try {
            this.methodsFactory.importMethods(Reporter.getMethodsFile());
        }
        catch (Exception e) {
            System.out.println("An error occurred while loading the methods.");
            e.printStackTrace();
            return 1;
        }
        this.modificationFactory = ModificationFactory.getInstance();
        WaitingHandlerCLIImpl waitingHandler = new WaitingHandlerCLIImpl();
        ProcessingParameters processingParameters = new ProcessingParameters();
        processingParameters.setnThreads(this.reporterCLIInputBean.getnThreads());
        IdentificationParameters tempIdentificationParameters = this.reporterCLIInputBean.getIdentificationParameters();
        File parametersFile = this.reporterCLIInputBean.getIdentificationParametersFile();
        if (parametersFile == null) {
            String name = tempIdentificationParameters.getName();
            name = name == null ? "SearchCLI.par" : name + ".par";
            parametersFile = new File(this.reporterCLIInputBean.getOutputFile(), name);
            IdentificationParameters.saveIdentificationParameters((IdentificationParameters)tempIdentificationParameters, (File)parametersFile);
        }
        ProjectImporter projectImporter = new ProjectImporter();
        this.psdbFile = this.reporterCLIInputBean.getPeptideShakerFile();
        this.setDbFolder(Reporter.getMatchesFolder());
        try {
            projectImporter.importPeptideShakerProject(this, this.spectrumFiles, (WaitingHandler)waitingHandler);
            projectImporter.importReporterProject(this, (WaitingHandler)waitingHandler);
        }
        catch (OutOfMemoryError error) {
            System.out.println("Ran out of memory! (runtime.maxMemory(): " + Runtime.getRuntime().maxMemory() + ")");
            String errorText = "Reporter used up all the available memory and had to be stopped.<br>Memory boundaries are changed in the the Welcome Dialog (Settings<br>& Help > Settings > Java Memory Settings) or in the Edit menu (Edit<br>Java Options). See also <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">JavaTroubleShooting</a>.";
            waitingHandler.appendReport(errorText, true, true);
            error.printStackTrace();
            return 1;
        }
        catch (EOFException e) {
            String errorText = "An error occurred while reading:\n" + this.psdbFile + ".\n\nThe file is corrupted and cannot be opened anymore.";
            waitingHandler.appendReport(errorText, true, true);
            e.printStackTrace();
            return 1;
        }
        catch (Exception e) {
            String errorText = "An error occurred while reading:\n" + this.psdbFile + ".\n\nPlease verify that the Reporter version used to create\nthe file is compatible with your version of Reporter.";
            waitingHandler.appendReport(errorText, true, true);
            e.printStackTrace();
            return 1;
        }
        DisplayPreferences displayPreferences = projectImporter.getDisplayPreferences();
        SpectrumProvider spectrumProvider = projectImporter.getSpectrumProvider();
        String error = PeptideShaker.loadModifications((SearchParameters)this.getIdentificationParameters().getSearchParameters());
        if (error != null) {
            System.out.println(error);
        }
        if ((ignoredPtms = this.reporterCLIInputBean.getIgnoredPtms()) != null) {
            for (String ptmName : ignoredPtms) {
                Modification modification = this.modificationFactory.getModification(ptmName);
                if (modification != null) continue;
                System.out.println("Modification " + ptmName + " not recognized.");
                return 1;
            }
        }
        ReporterSettings reporterSettings = projectImporter.getReporterSettings();
        ReporterIonQuantification reporterIonQuantification = projectImporter.getReporterIonQuantification();
        ReporterMethod selectedMethod = reporterIonQuantification.getReporterMethod();
        File methodsFile = this.reporterCLIInputBean.getIsotopesFile();
        if (methodsFile != null) {
            try {
                this.methodsFactory.importMethods(methodsFile);
            }
            catch (Exception e) {
                String errorText = "An error occurred while parsing:\n" + methodsFile + ".\n\n";
                waitingHandler.appendReport(errorText, true, true);
                e.printStackTrace();
                return 1;
            }
        }
        if ((specifiedMethodName = this.reporterCLIInputBean.getReporterMethod()) != null) {
            selectedMethod = this.methodsFactory.getReporterMethod(specifiedMethodName);
        }
        if (selectedMethod == null && this.methodsFactory.getMethodsNames().size() == 1) {
            selectedMethod = this.methodsFactory.getReporterMethod((String)this.methodsFactory.getMethodsNames().get(0));
        }
        if (selectedMethod == null) {
            String errorText = "The reporter quantification methods to use could not be inferred, please specify a method from the isotopic correction file as command line parameter.\n\n";
            waitingHandler.appendReport(errorText, true, true);
            return 1;
        }
        reporterIonQuantification.setMethod(selectedMethod);
        this.updateReporterIonSelectionSettings(reporterSettings.getReporterIonSelectionSettings());
        this.updateRatioEstimationSettings(reporterSettings.getRatioEstimationSettings());
        this.updateNormalizationSettings(reporterSettings.getNormalizationSettings());
        ArrayList reagents = selectedMethod.getReagentsSortedByMass();
        for (String reagent : reagents) {
            reporterIonQuantification.assignSample(reagent, reagent);
        }
        ArrayList<Integer> referenceIndexes = this.reporterCLIInputBean.getReferenceSamples();
        if (referenceIndexes != null) {
            ArrayList<String> referenceSamples = new ArrayList<String>(referenceIndexes.size());
            for (Integer index : referenceIndexes) {
                if (index > reagents.size()) {
                    System.out.println(System.getProperty("line.separator") + "Reference sample index " + index + " is higher than the number of reagents (" + reagents.size() + ")." + System.getProperty("line.separator"));
                    return 1;
                }
                referenceSamples.add((String)reagents.get(index - 1));
            }
            reporterIonQuantification.setControlSamples(referenceSamples);
        }
        QuantificationFeaturesGenerator quantificationFeaturesGenerator = new QuantificationFeaturesGenerator(new QuantificationFeaturesCache(), this.getIdentification(), this.getIdentificationFeaturesGenerator(), reporterSettings, reporterIonQuantification, this.identificationParameters.getSearchParameters(), this.identificationParameters.getSequenceMatchingParameters());
        NormalizationFactors normalizationFactors = reporterIonQuantification.getNormalizationFactors();
        if (!normalizationFactors.hasNormalizationFactors()) {
            try {
                Normalizer normalizer = new Normalizer();
                if (!normalizationFactors.hasPsmNormalisationFactors()) {
                    normalizer.setPsmNormalizationFactors(reporterIonQuantification, reporterSettings.getRatioEstimationSettings(), reporterSettings.getNormalizationSettings(), this.getIdentificationParameters().getSequenceMatchingParameters(), this.getIdentification(), spectrumProvider, quantificationFeaturesGenerator, processingParameters, this.getIdentificationParameters().getSearchParameters(), this.getIdentificationParameters().getFastaParameters(), this.getIdentificationParameters().getPeptideVariantsParameters(), this.exceptionHandler, (WaitingHandler)waitingHandler);
                }
                if (!normalizationFactors.hasPeptideNormalisationFactors()) {
                    normalizer.setPeptideNormalizationFactors(reporterIonQuantification, reporterSettings.getRatioEstimationSettings(), reporterSettings.getNormalizationSettings(), this.getIdentificationParameters().getSequenceMatchingParameters(), this.getIdentification(), spectrumProvider, quantificationFeaturesGenerator, processingParameters, this.getIdentificationParameters().getSearchParameters(), this.getIdentificationParameters().getFastaParameters(), this.getIdentificationParameters().getPeptideVariantsParameters(), this.exceptionHandler, (WaitingHandler)waitingHandler);
                }
                if (!normalizationFactors.hasProteinNormalisationFactors()) {
                    normalizer.setProteinNormalizationFactors(reporterIonQuantification, reporterSettings.getRatioEstimationSettings(), reporterSettings.getNormalizationSettings(), this.getIdentification(), spectrumProvider, this.getMetrics(), quantificationFeaturesGenerator, processingParameters, this.getIdentificationParameters().getSearchParameters(), this.getIdentificationParameters().getFastaParameters(), this.getIdentificationParameters().getPeptideVariantsParameters(), this.exceptionHandler, (WaitingHandler)waitingHandler);
                }
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while estimating the ratios." + System.getProperty("line.separator"));
                e.printStackTrace();
                return 1;
            }
        }
        if ((destinationFile = this.reporterCLIInputBean.getOutputFile()) == null) {
            destinationFile = this.psdbFile;
        } else {
            this.psdbFile = destinationFile;
        }
        try {
            ProjectSaver.saveProject(reporterSettings, reporterIonQuantification, displayPreferences, this, (WaitingHandler)waitingHandler);
            waitingHandler.appendReport("Project saved as " + destinationFile.getAbsolutePath() + ".", true, true);
        }
        catch (Exception e) {
            System.out.println(System.getProperty("line.separator") + "An error occurred while saving the project." + System.getProperty("line.separator"));
            e.printStackTrace();
            return 1;
        }
        ReportCLIInputBean reportCLIInputBean = this.reporterCLIInputBean.getReportCLIInputBean();
        if (reportCLIInputBean.getReportOutputFolder() == null) {
            reportCLIInputBean.setReportOutputFolder(destinationFile.getParentFile());
        }
        if (reportCLIInputBean.exportNeeded()) {
            waitingHandler.appendReport("Starting report export.", true, true);
            if (reportCLIInputBean.exportNeeded()) {
                for (String reportType : reportCLIInputBean.getReportTypes()) {
                    try {
                        CLIExportMethods.exportReport(reportCLIInputBean, reportType, this.projectParameters.getProjectUniqueName(), this.projectDetails, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.proteinDetailsProvider, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, this.identificationParameters, this.displayParameters.getnAASurroundingPeptides(), this.spectrumCountingParameters, (WaitingHandler)waitingHandler);
                    }
                    catch (Exception e) {
                        waitingHandler.appendReport("An error occurred while exporting the " + reportType + ".", true, true);
                        e.printStackTrace();
                        waitingHandler.setRunCanceled();
                    }
                }
            }
            if (reportCLIInputBean.documentationExportNeeded()) {
                for (String reportType : reportCLIInputBean.getReportTypes()) {
                    try {
                        CLIExportMethods.exportDocumentation(reportCLIInputBean, reportType, (WaitingHandler)waitingHandler);
                    }
                    catch (Exception e) {
                        waitingHandler.appendReport("An error occurred while exporting the documentation for " + reportType + ".", true, true);
                        e.printStackTrace();
                        waitingHandler.setRunCanceled();
                    }
                }
            }
        }
        if ((zipFile = this.reporterCLIInputBean.getZipExport()) != null) {
            waitingHandler.appendReportEndLine();
            waitingHandler.appendReport("Zipping project.", true, true);
            File parent = zipFile.getParentFile();
            try {
                parent.mkdirs();
            }
            catch (Exception e) {
                waitingHandler.appendReport("An error occurred while creating folder " + parent.getAbsolutePath() + ".", true, true);
                waitingHandler.setRunCanceled();
            }
            File fastaFile = new File(this.projectDetails.getFastaFile());
            try {
                ProjectExport.exportProjectAsZip((File)zipFile, (File)fastaFile, (SpectrumProvider)this.msFileHandler, (File)this.psdbFile, (boolean)false, (WaitingHandler)waitingHandler);
                int NUMBER_OF_BYTES_PER_MEGABYTE = 0x100000;
                double sizeOfZippedFile = Util.roundDouble((double)((double)zipFile.length() / 1048576.0), (int)2);
                waitingHandler.appendReport("Project zipped to '" + zipFile.getAbsolutePath() + "' (" + sizeOfZippedFile + " MB)", true, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                waitingHandler.appendReport("An error occurred while attempting to zip project in " + zipFile.getAbsolutePath() + ".", true, true);
                waitingHandler.setRunCanceled();
            }
        }
        waitingHandler.appendReportEndLine();
        if (waitingHandler.isRunCanceled()) {
            return 1;
        }
        waitingHandler.appendReport("Reporter processing completed.", true, true);
        return 0;
    }

    private void updateReporterIonSelectionSettings(ReporterIonSelectionSettings reporterIonSelectionSettings) {
        if (this.reporterCLIInputBean.getReporterIonTolerance() != null) {
            reporterIonSelectionSettings.setReporterIonsMzTolerance(this.reporterCLIInputBean.getReporterIonTolerance());
        }
        if (this.reporterCLIInputBean.getMostAccurate() != null) {
            reporterIonSelectionSettings.setMostAccurate(this.reporterCLIInputBean.getMostAccurate());
        }
        if (this.reporterCLIInputBean.getReporterIonsLocation() != null) {
            reporterIonSelectionSettings.setReporterIonsLocation(this.reporterCLIInputBean.getReporterIonsLocation());
        }
        if (this.reporterCLIInputBean.getPrecMzTolerance() != null) {
            reporterIonSelectionSettings.setPrecursorMzTolerance(this.reporterCLIInputBean.getPrecMzTolerance());
        }
        if (this.reporterCLIInputBean.getPrecMzTolerancePpm() != null) {
            reporterIonSelectionSettings.setPrecursorMzPpm(this.reporterCLIInputBean.getPrecMzTolerancePpm());
        }
        if (this.reporterCLIInputBean.getPrecRtTolerance() != null) {
            reporterIonSelectionSettings.setPrecursorRTTolerance(this.reporterCLIInputBean.getPrecRtTolerance());
        }
    }

    private void updateRatioEstimationSettings(RatioEstimationSettings ratioEstimationSettings) {
        if (this.reporterCLIInputBean.getIgnoreNull() != null) {
            ratioEstimationSettings.setIgnoreNullIntensities(this.reporterCLIInputBean.getIgnoreNull());
        }
        if (this.reporterCLIInputBean.getIgnoreMc() != null) {
            ratioEstimationSettings.setIgnoreMissedCleavages(this.reporterCLIInputBean.getIgnoreMc());
        }
        if (this.reporterCLIInputBean.getPercentile() != null) {
            ratioEstimationSettings.setPercentile(this.reporterCLIInputBean.getPercentile());
        }
        if (this.reporterCLIInputBean.getResolution() != null) {
            ratioEstimationSettings.setRatioResolution(this.reporterCLIInputBean.getResolution());
        }
        if (this.reporterCLIInputBean.getMinUnique() != null) {
            ratioEstimationSettings.setMinUnique(this.reporterCLIInputBean.getMinUnique());
        }
        if (this.reporterCLIInputBean.getIgnoredPtms() != null) {
            ratioEstimationSettings.emptyPTMList();
            for (String ptmName : this.reporterCLIInputBean.getIgnoredPtms()) {
                ratioEstimationSettings.addExcludingPtm(ptmName);
            }
        }
        if (this.reporterCLIInputBean.getValidationPsm() != null) {
            ratioEstimationSettings.setPsmValidationLevel(MatchValidationLevel.getMatchValidationLevel((int)this.reporterCLIInputBean.getValidationPsm()));
        }
        if (this.reporterCLIInputBean.getValidationPeptide() != null) {
            ratioEstimationSettings.setPeptideValidationLevel(MatchValidationLevel.getMatchValidationLevel((int)this.reporterCLIInputBean.getValidationPeptide()));
        }
        if (this.reporterCLIInputBean.getValidationProtein() != null) {
            ratioEstimationSettings.setProteinValidationLevel(MatchValidationLevel.getMatchValidationLevel((int)this.reporterCLIInputBean.getValidationProtein()));
        }
    }

    private void updateNormalizationSettings(NormalizationSettings normalizationSettings) {
        if (this.reporterCLIInputBean.getPsmNormalizationType() != null) {
            normalizationSettings.setPsmNormalization(this.reporterCLIInputBean.getPsmNormalizationType());
        }
        if (this.reporterCLIInputBean.getPeptideNormalizationType() != null) {
            normalizationSettings.setPeptideNormalization(this.reporterCLIInputBean.getPeptideNormalizationType());
        }
        if (this.reporterCLIInputBean.getProteinNormalizationType() != null) {
            normalizationSettings.setProteinNormalization(this.reporterCLIInputBean.getProteinNormalizationType());
        }
        if (this.reporterCLIInputBean.getStableProteins() != null) {
            normalizationSettings.setStableProteinsFastaFile(this.reporterCLIInputBean.getStableProteins());
        }
        if (this.reporterCLIInputBean.getContaminants() != null) {
            normalizationSettings.setContaminantsFastaFile(this.reporterCLIInputBean.getContaminants());
        }
    }

    public static void close(Identification identification) throws IOException, SQLException {
        try {
            if (identification != null) {
                identification.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File matchFolder = Reporter.getMatchesFolder();
            File[] tempFiles = matchFolder.listFiles();
            if (tempFiles != null) {
                for (File currentFile : tempFiles) {
                    boolean deleted = IoUtil.deleteDir((File)currentFile);
                    if (deleted) continue;
                    System.out.println(currentFile.getAbsolutePath() + " could not be deleted!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TempFilesManager.deleteTempFolders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "ReporterCLI estimates abundance ratios from PeptideShaker projects based on reporter ion quantification." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/reporter.html and https://compomics.github.io/projects/reporter/wiki/reportercli.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/reporter." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "\n";
    }

    public static void main(String[] args) {
        try {
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            ReporterCLIParameters.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            ReporterCLI reporterCLI = new ReporterCLI(args);
            if (!ReporterCLI.isValidCommandLine(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "======================" + System.getProperty("line.separator"));
                lPrintWriter.print("ReporterCLI" + System.getProperty("line.separator"));
                lPrintWriter.print("======================" + System.getProperty("line.separator"));
                lPrintWriter.print(ReporterCLI.getHeader());
                lPrintWriter.print(ReporterCLIParameters.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(1);
            } else {
                reporterCLI.call();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TempFilesManager.deleteTempFolders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void redirectErrorStream(File logFolder) {
        try {
            logFolder.mkdirs();
            File file = new File(logFolder, "Reporter.log");
            System.setErr(new PrintStream(new FileOutputStream(file, true)));
            System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator") + new Date() + ": Reporter version " + new Properties().getVersion() + ".");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + " b.");
            System.err.println("Total amount of memory in the Java virtual machine: " + Runtime.getRuntime().totalMemory() + " b.");
            System.err.println("Free memory: " + Runtime.getRuntime().freeMemory() + " b.");
            System.err.println("Java version: " + System.getProperty("java.version") + ".");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

