/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.export.report;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.io.export.ExportFactory;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.WorkbookStyle;
import com.compomics.util.io.export.features.peptideshaker.PsAnnotationFeature;
import com.compomics.util.io.export.features.peptideshaker.PsInputFilterFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProjectFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPtmScoringFeature;
import com.compomics.util.io.export.features.peptideshaker.PsSearchFeature;
import com.compomics.util.io.export.features.peptideshaker.PsSpectrumCountingFeature;
import com.compomics.util.io.export.features.peptideshaker.PsValidationFeature;
import com.compomics.util.io.export.features.reporter.ReporterPeptideFeature;
import com.compomics.util.io.export.features.reporter.ReporterProteinFeatures;
import com.compomics.util.io.export.features.reporter.ReporterPsmFeatures;
import com.compomics.util.io.export.writers.ExcelWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.export.PsExportStyle;
import eu.isas.peptideshaker.export.sections.PsAnnotationSection;
import eu.isas.peptideshaker.export.sections.PsInputFilterSection;
import eu.isas.peptideshaker.export.sections.PsProjectSection;
import eu.isas.peptideshaker.export.sections.PsPtmScoringSection;
import eu.isas.peptideshaker.export.sections.PsSearchParametersSection;
import eu.isas.peptideshaker.export.sections.PsSpectrumCountingSection;
import eu.isas.peptideshaker.export.sections.PsValidationSection;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.utils.ExportFactoryMarshaller;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.export.report.sections.ReporterPeptideSection;
import eu.isas.reporter.export.report.sections.ReporterProteinSection;
import eu.isas.reporter.export.report.sections.ReporterPsmSection;
import eu.isas.reporter.settings.ReporterSettings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.math.MathException;

public class ReporterExportFactory
implements ExportFactory {
    private static ReporterExportFactory instance = null;
    private static String JSON_FILE = System.getProperty("user.home") + "/.reporter/exportFactory.json";
    private HashMap<String, ExportScheme> userSchemes = new HashMap();
    private ArrayList<String> implementedReports = null;

    private ReporterExportFactory() {
    }

    public static ReporterExportFactory getInstance() {
        if (instance == null) {
            try {
                File savedFile = new File(JSON_FILE);
                instance = ReporterExportFactory.loadFromFile(savedFile);
            }
            catch (Exception e) {
                e.getMessage();
                instance = new ReporterExportFactory();
                try {
                    ReporterExportFactory.saveFactory(instance);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return instance;
    }

    public static void saveFactory(ReporterExportFactory reporterExportFactory) throws IOException {
        File factoryFile = new File(JSON_FILE);
        if (!factoryFile.getParentFile().exists()) {
            factoryFile.getParentFile().mkdir();
        }
        ExportFactoryMarshaller jsonMarshaller = new ExportFactoryMarshaller();
        jsonMarshaller.saveObjectToJson((Object)reporterExportFactory, factoryFile);
    }

    public static ReporterExportFactory loadFromFile(File file) throws IOException {
        ExportFactoryMarshaller jsonMarshaller = new ExportFactoryMarshaller();
        ReporterExportFactory result = (ReporterExportFactory)jsonMarshaller.fromJson(ReporterExportFactory.class, file);
        return result;
    }

    public ArrayList<String> getUserSchemesNames() {
        return new ArrayList<String>(this.userSchemes.keySet());
    }

    public ExportScheme getExportScheme(String schemeName) {
        ExportScheme exportScheme = this.userSchemes.get(schemeName);
        if (exportScheme == null) {
            exportScheme = ReporterExportFactory.getDefaultExportSchemes().get(schemeName);
        }
        return exportScheme;
    }

    public void removeExportScheme(String schemeName) {
        this.userSchemes.remove(schemeName);
    }

    public void addExportScheme(ExportScheme exportScheme) {
        this.userSchemes.put(exportScheme.getName(), exportScheme);
    }

    public ArrayList<String> getImplementedSections() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Annotation Settings");
        result.add("Input Filters");
        result.add("Protein Reporter Quantification Summary");
        result.add("Peptide Reporter Quantification Summary");
        result.add("PSM Reporter Quantification Summary");
        result.add("Fragment Ions Summary");
        result.add("Project Details");
        result.add("PTM Scoring Settings");
        result.add("Database Search Parameters");
        result.add("Spectrum Counting Parameters");
        result.add("Validation Summary");
        return result;
    }

    public ArrayList<ExportFeature> getExportFeatures(String sectionName, boolean includeSubFeatures) {
        switch (sectionName) {
            case "Annotation Settings": {
                return PsAnnotationFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Input Filters": {
                return PsInputFilterFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Peptide Reporter Quantification Summary": {
                return ReporterPeptideFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Project Details": {
                return PsProjectFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Protein Reporter Quantification Summary": {
                return ReporterProteinFeatures.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "PSM Reporter Quantification Summary": {
                return ReporterPsmFeatures.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "PTM Scoring Settings": {
                return PsPtmScoringFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Database Search Parameters": {
                return PsSearchFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Spectrum Counting Parameters": {
                return PsSpectrumCountingFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Validation Summary": {
                return PsValidationFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
        }
        return new ArrayList<ExportFeature>();
    }

    public ArrayList<String> getDefaultExportSchemesNames() {
        ArrayList<String> result = new ArrayList<String>(ReporterExportFactory.getDefaultExportSchemes().keySet());
        Collections.sort(result);
        return result;
    }

    public static void writeExport(ExportScheme exportScheme, File destinationFile, ExportFormat exportFormat, String experiment, ProjectDetails projectDetails, Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ProteinDetailsProvider proteinDetailsProvider, GeneMaps geneMaps, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, ReporterSettings reporterSettings, IdentificationParameters identificationParameters, ArrayList<String> proteinKeys, long[] peptideKeys, long[] psmKeys, String proteinMatchKey, int nSurroundingAA, SpectrumCountingParameters spectrumCountingParameters, WaitingHandler waitingHandler) throws IOException, SQLException, ClassNotFoundException, InterruptedException, MathException {
        ExportWriter exportWriter = ExportWriter.getExportWriter((ExportFormat)exportFormat, (File)destinationFile, (String)exportScheme.getSeparator(), (int)exportScheme.getSeparationLines(), (boolean)false);
        if (exportWriter instanceof ExcelWriter) {
            ExcelWriter excelWriter = (ExcelWriter)exportWriter;
            PsExportStyle exportStyle = PsExportStyle.getReportStyle((ExcelWriter)excelWriter);
            excelWriter.setWorkbookStyle((WorkbookStyle)exportStyle);
        }
        exportWriter.writeMainTitle(exportScheme.getMainTitle());
        block24: for (String sectionName : exportScheme.getSections()) {
            if (exportScheme.isIncludeSectionTitles()) {
                exportWriter.startNewSection(sectionName);
            } else {
                exportWriter.startNewSection();
            }
            switch (sectionName) {
                case "Annotation Settings": {
                    PsAnnotationSection psAnnotationSection = new PsAnnotationSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psAnnotationSection.writeSection(identificationParameters.getAnnotationParameters(), waitingHandler);
                    continue block24;
                }
                case "Input Filters": {
                    PsInputFilterSection psInputFilterSection = new PsInputFilterSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psInputFilterSection.writeSection(identificationParameters.getPeptideAssumptionFilter(), waitingHandler);
                    continue block24;
                }
                case "Peptide Reporter Quantification Summary": {
                    ReporterPeptideSection reporterPeptideSection = new ReporterPeptideSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    reporterPeptideSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, spectrumProvider, proteinDetailsProvider, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, identificationParameters, peptideKeys, nSurroundingAA, "", exportScheme.isValidatedOnly(), exportScheme.isIncludeDecoy(), waitingHandler);
                    continue block24;
                }
                case "Project Details": {
                    PsProjectSection psProjectSection = new PsProjectSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psProjectSection.writeSection(experiment, projectDetails, waitingHandler);
                    continue block24;
                }
                case "Protein Reporter Quantification Summary": {
                    ReporterProteinSection reporterProteinSection = new ReporterProteinSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    reporterProteinSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, spectrumProvider, proteinDetailsProvider, geneMaps, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, identificationParameters, psmKeys, nSurroundingAA, exportScheme.isValidatedOnly(), exportScheme.isIncludeDecoy(), waitingHandler);
                    continue block24;
                }
                case "PSM Reporter Quantification Summary": {
                    ReporterPsmSection reporterPsmSection = new ReporterPsmSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    reporterPsmSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, spectrumProvider, proteinDetailsProvider, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, identificationParameters, psmKeys, "", nSurroundingAA, exportScheme.isValidatedOnly(), exportScheme.isIncludeDecoy(), waitingHandler);
                    continue block24;
                }
                case "PTM Scoring Settings": {
                    PsPtmScoringSection psPtmScoringSection = new PsPtmScoringSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psPtmScoringSection.writeSection(identificationParameters.getModificationLocalizationParameters(), waitingHandler);
                    continue block24;
                }
                case "Database Search Parameters": {
                    PsSearchParametersSection psSearchParametersSection = new PsSearchParametersSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psSearchParametersSection.writeSection(identificationParameters.getSearchParameters(), projectDetails, waitingHandler);
                    continue block24;
                }
                case "Spectrum Counting Parameters": {
                    PsSpectrumCountingSection psSpectrumCountingSection = new PsSpectrumCountingSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psSpectrumCountingSection.writeSection(spectrumCountingParameters, waitingHandler);
                    continue block24;
                }
                case "Validation Summary": {
                    PsValidationSection psValidationSection = new PsValidationSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    PSMaps psMaps = new PSMaps();
                    psMaps = (PSMaps)identification.getUrParam((UrParameter)psMaps);
                    psValidationSection.writeSection(psMaps, identificationParameters, waitingHandler);
                    continue block24;
                }
            }
            throw new UnsupportedOperationException("Section " + sectionName + " not implemented.");
        }
        exportWriter.close();
    }

    public static void writeDocumentation(ExportScheme exportScheme, ExportFormat exportFormat, File destinationFile) throws IOException {
        String mainTitle;
        ExportWriter exportWriter = ExportWriter.getExportWriter((ExportFormat)exportFormat, (File)destinationFile, (String)exportScheme.getSeparator(), (int)exportScheme.getSeparationLines(), (boolean)false);
        if (exportWriter instanceof ExcelWriter) {
            ExcelWriter excelWriter = (ExcelWriter)exportWriter;
            PsExportStyle exportStyle = PsExportStyle.getReportStyle((ExcelWriter)excelWriter);
            excelWriter.setWorkbookStyle((WorkbookStyle)exportStyle);
        }
        if ((mainTitle = exportScheme.getMainTitle()) != null) {
            exportWriter.writeMainTitle(mainTitle);
        }
        for (String sectionName : exportScheme.getSections()) {
            exportWriter.startNewSection(sectionName);
            if (exportScheme.isIncludeSectionTitles()) {
                exportWriter.write(sectionName);
                exportWriter.newLine();
            }
            for (ExportFeature exportFeature : exportScheme.getExportFeatures(sectionName)) {
                exportWriter.write(exportFeature.getTitle());
                exportWriter.addSeparator();
                exportWriter.write(exportFeature.getDescription());
                exportWriter.newLine();
            }
        }
        exportWriter.close();
    }

    private static void writeSeparationLines(BufferedWriter writer, int nSeparationLines) throws IOException {
        for (int i = 1; i <= nSeparationLines; ++i) {
            writer.newLine();
        }
    }

    public String getCommandLineOptions() {
        this.setUpReportList();
        String options = "";
        for (int i = 0; i < this.implementedReports.size(); ++i) {
            if (!options.equals("")) {
                options = options + ", ";
            }
            options = options + i + ": " + this.implementedReports.get(i);
        }
        return options;
    }

    public static String getDefaultReportName(String experiment, String exportName) {
        return experiment + "_" + exportName + ".txt";
    }

    public static String getDefaultDocumentation(String exportName) {
        return exportName + "_documentation.txt";
    }

    public String getExportTypeFromCommandLineOption(int commandLine) {
        if (this.implementedReports == null) {
            this.setUpReportList();
        }
        if (commandLine >= this.implementedReports.size()) {
            throw new IllegalArgumentException("Unrecognized report type: " + commandLine + ". Available reports are: " + this.getCommandLineOptions() + ".");
        }
        return this.implementedReports.get(commandLine);
    }

    private void setUpReportList() {
        this.implementedReports = new ArrayList();
        this.implementedReports.addAll(this.getDefaultExportSchemesNames());
        ArrayList<String> userReports = new ArrayList<String>(this.userSchemes.keySet());
        Collections.sort(userReports);
        this.implementedReports.addAll(userReports);
    }

    private static HashMap<String, ExportScheme> getDefaultExportSchemes() {
        HashMap<String, ExportScheme> defaultSchemes = new HashMap<String, ExportScheme>();
        for (String schemeName : PSExportFactory.getDefaultExportSchemesNames()) {
            ExportScheme exportScheme = PSExportFactory.getDefaultExportScheme((String)schemeName);
            for (String section : exportScheme.getSections()) {
                boolean protein = false;
                boolean peptide = false;
                boolean psm = false;
                for (ExportFeature exportFeature : exportScheme.getExportFeatures(section)) {
                    if (exportFeature instanceof PsProteinFeature) {
                        protein = true;
                        continue;
                    }
                    if (exportFeature instanceof PsPeptideFeature) {
                        peptide = true;
                        continue;
                    }
                    if (!(exportFeature instanceof PsPsmFeature)) continue;
                    psm = true;
                }
                if (protein) {
                    exportScheme.addExportFeature(section, (ExportFeature)ReporterProteinFeatures.raw_unique_ratio);
                    exportScheme.addExportFeature(section, (ExportFeature)ReporterProteinFeatures.raw_shared_ratio);
                    exportScheme.addExportFeature(section, (ExportFeature)ReporterProteinFeatures.raw_ratio);
                    exportScheme.addExportFeature(section, (ExportFeature)ReporterProteinFeatures.unique_ratio);
                    exportScheme.addExportFeature(section, (ExportFeature)ReporterProteinFeatures.shared_ratio);
                    exportScheme.addExportFeature(section, (ExportFeature)ReporterProteinFeatures.ratio);
                }
                if (peptide) {
                    exportScheme.addExportFeature(section, (ExportFeature)ReporterPeptideFeature.raw_ratio);
                    exportScheme.addExportFeature(section, (ExportFeature)ReporterPeptideFeature.normalized_ratio);
                }
                if (!psm) continue;
                exportScheme.addExportFeature(section, (ExportFeature)ReporterPsmFeatures.reporter_mz);
                exportScheme.addExportFeature(section, (ExportFeature)ReporterPsmFeatures.reporter_intensity);
                exportScheme.addExportFeature(section, (ExportFeature)ReporterPsmFeatures.deisotoped_intensity);
                exportScheme.addExportFeature(section, (ExportFeature)ReporterPsmFeatures.ratio);
            }
            String psSection = "Protein Identification Summary";
            if (exportScheme.getSections().contains(psSection)) {
                exportScheme.setExportFeatures("Protein Reporter Quantification Summary", exportScheme.getExportFeatures(psSection));
                exportScheme.removeSection(psSection);
            }
            psSection = "Peptide Identification Summary";
            if (exportScheme.getSections().contains(psSection)) {
                exportScheme.setExportFeatures("Peptide Reporter Quantification Summary", exportScheme.getExportFeatures(psSection));
                exportScheme.removeSection(psSection);
            }
            psSection = "Peptide Spectrum Matching Summary";
            if (exportScheme.getSections().contains(psSection)) {
                exportScheme.setExportFeatures("PSM Reporter Quantification Summary", exportScheme.getExportFeatures(psSection));
                exportScheme.removeSection(psSection);
            }
            defaultSchemes.put(schemeName, exportScheme);
        }
        return defaultSchemes;
    }

    public static String getJsonFile() {
        return JSON_FILE;
    }

    public static String getJsonFolder() {
        File tempFile = new File(ReporterExportFactory.getJsonFile());
        return tempFile.getParent();
    }

    public static void setJsonFolder(String jsonFolder) {
        JSON_FILE = jsonFolder + "/reporter_exportFactory.cus";
    }
}

