/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.export.report;

import com.compomics.util.io.export.WorkbookStyle;
import com.compomics.util.io.export.writers.ExcelWriter;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ReporterReportStyle
implements WorkbookStyle {
    private HSSFWorkbook workbook;
    private CellStyle mainTitle;
    private CellStyle standardHeader;
    private CellStyle standard;
    private HashMap<Integer, CellStyle> hierarchicalStyles = new HashMap();
    private HashMap<Integer, CellStyle> hierarchicalHeaders = new HashMap();
    private static HashMap<HSSFWorkbook, ReporterReportStyle> styles = new HashMap();

    public static ReporterReportStyle getReportStyle(ExcelWriter excelWriter) {
        HSSFWorkbook workbook = excelWriter.getWorkbook();
        ReporterReportStyle result = styles.get(workbook);
        if (result == null) {
            result = new ReporterReportStyle(excelWriter);
            styles.put(workbook, result);
        }
        return result;
    }

    private ReporterReportStyle(ExcelWriter excelWriter) {
        this.workbook = excelWriter.getWorkbook();
        this.setCellStyles();
    }

    private void setCellStyles() {
        HSSFFont f = this.workbook.createFont();
        f.setFontHeightInPoints((short)20);
        this.mainTitle = this.workbook.createCellStyle();
        this.mainTitle.setFont((Font)f);
        f = this.workbook.createFont();
        f.setFontHeightInPoints((short)8);
        this.standard = this.workbook.createCellStyle();
        this.standard.setFont((Font)f);
        f = this.workbook.createFont();
        f.setFontHeightInPoints((short)8);
        this.standardHeader = this.workbook.createCellStyle();
        this.standardHeader.setFont((Font)f);
        this.standardHeader.setBorderBottom(BorderStyle.THIN);
        this.standardHeader.setBorderTop(BorderStyle.THIN);
        this.standardHeader.setBorderLeft(BorderStyle.THIN);
        this.standardHeader.setBorderRight(BorderStyle.THIN);
        this.standardHeader.setAlignment(HorizontalAlignment.CENTER);
        this.standardHeader.setVerticalAlignment(VerticalAlignment.CENTER);
        this.standardHeader.setFillForegroundColor(HSSFColor.HSSFColorPredefined.PALE_BLUE.getIndex());
        this.standardHeader.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFPalette palette = this.workbook.getCustomPalette();
        palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.PALE_BLUE.getIndex(), (byte)-6, (byte)-56, (byte)-56);
        this.hierarchicalHeaders.put(0, this.standardHeader);
        HSSFCellStyle subHeader = this.workbook.createCellStyle();
        subHeader.setFont((Font)f);
        subHeader.setBorderBottom(BorderStyle.THIN);
        subHeader.setBorderTop(BorderStyle.THIN);
        subHeader.setBorderLeft(BorderStyle.THIN);
        subHeader.setBorderRight(BorderStyle.THIN);
        subHeader.setAlignment(HorizontalAlignment.CENTER);
        subHeader.setVerticalAlignment(VerticalAlignment.CENTER);
        subHeader.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_50_PERCENT.getIndex());
        palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.GREY_50_PERCENT.getIndex(), (byte)-6, (byte)-36, (byte)-36);
        subHeader.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.hierarchicalHeaders.put(1, (CellStyle)subHeader);
        subHeader = this.workbook.createCellStyle();
        subHeader.setFont((Font)f);
        subHeader.setBorderBottom(BorderStyle.THIN);
        subHeader.setBorderTop(BorderStyle.THIN);
        subHeader.setBorderLeft(BorderStyle.THIN);
        subHeader.setBorderRight(BorderStyle.THIN);
        subHeader.setAlignment(HorizontalAlignment.CENTER);
        subHeader.setVerticalAlignment(VerticalAlignment.CENTER);
        subHeader.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
        palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex(), (byte)-6, (byte)-26, (byte)-26);
        subHeader.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.hierarchicalHeaders.put(2, (CellStyle)subHeader);
        subHeader = this.workbook.createCellStyle();
        subHeader.setFont((Font)f);
        subHeader.setBorderBottom(BorderStyle.THIN);
        subHeader.setBorderTop(BorderStyle.THIN);
        subHeader.setBorderLeft(BorderStyle.THIN);
        subHeader.setBorderRight(BorderStyle.THIN);
        subHeader.setAlignment(HorizontalAlignment.CENTER);
        subHeader.setVerticalAlignment(VerticalAlignment.CENTER);
        subHeader.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), (byte)-6, (byte)-16, (byte)-16);
        subHeader.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (int i = 3; i < 100; ++i) {
            this.hierarchicalHeaders.put(i, (CellStyle)subHeader);
        }
    }

    public CellStyle getMainTitleStyle() {
        return this.mainTitle;
    }

    public float getMainTitleRowHeight() {
        return 26.0f;
    }

    public CellStyle getStandardStyle() {
        return this.standard;
    }

    public CellStyle getStandardStyle(int hierarchicalDepth) {
        CellStyle cellStyle = this.hierarchicalStyles.get(hierarchicalDepth);
        if (cellStyle == null) {
            cellStyle = this.standard;
        }
        return cellStyle;
    }

    public float getStandardHeight() {
        return 12.75f;
    }

    public CellStyle getHeaderStyle() {
        return this.standardHeader;
    }

    public CellStyle getHeaderStyle(int hierarchicalDepth) {
        CellStyle cellStyle = this.hierarchicalHeaders.get(hierarchicalDepth);
        if (cellStyle == null) {
            cellStyle = this.standardHeader;
        }
        return cellStyle;
    }

    public float getHeaderHeight() {
        return 12.75f;
    }
}

