/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.export.report.sections;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.WorkbookStyle;
import com.compomics.util.io.export.features.ReporterExportFeature;
import com.compomics.util.io.export.features.peptideshaker.PsFragmentFeature;
import com.compomics.util.io.export.features.peptideshaker.PsIdentificationAlgorithmMatchesFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import com.compomics.util.io.export.features.reporter.ReporterPeptideFeature;
import com.compomics.util.io.export.features.reporter.ReporterProteinFeatures;
import com.compomics.util.io.export.features.reporter.ReporterPsmFeatures;
import com.compomics.util.io.export.writers.ExcelWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.sections.PsProteinSection;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.export.report.ReporterReportStyle;
import eu.isas.reporter.export.report.sections.ReporterPeptideSection;
import eu.isas.reporter.quantificationdetails.ProteinQuantificationDetails;
import eu.isas.reporter.settings.ReporterSettings;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math.MathException;

public class ReporterProteinSection {
    private ArrayList<ExportFeature> identificationFeatures = new ArrayList();
    private ArrayList<ReporterExportFeature> quantificationFeatures = new ArrayList();
    private ReporterPeptideSection peptideSection = null;
    private boolean indexes;
    private boolean header;
    private ExportWriter writer;
    private ReporterReportStyle reporterStyle;

    public ReporterProteinSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        ArrayList<ExportFeature> peptideFeatures = new ArrayList<ExportFeature>();
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof ReporterProteinFeatures) {
                this.quantificationFeatures.add((ReporterExportFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof ReporterPeptideFeature || exportFeature instanceof ReporterPsmFeatures || exportFeature instanceof PsPeptideFeature || exportFeature instanceof PsPsmFeature || exportFeature instanceof PsIdentificationAlgorithmMatchesFeature || exportFeature instanceof PsFragmentFeature) {
                peptideFeatures.add(exportFeature);
                continue;
            }
            if (exportFeature instanceof PsProteinFeature) {
                this.identificationFeatures.add(exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Export feature of type " + exportFeature.getClass() + " not recognized.");
        }
        if (!peptideFeatures.isEmpty()) {
            this.peptideSection = new ReporterPeptideSection(peptideFeatures, indexes, header, writer);
        }
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        if (writer instanceof ExcelWriter) {
            this.reporterStyle = ReporterReportStyle.getReportStyle((ExcelWriter)writer);
        }
    }

    public void writeSection(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ProteinDetailsProvider proteinDetailsProvider, GeneMaps geneMaps, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, ReporterSettings reporterSettings, IdentificationParameters identificationParameters, long[] keys, int nSurroundingAas, boolean validatedOnly, boolean decoys, WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, MathException {
        ProteinMatch proteinMatch;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            this.writeHeader(reporterIonQuantification);
        }
        if (keys == null) {
            keys = identification.getProteinIdentification().stream().mapToLong(Long::longValue).toArray();
        }
        int line = 1;
        PSParameter psParameter = new PSParameter();
        ArrayList<PSParameter> parameters = new ArrayList<PSParameter>(1);
        parameters.add(psParameter);
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(keys.length);
        }
        ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(keys, waitingHandler);
        while ((proteinMatch = proteinMatchesIterator.next()) != null) {
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
            long proteinKey = proteinMatch.getKey();
            if (!decoys && proteinMatch.isDecoy()) continue;
            psParameter = (PSParameter)identification.getProteinMatch(proteinKey).getUrParam((UrParameter)psParameter);
            if (validatedOnly && !psParameter.getMatchValidationLevel().isValidated()) continue;
            boolean first = true;
            if (this.indexes) {
                this.writer.write(line + "");
                first = false;
            }
            for (ExportFeature exportFeature : this.identificationFeatures) {
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                PsProteinFeature psProteinFeature = (PsProteinFeature)exportFeature;
                this.writer.write(PsProteinSection.getFeature((IdentificationFeaturesGenerator)identificationFeaturesGenerator, (SequenceProvider)sequenceProvider, (ProteinDetailsProvider)proteinDetailsProvider, (GeneMaps)geneMaps, (IdentificationParameters)identificationParameters, (int)nSurroundingAas, (long)proteinKey, (ProteinMatch)proteinMatch, (PSParameter)psParameter, (PsProteinFeature)psProteinFeature, (WaitingHandler)waitingHandler));
            }
            ArrayList sampleIndexes = new ArrayList(reporterIonQuantification.getSampleIndexes());
            Collections.sort(sampleIndexes);
            for (ExportFeature exportFeature : this.quantificationFeatures) {
                ReporterProteinFeatures tempProteinFeatures = (ReporterProteinFeatures)exportFeature;
                if (tempProteinFeatures.hasChannels()) {
                    for (String sampleIndex : sampleIndexes) {
                        if (!first) {
                            this.writer.addSeparator();
                        } else {
                            first = false;
                        }
                        this.writer.write(ReporterProteinSection.getFeature(spectrumProvider, quantificationFeaturesGenerator, reporterIonQuantification, proteinKey, tempProteinFeatures, sampleIndex, waitingHandler), (WorkbookStyle)this.reporterStyle);
                    }
                    continue;
                }
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                this.writer.write(ReporterProteinSection.getFeature(spectrumProvider, quantificationFeaturesGenerator, reporterIonQuantification, proteinKey, tempProteinFeatures, "", waitingHandler), (WorkbookStyle)this.reporterStyle);
            }
            this.writer.newLine();
            if (this.peptideSection != null) {
                this.writer.increaseDepth();
                this.peptideSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, spectrumProvider, proteinDetailsProvider, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, identificationParameters, proteinMatch.getPeptideMatchesKeys(), nSurroundingAas, line + ".", validatedOnly, decoys, null);
                this.writer.decreaseDepth();
            }
            ++line;
        }
    }

    public static String getFeature(SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, long proteinKey, ReporterProteinFeatures proteinFeatures, String sampleIndex, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        switch (proteinFeatures) {
            case raw_ratio: {
                ProteinQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getProteinMatchQuantificationDetails(spectrumProvider, proteinKey, waitingHandler);
                return quantificationDetails.getRawRatio(sampleIndex).toString();
            }
            case ratio: {
                ProteinQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getProteinMatchQuantificationDetails(spectrumProvider, proteinKey, waitingHandler);
                return quantificationDetails.getRatio(sampleIndex, reporterIonQuantification.getNormalizationFactors()).toString();
            }
            case raw_unique_ratio: {
                ProteinQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getProteinMatchQuantificationDetails(spectrumProvider, proteinKey, waitingHandler);
                return quantificationDetails.getUniqueRawRatio(sampleIndex).toString();
            }
            case unique_ratio: {
                ProteinQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getProteinMatchQuantificationDetails(spectrumProvider, proteinKey, waitingHandler);
                return quantificationDetails.getUniqueRatio(sampleIndex, reporterIonQuantification.getNormalizationFactors()).toString();
            }
            case raw_shared_ratio: {
                ProteinQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getProteinMatchQuantificationDetails(spectrumProvider, proteinKey, waitingHandler);
                return quantificationDetails.getSharedRawRatio(sampleIndex).toString();
            }
            case shared_ratio: {
                ProteinQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getProteinMatchQuantificationDetails(spectrumProvider, proteinKey, waitingHandler);
                return quantificationDetails.getSharedRatio(sampleIndex, reporterIonQuantification.getNormalizationFactors()).toString();
            }
        }
        return "Not implemented";
    }

    public void writeHeader(ReporterIonQuantification reporterIonQuantification) throws IOException {
        boolean needSecondLine = false;
        ArrayList sampleIndexes = new ArrayList(reporterIonQuantification.getSampleIndexes());
        Collections.sort(sampleIndexes);
        boolean firstColumn = true;
        if (this.indexes) {
            this.writer.writeHeaderText("");
            this.writer.addSeparator();
        }
        for (ExportFeature exportFeature : this.identificationFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(exportFeature.getTitle());
        }
        for (ReporterExportFeature reporterExportFeature : this.quantificationFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(reporterExportFeature.getTitle(), (WorkbookStyle)this.reporterStyle);
            if (!reporterExportFeature.hasChannels()) continue;
            for (int i = 1; i < sampleIndexes.size(); ++i) {
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    this.writer.addSeparator();
                }
                this.writer.writeHeaderText(" ", (WorkbookStyle)this.reporterStyle);
            }
            needSecondLine = true;
        }
        if (needSecondLine) {
            this.writer.newLine();
            firstColumn = true;
            if (this.indexes) {
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            for (ExportFeature exportFeature : this.identificationFeatures) {
                if (firstColumn) {
                    firstColumn = false;
                    continue;
                }
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            for (ReporterExportFeature reporterExportFeature : this.quantificationFeatures) {
                if (reporterExportFeature.hasChannels()) {
                    for (String sampleIndex : sampleIndexes) {
                        if (firstColumn) {
                            firstColumn = false;
                        } else {
                            this.writer.writeHeaderText("", (WorkbookStyle)this.reporterStyle);
                            this.writer.addSeparator();
                        }
                        this.writer.writeHeaderText(reporterIonQuantification.getSample(sampleIndex), (WorkbookStyle)this.reporterStyle);
                    }
                    continue;
                }
                if (firstColumn) {
                    firstColumn = false;
                    continue;
                }
                this.writer.writeHeaderText("", (WorkbookStyle)this.reporterStyle);
                this.writer.addSeparator();
            }
        }
        this.writer.newLine();
    }
}

