/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.export.report.sections;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.WorkbookStyle;
import com.compomics.util.io.export.features.ReporterExportFeature;
import com.compomics.util.io.export.features.peptideshaker.PsFragmentFeature;
import com.compomics.util.io.export.features.peptideshaker.PsIdentificationAlgorithmMatchesFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import com.compomics.util.io.export.features.reporter.ReporterPsmFeatures;
import com.compomics.util.io.export.writers.ExcelWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.sections.PsFragmentSection;
import eu.isas.peptideshaker.export.sections.PsIdentificationAlgorithmMatchesSection;
import eu.isas.peptideshaker.export.sections.PsPsmSection;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.export.report.ReporterReportStyle;
import eu.isas.reporter.quantificationdetails.PsmQuantificationDetails;
import eu.isas.reporter.quantificationdetails.SpectrumQuantificationDetails;
import eu.isas.reporter.settings.ReporterSettings;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math.MathException;

public class ReporterPsmSection {
    private ArrayList<PsPsmFeature> psmFeatures = new ArrayList();
    private ArrayList<PsIdentificationAlgorithmMatchesFeature> identificationAlgorithmMatchesFeatures = new ArrayList();
    private ArrayList<ReporterExportFeature> quantificationFeatures = new ArrayList();
    private PsFragmentSection fragmentSection = null;
    private boolean indexes;
    private boolean header;
    private ExportWriter writer;
    private ReporterReportStyle reporterStyle;

    public ReporterPsmSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        ArrayList<ExportFeature> fragmentFeatures = new ArrayList<ExportFeature>();
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof ReporterPsmFeatures) {
                this.quantificationFeatures.add((ReporterExportFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof PsPsmFeature) {
                this.psmFeatures.add((PsPsmFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof PsIdentificationAlgorithmMatchesFeature) {
                this.identificationAlgorithmMatchesFeatures.add((PsIdentificationAlgorithmMatchesFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof PsFragmentFeature) {
                fragmentFeatures.add(exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Export feature of type " + exportFeature.getClass() + " not recognized.");
        }
        if (!fragmentFeatures.isEmpty()) {
            this.fragmentSection = new PsFragmentSection(fragmentFeatures, indexes, header, writer);
        }
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        if (writer instanceof ExcelWriter) {
            this.reporterStyle = ReporterReportStyle.getReportStyle((ExcelWriter)writer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeSection(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ProteinDetailsProvider proteinDetailsProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, ReporterSettings reporterSettings, IdentificationParameters identificationParameters, long[] keys, String linePrefix, int nSurroundingAA, boolean validatedOnly, boolean decoys, WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, MathException {
        SpectrumMatch spectrumMatch;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            this.writeHeader(reporterIonQuantification);
        }
        int line = 1;
        int totalSize = identification.getNumber(SpectrumMatch.class);
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(totalSize);
        }
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(keys, waitingHandler);
        while ((spectrumMatch = psmIterator.next()) != null) {
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
            String spectrumFile = spectrumMatch.getSpectrumFile();
            String spectrumTitle = spectrumMatch.getSpectrumTitle();
            PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
            if (validatedOnly && !psParameter.getMatchValidationLevel().isValidated()) continue;
            PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
            TagAssumption tagAssumption = spectrumMatch.getBestTagAssumption();
            if (peptideAssumption == null && tagAssumption == null || !decoys && (peptideAssumption == null || PeptideUtils.isDecoy((Peptide)peptideAssumption.getPeptide(), (SequenceProvider)sequenceProvider)) && tagAssumption == null) continue;
            boolean first = true;
            if (this.indexes) {
                if (linePrefix != null) {
                    this.writer.write(linePrefix);
                }
                this.writer.write(Integer.toString(line));
                first = false;
            }
            for (PsIdentificationAlgorithmMatchesFeature psIdentificationAlgorithmMatchesFeature : this.identificationAlgorithmMatchesFeatures) {
                String feature;
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                if (peptideAssumption != null) {
                    peptideAssumption = spectrumMatch.getBestPeptideAssumption();
                    feature = PsIdentificationAlgorithmMatchesSection.getPeptideAssumptionFeature((Identification)identification, (IdentificationFeaturesGenerator)identificationFeaturesGenerator, (SequenceProvider)sequenceProvider, (ProteinDetailsProvider)proteinDetailsProvider, (SpectrumProvider)spectrumProvider, (IdentificationParameters)identificationParameters, (String)linePrefix, (int)nSurroundingAA, (PeptideAssumption)peptideAssumption, (String)spectrumFile, (String)spectrumTitle, (PSParameter)psParameter, (PsIdentificationAlgorithmMatchesFeature)psIdentificationAlgorithmMatchesFeature, (WaitingHandler)waitingHandler);
                } else if (tagAssumption != null) {
                    feature = PsIdentificationAlgorithmMatchesSection.getTagAssumptionFeature((Identification)identification, (IdentificationFeaturesGenerator)identificationFeaturesGenerator, (SpectrumProvider)spectrumProvider, (IdentificationParameters)identificationParameters, (String)linePrefix, (TagAssumption)tagAssumption, (String)spectrumFile, (String)spectrumTitle, (PSParameter)psParameter, (PsIdentificationAlgorithmMatchesFeature)psIdentificationAlgorithmMatchesFeature, (WaitingHandler)waitingHandler);
                } else {
                    throw new IllegalArgumentException("No best match found for spectrum " + spectrumMatch.getKey() + ".");
                }
                this.writer.write(feature);
            }
            for (PsPsmFeature psPsmFeature : this.psmFeatures) {
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                this.writer.write(PsPsmSection.getFeature((Identification)identification, (IdentificationFeaturesGenerator)identificationFeaturesGenerator, (IdentificationParameters)identificationParameters, (String)linePrefix, (SpectrumMatch)spectrumMatch, (PSParameter)psParameter, (PsPsmFeature)psPsmFeature, (boolean)validatedOnly, (boolean)decoys, (WaitingHandler)waitingHandler));
            }
            ArrayList sampleIndexes = new ArrayList(reporterIonQuantification.getSampleIndexes());
            Collections.sort(sampleIndexes);
            for (ExportFeature exportFeature : this.quantificationFeatures) {
                ReporterPsmFeatures psmFeature3 = (ReporterPsmFeatures)exportFeature;
                if (psmFeature3.hasChannels()) {
                    for (String sampleIndex : sampleIndexes) {
                        if (!first) {
                            this.writer.addSeparator();
                        } else {
                            first = false;
                        }
                        this.writer.write(ReporterPsmSection.getFeature(identification, spectrumProvider, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, spectrumMatch.getKey(), psmFeature3, sampleIndex), (WorkbookStyle)this.reporterStyle);
                    }
                    continue;
                }
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                this.writer.write(ReporterPsmSection.getFeature(identification, spectrumProvider, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, spectrumMatch.getKey(), psmFeature3, ""), (WorkbookStyle)this.reporterStyle);
            }
            this.writer.newLine();
            if (this.fragmentSection != null) {
                void var27_35;
                String string = "";
                if (linePrefix != null) {
                    String string2 = string + linePrefix;
                }
                String string3 = (String)var27_35 + line + ".";
                if (peptideAssumption != null) {
                    this.fragmentSection.writeSection(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)peptideAssumption, sequenceProvider, spectrumProvider, identificationParameters, string3, null);
                } else if (tagAssumption != null) {
                    this.fragmentSection.writeSection(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)tagAssumption, sequenceProvider, spectrumProvider, identificationParameters, string3, null);
                }
            }
            ++line;
        }
    }

    public static String getFeature(Identification identification, SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, ReporterSettings reporterSettings, long matchKey, ReporterPsmFeatures psmFeatures, String sampleIndex) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        SpectrumMatch spectrumMatch = identification.getSpectrumMatch(matchKey);
        long spectrumKey = spectrumMatch.getKey();
        switch (psmFeatures) {
            case raw_ratio: {
                PsmQuantificationDetails psmDetails = quantificationFeaturesGenerator.getPSMQuantificationDetails(spectrumProvider, matchKey);
                return psmDetails.getRawRatio(sampleIndex).toString();
            }
            case ratio: {
                PsmQuantificationDetails psmDetails = quantificationFeaturesGenerator.getPSMQuantificationDetails(spectrumProvider, matchKey);
                return psmDetails.getRatio(sampleIndex, reporterIonQuantification.getNormalizationFactors()).toString();
            }
            case reporter_intensity: {
                SpectrumQuantificationDetails spectrumDetails = quantificationFeaturesGenerator.getSpectrumQuantificationDetails(spectrumProvider, reporterIonQuantification, reporterSettings.getReporterIonSelectionSettings(), spectrumMatch);
                IonMatch ionMatch = spectrumDetails.getRepoterMatch(sampleIndex);
                if (ionMatch == null) {
                    return "";
                }
                return ionMatch.peakIntensity + "";
            }
            case reporter_mz: {
                SpectrumQuantificationDetails spectrumDetails = quantificationFeaturesGenerator.getSpectrumQuantificationDetails(spectrumProvider, reporterIonQuantification, reporterSettings.getReporterIonSelectionSettings(), spectrumMatch);
                IonMatch ionMatch = spectrumDetails.getRepoterMatch(sampleIndex);
                if (ionMatch == null) {
                    return "";
                }
                return ionMatch.peakMz + "";
            }
            case deisotoped_intensity: {
                SpectrumQuantificationDetails spectrumDetails = quantificationFeaturesGenerator.getSpectrumQuantificationDetails(spectrumProvider, reporterIonQuantification, reporterSettings.getReporterIonSelectionSettings(), spectrumMatch);
                return spectrumDetails.getDeisotopedIntensity(sampleIndex).toString();
            }
        }
        return "Not implemented";
    }

    public void writeHeader(ReporterIonQuantification reporterIonQuantification) throws IOException {
        boolean needSecondLine = false;
        ArrayList sampleIndexes = new ArrayList(reporterIonQuantification.getSampleIndexes());
        Collections.sort(sampleIndexes);
        boolean firstColumn = true;
        if (this.indexes) {
            this.writer.writeHeaderText("");
            this.writer.addSeparator();
        }
        for (ExportFeature exportFeature : this.identificationAlgorithmMatchesFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.write(exportFeature.getTitle());
        }
        for (ExportFeature exportFeature : this.psmFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.write(exportFeature.getTitle());
        }
        for (ReporterExportFeature reporterExportFeature : this.quantificationFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(reporterExportFeature.getTitle(), (WorkbookStyle)this.reporterStyle);
            if (!reporterExportFeature.hasChannels()) continue;
            for (int i = 1; i < sampleIndexes.size(); ++i) {
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    this.writer.addSeparator();
                }
                this.writer.writeHeaderText(" ", (WorkbookStyle)this.reporterStyle);
            }
            needSecondLine = true;
        }
        if (needSecondLine) {
            this.writer.newLine();
            firstColumn = true;
            if (this.indexes) {
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            for (ExportFeature exportFeature : this.identificationAlgorithmMatchesFeatures) {
                if (firstColumn) {
                    firstColumn = false;
                    continue;
                }
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            for (ExportFeature exportFeature : this.psmFeatures) {
                if (firstColumn) {
                    firstColumn = false;
                    continue;
                }
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            for (ReporterExportFeature reporterExportFeature : this.quantificationFeatures) {
                if (reporterExportFeature.hasChannels()) {
                    for (String sampleIndex : sampleIndexes) {
                        if (firstColumn) {
                            firstColumn = false;
                        } else {
                            this.writer.addSeparator();
                        }
                        this.writer.writeHeaderText(reporterIonQuantification.getSample(sampleIndex), (WorkbookStyle)this.reporterStyle);
                    }
                    continue;
                }
                if (firstColumn) {
                    firstColumn = false;
                    continue;
                }
                this.writer.writeHeaderText("", (WorkbookStyle)this.reporterStyle);
                this.writer.addSeparator();
            }
        }
        this.writer.newLine();
    }
}

