/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import eu.isas.reporter.gui.ReporterGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JumpToPanel
extends JPanel {
    private JumpType jumpType = JumpType.proteinAndPeptides;
    private ReporterGUI reporterGUI;
    private HashMap<JumpType, ArrayList<Long>> possibilities = new HashMap();
    private HashMap<JumpType, Integer> currentSelection = new HashMap();
    private HashMap<JumpType, String> lastInput = new HashMap();
    private HashMap<JumpType, String> lastLabel = new HashMap();
    private HashMap<JumpType, String> welcomeText;
    private int keyPressedCounter = 0;
    private int waitingTime = 1000;
    private ArrayList<Long> currentProteinKeys;
    private HashMap<JumpType, ArrayList<Type>> types = new HashMap();
    private JLabel findJLabel;
    private JLabel indexLabel;
    private JTextField inputTxt;
    private JButton nextButton;
    private JButton previousButton;

    public JumpToPanel(ReporterGUI reporterGUI) {
        this.initComponents();
        this.reporterGUI = reporterGUI;
        this.currentProteinKeys = new ArrayList();
        this.welcomeText = new HashMap();
        this.welcomeText.put(JumpType.proteinAndPeptides, "(protein)");
        this.inputTxt.setText(this.welcomeText.get((Object)this.jumpType));
        this.indexLabel.setText("");
        this.previousButton.setEnabled(false);
        this.nextButton.setEnabled(false);
    }

    public void setProteinKeys(ArrayList<Long> currentProteinKeys) {
        this.currentProteinKeys = currentProteinKeys;
    }

    public void selectTextField() {
        this.inputTxt.requestFocus();
        this.inputTxt.selectAll();
    }

    public void setColor(Color color) {
        this.indexLabel.setForeground(color);
    }

    public void updateSelectionInTab() {
        this.indexLabel.setForeground(Color.BLACK);
        if (this.types.get((Object)this.jumpType).get(this.currentSelection.get((Object)this.jumpType)) == Type.PROTEIN) {
            Long selectedProtein = this.possibilities.get((Object)this.jumpType).get(this.currentSelection.get((Object)this.jumpType));
            ArrayList<Long> selectedProteins = new ArrayList<Long>();
            selectedProteins.add(selectedProtein);
            this.reporterGUI.minimizeChart();
            this.reporterGUI.setSelectedProteins(selectedProteins, true, true);
        }
        String label = "(" + (this.currentSelection.get((Object)this.jumpType) + 1) + " of " + this.possibilities.get((Object)this.jumpType).size() + ")";
        this.indexLabel.setText(label);
        this.lastLabel.put(this.jumpType, label);
    }

    public ArrayList<String> getPossibilitiesDescriptions() throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        Identification identification = this.reporterGUI.getIdentification();
        ArrayList<Type> typeList = this.types.get((Object)this.jumpType);
        ArrayList<Long> keys = this.possibilities.get((Object)this.jumpType);
        ArrayList<Long> proteinKeys = new ArrayList<Long>();
        for (int i = 0; i < keys.size(); ++i) {
            Long key = keys.get(i);
            if (typeList.get(i) != Type.PROTEIN) continue;
            proteinKeys.add(key);
        }
        if (!proteinKeys.isEmpty()) {
            identification.loadObjects(proteinKeys, null, false);
        }
        ArrayList<String> descriptions = new ArrayList<String>();
        for (int i = 0; i < keys.size(); ++i) {
            Long key = keys.get(i);
            Type type = typeList.get(i);
            String description = this.getItemDescription(key, type);
            descriptions.add(description);
        }
        return descriptions;
    }

    private String getItemDescription(Long key, Type itemType) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        Identification identification = this.reporterGUI.getIdentification();
        switch (itemType.ordinal()) {
            case 0: {
                ProteinMatch proteinMatch = identification.getProteinMatch(key.longValue());
                String mainMatch = proteinMatch.getLeadingAccession();
                String description = this.reporterGUI.getProteinDetailsProvider().getSimpleDescription(proteinMatch.getLeadingAccession());
                String result = mainMatch;
                for (String accession : proteinMatch.getAccessions()) {
                    if (accession.equals(mainMatch)) continue;
                    if (!result.equals(mainMatch)) {
                        result = result + ", ";
                    }
                    result = result + accession;
                }
                result = result + " - " + description;
                return result;
            }
        }
        return "Unknown";
    }

    public int getIndexOfSelectedItem() {
        return this.currentSelection.get((Object)this.jumpType);
    }

    public void setSelectedItem(int itemIndex) {
        this.currentSelection.put(this.jumpType, itemIndex);
    }

    private void initComponents() {
        this.findJLabel = new JLabel();
        this.inputTxt = new JTextField();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.indexLabel = new JLabel();
        this.setOpaque(false);
        this.findJLabel.setText("Find");
        this.inputTxt.setForeground(new Color(204, 204, 204));
        this.inputTxt.setHorizontalAlignment(0);
        this.inputTxt.setText("(peptide or protein)");
        this.inputTxt.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.inputTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                JumpToPanel.this.inputTxtMouseReleased(evt);
            }
        });
        this.inputTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JumpToPanel.this.inputTxtKeyReleased(evt);
            }
        });
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/previous_grey.png")));
        this.previousButton.setToolTipText("Previous");
        this.previousButton.setBorder(null);
        this.previousButton.setBorderPainted(false);
        this.previousButton.setContentAreaFilled(false);
        this.previousButton.setIconTextGap(0);
        this.previousButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/previous.png")));
        this.previousButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JumpToPanel.this.previousButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JumpToPanel.this.previousButtonMouseExited(evt);
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JumpToPanel.this.previousButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/next_grey.png")));
        this.nextButton.setToolTipText("Next");
        this.nextButton.setBorderPainted(false);
        this.nextButton.setContentAreaFilled(false);
        this.nextButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/next.png")));
        this.nextButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JumpToPanel.this.nextButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JumpToPanel.this.nextButtonMouseExited(evt);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JumpToPanel.this.nextButtonActionPerformed(evt);
            }
        });
        this.indexLabel.setFont(this.indexLabel.getFont().deriveFont(this.indexLabel.getFont().getStyle() | 2));
        this.indexLabel.setHorizontalAlignment(0);
        this.indexLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.findJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputTxt, -2, 205, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previousButton, -2, 15, -2).addGap(0, 0, 0).addComponent(this.nextButton, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexLabel, -2, 97, -2).addContainerGap()));
        layout.linkSize(0, this.nextButton, this.previousButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.findJLabel).addComponent(this.inputTxt, -2, -1, -2).addComponent(this.indexLabel).addComponent(this.previousButton, -2, 15, -2).addComponent(this.nextButton, -2, 15, -2)).addContainerGap()));
    }

    private void inputTxtKeyReleased(KeyEvent evt) {
        final KeyEvent event = evt;
        ++this.keyPressedCounter;
        new Thread("FindThread"){

            @Override
            public synchronized void run() {
                try {
                    this.wait(JumpToPanel.this.waitingTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    Identification identification = JumpToPanel.this.reporterGUI.getIdentification();
                    if (identification != null && JumpToPanel.this.keyPressedCounter == 1) {
                        if (!JumpToPanel.this.inputTxt.getText().equalsIgnoreCase((String)JumpToPanel.this.welcomeText.get((Object)JumpToPanel.this.jumpType))) {
                            JumpToPanel.this.inputTxt.setForeground(Color.black);
                        } else {
                            JumpToPanel.this.inputTxt.setForeground(new Color(204, 204, 204));
                        }
                        if (event.getKeyCode() == 38 && JumpToPanel.this.previousButton.isEnabled()) {
                            JumpToPanel.this.previousButtonActionPerformed(null);
                        } else if (event.getKeyCode() == 40 && JumpToPanel.this.nextButton.isEnabled()) {
                            JumpToPanel.this.nextButtonActionPerformed(null);
                        } else {
                            if (!JumpToPanel.this.possibilities.containsKey((Object)JumpToPanel.this.jumpType)) {
                                JumpToPanel.this.possibilities.put(JumpToPanel.this.jumpType, new ArrayList());
                                JumpToPanel.this.types.put(JumpToPanel.this.jumpType, new ArrayList());
                            } else {
                                ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpToPanel.this.jumpType)).clear();
                                ((ArrayList)JumpToPanel.this.types.get((Object)JumpToPanel.this.jumpType)).clear();
                            }
                            JumpToPanel.this.currentSelection.put(JumpToPanel.this.jumpType, 0);
                            String inputLowerCase = JumpToPanel.this.inputTxt.getText().trim().toLowerCase();
                            JumpToPanel.this.lastInput.put(JumpToPanel.this.jumpType, inputLowerCase);
                            if (!inputLowerCase.equals("")) {
                                JumpToPanel.this.reporterGUI.setCursor(new Cursor(3));
                                JumpToPanel.this.inputTxt.setCursor(new Cursor(3));
                                if (JumpToPanel.this.jumpType == JumpType.proteinAndPeptides) {
                                    Iterator iterator = JumpToPanel.this.currentProteinKeys.iterator();
                                    while (iterator.hasNext()) {
                                        long proteinKey = (Long)iterator.next();
                                        ProteinMatch proteinMatch = identification.getProteinMatch(proteinKey);
                                        if (proteinMatch.isDecoy() || !Arrays.stream(proteinMatch.getAccessions()).map(accession -> accession.toLowerCase()).anyMatch(accession -> accession.contains(inputLowerCase)) && !Arrays.stream(proteinMatch.getAccessions()).map(accession -> JumpToPanel.this.reporterGUI.getProteinDetailsProvider().getDescription(accession)).map(description -> description.toLowerCase()).anyMatch(description -> description.contains(inputLowerCase))) continue;
                                        ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpToPanel.this.jumpType)).add(proteinKey);
                                        for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                                            ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpToPanel.this.jumpType)).add(peptideKey);
                                        }
                                    }
                                }
                                if (!((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpToPanel.this.jumpType)).isEmpty()) {
                                    if (((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpToPanel.this.jumpType)).size() > 1) {
                                        JumpToPanel.this.previousButton.setEnabled(true);
                                        JumpToPanel.this.nextButton.setEnabled(true);
                                    } else {
                                        JumpToPanel.this.previousButton.setEnabled(false);
                                        JumpToPanel.this.nextButton.setEnabled(false);
                                    }
                                    JumpToPanel.this.updateSelectionInTab();
                                } else {
                                    JumpToPanel.this.previousButton.setEnabled(false);
                                    JumpToPanel.this.nextButton.setEnabled(false);
                                    if (!inputLowerCase.equalsIgnoreCase((String)JumpToPanel.this.welcomeText.get((Object)JumpToPanel.this.jumpType))) {
                                        JumpToPanel.this.indexLabel.setText("(no matches)");
                                    } else {
                                        JumpToPanel.this.indexLabel.setText("");
                                    }
                                }
                                JumpToPanel.this.reporterGUI.setCursor(new Cursor(0));
                                JumpToPanel.this.inputTxt.setCursor(new Cursor(0));
                                JumpToPanel.this.inputTxt.requestFocus();
                            } else {
                                JumpToPanel.this.indexLabel.setText("");
                                JumpToPanel.this.previousButton.setEnabled(false);
                                JumpToPanel.this.nextButton.setEnabled(false);
                                JumpToPanel.this.inputTxt.setText((String)JumpToPanel.this.welcomeText.get((Object)JumpToPanel.this.jumpType));
                                JumpToPanel.this.inputTxt.selectAll();
                                JumpToPanel.this.inputTxt.requestFocus();
                            }
                        }
                        JumpToPanel.this.lastLabel.put(JumpToPanel.this.jumpType, JumpToPanel.this.indexLabel.getText());
                        JumpToPanel.this.keyPressedCounter = 0;
                    } else {
                        JumpToPanel.this.keyPressedCounter--;
                    }
                }
                catch (Exception e) {
                    JumpToPanel.this.reporterGUI.catchException(e);
                }
            }
        }.start();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        if (this.currentSelection.get((Object)this.jumpType) == 0) {
            this.currentSelection.put(this.jumpType, this.possibilities.get((Object)this.jumpType).size() - 1);
        } else {
            this.currentSelection.put(this.jumpType, this.currentSelection.get((Object)this.jumpType) - 1);
        }
        this.updateSelectionInTab();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (this.currentSelection.get((Object)this.jumpType) == this.possibilities.get((Object)this.jumpType).size() - 1) {
            this.currentSelection.put(this.jumpType, 0);
        } else {
            this.currentSelection.put(this.jumpType, this.currentSelection.get((Object)this.jumpType) + 1);
        }
        this.updateSelectionInTab();
    }

    private void inputTxtMouseReleased(MouseEvent evt) {
        if (this.inputTxt.getText().equals(this.welcomeText.get((Object)this.jumpType))) {
            this.inputTxt.selectAll();
        }
    }

    private void previousButtonMouseEntered(MouseEvent evt) {
        if (this.previousButton.isEnabled()) {
            this.setCursor(new Cursor(12));
        }
    }

    private void previousButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void nextButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void nextButtonMouseEntered(MouseEvent evt) {
        if (this.nextButton.isEnabled()) {
            this.setCursor(new Cursor(12));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.inputTxt.setEnabled(enabled);
        this.indexLabel.setEnabled(enabled);
        if (!this.possibilities.isEmpty() && enabled) {
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(true);
        } else {
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
        }
    }

    public void setType(JumpType jumpType) {
        this.jumpType = jumpType;
        if (this.lastInput.get((Object)jumpType) != null && !this.lastInput.get((Object)jumpType).equals("")) {
            this.inputTxt.setText(this.lastInput.get((Object)jumpType));
            this.indexLabel.setText(this.lastLabel.get((Object)jumpType));
        } else {
            this.inputTxt.setText(this.welcomeText.get((Object)jumpType));
            this.indexLabel.setText("");
        }
    }

    public static enum JumpType {
        proteinAndPeptides;

    }

    private static enum Type {
        PROTEIN;

    }
}

