/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileHandler;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFolder;
import com.compomics.util.experiment.quantification.Quantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethodFactory;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.parameters.tools.ProcessingParametersDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.utils.PsdbParent;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.gui.MethodSettingsDialog;
import eu.isas.reporter.gui.ReporterGUI;
import eu.isas.reporter.gui.WelcomeDialog;
import eu.isas.reporter.gui.settings.ReporterSettingsDialog;
import eu.isas.reporter.io.ProjectImporter;
import eu.isas.reporter.preferences.DisplayPreferences;
import eu.isas.reporter.settings.ReporterPreferences;
import eu.isas.reporter.settings.ReporterSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import org.jdesktop.layout.GroupLayout;
import org.xmlpull.v1.XmlPullParserException;

public class NewDialog
extends JDialog {
    private File methodsFile;
    private ReporterMethodFactory methodsFactory = ReporterMethodFactory.getInstance();
    private ReporterGUI reporterGUI;
    private ReporterMethod selectedMethod = null;
    private PsdbParent psdbParent;
    private ArrayList<File> spectrumFiles = new ArrayList();
    private File fastaFile;
    private ReporterSettings reporterSettings;
    private DisplayPreferences displayPreferences;
    private ProcessingParameters processingParameters = new ProcessingParameters();
    private ProgressDialogX progressDialog;
    private WelcomeDialog welcomeDialog;
    private HashMap<String, String> sampleNames = new HashMap();
    private ArrayList<String> reagents = new ArrayList();
    private ArrayList<String> controlSamples = new ArrayList();
    private boolean cancelled = false;
    private ReporterIonQuantification reporterIonQuantification = null;
    private final double DEFAULT_REPORTER_ION_TOLERANCE_TMT = 0.0016;
    private final double DEFAULT_REPORTER_ION_TOLERANCE_ITRAQ = 0.05;
    private ArrayList<String> sampleAssignmentTableToolTips;
    private ProjectDetails projectDetails = new ProjectDetails();
    private MsFileHandler msFileHandler = new MsFileHandler();
    private JButton aboutButton;
    private JButton addDbButton;
    private JButton addIdFilesButton;
    private JButton addSpectraFilesJButton;
    private JPanel advancedSettingsPanel;
    private JPanel backgroundPanel;
    private JLabel databaseFileLabel;
    private JButton editProcessingButton;
    private JButton editQuantPrefsButton;
    private JTextField fastaTxt;
    private JPanel fileSelectiontPanel;
    private JLabel idFilesLabel;
    private JButton loadButton;
    private JButton methodSettingsButton;
    private JButton moveBottomButton;
    private JButton moveDownButton;
    private JButton moveTopButton;
    private JButton moveUpButton;
    private JPanel orderSettingsPanel;
    private JLabel processingLbl;
    private JTextField processingTxt;
    private JLabel quantPreferencesLabel;
    private JTextField quantificationPreferencesTxt;
    private JComboBox reporterMethodComboBox;
    private JLabel reporterMethodLabel;
    private JLabel reporterPublicationLabel;
    private JScrollPane sampleAssignmentJScrollPane;
    private JTable sampleAssignmentTable;
    private JPanel samplePanel;
    private JLabel spectrumFilesLabel;
    private JTextField txtIdFileLocation;
    private JTextField txtSpectraFileLocation;

    public NewDialog(ReporterGUI reporterGUI, boolean modal) {
        super((Frame)reporterGUI, modal);
        this.reporterGUI = reporterGUI;
        this.welcomeDialog = null;
        this.methodsFile = Reporter.getMethodsFile();
        this.importMethods();
        this.initComponents();
        this.setUpGui();
        this.loadDefaultPreferences();
        if (this.selectedMethod == null && this.methodsFactory.getMethodsNames() != null && !this.methodsFactory.getMethodsNames().isEmpty()) {
            this.reporterMethodComboBox.setSelectedItem(this.methodsFactory.getReporterMethod((String)this.methodsFactory.getMethodsNames().get(0)));
        }
        this.reporterMethodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDialog.this.selectedMethod = NewDialog.this.methodsFactory.getReporterMethod((String)NewDialog.this.reporterMethodComboBox.getSelectedItem());
                NewDialog.this.reagents = NewDialog.this.selectedMethod.getReagentsSortedByMass();
                NewDialog.this.refresh();
            }
        });
        reporterGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")));
        this.refresh();
        this.setLocationRelativeTo(reporterGUI);
        this.setVisible(true);
    }

    public NewDialog(WelcomeDialog welcomeDialog, ReporterGUI reporterGui, boolean modal) {
        super((Dialog)welcomeDialog, modal);
        this.reporterGUI = reporterGui;
        this.welcomeDialog = welcomeDialog;
        this.methodsFile = Reporter.getMethodsFile();
        this.importMethods();
        this.initComponents();
        this.setUpGui();
        this.loadDefaultPreferences();
        if (this.selectedMethod == null && this.methodsFactory.getMethodsNames() != null && !this.methodsFactory.getMethodsNames().isEmpty()) {
            this.reporterMethodComboBox.setSelectedItem(this.methodsFactory.getMethodsNames().get(0));
        }
        this.reporterMethodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewDialog.this.selectedMethod = NewDialog.this.methodsFactory.getReporterMethod((String)NewDialog.this.reporterMethodComboBox.getSelectedItem());
                NewDialog.this.reagents = NewDialog.this.selectedMethod.getReagentsSortedByMass();
                NewDialog.this.refresh();
            }
        });
        reporterGui.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")));
        this.refresh();
        this.setLocationRelativeTo(welcomeDialog);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.sampleAssignmentTableToolTips = new ArrayList();
        this.sampleAssignmentTableToolTips.add(null);
        this.sampleAssignmentTableToolTips.add("The reporter label");
        this.sampleAssignmentTableToolTips.add("The sample name");
        this.sampleAssignmentTableToolTips.add("The reference sample(s)");
        this.sampleAssignmentJScrollPane.getViewport().setOpaque(false);
        this.reporterMethodComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.sampleAssignmentTable.getTableHeader().setReorderingAllowed(false);
        this.processingTxt.setText(this.processingParameters.getnThreads() + " cores");
    }

    private void setTableProperties() {
        this.sampleAssignmentTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.sampleAssignmentTable.getColumnModel().getColumn(1).setMinWidth(150);
        this.sampleAssignmentTable.getColumnModel().getColumn(1).setMaxWidth(150);
        this.sampleAssignmentTable.getColumnModel().getColumn(3).setMinWidth(80);
        this.sampleAssignmentTable.getColumnModel().getColumn(3).setMaxWidth(80);
        this.sampleAssignmentTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green-new.png")), null, "Yes", "No"));
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.fileSelectiontPanel = new JPanel();
        this.spectrumFilesLabel = new JLabel();
        this.txtSpectraFileLocation = new JTextField();
        this.idFilesLabel = new JLabel();
        this.txtIdFileLocation = new JTextField();
        this.addIdFilesButton = new JButton();
        this.addSpectraFilesJButton = new JButton();
        this.databaseFileLabel = new JLabel();
        this.fastaTxt = new JTextField();
        this.addDbButton = new JButton();
        this.samplePanel = new JPanel();
        this.sampleAssignmentJScrollPane = new JScrollPane();
        this.sampleAssignmentTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)NewDialog.this.sampleAssignmentTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.reporterMethodLabel = new JLabel();
        this.reporterMethodComboBox = new JComboBox();
        this.methodSettingsButton = new JButton();
        this.orderSettingsPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveTopButton = new JButton();
        this.moveDownButton = new JButton();
        this.moveBottomButton = new JButton();
        this.advancedSettingsPanel = new JPanel();
        this.quantPreferencesLabel = new JLabel();
        this.quantificationPreferencesTxt = new JTextField();
        this.editQuantPrefsButton = new JButton();
        this.editProcessingButton = new JButton();
        this.processingTxt = new JTextField();
        this.processingLbl = new JLabel();
        this.aboutButton = new JButton();
        this.reporterPublicationLabel = new JLabel();
        this.loadButton = new JButton();
        this.setTitle("New Project");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.fileSelectiontPanel.setBorder(BorderFactory.createTitledBorder("Files Selection"));
        this.fileSelectiontPanel.setOpaque(false);
        this.spectrumFilesLabel.setText("Spectrum File(s)");
        this.txtSpectraFileLocation.setEditable(false);
        this.txtSpectraFileLocation.setHorizontalAlignment(0);
        this.idFilesLabel.setText("Project File");
        this.txtIdFileLocation.setEditable(false);
        this.txtIdFileLocation.setHorizontalAlignment(0);
        this.txtIdFileLocation.setText("Please import a project");
        this.addIdFilesButton.setText("Browse");
        this.addIdFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.addIdFilesButtonActionPerformed(evt);
            }
        });
        this.addSpectraFilesJButton.setText("Browse");
        this.addSpectraFilesJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.addSpectraFilesJButtonActionPerformed(evt);
            }
        });
        this.databaseFileLabel.setText("Database File");
        this.fastaTxt.setEditable(false);
        this.fastaTxt.setHorizontalAlignment(0);
        this.addDbButton.setText("Browse");
        this.addDbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.addDbButtonActionPerformed(evt);
            }
        });
        GroupLayout fileSelectiontPanelLayout = new GroupLayout((Container)this.fileSelectiontPanel);
        this.fileSelectiontPanel.setLayout((LayoutManager)fileSelectiontPanelLayout);
        fileSelectiontPanelLayout.setHorizontalGroup((GroupLayout.Group)fileSelectiontPanelLayout.createParallelGroup(1).add((GroupLayout.Group)fileSelectiontPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)fileSelectiontPanelLayout.createParallelGroup(1).add((Component)this.spectrumFilesLabel, -2, 120, -2).add((Component)this.databaseFileLabel, -2, 120, -2).add((Component)this.idFilesLabel, -2, 120, -2)).add(10, 10, 10).add((GroupLayout.Group)fileSelectiontPanelLayout.createParallelGroup(1).add((Component)this.txtIdFileLocation).add((Component)this.txtSpectraFileLocation, -1, 531, Short.MAX_VALUE).add((Component)this.fastaTxt)).addPreferredGap(0).add((GroupLayout.Group)fileSelectiontPanelLayout.createParallelGroup(1).add(2, (Component)this.addSpectraFilesJButton).add(2, (Component)this.addIdFilesButton).add((Component)this.addDbButton)).addContainerGap()));
        fileSelectiontPanelLayout.linkSize(new Component[]{this.addDbButton, this.addIdFilesButton, this.addSpectraFilesJButton}, 1);
        fileSelectiontPanelLayout.setVerticalGroup((GroupLayout.Group)fileSelectiontPanelLayout.createParallelGroup(1).add((GroupLayout.Group)fileSelectiontPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)fileSelectiontPanelLayout.createParallelGroup(3).add((Component)this.idFilesLabel).add((Component)this.txtIdFileLocation, -2, -1, -2).add((Component)this.addIdFilesButton)).add(0, 0, 0).add((GroupLayout.Group)fileSelectiontPanelLayout.createParallelGroup(3).add((Component)this.spectrumFilesLabel).add((Component)this.txtSpectraFileLocation, -2, -1, -2).add((Component)this.addSpectraFilesJButton)).add(0, 0, 0).add((GroupLayout.Group)fileSelectiontPanelLayout.createParallelGroup(3).add((Component)this.databaseFileLabel).add((Component)this.fastaTxt, -2, -1, -2).add((Component)this.addDbButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.samplePanel.setBorder(BorderFactory.createTitledBorder("Sample Assignment"));
        this.samplePanel.setOpaque(false);
        this.sampleAssignmentTable.setModel(new AssignementTableModel());
        this.sampleAssignmentTable.setOpaque(false);
        this.sampleAssignmentTable.setSelectionMode(0);
        this.sampleAssignmentTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewDialog.this.sampleAssignmentTableMouseReleased(evt);
            }
        });
        this.sampleAssignmentJScrollPane.setViewportView(this.sampleAssignmentTable);
        this.reporterMethodLabel.setText("Reporter Method");
        this.reporterMethodComboBox.setModel(new DefaultComboBoxModel<String>(this.methodsFactory.getMethodsNamesAsArray()));
        this.reporterMethodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.reporterMethodComboBoxActionPerformed(evt);
            }
        });
        this.methodSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.methodSettingsButton.setToolTipText("Edit Method Settings");
        this.methodSettingsButton.setBorder(null);
        this.methodSettingsButton.setBorderPainted(false);
        this.methodSettingsButton.setContentAreaFilled(false);
        this.methodSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.methodSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewDialog.this.methodSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewDialog.this.methodSettingsButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewDialog.this.methodSettingsButtonMouseReleased(evt);
            }
        });
        this.orderSettingsPanel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.orderSettingsPanel.setOpaque(false);
        this.moveUpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUp_grey.png")));
        this.moveUpButton.setToolTipText("Move Up");
        this.moveUpButton.setBorderPainted(false);
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUp.png")));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.moveUpButtonActionPerformed(evt);
            }
        });
        this.moveTopButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUpTop_grey.png")));
        this.moveTopButton.setToolTipText("Move to Top");
        this.moveTopButton.setBorderPainted(false);
        this.moveTopButton.setContentAreaFilled(false);
        this.moveTopButton.setEnabled(false);
        this.moveTopButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUpTop.png")));
        this.moveTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.moveTopButtonActionPerformed(evt);
            }
        });
        this.moveDownButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDown_grey.png")));
        this.moveDownButton.setToolTipText("Move Down");
        this.moveDownButton.setBorderPainted(false);
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDown.png")));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.moveDownButtonActionPerformed(evt);
            }
        });
        this.moveBottomButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDownBottom_grey.png")));
        this.moveBottomButton.setToolTipText("Move to Bottom");
        this.moveBottomButton.setBorderPainted(false);
        this.moveBottomButton.setContentAreaFilled(false);
        this.moveBottomButton.setEnabled(false);
        this.moveBottomButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDownBottom.png")));
        this.moveBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.moveBottomButtonActionPerformed(evt);
            }
        });
        GroupLayout orderSettingsPanelLayout = new GroupLayout((Container)this.orderSettingsPanel);
        this.orderSettingsPanel.setLayout((LayoutManager)orderSettingsPanelLayout);
        orderSettingsPanelLayout.setHorizontalGroup((GroupLayout.Group)orderSettingsPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)orderSettingsPanelLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)orderSettingsPanelLayout.createParallelGroup(1, false).add(2, (Component)this.moveUpButton, -2, 0, Short.MAX_VALUE).add(2, (Component)this.moveDownButton, -2, 0, Short.MAX_VALUE).add(2, (Component)this.moveBottomButton, -2, 36, -2).add((Component)this.moveTopButton, -2, 36, -2))));
        orderSettingsPanelLayout.setVerticalGroup((GroupLayout.Group)orderSettingsPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)orderSettingsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.moveTopButton, -2, 20, -2).addPreferredGap(0).add((Component)this.moveUpButton, -2, 20, -2).addPreferredGap(0).add((Component)this.moveDownButton, -2, 20, -2).addPreferredGap(0).add((Component)this.moveBottomButton, -2, 20, -2).addContainerGap()));
        GroupLayout samplePanelLayout = new GroupLayout((Container)this.samplePanel);
        this.samplePanel.setLayout((LayoutManager)samplePanelLayout);
        samplePanelLayout.setHorizontalGroup((GroupLayout.Group)samplePanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)samplePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)samplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)samplePanelLayout.createSequentialGroup().add((Component)this.reporterMethodLabel, -2, 120, -2).addPreferredGap(1).add((Component)this.reporterMethodComboBox, 0, 533, Short.MAX_VALUE)).add((Component)this.sampleAssignmentJScrollPane)).addPreferredGap(0).add((GroupLayout.Group)samplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)samplePanelLayout.createSequentialGroup().add((Component)this.methodSettingsButton, -2, 66, -2).addContainerGap()).add(2, (GroupLayout.Group)samplePanelLayout.createSequentialGroup().add((Component)this.orderSettingsPanel, -2, -1, -2).add(18, 18, 18)))));
        samplePanelLayout.setVerticalGroup((GroupLayout.Group)samplePanelLayout.createParallelGroup(1).add((GroupLayout.Group)samplePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)samplePanelLayout.createParallelGroup(4).add((Component)this.reporterMethodLabel).add((Component)this.reporterMethodComboBox, -2, -1, -2).add((Component)this.methodSettingsButton)).addPreferredGap(1).add((GroupLayout.Group)samplePanelLayout.createParallelGroup(1).add((Component)this.sampleAssignmentJScrollPane, -1, 205, Short.MAX_VALUE).add((GroupLayout.Group)samplePanelLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.orderSettingsPanel, -2, -1, -2))).addContainerGap()));
        this.advancedSettingsPanel.setBorder(BorderFactory.createTitledBorder("Advanced Settings"));
        this.advancedSettingsPanel.setOpaque(false);
        this.quantPreferencesLabel.setText("Quantification");
        this.quantificationPreferencesTxt.setEditable(false);
        this.quantificationPreferencesTxt.setHorizontalAlignment(0);
        this.quantificationPreferencesTxt.setText("Default Settings");
        this.editQuantPrefsButton.setText("Edit");
        this.editQuantPrefsButton.setEnabled(false);
        this.editQuantPrefsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.editQuantPrefsButtonActionPerformed(evt);
            }
        });
        this.editProcessingButton.setText("Edit");
        this.editProcessingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.editProcessingButtonActionPerformed(evt);
            }
        });
        this.processingTxt.setEditable(false);
        this.processingTxt.setHorizontalAlignment(0);
        this.processingTxt.setText("Default Settings");
        this.processingLbl.setText("Processing");
        GroupLayout advancedSettingsPanelLayout = new GroupLayout((Container)this.advancedSettingsPanel);
        this.advancedSettingsPanel.setLayout((LayoutManager)advancedSettingsPanelLayout);
        advancedSettingsPanelLayout.setHorizontalGroup((GroupLayout.Group)advancedSettingsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)advancedSettingsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)advancedSettingsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)advancedSettingsPanelLayout.createSequentialGroup().add((Component)this.quantPreferencesLabel, -2, 120, -2).addPreferredGap(1).add((Component)this.quantificationPreferencesTxt, -1, 532, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.editQuantPrefsButton, -2, 66, -2)).add((GroupLayout.Group)advancedSettingsPanelLayout.createSequentialGroup().add((Component)this.processingLbl, -2, 120, -2).addPreferredGap(1).add((Component)this.processingTxt).addPreferredGap(0).add((Component)this.editProcessingButton, -2, 66, -2))).addContainerGap()));
        advancedSettingsPanelLayout.setVerticalGroup((GroupLayout.Group)advancedSettingsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)advancedSettingsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)advancedSettingsPanelLayout.createParallelGroup(3).add((Component)this.quantPreferencesLabel).add((Component)this.quantificationPreferencesTxt, -2, -1, -2).add((Component)this.editQuantPrefsButton)).add(0, 0, 0).add((GroupLayout.Group)advancedSettingsPanelLayout.createParallelGroup(3).add((Component)this.processingLbl).add((Component)this.processingTxt, -2, -1, -2).add((Component)this.editProcessingButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Reporter-shadow.png")));
        this.aboutButton.setToolTipText("Open the Reporter web page");
        this.aboutButton.setBorder(null);
        this.aboutButton.setBorderPainted(false);
        this.aboutButton.setContentAreaFilled(false);
        this.aboutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewDialog.this.aboutButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewDialog.this.aboutButtonMouseExited(evt);
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.aboutButtonActionPerformed(evt);
            }
        });
        this.reporterPublicationLabel.setText("<html>Please cite Reporter as <a href=\"http://compomics.github.io/projects/reporter.html\">http://compomics.github.io/projects/reporter.html</a></html>");
        this.reporterPublicationLabel.setToolTipText("Open the Reporter web page");
        this.reporterPublicationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewDialog.this.reporterPublicationLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewDialog.this.reporterPublicationLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewDialog.this.reporterPublicationLabelMouseExited(evt);
            }
        });
        this.loadButton.setBackground(new Color(0, 153, 0));
        this.loadButton.setFont(this.loadButton.getFont().deriveFont(this.loadButton.getFont().getStyle() | 1));
        this.loadButton.setForeground(new Color(255, 255, 255));
        this.loadButton.setText("Start Quantifying!");
        this.loadButton.setToolTipText("Click here to start the quantification");
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.loadButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout((Container)this.backgroundPanel);
        this.backgroundPanel.setLayout((LayoutManager)backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(2).add((Component)this.advancedSettingsPanel, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().add((Component)this.aboutButton).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.reporterPublicationLabel, -2, 422, -2).addPreferredGap(0).add((Component)this.loadButton, -2, 167, -2).add(14, 14, 14)).add(1, (Component)this.fileSelectiontPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.samplePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.fileSelectiontPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.samplePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.advancedSettingsPanel, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(4).add((Component)this.aboutButton).add((Component)this.reporterPublicationLabel, -2, 45, -2).add((Component)this.loadButton, -2, 53, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void addIdFilesButtonActionPerformed(ActionEvent evt) {
        String psdbFileFilterDescription = "PeptideShaker Database (.psdb)";
        String zipFileFilterDescription = "Zipped PeptideShaker (.zip)";
        String lastSelectedFolderPath = this.reporterGUI.getLastSelectedFolder().getLastSelectedFolder();
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".psdb", ".zip"}, (String[])new String[]{psdbFileFilterDescription, zipFileFilterDescription}, (String)"Open PeptideShaker Project", (String)lastSelectedFolderPath, null, (boolean)true, (boolean)false, (boolean)false, (int)0);
        if (selectedFileAndFilter != null) {
            File selectedFile = selectedFileAndFilter.getFile();
            this.reporterGUI.getLastSelectedFolder().setLastSelectedFolder(selectedFile.getParent());
            if (!selectedFile.getName().toLowerCase().endsWith(".zip")) {
                if (selectedFile.getName().toLowerCase().endsWith(".psdb")) {
                    this.importPeptideShakerFile(selectedFile);
                    LastSelectedFolder lastSelectedFolder = this.reporterGUI.getLastSelectedFolder();
                    lastSelectedFolder.setLastSelectedFolder(selectedFile.getAbsolutePath());
                } else {
                    JOptionPane.showMessageDialog(this, "Not a PeptideShaker file.", "Unsupported File.", 2);
                }
            }
        }
    }

    private void addSpectraFilesJButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.reporterGUI.getLastSelectedFolder().getLastSelectedFolder());
        fileChooser.setDialogTitle("Select Spectrum File(s)");
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(".mgf") || myFile.getName().toLowerCase().endsWith(".mgf.gz") || myFile.getName().toLowerCase().endsWith(".mzml") || myFile.getName().toLowerCase().endsWith(".mzml.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "mgf or mzML (.mgf, .mgf.gz, .mzml, .mzml.gz)";
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(this, "Add");
        if (returnVal == 0) {
            final ArrayList<File> selectedFiles = new ArrayList<File>();
            for (File newFile : fileChooser.getSelectedFiles()) {
                if (newFile.isDirectory()) {
                    File[] tempFiles;
                    for (File file : tempFiles = newFile.listFiles()) {
                        if (!file.getName().toLowerCase().endsWith(".mgf") && !file.getName().toLowerCase().endsWith(".mgf.gz") && !file.getName().toLowerCase().endsWith(".mzml") && !file.getName().toLowerCase().endsWith(".mzml.gz")) continue;
                        selectedFiles.add(file);
                    }
                    continue;
                }
                selectedFiles.add(newFile);
            }
            this.progressDialog = new ProgressDialogX((JDialog)this, (Frame)this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Loading Files. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        NewDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("loadingThread"){

                @Override
                public void run() {
                    boolean allLoaded = true;
                    for (File file : selectedFiles) {
                        try {
                            File folder = CmsFolder.getParentFolder() == null ? file.getParentFile() : new File(CmsFolder.getParentFolder());
                            NewDialog.this.msFileHandler.register(file, folder, (WaitingHandler)NewDialog.this.progressDialog);
                        }
                        catch (Exception e) {
                            NewDialog.this.progressDialog.setRunCanceled();
                            allLoaded = false;
                            JOptionPane.showMessageDialog(null, "An error occurred while reading the following file.\n" + file.getAbsolutePath() + "\n\nError:\n" + e.getLocalizedMessage(), "File error", 0);
                            e.printStackTrace();
                        }
                    }
                    NewDialog.this.progressDialog.setRunFinished();
                    if (allLoaded) {
                        NewDialog.this.spectrumFiles.addAll(selectedFiles);
                        NewDialog.this.txtSpectraFileLocation.setText(NewDialog.this.spectrumFiles.size() + " file(s) selected");
                        NewDialog.this.validateInput();
                    }
                }
            }.start();
        }
    }

    private void reporterMethodComboBoxActionPerformed(ActionEvent evt) {
        this.sampleNames = new HashMap();
        this.selectedMethod = this.methodsFactory.getReporterMethod((String)this.reporterMethodComboBox.getSelectedItem());
        this.reagents = this.selectedMethod.getReagentsSortedByMass();
        if (this.psdbParent != null) {
            IdentificationParameters identificationParameters = this.psdbParent.getIdentificationParameters();
            ProjectImporter.getDefaultReporterSettings(this.selectedMethod, identificationParameters, this.reporterSettings);
        }
        this.refresh();
    }

    private void addDbButtonActionPerformed(ActionEvent evt) {
        File startLocation = this.fastaFile;
        if (startLocation == null && this.reporterGUI.getUtilitiesUserParameters().getDbFolder() != null && this.reporterGUI.getUtilitiesUserParameters().getDbFolder().exists()) {
            startLocation = this.reporterGUI.getUtilitiesUserParameters().getDbFolder();
        }
        if (startLocation == null) {
            startLocation = new File(this.reporterGUI.getLastSelectedFolder().getLastSelectedFolder());
        }
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "FASTA (.fasta)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            this.fastaFile = fc.getSelectedFile();
            File folder = this.fastaFile.getParentFile();
            this.reporterGUI.getUtilitiesUserParameters().setDbFolder(folder);
            this.reporterGUI.getLastSelectedFolder().setLastSelectedFolder("fastaFile", folder.getAbsolutePath());
            this.fastaTxt.setText(this.fastaFile.getName());
            this.psdbParent.getProjectDetails().setFastaFile(this.fastaFile);
            if (this.fastaFile.getName().contains(" ")) {
                JOptionPane.showMessageDialog(this, "Your FASTA file name contains white space and ougth to be renamed.", "File Name Warning", 2);
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void methodSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void methodSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void methodSettingsButtonMouseReleased(MouseEvent evt) {
        new MethodSettingsDialog(this, true);
    }

    private void editQuantPrefsButtonActionPerformed(ActionEvent evt) {
        ReporterSettingsDialog reporterSettingsDialog = new ReporterSettingsDialog(this, this.reporterSettings, this.psdbParent.getIdentificationParameters().getSearchParameters().getModificationParameters(), this.getSelectedMethod(), true);
        ReporterSettings newSettings = reporterSettingsDialog.getReporterSettings();
        if (!reporterSettingsDialog.isCanceled()) {
            this.reporterSettings = newSettings;
            this.quantificationPreferencesTxt.setText("Custom Settings");
        }
    }

    private void aboutButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void aboutButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://compomics.github.io/projects/reporter.html");
        this.setCursor(new Cursor(0));
    }

    private void reporterPublicationLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://compomics.github.io/projects/reporter.html");
        this.setCursor(new Cursor(0));
    }

    private void reporterPublicationLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void reporterPublicationLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.reporterIonQuantification = new ReporterIonQuantification(Quantification.QuantificationMethod.REPORTER_IONS);
            for (String key : this.sampleNames.keySet()) {
                this.reporterIonQuantification.assignSample(key, this.sampleNames.get(key));
            }
            this.reporterIonQuantification.setMethod(this.selectedMethod);
            this.reporterIonQuantification.setControlSamples(this.controlSamples);
            if (this.welcomeDialog != null) {
                this.welcomeDialog.setVisible(false);
            }
            this.displayPreferences.setReagents(this.reagents);
            this.reporterGUI.createNewProject(this.psdbParent, this.reporterSettings, this.reporterIonQuantification, this.processingParameters, this.displayPreferences);
            this.dispose();
        }
    }

    private void editProcessingButtonActionPerformed(ActionEvent evt) {
        ProcessingParametersDialog processingParametersDialog = new ProcessingParametersDialog((Dialog)this, (Frame)this.reporterGUI, this.processingParameters, true);
        if (!processingParametersDialog.isCanceled()) {
            this.processingParameters = processingParametersDialog.getProcessingParameters();
            this.processingTxt.setText(this.processingParameters.getnThreads() + " cores");
        }
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[0] > 0) {
            String toMove = this.reagents.get(selectedRows[0]);
            String toReplace = this.reagents.get(selectedRows[0] - 1);
            this.reagents.set(selectedRows[0] - 1, toMove);
            this.reagents.set(selectedRows[0], toReplace);
            this.sampleAssignmentTable.setRowSelectionInterval(selectedRows[0] - 1, selectedRows[0] - 1 + selectedRows.length - 1);
            this.resetTableIndexes();
            this.sampleAssignmentTableMouseReleased(null);
        }
    }

    private void moveTopButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[0] > 0) {
            String toMove = this.reagents.get(selectedRows[0]);
            this.reagents.remove(selectedRows[0]);
            this.reagents.add(0, toMove);
            this.sampleAssignmentTable.setRowSelectionInterval(0, selectedRows.length - 1);
            this.resetTableIndexes();
            this.sampleAssignmentTableMouseReleased(null);
        }
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[selectedRows.length - 1] < this.sampleAssignmentTable.getRowCount() - 1) {
            String toMove = this.reagents.get(selectedRows[0]);
            String toReplace = this.reagents.get(selectedRows[0] + 1);
            this.reagents.set(selectedRows[0] + 1, toMove);
            this.reagents.set(selectedRows[0], toReplace);
            this.sampleAssignmentTable.setRowSelectionInterval(selectedRows[0] + 1, selectedRows[0] + selectedRows.length);
            this.resetTableIndexes();
            this.sampleAssignmentTableMouseReleased(null);
        }
    }

    private void moveBottomButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[selectedRows.length - 1] < this.sampleAssignmentTable.getRowCount() - 1) {
            String toMove = this.reagents.get(selectedRows[0]);
            this.reagents.remove(selectedRows[0]);
            this.reagents.add(toMove);
            this.sampleAssignmentTable.setRowSelectionInterval(this.sampleAssignmentTable.getRowCount() - selectedRows.length, this.sampleAssignmentTable.getRowCount() - 1);
            this.resetTableIndexes();
            this.sampleAssignmentTableMouseReleased(null);
        }
    }

    private void sampleAssignmentTableMouseReleased(MouseEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.moveUpButton.setEnabled(selectedRows[0] > 0);
            this.moveTopButton.setEnabled(selectedRows[0] > 0);
            this.moveDownButton.setEnabled(selectedRows[selectedRows.length - 1] < this.sampleAssignmentTable.getRowCount() - 1);
            this.moveBottomButton.setEnabled(selectedRows[selectedRows.length - 1] < this.sampleAssignmentTable.getRowCount() - 1);
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveTopButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.moveBottomButton.setEnabled(false);
        }
    }

    private boolean verifyFastaFile() {
        String fastaFilePath = this.psdbParent.getProjectDetails().getFastaFile();
        if (fastaFilePath != null) {
            this.fastaTxt.setText(fastaFilePath);
            return true;
        }
        String errorText = "FASTA file not found or incorrectly loaded:\n" + this.psdbParent.getProjectDetails().getFastaFile() + "\nPlease locate it manually.";
        JOptionPane.showMessageDialog(this, errorText, "FASTA File(s) Not Found", 2);
        return false;
    }

    private boolean verifySpectrumFiles() {
        String missing = "";
        int nMissing = 0;
        TreeSet msFiles = new TreeSet(this.psdbParent.getIdentification().getSpectrumIdentification().keySet());
        for (String spectrumFileName : msFiles) {
            boolean found = false;
            for (File spectrumFile : this.spectrumFiles) {
                if (!IoUtil.removeExtension((String)spectrumFile.getName()).equalsIgnoreCase(spectrumFileName)) continue;
                found = true;
            }
            if (found) continue;
            ++nMissing;
            missing = missing + spectrumFileName + "\n";
        }
        if (nMissing > 0) {
            if (nMissing < 11) {
                JOptionPane.showMessageDialog(this, "Spectrum file(s) not found:\n" + missing + "\nPlease locate them manually.", "Spectrum File Not Found", 2);
            } else {
                JOptionPane.showMessageDialog(this, "Spectrum files not found.\nPlease locate them manually.", "Spectrum File Not Found", 2);
            }
        }
        if (this.spectrumFiles.size() > 1) {
            this.txtSpectraFileLocation.setText(this.spectrumFiles.size() + " files loaded");
        } else if (this.spectrumFiles.size() == 1) {
            this.txtSpectraFileLocation.setText(this.spectrumFiles.get(0).getName());
        } else {
            this.txtSpectraFileLocation.setText("");
        }
        return nMissing == 0;
    }

    private void refresh() {
        if (this.selectedMethod != null) {
            this.reporterMethodComboBox.setSelectedItem(this.selectedMethod.getName());
        }
        this.sampleAssignmentTable.setModel(new AssignementTableModel());
        this.setTableProperties();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewDialog.this.sampleAssignmentTable.revalidate();
                NewDialog.this.sampleAssignmentTable.repaint();
            }
        });
    }

    private void importMethods() {
        try {
            this.methodsFactory.importMethods(this.methodsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.importMethodsError();
        }
    }

    private void loadDefaultPreferences() {
        ReporterPreferences reporterPreferences = ReporterPreferences.getUserPreferences();
        this.reporterSettings = reporterPreferences.getDefaultSettings();
    }

    private void importPeptideShakerFile(final File psFile) {
        this.progressDialog = this.welcomeDialog != null ? new ProgressDialogX((JDialog)this.welcomeDialog, (Frame)this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true) : new ProgressDialogX((JDialog)this, (Frame)this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Importing Project. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    NewDialog.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("ImportThread"){

            @Override
            public void run() {
                NewDialog.this.psdbParent = new PsdbParent(Reporter.getMatchesFolder());
                NewDialog.this.psdbParent.setPsdbFile(psFile);
                ProjectImporter projectImporter = new ProjectImporter(NewDialog.this);
                try {
                    projectImporter.importPeptideShakerProject(NewDialog.this.psdbParent, NewDialog.this.spectrumFiles, (WaitingHandler)NewDialog.this.progressDialog);
                    projectImporter.importReporterProject(NewDialog.this.psdbParent, (WaitingHandler)NewDialog.this.progressDialog);
                }
                catch (OutOfMemoryError error) {
                    System.out.println("Ran out of memory! (runtime.maxMemory(): " + Runtime.getRuntime().maxMemory() + ")");
                    error.printStackTrace();
                    String errorText = "PeptideShaker used up all the available memory and had to be stopped.<br>Memory boundaries are changed in the the Welcome Dialog (Settings<br>& Help > Settings > Java Memory Settings) or in the Edit menu (Edit<br>Java Options). See also <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">JavaTroubleShooting</a>.";
                    JOptionPane.showMessageDialog(NewDialog.this, errorText, "Out of Memory", 0);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String errorText = "An error occurred while reading:\n" + psFile + ".\n\nPlease verify that the PeptideShaker version used to create\nthe file is compatible with your version of Reporter.";
                    JOptionPane.showMessageDialog(NewDialog.this, errorText, "Error", 0);
                    return;
                }
                if (NewDialog.this.progressDialog.isRunCanceled()) {
                    NewDialog.this.progressDialog.dispose();
                    return;
                }
                NewDialog.this.loadButton.setEnabled(true);
                NewDialog.this.editQuantPrefsButton.setEnabled(true);
                NewDialog.this.verifySpectrumFiles();
                NewDialog.this.verifyFastaFile();
                NewDialog.this.txtIdFileLocation.setText(NewDialog.this.psdbParent.getPsdbFile().getName());
                String error = PeptideShaker.loadModifications((SearchParameters)NewDialog.this.getSearchParameters());
                if (error != null) {
                    JOptionPane.showMessageDialog(NewDialog.this, error, "PTM Definition Changed", 2);
                }
                NewDialog.this.reporterSettings = projectImporter.getReporterSettings();
                NewDialog.this.reporterIonQuantification = projectImporter.getReporterIonQuantification();
                NewDialog.this.selectedMethod = NewDialog.this.reporterIonQuantification.getReporterMethod();
                if (NewDialog.this.selectedMethod == null) {
                    NewDialog.this.selectedMethod = NewDialog.this.methodsFactory.getReporterMethod((String)NewDialog.this.methodsFactory.getMethodsNames().get(0));
                }
                NewDialog.this.reagents = NewDialog.this.selectedMethod.getReagentsSortedByMass();
                NewDialog.this.displayPreferences = projectImporter.getDisplayPreferences();
                NewDialog.this.sampleNames.clear();
                NewDialog.this.refresh();
                NewDialog.this.progressDialog.setRunFinished();
            }
        }.start();
    }

    public ProjectDetails getProjectDetails() {
        return this.psdbParent.getProjectDetails();
    }

    public SearchParameters getSearchParameters() {
        return this.psdbParent.getIdentificationParameters().getSearchParameters();
    }

    public Identification getIdentification() {
        return this.psdbParent.getIdentification();
    }

    private void importMethodsError() {
        JOptionPane.showMessageDialog(this, "Default reporter methods file could not be parsed, please select a method file.", "No Spectrum File Selected", 2);
        JFileChooser fileChooser = new JFileChooser(this.reporterGUI.getLastSelectedFolder().getLastSelectedFolder());
        fileChooser.setDialogTitle("Select Methods file");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        int returnVal = fileChooser.showDialog(this.getParent(), "Add");
        if (returnVal == 0) {
            File newFile = fileChooser.getSelectedFile();
            try {
                this.methodsFactory.importMethods(newFile);
                this.reporterGUI.getLastSelectedFolder().setLastSelectedFolder(newFile.getPath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "File " + newFile + " could not be parsed.", "Methods file error", 2);
                this.importMethodsError();
            }
            catch (XmlPullParserException e) {
                JOptionPane.showMessageDialog(this, "An error occurred while parsing " + newFile + " at line " + e.getLineNumber() + ".", "Parsing error", 2);
                this.importMethodsError();
            }
        }
    }

    private boolean validateInput() {
        if (this.fastaTxt.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "FASTA file not selected.", "FASTA File Missing", 2);
            return false;
        }
        if (this.selectedMethod.getName().contains("TMT") && this.reporterSettings.getReporterIonSelectionSettings().getReporterIonsMzTolerance() > 0.0016) {
            JOptionPane.showMessageDialog(this, "TMT quantification requires high resolution spectra. Please check\nthe Reporter Ions Tolerance in the Quantification Settings.", "TMT Resolution Warning", 2);
            return false;
        }
        return true;
    }

    public ReporterMethod getSelectedMethod() {
        return this.selectedMethod;
    }

    public void setSelectedMethod(ReporterMethod selectedMethod) {
        this.selectedMethod = selectedMethod;
    }

    public ArrayList<String> getReagents() {
        return this.reagents;
    }

    public void setReagents(ArrayList<String> reagents) {
        this.reagents = reagents;
    }

    public File getMethodsFile() {
        return this.methodsFile;
    }

    public void setMethodsFile(File methodsFile) {
        this.methodsFile = methodsFile;
    }

    public ReporterGUI getReporterGui() {
        return this.reporterGUI;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public PsdbParent getPsdbBean() {
        return this.psdbParent;
    }

    public ReporterSettings getReporterSettings() {
        return this.reporterSettings;
    }

    public ReporterIonQuantification getReporterIonQuantification() {
        return this.reporterIonQuantification;
    }

    public void updateReagentNames() {
        this.sampleAssignmentTable.revalidate();
        this.sampleAssignmentTable.repaint();
    }

    private void resetTableIndexes() {
        for (int i = 0; i < this.sampleAssignmentTable.getRowCount(); ++i) {
            this.sampleAssignmentTable.setValueAt(i + 1, i, 0);
        }
    }

    private class AssignementTableModel
    extends DefaultTableModel {
        private AssignementTableModel() {
        }

        @Override
        public int getRowCount() {
            if (NewDialog.this.selectedMethod == null || NewDialog.this.psdbParent == null) {
                return 0;
            }
            return NewDialog.this.reagents.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Label";
                }
                case 2: {
                    return "Sample";
                }
                case 3: {
                    return "Ref";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String reagentName = (String)NewDialog.this.reagents.get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    ReporterIon reporterIon = NewDialog.this.selectedMethod.getReporterIon(reagentName);
                    return reporterIon.getName();
                }
                case 2: {
                    String projectName = NewDialog.this.psdbParent.getProjectParameters().getProjectUniqueName();
                    if (NewDialog.this.sampleNames.get(reagentName) == null) {
                        if (projectName != null) {
                            NewDialog.this.sampleNames.put(reagentName, projectName + " " + reagentName);
                        } else {
                            NewDialog.this.sampleNames.put(reagentName, "Sample " + reagentName);
                        }
                    }
                    return NewDialog.this.sampleNames.get(reagentName);
                }
                case 3: {
                    return NewDialog.this.controlSamples.contains(reagentName);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            String reagentName = (String)NewDialog.this.reagents.get(row);
            if (column == 2) {
                NewDialog.this.sampleNames.put(reagentName, aValue.toString());
            } else if (column == 3) {
                if (NewDialog.this.controlSamples.contains(reagentName)) {
                    NewDialog.this.controlSamples.remove(reagentName);
                } else {
                    NewDialog.this.controlSamples.add(reagentName);
                }
            }
            NewDialog.this.repaint();
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column > 1;
        }
    }
}

