/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.resultpanels;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.genes.GeneDetailsDialog;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.math.clustering.KMeansClustering;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.reporter.calculation.clustering.ClusterBuilder;
import eu.isas.reporter.gui.ReporterGUI;
import eu.isas.reporter.gui.tablemodels.PeptideTableModel;
import eu.isas.reporter.gui.tablemodels.ProteinTableModel;
import eu.isas.reporter.gui.tablemodels.PsmTableModel;
import eu.isas.reporter.settings.ClusteringSettings;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesHeatMapTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class OverviewPanel
extends JPanel {
    private ArrayList<String> proteinTableToolTips;
    private ReporterGUI reporterGUI;
    private Identification identification;
    private GeneMaps geneMaps;
    private IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private ProgressDialogX progressDialog;
    private long[] proteinKeys;
    private long[] peptideKeys;
    private long[] psmKeys;
    public static final float LINE_WIDTH = 4.0f;
    private int maxLegendSize = 20;
    private ChartPanel lineChartChartPanel;
    private ChartPanel maximizeIconChartPanel;
    private ChartPanel selectedChartPanel = null;
    private Color notSelectedProteinProfileColor = new Color(200, 200, 200, 100);
    private long[] allOrderedProteinKeys;
    private boolean chartMaximized = false;
    private ArrayList<ChartPanel> allChartPanels = new ArrayList();
    public static final int NO_ID = 0;
    public static final int CONFLICT = 1;
    public static final int PARTIALLY_MISSING = 2;
    public static final int AGREEMENT = 3;
    public static final int AGREEMENT_WITH_MODS = 4;
    private JLayeredPane backgroundLayeredPane;
    private JPopupMenu clusterPopupMenu;
    private JPanel contextMenuProteinsBackgroundPanel;
    private JPanel contextMenuRatioPlotBackgroundPanel;
    private JButton exportProteinsJButton;
    private JButton exportRatioPlotContextJButton;
    private JTabbedPane matchesJTabbedPane;
    private JButton maximizeChartJButton;
    private JMenuItem numberOfClustersMenuItem;
    private JPanel overviewJPanel;
    private JSplitPane overviewJSplitPane;
    private JScrollPane peptideScrollPane;
    private JTable peptideTable;
    private JPanel plotPanel;
    private JPanel proteinPeptidePsmLayeredPanel;
    private JScrollPane proteinScrollPane;
    private JTable proteinTable;
    private JButton proteinsHelpJButton;
    private JPanel proteinsJPanel;
    private JLayeredPane proteinsLayeredPane;
    private JScrollPane psmScrollPane;
    private JTable psmTable;
    private JButton ratioPlotHelpJButton;
    private JButton ratioPlotOptionsJButton;
    private JPanel ratioPlotsJPanel;
    private JLayeredPane ratioPlotsMainLayeredPane;
    private JPanel ratioPlotsTitledPanel;

    public OverviewPanel(ReporterGUI reporterGUI) {
        this.initComponents();
        this.reporterGUI = reporterGUI;
        this.setUpGui();
        this.formComponentResized(null);
    }

    private void setUpGui() {
        this.maximizeChartJButton.setVisible(false);
        this.proteinTable.getTableHeader().setReorderingAllowed(false);
        this.peptideTable.getTableHeader().setReorderingAllowed(false);
        this.psmTable.getTableHeader().setReorderingAllowed(false);
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.proteinTable.getTableHeader().getBackground());
        this.proteinScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        JPanel peptideCorner = new JPanel();
        peptideCorner.setBackground(this.proteinTable.getTableHeader().getBackground());
        this.peptideScrollPane.setCorner("UPPER_RIGHT_CORNER", peptideCorner);
        JPanel psmCorner = new JPanel();
        psmCorner.setBackground(this.proteinTable.getTableHeader().getBackground());
        this.psmScrollPane.setCorner("UPPER_RIGHT_CORNER", psmCorner);
        SelfUpdatingTableModel.addSortListener((JTable)this.proteinTable, (ProgressDialogX)new ProgressDialogX((Frame)this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true));
        SelfUpdatingTableModel.addSortListener((JTable)this.peptideTable, (ProgressDialogX)new ProgressDialogX((Frame)this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true));
        SelfUpdatingTableModel.addSortListener((JTable)this.psmTable, (ProgressDialogX)new ProgressDialogX((Frame)this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true));
        SelfUpdatingTableModel.addScrollListeners((JTable)this.proteinTable, (JScrollPane)this.proteinScrollPane, (JScrollBar)this.proteinScrollPane.getVerticalScrollBar());
        SelfUpdatingTableModel.addScrollListeners((JTable)this.peptideTable, (JScrollPane)this.peptideScrollPane, (JScrollBar)this.peptideScrollPane.getVerticalScrollBar());
        SelfUpdatingTableModel.addScrollListeners((JTable)this.psmTable, (JScrollPane)this.psmScrollPane, (JScrollBar)this.psmScrollPane.getVerticalScrollBar());
        this.proteinScrollPane.getViewport().setOpaque(false);
        this.peptideScrollPane.getViewport().setOpaque(false);
        this.psmScrollPane.getViewport().setOpaque(false);
        this.setUpTableHeaderToolTips();
    }

    public void updateDisplay() {
        this.minimizeChart();
        this.identification = this.reporterGUI.getIdentification();
        this.geneMaps = this.reporterGUI.getGeneMaps();
        this.identificationFeaturesGenerator = this.reporterGUI.getIdentificationFeaturesGenerator();
        this.allChartPanels.clear();
        this.selectedChartPanel = null;
        this.numberOfClustersMenuItem.setEnabled(this.reporterGUI.getkMeansClutering() != null);
        this.progressDialog = new ProgressDialogX((Frame)this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading Overview. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OverviewPanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DisplayThread"){

            @Override
            public void run() {
                try {
                    OverviewPanel.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                    OverviewPanel.this.progressDialog.setTitle("Preparing Overview. Please Wait...");
                    OverviewPanel.this.reporterGUI.getIdentificationFeaturesGenerator().setProteinKeys(OverviewPanel.this.reporterGUI.getMetrics().getProteinKeys());
                    OverviewPanel.access$202(OverviewPanel.this, OverviewPanel.this.reporterGUI.getIdentificationFeaturesGenerator().getProcessedProteinKeys((WaitingHandler)OverviewPanel.this.progressDialog, OverviewPanel.this.reporterGUI.getFilterParameters(), false));
                    OverviewPanel.access$302(OverviewPanel.this, OverviewPanel.this.reporterGUI.getIdentificationFeaturesGenerator().getProcessedProteinKeys((WaitingHandler)OverviewPanel.this.progressDialog, OverviewPanel.this.reporterGUI.getFilterParameters(), false));
                    OverviewPanel.this.displayClusters((WaitingHandler)OverviewPanel.this.progressDialog);
                    ArrayList<Long> emptySelection = new ArrayList<Long>();
                    OverviewPanel.this.reporterGUI.setSelectedProteins(emptySelection, false, false);
                    OverviewPanel.this.reporterGUI.setSelectedPeptides(emptySelection, false, false);
                    OverviewPanel.this.reporterGUI.setSelectedPsms(emptySelection, false, false);
                    OverviewPanel.this.proteinTable.clearSelection();
                    OverviewPanel.this.peptideTable.clearSelection();
                    OverviewPanel.this.psmTable.clearSelection();
                    OverviewPanel.access$202(OverviewPanel.this, null);
                    OverviewPanel.access$802(OverviewPanel.this, null);
                    OverviewPanel.access$902(OverviewPanel.this, null);
                    ((ProteinTableModel)((Object)OverviewPanel.this.proteinTable.getModel())).reset();
                    ((PeptideTableModel)((Object)OverviewPanel.this.peptideTable.getModel())).reset();
                    ((PsmTableModel)((Object)OverviewPanel.this.psmTable.getModel())).reset();
                    OverviewPanel.this.setProteinTableProperties();
                    OverviewPanel.this.setPeptideTableProperties();
                    OverviewPanel.this.setPsmTableProperties();
                    ((DefaultTableModel)OverviewPanel.this.proteinTable.getModel()).fireTableDataChanged();
                    OverviewPanel.this.updateProteinTableCellRenderers();
                    ((DefaultTableModel)OverviewPanel.this.peptideTable.getModel()).fireTableDataChanged();
                    OverviewPanel.this.updatePeptideTableCellRenderers();
                    ((DefaultTableModel)OverviewPanel.this.psmTable.getModel()).fireTableDataChanged();
                    OverviewPanel.this.updatePsmTableCellRenderers();
                    String title = ReporterGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Proteins (" + OverviewPanel.this.proteinTable.getRowCount() + "), Peptides (" + OverviewPanel.this.peptideTable.getRowCount() + "), PSMs (" + OverviewPanel.this.psmTable.getRowCount() + ")";
                    ((TitledBorder)OverviewPanel.this.proteinPeptidePsmLayeredPanel.getBorder()).setTitle(title);
                    OverviewPanel.this.proteinPeptidePsmLayeredPanel.repaint();
                    if (OverviewPanel.this.reporterGUI.getIdentificationDisplayPreferences().showScores()) {
                        OverviewPanel.this.proteinTableToolTips.set(OverviewPanel.this.proteinTable.getColumnCount() - 2, "Protein Score");
                    } else {
                        OverviewPanel.this.proteinTableToolTips.set(OverviewPanel.this.proteinTable.getColumnCount() - 2, "Protein Confidence");
                    }
                    OverviewPanel.this.exportProteinsJButton.setEnabled(true);
                    OverviewPanel.this.ratioPlotOptionsJButton.setEnabled(true);
                    OverviewPanel.this.reporterGUI.setCursor(new Cursor(0));
                    OverviewPanel.this.progressDialog.setRunFinished();
                }
                catch (Exception e) {
                    OverviewPanel.this.reporterGUI.setCursor(new Cursor(0));
                    OverviewPanel.this.reporterGUI.catchException(e);
                    OverviewPanel.this.progressDialog.setRunFinished();
                }
            }
        }.start();
    }

    private void displayClusters(WaitingHandler waitingHandler) {
        this.plotPanel.removeAll();
        ArrayList sampleIndexes = new ArrayList(this.reporterGUI.getReporterIonQuantification().getSampleIndexes());
        Collections.sort(sampleIndexes);
        ArrayList<String> reagentsOrder = this.reporterGUI.getDisplayParameters().getReagents();
        KMeansClustering kMeansClustering = this.reporterGUI.getkMeansClutering();
        if (kMeansClustering != null) {
            for (int clusterIndex = 0; clusterIndex < kMeansClustering.getNumberOfClusters() && !waitingHandler.isRunCanceled(); ++clusterIndex) {
                DefaultCategoryDataset chartDataset = new DefaultCategoryDataset();
                ArrayList clusterMembers = kMeansClustering.getClusterMembers(clusterIndex);
                HashMap allValues = kMeansClustering.getClusterMembersData(clusterIndex);
                for (String tempKey : clusterMembers) {
                    if (waitingHandler.isRunCanceled()) break;
                    ArrayList tempValues = (ArrayList)allValues.get(tempKey);
                    for (String tempReagent : reagentsOrder) {
                        int sampleIndex = sampleIndexes.indexOf(tempReagent);
                        chartDataset.addValue((Number)tempValues.get(sampleIndex), (Comparable)((Object)tempKey), (Comparable)((Object)this.reporterGUI.getReporterIonQuantification().getSample((String)sampleIndexes.get(sampleIndex))));
                    }
                }
                this.addClusterChart(chartDataset);
            }
        }
    }

    private void addClusterChart(DefaultCategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
        ClusteringSettings clusteringSettings = this.reporterGUI.getDisplayParameters().getClusteringSettings();
        LineAndShapeRenderer renderer = new LineAndShapeRenderer(true, false);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            Color nonSelectedColor;
            String clusterClass;
            ArrayList<String> classes;
            boolean isPsm;
            Long key = Long.valueOf((String)((Object)dataset.getRowKey(i)));
            boolean isProtein = clusterBuilder.getProteinIndex(key) != null;
            boolean isPeptide = clusterBuilder.getPeptideIndex(key) != null;
            boolean bl = isPsm = clusterBuilder.getPsmIndex(key) != null;
            if (isProtein) {
                classes = clusterBuilder.getProteinClasses(key);
                clusterClass = classes.get(0);
                nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                renderer.setSeriesPaint(i, (Paint)nonSelectedColor);
            } else if (isPeptide) {
                classes = clusterBuilder.getPeptideClasses(key);
                clusterClass = classes.get(0);
                nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                renderer.setSeriesPaint(i, (Paint)nonSelectedColor);
            } else if (isPsm) {
                classes = clusterBuilder.getPsmClasses(key);
                clusterClass = classes.get(0);
                nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                renderer.setSeriesPaint(i, (Paint)nonSelectedColor);
            } else {
                throw new IllegalArgumentException("No match found for key " + key + ".");
            }
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(4.0f, 1, 1));
        }
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        plot.setRenderer((CategoryItemRenderer)renderer);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setLowerMargin(0.15);
        rangeAxis.setUpperMargin(0.15);
        Double amplitude = clusterBuilder.getRatioAmplitude();
        rangeAxis.setUpperBound(amplitude.doubleValue());
        rangeAxis.setLowerBound(-amplitude.doubleValue());
        this.lineChartChartPanel = new ChartPanel(chart, false);
        this.lineChartChartPanel.setName("" + this.plotPanel.getComponentCount());
        this.lineChartChartPanel.setRangeZoomable(false);
        this.lineChartChartPanel.setPopupMenu(null);
        plot.setOutlineVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setDomainGridlinesVisible(false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        this.lineChartChartPanel.setBackground(Color.WHITE);
        this.lineChartChartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent cme) {
                if (cme.getTrigger().getButton() == 1 && cme.getTrigger().getClickCount() == 2) {
                    OverviewPanel.this.maximizeChartJButtonActionPerformed(null);
                }
            }

            public void chartMouseMoved(ChartMouseEvent cme) {
                ChartPanel chartPanelParent = (ChartPanel)cme.getTrigger().getComponent();
                int x = chartPanelParent.getX() + chartPanelParent.getWidth() - 5;
                int y = chartPanelParent.getY() + 38;
                OverviewPanel.this.maximizeChartJButton.setLocation(x, y);
                OverviewPanel.this.maximizeChartJButton.setVisible(true);
                OverviewPanel.this.maximizeIconChartPanel = chartPanelParent;
            }
        });
        this.lineChartChartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Component c = e.getComponent();
                if (c instanceof ChartPanel) {
                    boolean chartAlreadySelected = false;
                    if (OverviewPanel.this.selectedChartPanel != null) {
                        chartAlreadySelected = OverviewPanel.this.selectedChartPanel.getName().equalsIgnoreCase(c.getName());
                    }
                    if (!chartAlreadySelected) {
                        OverviewPanel.this.reporterGUI.setSelectedProteins(new ArrayList<Long>(), true, true);
                        OverviewPanel.this.selectCluster((ChartPanel)c, true);
                    }
                }
            }
        });
        this.allChartPanels.add(this.lineChartChartPanel);
        this.plotPanel.add((Component)this.lineChartChartPanel);
        this.plotPanel.validate();
    }

    private void selectCluster(ChartPanel chartPanel, boolean resetSelection) {
        if (this.selectedChartPanel != null) {
            this.selectedChartPanel.setBorder(null);
            if (resetSelection) {
                CategoryItemRenderer renderer = this.selectedChartPanel.getChart().getCategoryPlot().getRenderer();
                DefaultCategoryDataset dataset = (DefaultCategoryDataset)this.selectedChartPanel.getChart().getCategoryPlot().getDataset();
                ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
                ClusteringSettings clusteringSettings = this.reporterGUI.getDisplayParameters().getClusteringSettings();
                for (int i = 0; i < dataset.getRowCount(); ++i) {
                    Color nonSelectedColor;
                    String clusterClass;
                    ArrayList<String> classes;
                    boolean isPsm;
                    Long key = Long.valueOf((String)((Object)dataset.getRowKey(i)));
                    boolean isProtein = clusterBuilder.getProteinIndex(key) != null;
                    boolean isPeptide = clusterBuilder.getPeptideIndex(key) != null;
                    boolean bl = isPsm = clusterBuilder.getPsmIndex(key) != null;
                    if (isProtein) {
                        classes = clusterBuilder.getProteinClasses(key);
                        clusterClass = classes.get(0);
                        nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                        renderer.setSeriesPaint(i, (Paint)nonSelectedColor);
                        continue;
                    }
                    if (isPeptide) {
                        classes = clusterBuilder.getPeptideClasses(key);
                        clusterClass = classes.get(0);
                        nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                        renderer.setSeriesPaint(i, (Paint)nonSelectedColor);
                        continue;
                    }
                    if (isPsm) {
                        classes = clusterBuilder.getPsmClasses(key);
                        clusterClass = classes.get(0);
                        nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                        renderer.setSeriesPaint(i, (Paint)nonSelectedColor);
                        continue;
                    }
                    throw new IllegalArgumentException("No match found for key " + key + ".");
                }
            }
            this.selectedChartPanel.getChart().fireChartChanged();
        }
        chartPanel.setBorder((Border)new LineBorder(Color.DARK_GRAY));
        chartPanel.getChart().fireChartChanged();
        this.selectedChartPanel = chartPanel;
        if (resetSelection) {
            int i;
            DefaultCategoryDataset dataset = (DefaultCategoryDataset)chartPanel.getChart().getCategoryPlot().getDataset();
            List rowKeys = dataset.getRowKeys();
            int size = Math.max(32, rowKeys.size() / 3);
            HashMap<Integer, Long> psmKeysMap = new HashMap<Integer, Long>(size);
            HashMap<Integer, Long> peptideKeysMap = new HashMap<Integer, Long>(size);
            HashMap<Integer, Long> proteinKeysMap = new HashMap<Integer, Long>(size);
            ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
            for (String rowKey : rowKeys) {
                Integer psmIndex;
                Integer peptideIndex;
                long rowKeyAsLong = Long.parseLong(rowKey);
                Integer proteinIndex = clusterBuilder.getProteinIndex(rowKeyAsLong);
                if (proteinIndex != null) {
                    proteinKeysMap.put(proteinIndex, rowKeyAsLong);
                }
                if ((peptideIndex = clusterBuilder.getPeptideIndex(rowKeyAsLong)) != null) {
                    peptideKeysMap.put(peptideIndex, rowKeyAsLong);
                }
                if ((psmIndex = clusterBuilder.getPsmIndex(rowKeyAsLong)) != null) {
                    psmKeysMap.put(psmIndex, rowKeyAsLong);
                }
                if (proteinIndex != null || peptideIndex != null || psmIndex != null) continue;
                throw new IllegalArgumentException("Key " + rowKey + " not found.");
            }
            ArrayList indexes = new ArrayList(proteinKeysMap.keySet());
            Collections.sort(indexes);
            this.proteinKeys = new long[proteinKeysMap.size()];
            for (i = 0; i < indexes.size(); ++i) {
                long accession;
                this.proteinKeys[i] = accession = ((Long)proteinKeysMap.get(indexes.get(i))).longValue();
            }
            indexes = new ArrayList(peptideKeysMap.keySet());
            Collections.sort(indexes);
            this.peptideKeys = new long[peptideKeysMap.size()];
            for (i = 0; i < indexes.size(); ++i) {
                long accession;
                this.peptideKeys[i] = accession = ((Long)peptideKeysMap.get(indexes.get(i))).longValue();
            }
            indexes = new ArrayList(psmKeysMap.keySet());
            Collections.sort(indexes);
            this.psmKeys = new long[psmKeysMap.size()];
            for (i = 0; i < indexes.size(); ++i) {
                long accession;
                this.psmKeys[i] = accession = ((Long)psmKeysMap.get(indexes.get(i))).longValue();
            }
            this.updateProteinTable();
            this.updatePeptideTable();
            this.updatePsmTable();
            String title = ReporterGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Proteins (" + this.proteinTable.getRowCount() + "), Peptides (" + this.peptideTable.getRowCount() + "), PSMs (" + this.psmTable.getRowCount() + ")";
            ((TitledBorder)this.proteinPeptidePsmLayeredPanel.getBorder()).setTitle(title);
            this.proteinPeptidePsmLayeredPanel.repaint();
        }
    }

    private void updateProteinTable() {
        if (this.proteinTable.getModel() instanceof ProteinTableModel && ((ProteinTableModel)((Object)this.proteinTable.getModel())).isInstantiated()) {
            ((ProteinTableModel)((Object)this.proteinTable.getModel())).updateDataModel(this.identification, this.identificationFeaturesGenerator, this.reporterGUI.getProteinDetailsProvider(), this.reporterGUI.getSequenceProvider(), this.reporterGUI.getSpectrumProvider(), this.geneMaps, this.reporterGUI.getReporterIonQuantification(), this.reporterGUI.getQuantificationFeaturesGenerator(), this.reporterGUI.getDisplayFeaturesGenerator(), this.reporterGUI.getDisplayParameters(), this.proteinKeys);
        } else {
            ProteinTableModel proteinTableModel = new ProteinTableModel(this.identification, this.identificationFeaturesGenerator, this.reporterGUI.getProteinDetailsProvider(), this.reporterGUI.getSequenceProvider(), this.geneMaps, this.reporterGUI.getReporterIonQuantification(), this.reporterGUI.getQuantificationFeaturesGenerator(), this.reporterGUI.getDisplayFeaturesGenerator(), this.reporterGUI.getDisplayParameters(), this.reporterGUI.getExceptionHandler(), this.proteinKeys);
            this.proteinTable.setModel((TableModel)((Object)proteinTableModel));
        }
        this.setProteinTableProperties();
        ((DefaultTableModel)this.proteinTable.getModel()).fireTableDataChanged();
        this.updateProteinTableCellRenderers();
    }

    private void updatePeptideTable() {
        if (this.peptideTable.getModel() instanceof PeptideTableModel && ((PeptideTableModel)((Object)this.peptideTable.getModel())).isInstantiated()) {
            ((PeptideTableModel)((Object)this.peptideTable.getModel())).updateDataModel(this.identification, this.identificationFeaturesGenerator, this.reporterGUI.getReporterIonQuantification(), this.reporterGUI.getQuantificationFeaturesGenerator(), this.reporterGUI.getDisplayFeaturesGenerator(), this.reporterGUI.getDisplayParameters(), this.reporterGUI.getIdentificationParameters(), null, this.peptideKeys, false);
        } else {
            PeptideTableModel peptideTableModel = new PeptideTableModel(this.identification, this.reporterGUI.getSpectrumProvider(), this.identificationFeaturesGenerator, this.reporterGUI.getReporterIonQuantification(), this.reporterGUI.getQuantificationFeaturesGenerator(), this.reporterGUI.getDisplayFeaturesGenerator(), this.reporterGUI.getDisplayParameters(), this.reporterGUI.getIdentificationParameters(), null, this.peptideKeys, false, this.reporterGUI.getExceptionHandler());
            this.peptideTable.setModel((TableModel)((Object)peptideTableModel));
        }
        this.setPeptideTableProperties();
        ((DefaultTableModel)this.peptideTable.getModel()).fireTableDataChanged();
        this.updatePeptideTableCellRenderers();
    }

    private void updatePsmTable() {
        if (this.psmTable.getModel() instanceof PsmTableModel && ((PsmTableModel)((Object)this.psmTable.getModel())).isInstantiated()) {
            ((PsmTableModel)((Object)this.psmTable.getModel())).updateDataModel(this.identification, this.reporterGUI.getSpectrumProvider(), this.reporterGUI.getDisplayFeaturesGenerator(), this.reporterGUI.getDisplayParameters(), this.reporterGUI.getIdentificationParameters(), this.reporterGUI.getReporterIonQuantification(), this.reporterGUI.getQuantificationFeaturesGenerator(), this.psmKeys, false);
        } else {
            PsmTableModel psmTableModel = new PsmTableModel(this.identification, this.reporterGUI.getSpectrumProvider(), this.reporterGUI.getDisplayFeaturesGenerator(), this.reporterGUI.getDisplayParameters(), this.reporterGUI.getIdentificationParameters(), this.reporterGUI.getReporterIonQuantification(), this.reporterGUI.getQuantificationFeaturesGenerator(), this.psmKeys, false, this.reporterGUI.getExceptionHandler());
            this.psmTable.setModel((TableModel)((Object)psmTableModel));
        }
        this.setPsmTableProperties();
        ((DefaultTableModel)this.psmTable.getModel()).fireTableDataChanged();
        this.updatePsmTableCellRenderers();
    }

    private void setUpTableHeaderToolTips() {
        this.proteinTableToolTips = new ArrayList();
        this.proteinTableToolTips.add(null);
        this.proteinTableToolTips.add("Protein Quantification");
        this.proteinTableToolTips.add("Protein Inference Class");
        this.proteinTableToolTips.add("Protein Accession Number");
        this.proteinTableToolTips.add("Protein Description");
        this.proteinTableToolTips.add("Chromosome Number");
        this.proteinTableToolTips.add("Protein Sequence Coverage (%) (Confident / Doubtful / Not Validated / Possible)");
        this.proteinTableToolTips.add("Number of Peptides (Confident / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("Number of Spectra (Confident / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("Protein Molecular Weight (kDa)");
        if (this.reporterGUI.getIdentificationDisplayPreferences() != null && this.reporterGUI.getIdentificationDisplayPreferences().showScores()) {
            this.proteinTableToolTips.add("Protein Score");
        } else {
            this.proteinTableToolTips.add("Protein Confidence");
        }
        this.proteinTableToolTips.add("Validated");
    }

    private void setProteinTableProperties() {
        ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
        Double amplitude = clusterBuilder.getRatioAmplitude();
        ProteinTableModel.setProteinTableProperties(this.proteinTable, this.reporterGUI.getSparklineColor(), this.reporterGUI.getSparklineColorNonValidated(), this.reporterGUI.getSparklineColorNotFound(), this.reporterGUI.getSparklineColorDoubtful(), this.reporterGUI.getScoreAndConfidenceDecimalFormat(), this.getClass(), this.reporterGUI.getMetrics().getMaxProteinAccessionLength(), amplitude);
        this.proteinTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewPanel.this.resetSelection();
                    }
                });
            }
        });
    }

    private void setPeptideTableProperties() {
        this.peptideTable.getColumn(" ").setMaxWidth(50);
        this.peptideTable.getColumn(" ").setMinWidth(50);
        try {
            this.peptideTable.getColumn("Confidence").setMaxWidth(90);
            this.peptideTable.getColumn("Confidence").setMinWidth(90);
        }
        catch (IllegalArgumentException w) {
            this.peptideTable.getColumn("Score").setMaxWidth(90);
            this.peptideTable.getColumn("Score").setMinWidth(90);
        }
        this.peptideTable.getColumn("").setMaxWidth(30);
        this.peptideTable.getColumn("PI").setMaxWidth(37);
        this.peptideTable.getColumn("PI").setMinWidth(37);
        this.peptideTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewPanel.this.resetSelection();
                    }
                });
            }
        });
    }

    private void setPsmTableProperties() {
        this.psmTable.getColumn(" ").setMaxWidth(50);
        this.psmTable.getColumn(" ").setMinWidth(50);
        try {
            this.psmTable.getColumn("Confidence").setMaxWidth(90);
            this.psmTable.getColumn("Confidence").setMinWidth(90);
        }
        catch (IllegalArgumentException w) {
            this.psmTable.getColumn("Score").setMaxWidth(90);
            this.psmTable.getColumn("Score").setMinWidth(90);
        }
        this.psmTable.getColumn("").setMaxWidth(30);
        this.psmTable.getColumn("").setMinWidth(30);
        this.psmTable.getColumn("ID").setMaxWidth(37);
        this.psmTable.getColumn("ID").setMinWidth(37);
        this.psmTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewPanel.this.resetSelection();
                    }
                });
            }
        });
    }

    public void resetSelection() {
        ArrayList<Long> selectedProteins = this.reporterGUI.getSelectedProteins();
        this.proteinTable.clearSelection();
        for (long tempProteinKey : selectedProteins) {
            int proteinRow = this.getProteinRow(tempProteinKey);
            if (proteinRow == -1) continue;
            this.proteinTable.addRowSelectionInterval(proteinRow, proteinRow);
        }
        ArrayList<Long> selectedPeptides = this.reporterGUI.getSelectedPeptides();
        this.peptideTable.clearSelection();
        for (long tempPeptideKey : selectedPeptides) {
            int peptideRow = this.getPeptideRow(tempPeptideKey);
            if (peptideRow == -1) continue;
            this.peptideTable.addRowSelectionInterval(peptideRow, peptideRow);
        }
        ArrayList<Long> selectedPsms = this.reporterGUI.getSelectedPsms();
        this.psmTable.clearSelection();
        for (long tempPsmKey : selectedPsms) {
            int psmRow = this.getPsmRow(tempPsmKey);
            if (psmRow == -1) continue;
            this.psmTable.addRowSelectionInterval(psmRow, psmRow);
        }
    }

    public void minimizeChart() {
        if (this.chartMaximized) {
            this.maximizeChartJButtonActionPerformed(null);
        }
    }

    public void updateSelection(boolean clearSelection) {
        ArrayList<Long> selectedProteins = this.reporterGUI.getSelectedProteins();
        ArrayList<Long> selectedPeptides = this.reporterGUI.getSelectedPeptides();
        ArrayList<Long> selectedPsms = this.reporterGUI.getSelectedPsms();
        if (clearSelection) {
            this.proteinTable.clearSelection();
            this.peptideTable.clearSelection();
            this.psmTable.clearSelection();
        }
        if (selectedProteins.size() == 1) {
            int currentCluster = -1;
            for (int i = 0; i < this.reporterGUI.getkMeansClutering().getNumberOfClusters() && currentCluster == -1; ++i) {
                if (!this.reporterGUI.getkMeansClutering().getClusterMembers(i).contains(selectedProteins.get(0).toString())) continue;
                currentCluster = i;
            }
            if (currentCluster != -1) {
                ChartPanel currentChartPanel = (ChartPanel)this.plotPanel.getComponent(currentCluster);
                this.selectCluster(currentChartPanel, clearSelection);
            }
        }
        for (long tempProteinKey : selectedProteins) {
            int proteinRow = this.getProteinRow(tempProteinKey);
            if (proteinRow == -1) continue;
            this.proteinTable.addRowSelectionInterval(proteinRow, proteinRow);
        }
        if (!selectedProteins.isEmpty()) {
            int proteinRow = this.getProteinRow(selectedProteins.get(0));
            if (proteinRow != -1) {
                this.proteinTable.scrollRectToVisible(this.proteinTable.getCellRect(proteinRow, 0, false));
            }
            this.proteinTableMouseReleased(null);
        }
    }

    private int getProteinRow(long proteinKey) {
        int modelIndex = IntStream.range(0, this.proteinKeys.length).filter(i -> this.proteinKeys[i] == proteinKey).findAny().orElse(-1);
        return modelIndex == -1 ? -1 : ((SelfUpdatingTableModel)this.proteinTable.getModel()).getRowNumber(modelIndex);
    }

    private int getPeptideRow(long peptideKey) {
        int modelIndex = IntStream.range(0, this.peptideKeys.length).filter(i -> this.peptideKeys[i] == peptideKey).findAny().orElse(-1);
        return modelIndex == -1 ? -1 : ((SelfUpdatingTableModel)this.peptideTable.getModel()).getRowNumber(modelIndex);
    }

    private int getPsmRow(long psmKey) {
        int modelIndex = IntStream.range(0, this.psmKeys.length).filter(i -> this.psmKeys[i] == psmKey).findAny().orElse(-1);
        return modelIndex == -1 ? -1 : ((SelfUpdatingTableModel)this.psmTable.getModel()).getRowNumber(modelIndex);
    }

    private void initComponents() {
        this.clusterPopupMenu = new JPopupMenu();
        this.numberOfClustersMenuItem = new JMenuItem();
        this.backgroundLayeredPane = new JLayeredPane();
        this.overviewJPanel = new JPanel();
        this.overviewJSplitPane = new JSplitPane();
        this.ratioPlotsJPanel = new JPanel();
        this.ratioPlotsMainLayeredPane = new JLayeredPane();
        this.ratioPlotHelpJButton = new JButton();
        this.exportRatioPlotContextJButton = new JButton();
        this.ratioPlotOptionsJButton = new JButton();
        this.contextMenuRatioPlotBackgroundPanel = new JPanel();
        this.maximizeChartJButton = new JButton();
        this.ratioPlotsTitledPanel = new JPanel();
        this.plotPanel = new JPanel();
        this.proteinsJPanel = new JPanel();
        this.proteinsLayeredPane = new JLayeredPane();
        this.proteinsHelpJButton = new JButton();
        this.exportProteinsJButton = new JButton();
        this.contextMenuProteinsBackgroundPanel = new JPanel();
        this.proteinPeptidePsmLayeredPanel = new JPanel();
        this.matchesJTabbedPane = new JTabbedPane();
        this.proteinScrollPane = new JScrollPane();
        this.proteinTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)OverviewPanel.this.proteinTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.peptideScrollPane = new JScrollPane();
        this.peptideTable = new JTable();
        this.psmScrollPane = new JScrollPane();
        this.psmTable = new JTable();
        this.numberOfClustersMenuItem.setText("Number of Clusters");
        this.numberOfClustersMenuItem.setToolTipText("Set the number of clusters");
        this.numberOfClustersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.numberOfClustersMenuItemActionPerformed(evt);
            }
        });
        this.clusterPopupMenu.add(this.numberOfClustersMenuItem);
        this.setBackground(new Color(255, 255, 255));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                OverviewPanel.this.formComponentResized(evt);
            }
        });
        this.overviewJPanel.setBackground(new Color(255, 255, 255));
        this.overviewJPanel.setOpaque(false);
        this.overviewJPanel.setPreferredSize(new Dimension(900, 800));
        this.overviewJSplitPane.setBorder(null);
        this.overviewJSplitPane.setDividerLocation(300);
        this.overviewJSplitPane.setDividerSize(0);
        this.overviewJSplitPane.setOrientation(0);
        this.overviewJSplitPane.setResizeWeight(0.5);
        this.ratioPlotsJPanel.setOpaque(false);
        this.ratioPlotsMainLayeredPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.ratioPlotsMainLayeredPaneMouseExited(evt);
            }
        });
        this.ratioPlotHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.ratioPlotHelpJButton.setToolTipText("Help");
        this.ratioPlotHelpJButton.setBorder(null);
        this.ratioPlotHelpJButton.setBorderPainted(false);
        this.ratioPlotHelpJButton.setContentAreaFilled(false);
        this.ratioPlotHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.ratioPlotHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.ratioPlotHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.ratioPlotHelpJButtonMouseExited(evt);
            }
        });
        this.ratioPlotHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.ratioPlotHelpJButtonActionPerformed(evt);
            }
        });
        this.ratioPlotsMainLayeredPane.setLayer(this.ratioPlotHelpJButton, JLayeredPane.POPUP_LAYER);
        this.ratioPlotsMainLayeredPane.add(this.ratioPlotHelpJButton);
        this.ratioPlotHelpJButton.setBounds(930, 0, 10, 19);
        this.exportRatioPlotContextJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportRatioPlotContextJButton.setToolTipText("Copy to Clipboard");
        this.exportRatioPlotContextJButton.setBorder(null);
        this.exportRatioPlotContextJButton.setBorderPainted(false);
        this.exportRatioPlotContextJButton.setContentAreaFilled(false);
        this.exportRatioPlotContextJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportRatioPlotContextJButton.setEnabled(false);
        this.exportRatioPlotContextJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportRatioPlotContextJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.exportRatioPlotContextJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.exportRatioPlotContextJButtonMouseExited(evt);
            }
        });
        this.exportRatioPlotContextJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.exportRatioPlotContextJButtonActionPerformed(evt);
            }
        });
        this.ratioPlotsMainLayeredPane.setLayer(this.exportRatioPlotContextJButton, JLayeredPane.POPUP_LAYER);
        this.ratioPlotsMainLayeredPane.add(this.exportRatioPlotContextJButton);
        this.exportRatioPlotContextJButton.setBounds(920, 0, 10, 19);
        this.ratioPlotOptionsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.ratioPlotOptionsJButton.setToolTipText("Plot Options");
        this.ratioPlotOptionsJButton.setBorder(null);
        this.ratioPlotOptionsJButton.setBorderPainted(false);
        this.ratioPlotOptionsJButton.setContentAreaFilled(false);
        this.ratioPlotOptionsJButton.setEnabled(false);
        this.ratioPlotOptionsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_black.png")));
        this.ratioPlotOptionsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.ratioPlotOptionsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.ratioPlotOptionsJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.ratioPlotOptionsJButtonMouseReleased(evt);
            }
        });
        this.ratioPlotsMainLayeredPane.setLayer(this.ratioPlotOptionsJButton, JLayeredPane.POPUP_LAYER);
        this.ratioPlotsMainLayeredPane.add(this.ratioPlotOptionsJButton);
        this.ratioPlotOptionsJButton.setBounds(905, 5, 10, 19);
        this.contextMenuRatioPlotBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuRatioPlotBackgroundPanelLayout = new GroupLayout(this.contextMenuRatioPlotBackgroundPanel);
        this.contextMenuRatioPlotBackgroundPanel.setLayout(contextMenuRatioPlotBackgroundPanelLayout);
        contextMenuRatioPlotBackgroundPanelLayout.setHorizontalGroup(contextMenuRatioPlotBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        contextMenuRatioPlotBackgroundPanelLayout.setVerticalGroup(contextMenuRatioPlotBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.ratioPlotsMainLayeredPane.setLayer(this.contextMenuRatioPlotBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.ratioPlotsMainLayeredPane.add(this.contextMenuRatioPlotBackgroundPanel);
        this.contextMenuRatioPlotBackgroundPanel.setBounds(890, 0, 50, 19);
        this.maximizeChartJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/maximize-grey.png")));
        this.maximizeChartJButton.setToolTipText("Maximize");
        this.maximizeChartJButton.setBorder(null);
        this.maximizeChartJButton.setBorderPainted(false);
        this.maximizeChartJButton.setContentAreaFilled(false);
        this.maximizeChartJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/maximize.png")));
        this.maximizeChartJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.maximizeChartJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.maximizeChartJButtonMouseExited(evt);
            }
        });
        this.maximizeChartJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.maximizeChartJButtonActionPerformed(evt);
            }
        });
        this.ratioPlotsMainLayeredPane.setLayer(this.maximizeChartJButton, JLayeredPane.POPUP_LAYER);
        this.ratioPlotsMainLayeredPane.add(this.maximizeChartJButton);
        this.maximizeChartJButton.setBounds(50, 50, 20, 19);
        this.ratioPlotsTitledPanel.setBackground(new Color(255, 255, 255));
        this.ratioPlotsTitledPanel.setBorder(BorderFactory.createTitledBorder("Profile Clusters"));
        this.ratioPlotsTitledPanel.setOpaque(false);
        this.plotPanel.setOpaque(false);
        this.plotPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OverviewPanel.this.plotPanelMouseMoved(evt);
            }
        });
        this.plotPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.plotPanelMouseExited(evt);
            }
        });
        this.plotPanel.setLayout(new GridLayout(3, 4, 15, 15));
        GroupLayout ratioPlotsTitledPanelLayout = new GroupLayout(this.ratioPlotsTitledPanel);
        this.ratioPlotsTitledPanel.setLayout(ratioPlotsTitledPanelLayout);
        ratioPlotsTitledPanelLayout.setHorizontalGroup(ratioPlotsTitledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 948, Short.MAX_VALUE).addGroup(ratioPlotsTitledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ratioPlotsTitledPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plotPanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
        ratioPlotsTitledPanelLayout.setVerticalGroup(ratioPlotsTitledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 267, Short.MAX_VALUE).addGroup(ratioPlotsTitledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ratioPlotsTitledPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plotPanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
        this.ratioPlotsMainLayeredPane.add(this.ratioPlotsTitledPanel);
        this.ratioPlotsTitledPanel.setBounds(0, 0, 960, 290);
        GroupLayout ratioPlotsJPanelLayout = new GroupLayout(this.ratioPlotsJPanel);
        this.ratioPlotsJPanel.setLayout(ratioPlotsJPanelLayout);
        ratioPlotsJPanelLayout.setHorizontalGroup(ratioPlotsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ratioPlotsMainLayeredPane));
        ratioPlotsJPanelLayout.setVerticalGroup(ratioPlotsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ratioPlotsMainLayeredPane));
        this.overviewJSplitPane.setLeftComponent(this.ratioPlotsJPanel);
        this.proteinsJPanel.setOpaque(false);
        this.proteinsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.proteinsHelpJButton.setToolTipText("Help");
        this.proteinsHelpJButton.setBorder(null);
        this.proteinsHelpJButton.setBorderPainted(false);
        this.proteinsHelpJButton.setContentAreaFilled(false);
        this.proteinsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.proteinsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.proteinsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.proteinsHelpJButtonMouseExited(evt);
            }
        });
        this.proteinsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.proteinsHelpJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.proteinsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.proteinsHelpJButton);
        this.proteinsHelpJButton.setBounds(930, 0, 10, 19);
        this.exportProteinsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsJButton.setToolTipText("Copy to File");
        this.exportProteinsJButton.setBorder(null);
        this.exportProteinsJButton.setBorderPainted(false);
        this.exportProteinsJButton.setContentAreaFilled(false);
        this.exportProteinsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsJButton.setEnabled(false);
        this.exportProteinsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportProteinsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.exportProteinsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.exportProteinsJButtonMouseExited(evt);
            }
        });
        this.exportProteinsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.exportProteinsJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.exportProteinsJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.exportProteinsJButton);
        this.exportProteinsJButton.setBounds(920, 0, 10, 19);
        this.contextMenuProteinsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuProteinsBackgroundPanelLayout = new GroupLayout(this.contextMenuProteinsBackgroundPanel);
        this.contextMenuProteinsBackgroundPanel.setLayout(contextMenuProteinsBackgroundPanelLayout);
        contextMenuProteinsBackgroundPanelLayout.setHorizontalGroup(contextMenuProteinsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        contextMenuProteinsBackgroundPanelLayout.setVerticalGroup(contextMenuProteinsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.proteinsLayeredPane.setLayer(this.contextMenuProteinsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.contextMenuProteinsBackgroundPanel);
        this.contextMenuProteinsBackgroundPanel.setBounds(910, 0, 40, 19);
        this.proteinPeptidePsmLayeredPanel.setBorder(BorderFactory.createTitledBorder("Proteins, Peptides & PSMs"));
        this.proteinPeptidePsmLayeredPanel.setOpaque(false);
        this.matchesJTabbedPane.setTabPlacement(3);
        this.proteinTable.setModel((TableModel)((Object)new ProteinTableModel()));
        this.proteinTable.setOpaque(false);
        this.proteinTable.setSelectionMode(2);
        this.proteinTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OverviewPanel.this.proteinTableMouseMoved(evt);
            }
        });
        this.proteinTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.proteinTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.proteinTableMouseReleased(evt);
            }
        });
        this.proteinTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OverviewPanel.this.proteinTableKeyReleased(evt);
            }
        });
        this.proteinScrollPane.setViewportView(this.proteinTable);
        this.matchesJTabbedPane.addTab("Proteins", this.proteinScrollPane);
        this.peptideTable.setModel((TableModel)((Object)new PeptideTableModel()));
        this.peptideTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.peptideTableMouseReleased(evt);
            }
        });
        this.peptideTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OverviewPanel.this.peptideTableKeyReleased(evt);
            }
        });
        this.peptideScrollPane.setViewportView(this.peptideTable);
        this.matchesJTabbedPane.addTab("Peptides", this.peptideScrollPane);
        this.psmTable.setModel((TableModel)((Object)new PsmTableModel()));
        this.psmTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.psmTableMouseReleased(evt);
            }
        });
        this.psmTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OverviewPanel.this.psmTableKeyReleased(evt);
            }
        });
        this.psmScrollPane.setViewportView(this.psmTable);
        this.matchesJTabbedPane.addTab("PSMs", this.psmScrollPane);
        GroupLayout proteinPeptidePsmLayeredPanelLayout = new GroupLayout(this.proteinPeptidePsmLayeredPanel);
        this.proteinPeptidePsmLayeredPanel.setLayout(proteinPeptidePsmLayeredPanelLayout);
        proteinPeptidePsmLayeredPanelLayout.setHorizontalGroup(proteinPeptidePsmLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinPeptidePsmLayeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.matchesJTabbedPane).addContainerGap()));
        proteinPeptidePsmLayeredPanelLayout.setVerticalGroup(proteinPeptidePsmLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinPeptidePsmLayeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.matchesJTabbedPane, -1, 305, Short.MAX_VALUE).addContainerGap()));
        this.proteinsLayeredPane.add(this.proteinPeptidePsmLayeredPanel);
        this.proteinPeptidePsmLayeredPanel.setBounds(0, 0, 950, 350);
        GroupLayout proteinsJPanelLayout = new GroupLayout(this.proteinsJPanel);
        this.proteinsJPanel.setLayout(proteinsJPanelLayout);
        proteinsJPanelLayout.setHorizontalGroup(proteinsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinsLayeredPane, -1, 970, Short.MAX_VALUE));
        proteinsJPanelLayout.setVerticalGroup(proteinsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinsLayeredPane, -1, 458, Short.MAX_VALUE));
        this.overviewJSplitPane.setRightComponent(this.proteinsJPanel);
        GroupLayout overviewJPanelLayout = new GroupLayout(this.overviewJPanel);
        this.overviewJPanel.setLayout(overviewJPanelLayout);
        overviewJPanelLayout.setHorizontalGroup(overviewJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overviewJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.overviewJSplitPane).addContainerGap()));
        overviewJPanelLayout.setVerticalGroup(overviewJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overviewJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.overviewJSplitPane).addContainerGap()));
        this.backgroundLayeredPane.add(this.overviewJPanel);
        this.overviewJPanel.setBounds(0, 0, 990, 780);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 993, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundLayeredPane, -1, 993, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 688, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundLayeredPane, GroupLayout.Alignment.TRAILING, -1, 688, Short.MAX_VALUE)));
    }

    private void proteinTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void proteinTableMouseReleased(MouseEvent evt) {
        if (this.selectedChartPanel != null) {
            int j;
            Long proteinKeyAsLong;
            String proteinKey;
            int i;
            DefaultCategoryDataset oldDataset = (DefaultCategoryDataset)this.selectedChartPanel.getChart().getCategoryPlot().getDataset();
            ArrayList<Long> selectedProteins = new ArrayList<Long>();
            int[] selectedRowIndexes = this.proteinTable.getSelectedRows();
            for (int i2 = 0; i2 < selectedRowIndexes.length; ++i2) {
                Long proteinKey2 = this.proteinKeys[((SelfUpdatingTableModel)this.proteinTable.getModel()).getViewIndex(selectedRowIndexes[i2])];
                selectedProteins.add(proteinKey2);
            }
            this.reporterGUI.setSelectedProteins(selectedProteins, false, false);
            this.reporterGUI.setSelectedPeptides(new ArrayList<Long>(), false, false);
            this.reporterGUI.setSelectedPsms(new ArrayList<Long>(), false, false);
            DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
            for (i = 0; i < oldDataset.getRowCount(); ++i) {
                proteinKey = (String)((Object)oldDataset.getRowKey(i));
                proteinKeyAsLong = Long.valueOf(proteinKey);
                if (selectedProteins.contains(proteinKeyAsLong)) continue;
                for (j = 0; j < oldDataset.getColumnKeys().size(); ++j) {
                    newDataset.addValue(oldDataset.getValue(i, j), (Comparable)((Object)proteinKey), (Comparable)((Object)((String)oldDataset.getColumnKeys().get(j))));
                }
            }
            for (i = 0; i < oldDataset.getRowCount(); ++i) {
                proteinKey = (String)((Object)oldDataset.getRowKey(i));
                proteinKeyAsLong = Long.valueOf(proteinKey);
                if (!selectedProteins.contains(proteinKeyAsLong)) continue;
                for (j = 0; j < oldDataset.getColumnKeys().size(); ++j) {
                    newDataset.addValue(oldDataset.getValue(i, j), (Comparable)((Object)proteinKey), (Comparable)((Object)((String)oldDataset.getColumnKeys().get(j))));
                }
            }
            this.selectedChartPanel.getChart().getCategoryPlot().setDataset((CategoryDataset)newDataset);
            CategoryItemRenderer renderer = this.selectedChartPanel.getChart().getCategoryPlot().getRenderer();
            ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
            ClusteringSettings clusteringSettings = this.reporterGUI.getDisplayParameters().getClusteringSettings();
            for (int i3 = 0; i3 < newDataset.getRowCount(); ++i3) {
                Color nonSelectedColor;
                Color classColor;
                String clusterClass;
                ArrayList<String> classes;
                boolean isPsm;
                Long key = Long.valueOf((String)((Object)newDataset.getRowKey(i3)));
                boolean isProtein = clusterBuilder.getProteinIndex(key) != null;
                boolean isPeptide = clusterBuilder.getPeptideIndex(key) != null;
                boolean bl = isPsm = clusterBuilder.getPsmIndex(key) != null;
                if (isProtein) {
                    classes = clusterBuilder.getProteinClasses(key);
                    clusterClass = classes.get(0);
                    if (selectedProteins.contains(key)) {
                        classColor = clusteringSettings.getColor(clusterClass);
                        renderer.setSeriesPaint(i3, (Paint)classColor);
                        continue;
                    }
                    nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
                    continue;
                }
                if (isPeptide) {
                    classes = clusterBuilder.getPeptideClasses(key);
                    clusterClass = classes.get(0);
                    if (selectedProteins.contains(key)) {
                        classColor = clusteringSettings.getColor(clusterClass);
                        renderer.setSeriesPaint(i3, (Paint)classColor);
                        continue;
                    }
                    nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
                    continue;
                }
                if (!isPsm) throw new IllegalArgumentException("No match found for key " + key + ".");
                classes = clusterBuilder.getPsmClasses(key);
                clusterClass = classes.get(0);
                if (selectedProteins.contains(key)) {
                    classColor = clusteringSettings.getColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)classColor);
                    continue;
                }
                nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
            }
            this.selectedChartPanel.getChart().fireChartChanged();
        }
        int row = this.proteinTable.getSelectedRow();
        int column = this.proteinTable.getSelectedColumn();
        int proteinIndex = -1;
        if (row != -1) {
            proteinIndex = this.proteinTable.convertRowIndexToModel(row);
        }
        if (evt == null || evt.getButton() == 1 && proteinIndex != -1 && column != -1) {
            if (proteinIndex == -1) return;
            long proteinKey = this.proteinKeys[proteinIndex];
            if (column == this.proteinTable.getColumn("Chr").getModelIndex() && evt != null && evt.getButton() == 1) {
                try {
                    new GeneDetailsDialog((Frame)this.reporterGUI, this.identification.getProteinMatch(proteinKey), this.geneMaps, this.reporterGUI.getProteinDetailsProvider());
                }
                catch (Exception ex) {
                    this.reporterGUI.catchException(ex);
                }
            }
            if (column == this.proteinTable.getColumn("Accession").getModelIndex() && evt != null && evt.getButton() == 1 && ((String)this.proteinTable.getValueAt(row, column)).lastIndexOf("<html>") != -1) {
                String link = (String)this.proteinTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL((String)link);
                this.setCursor(new Cursor(0));
            }
            if (column == this.proteinTable.getColumn("PI").getModelIndex() && evt != null && evt.getButton() != 1) return;
        }
        if (evt.getButton() == 3 && this.proteinTable.columnAtPoint(evt.getPoint()) != this.proteinTable.getColumn("  ").getModelIndex()) return;
    }

    private void proteinTableMouseMoved(MouseEvent evt) {
        int row = this.proteinTable.rowAtPoint(evt.getPoint());
        int column = this.proteinTable.columnAtPoint(evt.getPoint());
        this.proteinTable.setToolTipText(null);
        if (row != -1 && column != -1 && column == this.proteinTable.getColumn("Accession").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.proteinTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<html>") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else if (column == this.proteinTable.getColumn("PI").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            this.setCursor(new Cursor(12));
        } else if (column == this.proteinTable.getColumn("Chr").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            this.setCursor(new Cursor(12));
        } else if (column == this.proteinTable.getColumn("Description").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            if (GuiUtilities.getPreferredWidthOfCell((JTable)this.proteinTable, (int)row, (int)column) > this.proteinTable.getColumn("Description").getWidth()) {
                this.proteinTable.setToolTipText("" + this.proteinTable.getValueAt(row, column));
            }
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void proteinTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.proteinTableMouseReleased(null);
        }
    }

    private void proteinsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void proteinsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.reporterGUI, this.getClass().getResource("/helpFiles/OverviewTabReporter.html"), null, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), "Proteins Help");
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportProteinsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsJButtonActionPerformed(ActionEvent evt) {
    }

    private void ratioPlotHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void ratioPlotHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void ratioPlotHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.reporterGUI, this.getClass().getResource("/helpFiles/OverviewTabReporter.html"), null, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), "Plot Help");
        this.setCursor(new Cursor(0));
    }

    private void exportRatioPlotContextJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportRatioPlotContextJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportRatioPlotContextJButtonActionPerformed(ActionEvent evt) {
    }

    private void ratioPlotOptionsJButtonMouseEntered(MouseEvent evt) {
        if (this.ratioPlotOptionsJButton.isEnabled()) {
            this.setCursor(new Cursor(12));
        }
    }

    private void ratioPlotOptionsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    public void autoResizeComponents() {
        this.formComponentResized(null);
    }

    private void formComponentResized(ComponentEvent evt) {
        this.backgroundLayeredPane.getComponent(0).setBounds(0, 0, this.backgroundLayeredPane.getWidth(), this.backgroundLayeredPane.getHeight());
        this.backgroundLayeredPane.revalidate();
        this.backgroundLayeredPane.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OverviewPanel.this.overviewJSplitPane.setDividerLocation(0.5);
                OverviewPanel.this.proteinsLayeredPane.getComponent(0).setBounds(OverviewPanel.this.proteinsLayeredPane.getWidth() - OverviewPanel.this.proteinsLayeredPane.getComponent(0).getWidth() - 10, -3, OverviewPanel.this.proteinsLayeredPane.getComponent(0).getWidth(), OverviewPanel.this.proteinsLayeredPane.getComponent(0).getHeight());
                OverviewPanel.this.proteinsLayeredPane.getComponent(1).setBounds(OverviewPanel.this.proteinsLayeredPane.getWidth() - OverviewPanel.this.proteinsLayeredPane.getComponent(1).getWidth() - 20, -3, OverviewPanel.this.proteinsLayeredPane.getComponent(1).getWidth(), OverviewPanel.this.proteinsLayeredPane.getComponent(1).getHeight());
                OverviewPanel.this.proteinsLayeredPane.getComponent(2).setBounds(OverviewPanel.this.proteinsLayeredPane.getWidth() - OverviewPanel.this.proteinsLayeredPane.getComponent(2).getWidth() - 5, -3, OverviewPanel.this.proteinsLayeredPane.getComponent(2).getWidth(), OverviewPanel.this.proteinsLayeredPane.getComponent(2).getHeight());
                OverviewPanel.this.proteinsLayeredPane.getComponent(3).setBounds(0, 0, OverviewPanel.this.proteinsLayeredPane.getWidth(), OverviewPanel.this.proteinsLayeredPane.getHeight());
                OverviewPanel.this.proteinsLayeredPane.revalidate();
                OverviewPanel.this.proteinsLayeredPane.repaint();
                OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(0).setBounds(OverviewPanel.this.ratioPlotsMainLayeredPane.getWidth() - OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(0).getWidth() - 10, -3, OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(0).getWidth(), OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(0).getHeight());
                OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(1).setBounds(OverviewPanel.this.ratioPlotsMainLayeredPane.getWidth() - OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(1).getWidth() - 20, -3, OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(1).getWidth(), OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(1).getHeight());
                OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(2).setBounds(OverviewPanel.this.ratioPlotsMainLayeredPane.getWidth() - OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(2).getWidth() - 32, 0, OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(2).getWidth(), OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(2).getHeight());
                OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(3).setBounds(OverviewPanel.this.ratioPlotsMainLayeredPane.getWidth() - OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(3).getWidth() - 5, -3, OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(3).getWidth(), OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(3).getHeight());
                OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(4).setBounds(50, 50, OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(4).getWidth(), OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(4).getHeight());
                OverviewPanel.this.ratioPlotsMainLayeredPane.getComponent(5).setBounds(0, 0, OverviewPanel.this.ratioPlotsMainLayeredPane.getWidth(), OverviewPanel.this.ratioPlotsMainLayeredPane.getHeight());
                OverviewPanel.this.ratioPlotsMainLayeredPane.revalidate();
                OverviewPanel.this.ratioPlotsMainLayeredPane.repaint();
            }
        });
    }

    private void numberOfClustersMenuItemActionPerformed(ActionEvent evt) {
        String value = JOptionPane.showInputDialog(this, "Number of clusters:", this.reporterGUI.getkMeansClutering().getNumberOfClusters());
        if (value != null) {
            try {
                int numberOfClusters = Integer.parseInt(value);
                this.reporterGUI.recluster(numberOfClusters, false);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The number of cluster has to be an integer value.", "Input Error", 2);
            }
        }
    }

    private void ratioPlotOptionsJButtonMouseReleased(MouseEvent evt) {
        if (this.ratioPlotOptionsJButton.isEnabled()) {
            this.clusterPopupMenu.show(this.ratioPlotOptionsJButton, evt.getX(), evt.getY());
        }
    }

    private void maximizeChartJButtonMouseEntered(MouseEvent evt) {
        if (this.ratioPlotOptionsJButton.isEnabled()) {
            this.setCursor(new Cursor(12));
        }
    }

    private void maximizeChartJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void maximizeChartJButtonActionPerformed(ActionEvent evt) {
        this.maximizeChartJButton.setVisible(false);
        if (this.chartMaximized) {
            this.maximizeChartJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/maximize-grey.png")));
            this.maximizeChartJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/maximize.png")));
            this.maximizeChartJButton.setToolTipText("Maximize");
        } else {
            this.maximizeChartJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/minimize-grey.png")));
            this.maximizeChartJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/minimize.png")));
            this.maximizeChartJButton.setToolTipText("Minimize");
        }
        this.chartMaximized = !this.chartMaximized;
        CategoryPlot plot = (CategoryPlot)this.selectedChartPanel.getChart().getPlot();
        plot.getDomainAxis().setVisible(this.chartMaximized);
        plot.setDomainGridlinesVisible(this.chartMaximized);
        if (this.chartMaximized) {
            boolean chartAlreadySelected = false;
            if (this.selectedChartPanel != null) {
                chartAlreadySelected = this.selectedChartPanel.getName().equalsIgnoreCase(this.maximizeIconChartPanel.getName());
            }
            if (!chartAlreadySelected) {
                this.reporterGUI.setSelectedProteins(new ArrayList<Long>(), true, true);
                if (this.selectedChartPanel != null) {
                    this.selectCluster(this.selectedChartPanel, true);
                    this.selectedChartPanel.setBorder(null);
                    this.selectedChartPanel.getChart().fireChartChanged();
                }
                this.selectCluster(this.maximizeIconChartPanel, true);
            }
            this.selectedChartPanel = this.maximizeIconChartPanel;
            plot.getRenderer().setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
            this.plotPanel.removeAll();
            this.plotPanel.setLayout(new BorderLayout());
            this.plotPanel.add((Component)this.selectedChartPanel);
            this.selectedChartPanel.setBorder(null);
            this.selectedChartPanel.getChart().fireChartChanged();
        } else {
            this.plotPanel.removeAll();
            this.plotPanel.setLayout(new GridLayout(3, 4, 15, 15));
            for (ChartPanel tempChartPanel : this.allChartPanels) {
                tempChartPanel.setBorder(null);
                tempChartPanel.getChart().fireChartChanged();
                ((CategoryPlot)tempChartPanel.getChart().getPlot()).getRenderer().setBaseToolTipGenerator(null);
                this.plotPanel.add((Component)tempChartPanel);
            }
            if (this.selectedChartPanel != null) {
                this.selectedChartPanel.setBorder((Border)new LineBorder(Color.DARK_GRAY));
                this.selectedChartPanel.getChart().fireChartChanged();
            }
        }
        this.ratioPlotsMainLayeredPane.revalidate();
        this.ratioPlotsMainLayeredPane.repaint();
    }

    private void plotPanelMouseMoved(MouseEvent evt) {
        Component c = evt.getComponent();
        if (c == null || c instanceof JPanel) {
            this.maximizeChartJButton.setVisible(false);
        }
    }

    private void plotPanelMouseExited(MouseEvent evt) {
        this.maximizeChartJButton.setVisible(false);
    }

    private void ratioPlotsMainLayeredPaneMouseExited(MouseEvent evt) {
        this.maximizeChartJButton.setVisible(false);
    }

    private void peptideTableMouseReleased(MouseEvent evt) {
        if (this.selectedChartPanel != null) {
            int j;
            Long peptideKeyAsLong;
            String peptideKey;
            int i;
            DefaultCategoryDataset oldDataset = (DefaultCategoryDataset)this.selectedChartPanel.getChart().getCategoryPlot().getDataset();
            ArrayList<Long> selectedPeptides = new ArrayList<Long>();
            int[] selectedRowIndexes = this.peptideTable.getSelectedRows();
            for (int i2 = 0; i2 < selectedRowIndexes.length; ++i2) {
                Long peptideKey2 = this.peptideKeys[((SelfUpdatingTableModel)this.peptideTable.getModel()).getViewIndex(selectedRowIndexes[i2])];
                selectedPeptides.add(peptideKey2);
            }
            this.reporterGUI.setSelectedProteins(new ArrayList<Long>(), false, false);
            this.reporterGUI.setSelectedPeptides(selectedPeptides, false, false);
            this.reporterGUI.setSelectedPsms(new ArrayList<Long>(), false, false);
            DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
            for (i = 0; i < oldDataset.getRowCount(); ++i) {
                peptideKey = (String)((Object)oldDataset.getRowKey(i));
                peptideKeyAsLong = Long.valueOf(peptideKey);
                if (selectedPeptides.contains(peptideKeyAsLong)) continue;
                for (j = 0; j < oldDataset.getColumnKeys().size(); ++j) {
                    newDataset.addValue(oldDataset.getValue(i, j), (Comparable)((Object)peptideKey), (Comparable)((Object)((String)oldDataset.getColumnKeys().get(j))));
                }
            }
            for (i = 0; i < oldDataset.getRowCount(); ++i) {
                peptideKey = (String)((Object)oldDataset.getRowKey(i));
                peptideKeyAsLong = Long.valueOf(peptideKey);
                if (!selectedPeptides.contains(peptideKeyAsLong)) continue;
                for (j = 0; j < oldDataset.getColumnKeys().size(); ++j) {
                    newDataset.addValue(oldDataset.getValue(i, j), (Comparable)((Object)peptideKey), (Comparable)((Object)((String)oldDataset.getColumnKeys().get(j))));
                }
            }
            this.selectedChartPanel.getChart().getCategoryPlot().setDataset((CategoryDataset)newDataset);
            CategoryItemRenderer renderer = this.selectedChartPanel.getChart().getCategoryPlot().getRenderer();
            ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
            ClusteringSettings clusteringSettings = this.reporterGUI.getDisplayParameters().getClusteringSettings();
            for (int i3 = 0; i3 < newDataset.getRowCount(); ++i3) {
                Color nonSelectedColor;
                Color classColor;
                String clusterClass;
                ArrayList<String> classes;
                boolean isPsm;
                Long key = Long.valueOf((String)((Object)newDataset.getRowKey(i3)));
                boolean isProtein = clusterBuilder.getProteinIndex(key) != null;
                boolean isPeptide = clusterBuilder.getPeptideIndex(key) != null;
                boolean bl = isPsm = clusterBuilder.getPsmIndex(key) != null;
                if (isProtein) {
                    classes = clusterBuilder.getProteinClasses(key);
                    clusterClass = classes.get(0);
                    if (selectedPeptides.contains(key)) {
                        classColor = clusteringSettings.getColor(clusterClass);
                        renderer.setSeriesPaint(i3, (Paint)classColor);
                        continue;
                    }
                    nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
                    continue;
                }
                if (isPeptide) {
                    classes = clusterBuilder.getPeptideClasses(key);
                    clusterClass = classes.get(0);
                    if (selectedPeptides.contains(key)) {
                        classColor = clusteringSettings.getColor(clusterClass);
                        renderer.setSeriesPaint(i3, (Paint)classColor);
                        continue;
                    }
                    nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
                    continue;
                }
                if (isPsm) {
                    classes = clusterBuilder.getPsmClasses(key);
                    clusterClass = classes.get(0);
                    if (selectedPeptides.contains(key)) {
                        classColor = clusteringSettings.getColor(clusterClass);
                        renderer.setSeriesPaint(i3, (Paint)classColor);
                        continue;
                    }
                    nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
                    continue;
                }
                throw new IllegalArgumentException("No match found for key " + key + ".");
            }
            this.selectedChartPanel.getChart().fireChartChanged();
        }
    }

    private void peptideTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.peptideTableMouseReleased(null);
        }
    }

    private void psmTableMouseReleased(MouseEvent evt) {
        if (this.selectedChartPanel != null) {
            int j;
            Long psmKeyLong;
            String psmKey;
            int i;
            DefaultCategoryDataset oldDataset = (DefaultCategoryDataset)this.selectedChartPanel.getChart().getCategoryPlot().getDataset();
            ArrayList<Long> selectedPsms = new ArrayList<Long>();
            int[] selectedRowIndexes = this.psmTable.getSelectedRows();
            for (int i2 = 0; i2 < selectedRowIndexes.length; ++i2) {
                long proteinKey = this.psmKeys[((SelfUpdatingTableModel)this.psmTable.getModel()).getViewIndex(selectedRowIndexes[i2])];
                selectedPsms.add(proteinKey);
            }
            this.reporterGUI.setSelectedProteins(new ArrayList<Long>(), false, false);
            this.reporterGUI.setSelectedPeptides(new ArrayList<Long>(), false, false);
            this.reporterGUI.setSelectedPsms(selectedPsms, false, false);
            DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
            for (i = 0; i < oldDataset.getRowCount(); ++i) {
                psmKey = (String)((Object)oldDataset.getRowKey(i));
                psmKeyLong = Long.valueOf(psmKey);
                if (selectedPsms.contains(psmKeyLong)) continue;
                for (j = 0; j < oldDataset.getColumnKeys().size(); ++j) {
                    newDataset.addValue(oldDataset.getValue(i, j), (Comparable)((Object)psmKey), (Comparable)((Object)((String)oldDataset.getColumnKeys().get(j))));
                }
            }
            for (i = 0; i < oldDataset.getRowCount(); ++i) {
                psmKey = (String)((Object)oldDataset.getRowKey(i));
                psmKeyLong = Long.valueOf(psmKey);
                if (!selectedPsms.contains(psmKeyLong)) continue;
                for (j = 0; j < oldDataset.getColumnKeys().size(); ++j) {
                    newDataset.addValue(oldDataset.getValue(i, j), (Comparable)((Object)psmKey), (Comparable)((Object)((String)oldDataset.getColumnKeys().get(j))));
                }
            }
            this.selectedChartPanel.getChart().getCategoryPlot().setDataset((CategoryDataset)newDataset);
            CategoryItemRenderer renderer = this.selectedChartPanel.getChart().getCategoryPlot().getRenderer();
            ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
            ClusteringSettings clusteringSettings = this.reporterGUI.getDisplayParameters().getClusteringSettings();
            for (int i3 = 0; i3 < newDataset.getRowCount(); ++i3) {
                Color nonSelectedColor;
                Color classColor;
                String clusterClass;
                ArrayList<String> classes;
                boolean isPsm;
                Long key = Long.valueOf((String)((Object)newDataset.getRowKey(i3)));
                boolean isProtein = clusterBuilder.getProteinIndex(key) != null;
                boolean isPeptide = clusterBuilder.getPeptideIndex(key) != null;
                boolean bl = isPsm = clusterBuilder.getPsmIndex(key) != null;
                if (isProtein) {
                    classes = clusterBuilder.getProteinClasses(key);
                    clusterClass = classes.get(0);
                    if (selectedPsms.contains(key)) {
                        classColor = clusteringSettings.getColor(clusterClass);
                        renderer.setSeriesPaint(i3, (Paint)classColor);
                        continue;
                    }
                    nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
                    continue;
                }
                if (isPeptide) {
                    classes = clusterBuilder.getPeptideClasses(key);
                    clusterClass = classes.get(0);
                    if (selectedPsms.contains(key)) {
                        classColor = clusteringSettings.getColor(clusterClass);
                        renderer.setSeriesPaint(i3, (Paint)classColor);
                        continue;
                    }
                    nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
                    continue;
                }
                if (isPsm) {
                    classes = clusterBuilder.getPsmClasses(key);
                    clusterClass = classes.get(0);
                    if (selectedPsms.contains(key)) {
                        classColor = clusteringSettings.getColor(clusterClass);
                        renderer.setSeriesPaint(i3, (Paint)classColor);
                        continue;
                    }
                    nonSelectedColor = clusteringSettings.getNonSelectedColor(clusterClass);
                    renderer.setSeriesPaint(i3, (Paint)nonSelectedColor);
                    continue;
                }
                throw new IllegalArgumentException("No match found for key " + key + ".");
            }
            this.selectedChartPanel.getChart().fireChartChanged();
        }
    }

    private void psmTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.psmTableMouseReleased(null);
        }
    }

    public void deactivateSelfUpdatingTableModels() {
        if (this.proteinTable.getModel() instanceof SelfUpdatingTableModel) {
            ((SelfUpdatingTableModel)this.proteinTable.getModel()).setSelfUpdating(false);
        }
    }

    private void updateProteinTableCellRenderers() {
        if (this.reporterGUI.getIdentification() != null) {
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).setMaxValue((double)this.reporterGUI.getMetrics().getMaxNPeptides().intValue());
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).setMaxValue((double)this.reporterGUI.getMetrics().getMaxNPsms().intValue());
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MW").getCellRenderer()).setMaxValue(this.reporterGUI.getMetrics().getMaxMW().doubleValue());
            try {
                ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Confidence").getCellRenderer()).setMaxValue(100.0);
            }
            catch (IllegalArgumentException e) {
                ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Score").getCellRenderer()).setMaxValue(100.0);
            }
        }
    }

    private void updatePeptideTableCellRenderers() {
        if (this.reporterGUI.getIdentification() != null) {
            HashMap<Integer, Color> peptideInferenceColorMap = new HashMap<Integer, Color>();
            peptideInferenceColorMap.put(0, this.reporterGUI.getSparklineColor());
            peptideInferenceColorMap.put(1, Color.YELLOW);
            peptideInferenceColorMap.put(2, Color.ORANGE);
            peptideInferenceColorMap.put(3, Color.RED);
            HashMap<Integer, String> peptideInferenceTooltipMap = new HashMap<Integer, String>();
            peptideInferenceTooltipMap.put(0, "Unique to a single protein");
            peptideInferenceTooltipMap.put(1, "Belongs to a group of related proteins");
            peptideInferenceTooltipMap.put(2, "Belongs to a group of related and unrelated proteins");
            peptideInferenceTooltipMap.put(3, "Belongs to unrelated proteins");
            this.peptideTable.getColumn("PI").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(this.reporterGUI.getSparklineColor(), peptideInferenceColorMap, peptideInferenceTooltipMap));
            Color nonValidatedColor = this.reporterGUI.getSparklineColorNonValidated();
            if (!this.reporterGUI.getIdentificationParameters().getFastaParameters().isTargetDecoy()) {
                nonValidatedColor = this.reporterGUI.getUtilitiesUserParameters().getSparklineColorNotFound();
            }
            ArrayList<Color> sparklineColors = new ArrayList<Color>();
            sparklineColors.add(this.reporterGUI.getSparklineColor());
            sparklineColors.add(this.reporterGUI.getUtilitiesUserParameters().getSparklineColorDoubtful());
            sparklineColors.add(nonValidatedColor);
            this.peptideTable.getColumn("#Spectra").setCellRenderer((TableCellRenderer)new JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), sparklineColors, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers));
            ((JSparklinesArrayListBarChartTableCellRenderer)this.peptideTable.getColumn("#Spectra").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0"));
            this.peptideTable.getColumn("").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
            try {
                this.peptideTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.reporterGUI.getSparklineColor()));
                ((JSparklinesBarChartTableCellRenderer)this.peptideTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.reporterGUI.getScoreAndConfidenceDecimalFormat());
            }
            catch (IllegalArgumentException e) {
                this.peptideTable.getColumn("Score").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.reporterGUI.getSparklineColor()));
                ((JSparklinesBarChartTableCellRenderer)this.peptideTable.getColumn("Score").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.reporterGUI.getScoreAndConfidenceDecimalFormat());
            }
            ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
            Double amplitude = clusterBuilder.getRatioAmplitude();
            this.peptideTable.getColumn("Quant").setCellRenderer((TableCellRenderer)new JSparklinesHeatMapTableCellRenderer(GradientColorCoding.ColorGradient.GreenWhiteRed, amplitude.doubleValue()));
        }
    }

    private void updatePsmTableCellRenderers() {
        if (this.reporterGUI.getIdentification() != null) {
            HashMap<Integer, Color> psmColorMap = new HashMap<Integer, Color>();
            psmColorMap.put(4, this.reporterGUI.getSparklineColor());
            psmColorMap.put(3, Color.CYAN);
            psmColorMap.put(1, Color.YELLOW);
            psmColorMap.put(2, Color.ORANGE);
            HashMap<Integer, String> psmTooltipMap = new HashMap<Integer, String>();
            psmTooltipMap.put(4, "ID Software Agree");
            psmTooltipMap.put(3, "ID Software Agree - PTM Certainty Issues");
            psmTooltipMap.put(1, "ID Software Disagree");
            psmTooltipMap.put(2, "First Hit(s) Missing");
            this.psmTable.getColumn("ID").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, psmColorMap, psmTooltipMap));
            this.psmTable.getColumn("m/z Error").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-this.reporterGUI.getIdentificationParameters().getSearchParameters().getPrecursorAccuracy()), Double.valueOf(this.reporterGUI.getIdentificationParameters().getSearchParameters().getPrecursorAccuracy()), this.reporterGUI.getSparklineColor(), this.reporterGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumn("m/z Error").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
            this.psmTable.getColumn("Charge").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(this.reporterGUI.getMetrics().getMaxCharge()), this.reporterGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumn("Charge").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 30);
            this.psmTable.getColumn("").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
            try {
                this.psmTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.reporterGUI.getSparklineColor()));
                ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.reporterGUI.getScoreAndConfidenceDecimalFormat());
            }
            catch (IllegalArgumentException e) {
                this.psmTable.getColumn("Score").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.reporterGUI.getSparklineColor()));
                ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumn("Score").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.reporterGUI.getScoreAndConfidenceDecimalFormat());
            }
            ClusterBuilder clusterBuilder = this.reporterGUI.getClusterBuilder();
            Double amplitude = clusterBuilder.getRatioAmplitude();
            this.psmTable.getColumn("Quant").setCellRenderer((TableCellRenderer)new JSparklinesHeatMapTableCellRenderer(GradientColorCoding.ColorGradient.GreenWhiteRed, amplitude.doubleValue()));
        }
    }

    static /* synthetic */ long[] access$202(OverviewPanel x0, long[] x1) {
        x0.proteinKeys = x1;
        return x1;
    }

    static /* synthetic */ long[] access$302(OverviewPanel x0, long[] x1) {
        x0.allOrderedProteinKeys = x1;
        return x1;
    }

    static /* synthetic */ long[] access$802(OverviewPanel x0, long[] x1) {
        x0.peptideKeys = x1;
        return x1;
    }

    static /* synthetic */ long[] access$902(OverviewPanel x0, long[] x1) {
        x0.psmKeys = x1;
        return x1;
    }

    static {
        XYBarRenderer.setDefaultBarPainter((XYBarPainter)new StandardXYBarPainter());
    }
}

