/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.settings.display;

import eu.isas.reporter.calculation.clustering.ClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.PeptideClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.ProteinClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.PsmClusterClassKey;
import eu.isas.reporter.settings.ClusteringSettings;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;

public class ClusteringSettingsDialog
extends JDialog {
    private boolean canceled = false;
    private ArrayList<String> proteinClasses;
    private ArrayList<String> peptideClasses;
    private ArrayList<String> psmClasses;
    private HashMap<String, ProteinClusterClassKey> proteinClassesMap;
    private HashMap<String, PeptideClusterClassKey> peptideClassesMap;
    private HashMap<String, PsmClusterClassKey> psmClassesMap;
    private ArrayList<String> selectedProteinClasses;
    private ArrayList<String> selectedPeptideClasses;
    private ArrayList<String> selectedPsmClasses;
    private HashMap<String, Color> classesColors;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JScrollPane peptideClassesScrollPane;
    private JTable peptideClassesTable;
    private JLabel peptidesClassesLbl;
    private JScrollPane proteinClassesScrollPane;
    private JTable proteinClassesTable;
    private JLabel proteinsClassesLbl;
    private JScrollPane psmClassesScrollPane;
    private JTable psmClassesTable;
    private JLabel psmsClassesLbl;
    private JPanel selectionPanel;

    public ClusteringSettingsDialog(JFrame parentFrame, ClusteringSettings clusteringSettings, boolean editable) {
        super((Frame)parentFrame, true);
        this.initComponents();
        this.editable = editable;
        this.populateGUI(clusteringSettings);
        this.setUpGui();
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    private void setUpGui() {
        TableColumn colorColumn = this.proteinClassesTable.getColumnModel().getColumn(0);
        colorColumn.setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        colorColumn.setMaxWidth(35);
        colorColumn.setMinWidth(35);
        colorColumn = this.peptideClassesTable.getColumnModel().getColumn(0);
        colorColumn.setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        colorColumn.setMaxWidth(35);
        colorColumn.setMinWidth(35);
        colorColumn = this.psmClassesTable.getColumnModel().getColumn(0);
        colorColumn.setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        colorColumn.setMaxWidth(35);
        colorColumn.setMinWidth(35);
        colorColumn = this.proteinClassesTable.getColumnModel().getColumn(2);
        colorColumn.setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        colorColumn.setMaxWidth(35);
        colorColumn.setMinWidth(35);
        colorColumn = this.peptideClassesTable.getColumnModel().getColumn(2);
        colorColumn.setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        colorColumn.setMaxWidth(35);
        colorColumn.setMinWidth(35);
        colorColumn = this.psmClassesTable.getColumnModel().getColumn(2);
        colorColumn.setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        colorColumn.setMaxWidth(35);
        colorColumn.setMinWidth(35);
        this.proteinClassesTable.getTableHeader().setReorderingAllowed(false);
        this.peptideClassesTable.getTableHeader().setReorderingAllowed(false);
        this.psmClassesTable.getTableHeader().setReorderingAllowed(false);
        this.proteinClassesScrollPane.getViewport().setOpaque(false);
        this.peptideClassesScrollPane.getViewport().setOpaque(false);
        this.psmClassesScrollPane.getViewport().setOpaque(false);
    }

    private void populateGUI(ClusteringSettings clusteringSettings) {
        this.proteinClasses = new ArrayList<String>(clusteringSettings.getPossibleProteinClasses());
        this.peptideClasses = new ArrayList<String>(clusteringSettings.getPossiblePeptideClasses());
        this.psmClasses = new ArrayList<String>(clusteringSettings.getPossiblePsmClasses());
        this.selectedProteinClasses = new ArrayList<String>(clusteringSettings.getSelectedProteinClasses());
        this.selectedPeptideClasses = new ArrayList<String>(clusteringSettings.getSelectedPeptideClasses());
        this.selectedPsmClasses = new ArrayList<String>(clusteringSettings.getSelectedPsmClasses());
        this.classesColors = clusteringSettings.getClassesColors();
        this.proteinClassesMap = clusteringSettings.getProteinKeysMap();
        HashMap<String, ClusterClassKey> proteinKeysMap = new HashMap<String, ClusterClassKey>(this.proteinClassesMap);
        this.proteinClassesTable.setModel(new ClassListTableModel(this.proteinClasses, this.selectedProteinClasses, proteinKeysMap));
        this.peptideClassesMap = clusteringSettings.getPeptideKeysMap();
        HashMap<String, ClusterClassKey> peptideKeysMap = new HashMap<String, ClusterClassKey>(this.peptideClassesMap);
        this.peptideClassesTable.setModel(new ClassListTableModel(this.peptideClasses, this.selectedPeptideClasses, peptideKeysMap));
        this.psmClassesMap = clusteringSettings.getPsmKeysMap();
        HashMap<String, ClusterClassKey> psmKeysMap = new HashMap<String, ClusterClassKey>(this.psmClassesMap);
        this.psmClassesTable.setModel(new ClassListTableModel(this.psmClasses, this.selectedPsmClasses, psmKeysMap));
        this.updateGUI();
    }

    private void updateGUI() {
        ((DefaultTableModel)this.proteinClassesTable.getModel()).fireTableDataChanged();
        ((DefaultTableModel)this.peptideClassesTable.getModel()).fireTableDataChanged();
        ((DefaultTableModel)this.psmClassesTable.getModel()).fireTableDataChanged();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public ClusteringSettings getClusteringSettings() {
        String selection;
        Boolean selected;
        int i;
        ArrayList<ProteinClusterClassKey> proteinClassesKeys = new ArrayList<ProteinClusterClassKey>(this.proteinClasses.size());
        for (String string : this.proteinClasses) {
            proteinClassesKeys.add(this.proteinClassesMap.get(string));
        }
        ArrayList<PeptideClusterClassKey> peptideClassesKeys = new ArrayList<PeptideClusterClassKey>(this.peptideClasses.size());
        for (String string : this.peptideClasses) {
            peptideClassesKeys.add(this.peptideClassesMap.get(string));
        }
        ArrayList<PsmClusterClassKey> arrayList = new ArrayList<PsmClusterClassKey>(this.psmClasses.size());
        for (String classKey : this.psmClasses) {
            arrayList.add(this.psmClassesMap.get(classKey));
        }
        ClusteringSettings clusteringSettings = new ClusteringSettings();
        clusteringSettings.setProteinClassKeys(proteinClassesKeys);
        clusteringSettings.setPeptideClassKeys(peptideClassesKeys);
        clusteringSettings.setPsmClassKeys(arrayList);
        for (i = 0; i < this.proteinClasses.size(); ++i) {
            selected = (Boolean)this.proteinClassesTable.getValueAt(i, 2);
            if (!selected.booleanValue()) continue;
            selection = this.proteinClasses.get(i);
            clusteringSettings.addProteinClass(selection);
        }
        for (i = 0; i < this.peptideClasses.size(); ++i) {
            selected = (Boolean)this.peptideClassesTable.getValueAt(i, 2);
            if (!selected.booleanValue()) continue;
            selection = this.peptideClasses.get(i);
            clusteringSettings.addPeptideClass(selection);
        }
        for (i = 0; i < this.psmClasses.size(); ++i) {
            selected = (Boolean)this.psmClassesTable.getValueAt(i, 2);
            if (!selected.booleanValue()) continue;
            selection = this.psmClasses.get(i);
            clusteringSettings.addPsmClass(selection);
        }
        clusteringSettings.setClassesColors(this.classesColors);
        return clusteringSettings;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.selectionPanel = new JPanel();
        this.proteinsClassesLbl = new JLabel();
        this.peptidesClassesLbl = new JLabel();
        this.psmsClassesLbl = new JLabel();
        this.proteinClassesScrollPane = new JScrollPane();
        this.proteinClassesTable = new JTable();
        this.peptideClassesScrollPane = new JScrollPane();
        this.peptideClassesTable = new JTable();
        this.psmClassesScrollPane = new JScrollPane();
        this.psmClassesTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("Cluster Settings");
        this.setBackground(new Color(230, 230, 230));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ClusteringSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClusteringSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClusteringSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.selectionPanel.setBorder(BorderFactory.createTitledBorder("Cluster Categories"));
        this.selectionPanel.setOpaque(false);
        this.proteinsClassesLbl.setText("Proteins");
        this.peptidesClassesLbl.setText("Peptides");
        this.psmsClassesLbl.setText("PSMs");
        this.proteinClassesTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.proteinClassesScrollPane.setViewportView(this.proteinClassesTable);
        this.peptideClassesTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.peptideClassesScrollPane.setViewportView(this.peptideClassesTable);
        this.psmClassesTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.psmClassesScrollPane.setViewportView(this.psmClassesTable);
        GroupLayout selectionPanelLayout = new GroupLayout(this.selectionPanel);
        this.selectionPanel.setLayout(selectionPanelLayout);
        selectionPanelLayout.setHorizontalGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectionPanelLayout.createSequentialGroup().addContainerGap().addGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinsClassesLbl).addComponent(this.psmsClassesLbl).addComponent(this.peptidesClassesLbl).addComponent(this.psmClassesScrollPane).addComponent(this.peptideClassesScrollPane, -1, 496, Short.MAX_VALUE).addComponent(this.proteinClassesScrollPane, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        selectionPanelLayout.setVerticalGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinsClassesLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteinClassesScrollPane, -1, 121, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.peptidesClassesLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideClassesScrollPane, -1, 121, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.psmsClassesLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psmClassesScrollPane, -1, 119, Short.MAX_VALUE).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.selectionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.selectionPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private class ClassListTableModel
    extends DefaultTableModel {
        private ArrayList<String> classes;
        private HashMap<String, Boolean> selectedClasses;
        private HashMap<String, ClusterClassKey> keysMap;

        public ClassListTableModel(ArrayList<String> possibleClasses, ArrayList<String> selectedClasses, HashMap<String, ClusterClassKey> keysMap) {
            this.classes = possibleClasses;
            this.selectedClasses = new HashMap(this.classes.size());
            for (String category : this.classes) {
                if (selectedClasses.contains(category)) {
                    this.selectedClasses.put(category, true);
                    continue;
                }
                this.selectedClasses.put(category, false);
            }
            this.keysMap = keysMap;
        }

        @Override
        public int getRowCount() {
            if (this.classes == null) {
                return 0;
            }
            return this.classes.size();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 2) {
                String key;
                this.selectedClasses.put(key, this.selectedClasses.get(key = this.classes.get(row)) == false);
            }
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 1: {
                    return "Category";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    String key = this.classes.get(row);
                    Color color = (Color)ClusteringSettingsDialog.this.classesColors.get(key);
                    if (color == null) {
                        color = Color.GRAY;
                    }
                    return color;
                }
                case 1: {
                    String key = this.classes.get(row);
                    ClusterClassKey clusterClassKey = this.keysMap.get(key);
                    return clusterClassKey.getName();
                }
                case 2: {
                    String key = this.classes.get(row);
                    return this.selectedClasses.get(key);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }
    }
}

