/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.settings.quantification;

import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import eu.isas.reporter.calculation.normalization.NormalizationType;
import eu.isas.reporter.settings.NormalizationSettings;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class NormalizationSettingsDialog
extends JDialog {
    private boolean canceled = false;
    private NormalizationType psmNormalizationType;
    private NormalizationType peptideNormalizationType;
    private NormalizationType proteinNormalizationType;
    private File stableProteinsFile;
    private File contaminantsFile;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton contaminantsBrowseButton;
    private JButton contaminantsClearButton;
    private JTextField contaminantsTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel matchesNormalizationPanel;
    private JButton okButton;
    private JComboBox peptideNormalizationCmb;
    private JLabel peptideNormalizationLbl;
    private JComboBox proteinNormalizationCmb;
    private JLabel proteinNormalizationLbl;
    private JComboBox psmNormalizationCmb;
    private JLabel psmNormalizationLbl;
    private JPanel specialProteinsPanel;
    private JButton stableProteinsBrowseButton;
    private JButton stableProteinsClearButton;
    private JTextField stableProteinsTxt;

    public NormalizationSettingsDialog(JDialog parentDialog, NormalizationSettings normalizationSettings, boolean editable) {
        super((Dialog)parentDialog, true);
        this.initComponents();
        this.setUpGui(editable);
        this.populateGUI(normalizationSettings);
        this.setLocationRelativeTo(parentDialog);
        this.setVisible(true);
    }

    private void setUpGui(boolean editable) {
        this.psmNormalizationCmb.setEnabled(editable);
        this.peptideNormalizationCmb.setEnabled(editable);
        this.proteinNormalizationCmb.setEnabled(editable);
        this.stableProteinsBrowseButton.setEnabled(editable);
        this.stableProteinsClearButton.setEnabled(editable);
        this.contaminantsBrowseButton.setEnabled(editable);
        this.contaminantsClearButton.setEnabled(editable);
        this.psmNormalizationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.peptideNormalizationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.proteinNormalizationCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(NormalizationSettings normalizationSettings) {
        this.psmNormalizationType = normalizationSettings.getPsmNormalization();
        this.peptideNormalizationType = normalizationSettings.getPeptideNormalization();
        this.proteinNormalizationType = normalizationSettings.getProteinNormalization();
        this.stableProteinsFile = normalizationSettings.getStableProteinsFastaFile();
        this.contaminantsFile = normalizationSettings.getContaminantsFastaFile();
        this.updateGUI();
    }

    private void updateGUI() {
        this.psmNormalizationCmb.setSelectedItem((Object)this.psmNormalizationType);
        this.peptideNormalizationCmb.setSelectedItem((Object)this.peptideNormalizationType);
        this.proteinNormalizationCmb.setSelectedItem((Object)this.proteinNormalizationType);
        if (this.stableProteinsFile != null) {
            this.stableProteinsTxt.setText(this.stableProteinsFile.getName());
        } else {
            this.stableProteinsTxt.setText("No File Selected");
        }
        if (this.contaminantsFile != null) {
            this.contaminantsTxt.setText(this.contaminantsFile.getName());
        } else {
            this.contaminantsTxt.setText("No File Selected");
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.matchesNormalizationPanel = new JPanel();
        this.psmNormalizationLbl = new JLabel();
        this.psmNormalizationCmb = new JComboBox();
        this.peptideNormalizationLbl = new JLabel();
        this.peptideNormalizationCmb = new JComboBox();
        this.proteinNormalizationLbl = new JLabel();
        this.proteinNormalizationCmb = new JComboBox();
        this.specialProteinsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.stableProteinsClearButton = new JButton();
        this.stableProteinsBrowseButton = new JButton();
        this.contaminantsClearButton = new JButton();
        this.contaminantsBrowseButton = new JButton();
        this.stableProteinsTxt = new JTextField();
        this.contaminantsTxt = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Normalization Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.matchesNormalizationPanel.setBorder(BorderFactory.createTitledBorder("Matches Normalization"));
        this.matchesNormalizationPanel.setOpaque(false);
        this.psmNormalizationLbl.setText("PSM Normalization");
        this.psmNormalizationCmb.setModel(new DefaultComboBoxModel<NormalizationType>(NormalizationType.values()));
        this.psmNormalizationCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.psmNormalizationCmbActionPerformed(evt);
            }
        });
        this.peptideNormalizationLbl.setText("Peptide Normalization");
        this.peptideNormalizationCmb.setModel(new DefaultComboBoxModel<NormalizationType>(NormalizationType.values()));
        this.peptideNormalizationCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.peptideNormalizationCmbActionPerformed(evt);
            }
        });
        this.proteinNormalizationLbl.setText("Protein Normalization");
        this.proteinNormalizationCmb.setModel(new DefaultComboBoxModel<NormalizationType>(NormalizationType.values()));
        this.proteinNormalizationCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.proteinNormalizationCmbActionPerformed(evt);
            }
        });
        GroupLayout matchesNormalizationPanelLayout = new GroupLayout(this.matchesNormalizationPanel);
        this.matchesNormalizationPanel.setLayout(matchesNormalizationPanelLayout);
        matchesNormalizationPanelLayout.setHorizontalGroup(matchesNormalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(matchesNormalizationPanelLayout.createSequentialGroup().addContainerGap().addGroup(matchesNormalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(matchesNormalizationPanelLayout.createSequentialGroup().addComponent(this.psmNormalizationLbl, -2, 150, -2).addGap(18, 18, 18).addComponent(this.psmNormalizationCmb, 0, -1, Short.MAX_VALUE)).addGroup(matchesNormalizationPanelLayout.createSequentialGroup().addComponent(this.proteinNormalizationLbl, -2, 150, -2).addGap(18, 18, 18).addComponent(this.proteinNormalizationCmb, -2, 380, -2)).addGroup(matchesNormalizationPanelLayout.createSequentialGroup().addComponent(this.peptideNormalizationLbl, -2, 150, -2).addGap(18, 18, 18).addComponent(this.peptideNormalizationCmb, 0, -1, Short.MAX_VALUE))).addContainerGap(159, Short.MAX_VALUE)));
        matchesNormalizationPanelLayout.setVerticalGroup(matchesNormalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(matchesNormalizationPanelLayout.createSequentialGroup().addContainerGap().addGroup(matchesNormalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmNormalizationLbl).addComponent(this.psmNormalizationCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(matchesNormalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideNormalizationLbl).addComponent(this.peptideNormalizationCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(matchesNormalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinNormalizationLbl).addComponent(this.proteinNormalizationCmb, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        this.specialProteinsPanel.setBorder(BorderFactory.createTitledBorder("Special Proteins"));
        this.specialProteinsPanel.setOpaque(false);
        this.jLabel1.setText("Stable Proteins");
        this.jLabel2.setText("Contaminants");
        this.stableProteinsClearButton.setText("Clear");
        this.stableProteinsClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.stableProteinsClearButtonActionPerformed(evt);
            }
        });
        this.stableProteinsBrowseButton.setText("Browse");
        this.stableProteinsBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.stableProteinsBrowseButtonActionPerformed(evt);
            }
        });
        this.contaminantsClearButton.setText("Clear");
        this.contaminantsClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.contaminantsClearButtonActionPerformed(evt);
            }
        });
        this.contaminantsBrowseButton.setText("Browse");
        this.contaminantsBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalizationSettingsDialog.this.contaminantsBrowseButtonActionPerformed(evt);
            }
        });
        this.stableProteinsTxt.setEditable(false);
        this.stableProteinsTxt.setHorizontalAlignment(0);
        this.contaminantsTxt.setEditable(false);
        this.contaminantsTxt.setHorizontalAlignment(0);
        GroupLayout specialProteinsPanelLayout = new GroupLayout(this.specialProteinsPanel);
        this.specialProteinsPanel.setLayout(specialProteinsPanelLayout);
        specialProteinsPanelLayout.setHorizontalGroup(specialProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, specialProteinsPanelLayout.createSequentialGroup().addContainerGap().addGroup(specialProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 150, -2).addComponent(this.jLabel2, -2, 150, -2)).addGap(18, 18, 18).addGroup(specialProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contaminantsTxt, -1, 383, Short.MAX_VALUE).addComponent(this.stableProteinsTxt, -1, 383, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(specialProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, specialProteinsPanelLayout.createSequentialGroup().addComponent(this.stableProteinsBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stableProteinsClearButton, -2, 67, -2)).addGroup(GroupLayout.Alignment.TRAILING, specialProteinsPanelLayout.createSequentialGroup().addComponent(this.contaminantsBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contaminantsClearButton, -2, 67, -2))).addContainerGap()));
        specialProteinsPanelLayout.setVerticalGroup(specialProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(specialProteinsPanelLayout.createSequentialGroup().addContainerGap().addGroup(specialProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.stableProteinsClearButton).addComponent(this.stableProteinsBrowseButton).addComponent(this.stableProteinsTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(specialProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.contaminantsClearButton).addComponent(this.contaminantsBrowseButton).addComponent(this.contaminantsTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 585, Short.MAX_VALUE).addComponent(this.okButton, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 69, -2)).addComponent(this.matchesNormalizationPanel, -1, -1, Short.MAX_VALUE).addComponent(this.specialProteinsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.matchesNormalizationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.specialProteinsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void stableProteinsClearButtonActionPerformed(ActionEvent evt) {
        this.stableProteinsFile = null;
        this.updateGUI();
    }

    private void contaminantsClearButtonActionPerformed(ActionEvent evt) {
        this.contaminantsFile = null;
        this.updateGUI();
    }

    private void stableProteinsBrowseButtonActionPerformed(ActionEvent evt) {
        File fastaFile;
        File startFile = null;
        if (this.stableProteinsFile != null) {
            startFile = this.stableProteinsFile.getParentFile();
        }
        this.stableProteinsFile = fastaFile = this.getFastaFile(startFile);
        this.updateGUI();
    }

    private void contaminantsBrowseButtonActionPerformed(ActionEvent evt) {
        File fastaFile;
        File startFile = null;
        if (this.contaminantsFile != null) {
            startFile = this.contaminantsFile.getParentFile();
        }
        this.contaminantsFile = fastaFile = this.getFastaFile(startFile);
        this.updateGUI();
    }

    private void psmNormalizationCmbActionPerformed(ActionEvent evt) {
        this.psmNormalizationType = (NormalizationType)((Object)this.psmNormalizationCmb.getSelectedItem());
    }

    private void peptideNormalizationCmbActionPerformed(ActionEvent evt) {
        this.peptideNormalizationType = (NormalizationType)((Object)this.peptideNormalizationCmb.getSelectedItem());
    }

    private void proteinNormalizationCmbActionPerformed(ActionEvent evt) {
        this.proteinNormalizationType = (NormalizationType)((Object)this.proteinNormalizationCmb.getSelectedItem());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private boolean validateInput() {
        return true;
    }

    public NormalizationSettings getNormalizationSettings() {
        NormalizationSettings normalizationSettings = new NormalizationSettings();
        normalizationSettings.setPsmNormalization(this.psmNormalizationType);
        normalizationSettings.setPeptideNormalization(this.peptideNormalizationType);
        normalizationSettings.setProteinNormalization(this.proteinNormalizationType);
        normalizationSettings.setStableProteinsFastaFile(this.stableProteinsFile);
        normalizationSettings.setContaminantsFastaFile(this.contaminantsFile);
        return normalizationSettings;
    }

    private File getFastaFile(File startLocation) {
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(".fasta") || myFile.getName().toLowerCase().endsWith(".fas") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "FASTA (.fasta or .fas)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            return file;
        }
        return null;
    }
}

