/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.settings.quantification;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import eu.isas.reporter.settings.RatioEstimationSettings;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class RatioEstimationSettingsDialog
extends JDialog {
    private boolean canceled = false;
    private ModificationParameters modificationParameters;
    private JButton addModifications;
    private JList allPTMs;
    private JScrollPane allPtmsScrollPane;
    private JLabel availablePtmsLabel;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox excludeMiscleavedCmb;
    private JComboBox excludeMissingIntensitiesCmb;
    private JLabel excludePeptidesLabel;
    private JComboBox excludeSharedCmb;
    private JLabel helpLabel;
    private JLabel helpLinkLabel;
    private JPanel idSelectionPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton okButton;
    private JComboBox peptideValidationCmb;
    private JLabel peptidesLabel;
    private JPanel proteinGroupJPanel;
    private JComboBox proteinValidationCmb;
    private JLabel proteinsLabel;
    private JComboBox psmValidationCmb;
    private JLabel psmsLabel;
    private JPanel ratioEstimationsPanel;
    private JButton removeModification;
    private JLabel resolutionLabel;
    private JTextField resolutionTxt;
    private JList selectedPTMs;
    private JScrollPane selectedPtmsScrollPane;
    private JLabel uniquePeptidesLbl;
    private JSpinner uniquePeptidesSpinner;
    private JTextField widthTxt;
    private JLabel windowWidthLabel;

    public RatioEstimationSettingsDialog(JDialog parentDialog, RatioEstimationSettings ratioEstimationSettings, ModificationParameters modificationParameters, boolean editable) {
        super((Dialog)parentDialog, true);
        this.modificationParameters = modificationParameters;
        this.initComponents();
        this.setUpGui(editable);
        this.populateGUI(ratioEstimationSettings);
        this.setLocationRelativeTo(parentDialog);
        this.setVisible(true);
    }

    private void setUpGui(boolean editable) {
        this.proteinValidationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.peptideValidationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.psmValidationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.excludeMissingIntensitiesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.excludeSharedCmb.setRenderer(new AlignedListCellRenderer(0));
        this.excludeMiscleavedCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(RatioEstimationSettings ratioEstimationSettings) {
        boolean excludeShared;
        this.proteinValidationCmb.setSelectedIndex(ratioEstimationSettings.getProteinValidationLevel().getIndex());
        this.peptideValidationCmb.setSelectedIndex(ratioEstimationSettings.getPeptideValidationLevel().getIndex());
        this.psmValidationCmb.setSelectedIndex(ratioEstimationSettings.getPsmValidationLevel().getIndex());
        if (ratioEstimationSettings.isIgnoreNullIntensities()) {
            this.excludeMissingIntensitiesCmb.setSelectedIndex(0);
        } else {
            this.excludeMissingIntensitiesCmb.setSelectedIndex(1);
        }
        this.widthTxt.setText(ratioEstimationSettings.getPercentile() + "");
        this.resolutionTxt.setText(ratioEstimationSettings.getRatioResolution() + "");
        ArrayList<String> selectedModificationsList = new ArrayList<String>(ratioEstimationSettings.getExcludingPtms());
        Collections.sort(selectedModificationsList);
        String[] allModificationsAsArray = new String[selectedModificationsList.size()];
        for (int i = 0; i < selectedModificationsList.size(); ++i) {
            allModificationsAsArray[i] = selectedModificationsList.get(i);
        }
        this.selectedPTMs.setListData(allModificationsAsArray);
        this.updateModificationList();
        int nUnique = ratioEstimationSettings.getMinUnique();
        boolean bl = excludeShared = nUnique >= 0;
        if (excludeShared) {
            this.excludeSharedCmb.setSelectedIndex(0);
        } else {
            this.excludeSharedCmb.setSelectedIndex(1);
        }
        this.uniquePeptidesSpinner.setEnabled(excludeShared);
        if (nUnique >= 0) {
            this.uniquePeptidesSpinner.setValue(ratioEstimationSettings.getMinUnique());
        }
        if (ratioEstimationSettings.isIgnoreMissedCleavages()) {
            this.excludeMiscleavedCmb.setSelectedIndex(0);
        } else {
            this.excludeMiscleavedCmb.setSelectedIndex(1);
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.idSelectionPanel = new JPanel();
        this.excludePeptidesLabel = new JLabel();
        this.selectedPtmsScrollPane = new JScrollPane();
        this.selectedPTMs = new JList();
        this.allPtmsScrollPane = new JScrollPane();
        this.allPTMs = new JList();
        this.availablePtmsLabel = new JLabel();
        this.addModifications = new JButton();
        this.removeModification = new JButton();
        this.ratioEstimationsPanel = new JPanel();
        this.resolutionLabel = new JLabel();
        this.windowWidthLabel = new JLabel();
        this.widthTxt = new JTextField();
        this.resolutionTxt = new JTextField();
        this.proteinsLabel = new JLabel();
        this.peptidesLabel = new JLabel();
        this.psmsLabel = new JLabel();
        this.peptideValidationCmb = new JComboBox();
        this.proteinValidationCmb = new JComboBox();
        this.psmValidationCmb = new JComboBox();
        this.jLabel1 = new JLabel();
        this.excludeMissingIntensitiesCmb = new JComboBox();
        this.helpLabel = new JLabel();
        this.helpLinkLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.proteinGroupJPanel = new JPanel();
        this.uniquePeptidesSpinner = new JSpinner();
        this.uniquePeptidesLbl = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.excludeSharedCmb = new JComboBox();
        this.excludeMiscleavedCmb = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Ratio Estimation Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.idSelectionPanel.setBorder(BorderFactory.createTitledBorder("PTM Selection"));
        this.idSelectionPanel.setOpaque(false);
        this.excludePeptidesLabel.setFont(this.excludePeptidesLabel.getFont().deriveFont(this.excludePeptidesLabel.getFont().getStyle() | 2));
        this.excludePeptidesLabel.setText("Exclude peptides with the following PTMs");
        this.selectedPtmsScrollPane.setViewportView(this.selectedPTMs);
        this.allPTMs.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.allPtmsScrollPane.setViewportView(this.allPTMs);
        this.availablePtmsLabel.setFont(this.availablePtmsLabel.getFont().deriveFont(this.availablePtmsLabel.getFont().getStyle() | 2));
        this.availablePtmsLabel.setText("Available PTMs");
        this.addModifications.setText("<<");
        this.addModifications.setToolTipText("Add to list of expected modifications");
        this.addModifications.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RatioEstimationSettingsDialog.this.addModificationsActionPerformed(evt);
            }
        });
        this.removeModification.setText(">>");
        this.removeModification.setToolTipText("Remove from list of selected modifications");
        this.removeModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RatioEstimationSettingsDialog.this.removeModificationActionPerformed(evt);
            }
        });
        GroupLayout idSelectionPanelLayout = new GroupLayout(this.idSelectionPanel);
        this.idSelectionPanel.setLayout(idSelectionPanelLayout);
        idSelectionPanelLayout.setHorizontalGroup(idSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idSelectionPanelLayout.createSequentialGroup().addGroup(idSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idSelectionPanelLayout.createSequentialGroup().addComponent(this.selectedPtmsScrollPane, -2, 408, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(idSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addModifications, -1, -1, Short.MAX_VALUE).addComponent(this.removeModification)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(idSelectionPanelLayout.createSequentialGroup().addComponent(this.excludePeptidesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(idSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allPtmsScrollPane, -2, 405, -2).addComponent(this.availablePtmsLabel))));
        idSelectionPanelLayout.linkSize(0, this.allPtmsScrollPane, this.selectedPtmsScrollPane);
        idSelectionPanelLayout.setVerticalGroup(idSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idSelectionPanelLayout.createSequentialGroup().addContainerGap().addGroup(idSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idSelectionPanelLayout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.addModifications).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeModification).addGap(69, 117, Short.MAX_VALUE)).addGroup(idSelectionPanelLayout.createSequentialGroup().addGroup(idSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idSelectionPanelLayout.createSequentialGroup().addGroup(idSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.availablePtmsLabel).addComponent(this.excludePeptidesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allPtmsScrollPane)).addGroup(idSelectionPanelLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.selectedPtmsScrollPane))).addContainerGap()))));
        this.ratioEstimationsPanel.setBorder(BorderFactory.createTitledBorder("Ratio Estimation"));
        this.ratioEstimationsPanel.setOpaque(false);
        this.resolutionLabel.setText("Resolution");
        this.windowWidthLabel.setText("Window Width (%)");
        this.widthTxt.setHorizontalAlignment(0);
        this.resolutionTxt.setHorizontalAlignment(0);
        this.proteinsLabel.setText("Proteins");
        this.peptidesLabel.setText("Peptides");
        this.psmsLabel.setText("PSMs");
        this.peptideValidationCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "Validated", "Confident"}));
        this.proteinValidationCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "Validated", "Confident"}));
        this.psmValidationCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "Validated", "Confident"}));
        this.jLabel1.setText("Exclude Missing Intensities");
        this.excludeMissingIntensitiesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout ratioEstimationsPanelLayout = new GroupLayout(this.ratioEstimationsPanel);
        this.ratioEstimationsPanel.setLayout(ratioEstimationsPanelLayout);
        ratioEstimationsPanelLayout.setHorizontalGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ratioEstimationsPanelLayout.createSequentialGroup().addContainerGap().addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptidesLabel, -2, 150, -2).addComponent(this.psmsLabel, -2, 150, -2).addComponent(this.proteinsLabel, -2, 150, -2).addComponent(this.resolutionLabel, -2, 150, -2).addComponent(this.windowWidthLabel, -2, 150, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 115, Short.MAX_VALUE).addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.excludeMissingIntensitiesCmb, -2, 150, -2).addGroup(ratioEstimationsPanelLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psmValidationCmb, -2, 150, -2).addComponent(this.peptideValidationCmb, -2, 150, -2).addComponent(this.proteinValidationCmb, 0, 150, Short.MAX_VALUE).addComponent(this.resolutionTxt, -2, 150, -2).addComponent(this.widthTxt, -1, 150, Short.MAX_VALUE)))).addContainerGap()));
        ratioEstimationsPanelLayout.linkSize(0, this.peptidesLabel, this.proteinsLabel, this.psmsLabel);
        ratioEstimationsPanelLayout.linkSize(0, this.peptideValidationCmb, this.proteinValidationCmb, this.psmValidationCmb, this.resolutionTxt, this.widthTxt);
        ratioEstimationsPanelLayout.setVerticalGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ratioEstimationsPanelLayout.createSequentialGroup().addContainerGap().addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinsLabel).addComponent(this.proteinValidationCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptidesLabel).addComponent(this.peptideValidationCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmsLabel).addComponent(this.psmValidationCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resolutionTxt, -2, -1, -2).addComponent(this.resolutionLabel)).addGap(0, 0, 0).addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthTxt, -2, -1, -2).addComponent(this.windowWidthLabel)).addGap(0, 0, 0).addGroup(ratioEstimationsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.excludeMissingIntensitiesCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() | 2));
        this.helpLabel.setText("For ratio estimation help see:");
        this.helpLinkLabel.setText("<html> <a href=\\\"dummy_link\">Burkhart et al.  (2011) [PMID: 21328540]</a>.</html>");
        this.helpLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RatioEstimationSettingsDialog.this.helpLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                RatioEstimationSettingsDialog.this.helpLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                RatioEstimationSettingsDialog.this.helpLinkLabelMouseExited(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RatioEstimationSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RatioEstimationSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.proteinGroupJPanel.setBorder(BorderFactory.createTitledBorder("Protein Group Ratio Estimation"));
        this.proteinGroupJPanel.setOpaque(false);
        this.uniquePeptidesSpinner.setModel(new SpinnerNumberModel((Number)3, Integer.valueOf(1), null, (Number)1));
        this.uniquePeptidesLbl.setText("Minimum Unique");
        this.jLabel2.setText("Exclude Shared Peptides If Enough Unique");
        this.jLabel3.setText("Exclude Miscleaved Peptides");
        this.excludeSharedCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.excludeMiscleavedCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout proteinGroupJPanelLayout = new GroupLayout(this.proteinGroupJPanel);
        this.proteinGroupJPanel.setLayout(proteinGroupJPanelLayout);
        proteinGroupJPanelLayout.setHorizontalGroup(proteinGroupJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinGroupJPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinGroupJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.uniquePeptidesLbl, -2, 150, -2)).addGap(30, 30, 30).addGroup(proteinGroupJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.uniquePeptidesSpinner, -2, 150, -2).addComponent(this.excludeMiscleavedCmb, -2, 150, -2).addComponent(this.excludeSharedCmb, -2, 150, -2)).addContainerGap(13, Short.MAX_VALUE)));
        proteinGroupJPanelLayout.setVerticalGroup(proteinGroupJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinGroupJPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinGroupJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludeSharedCmb, -2, -1, -2).addComponent(this.jLabel2)).addGap(0, 0, 0).addGroup(proteinGroupJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludeMiscleavedCmb, -2, -1, -2).addComponent(this.jLabel3)).addGap(0, 0, 0).addGroup(proteinGroupJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uniquePeptidesSpinner, -2, -1, -2).addComponent(this.uniquePeptidesLbl)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpLinkLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 69, -2)).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.idSelectionPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.ratioEstimationsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteinGroupJPanel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.proteinGroupJPanel, this.ratioEstimationsPanel);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ratioEstimationsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.proteinGroupJPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idSelectionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpLabel).addComponent(this.helpLinkLabel, -2, -1, -2).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void helpLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://onlinelibrary.wiley.com/doi/10.1002/pmic.201000711/abstract");
        this.setCursor(new Cursor(0));
    }

    private void removeModificationActionPerformed(ActionEvent evt) {
        int nSelected = this.selectedPTMs.getModel().getSize();
        int nToRemove = this.selectedPTMs.getSelectedIndices().length;
        String[] variableModifications = new String[nSelected - nToRemove];
        int cpt = 0;
        for (int i = 0; i < this.selectedPTMs.getModel().getSize(); ++i) {
            boolean found = false;
            for (Object selection : this.selectedPTMs.getSelectedValuesList()) {
                if (!((String)this.selectedPTMs.getModel().getElementAt(i)).equals((String)selection)) continue;
                found = true;
                break;
            }
            if (found) continue;
            variableModifications[cpt] = (String)this.selectedPTMs.getModel().getElementAt(i);
            ++cpt;
        }
        this.selectedPTMs.setListData(variableModifications);
        this.updateModificationList();
    }

    private void addModificationsActionPerformed(ActionEvent evt) {
        int nSelected = this.selectedPTMs.getModel().getSize();
        int nNew = this.allPTMs.getSelectedIndices().length;
        String[] fixedModifications = new String[nSelected + nNew];
        int cpt = 0;
        for (int i = 0; i < nSelected; ++i) {
            fixedModifications[cpt] = (String)this.selectedPTMs.getModel().getElementAt(i);
            ++cpt;
        }
        for (Object selection : this.allPTMs.getSelectedValuesList()) {
            String name = (String)selection;
            boolean found = false;
            for (int i = 0; i < this.selectedPTMs.getModel().getSize(); ++i) {
                if (!((String)this.selectedPTMs.getModel().getElementAt(i)).equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            fixedModifications[cpt] = name;
            ++cpt;
        }
        this.selectedPTMs.setListData(fixedModifications);
        this.updateModificationList();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private boolean validateInput() {
        Double input;
        try {
            input = Double.valueOf(this.resolutionTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "please enter a correct ratio resolution.", "Ratio Resolution Error", 0);
            return false;
        }
        if (input <= 0.0) {
            JOptionPane.showMessageDialog(this, "Please input a positive number for the ratio resolution.", "Ratio Resolution Error", 0);
            return false;
        }
        try {
            input = Double.valueOf(this.widthTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please enter a correct window width.", "Window Width Error", 0);
            return false;
        }
        if (input <= 0.0) {
            JOptionPane.showMessageDialog(this, "Please input a positive number for the window width.", "Window Width Error", 0);
            return false;
        }
        return true;
    }

    private void updateModificationList() {
        ArrayList allModificationsList = new ArrayList(this.modificationParameters.getAllNotFixedModifications());
        int nSelected = this.selectedPTMs.getModel().getSize();
        ArrayList<String> allModifications = new ArrayList<String>();
        for (String name : allModificationsList) {
            boolean found = false;
            for (int j = 0; j < nSelected; ++j) {
                if (!((String)this.selectedPTMs.getModel().getElementAt(j)).equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            allModifications.add(name);
        }
        Object[] allModificationsAsArray = new String[allModifications.size()];
        for (int i = 0; i < allModifications.size(); ++i) {
            allModificationsAsArray[i] = (String)allModifications.get(i);
        }
        Arrays.sort(allModificationsAsArray);
        this.allPTMs.setListData(allModificationsAsArray);
        this.allPTMs.setSelectedIndex(0);
    }

    public RatioEstimationSettings getRatioEstimationSettings() {
        RatioEstimationSettings ratioEstimationSettings = new RatioEstimationSettings();
        ratioEstimationSettings.setProteinValidationLevel(MatchValidationLevel.getMatchValidationLevel((int)this.proteinValidationCmb.getSelectedIndex()));
        ratioEstimationSettings.setPeptideValidationLevel(MatchValidationLevel.getMatchValidationLevel((int)this.peptideValidationCmb.getSelectedIndex()));
        ratioEstimationSettings.setPsmValidationLevel(MatchValidationLevel.getMatchValidationLevel((int)this.psmValidationCmb.getSelectedIndex()));
        Double resolution = Double.valueOf(this.resolutionTxt.getText());
        ratioEstimationSettings.setRatioResolution(resolution);
        Double windowWidth = Double.valueOf(this.widthTxt.getText());
        ratioEstimationSettings.setPercentile(windowWidth);
        ratioEstimationSettings.setIgnoreNullIntensities(this.excludeMissingIntensitiesCmb.getSelectedIndex() == 0);
        for (int i = 0; i < this.selectedPTMs.getModel().getSize(); ++i) {
            ratioEstimationSettings.addExcludingPtm(this.selectedPTMs.getModel().getElementAt(i).toString());
        }
        if (this.excludeSharedCmb.getSelectedIndex() == 0) {
            ratioEstimationSettings.setMinUnique((Integer)this.uniquePeptidesSpinner.getValue());
        } else {
            ratioEstimationSettings.setMinUnique(-1);
        }
        ratioEstimationSettings.setIgnoreMissedCleavages(this.excludeMiscleavedCmb.getSelectedIndex() == 0);
        return ratioEstimationSettings;
    }
}

