/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.tablemodels;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.gui.tabpanels.SpectrumIdentificationPanel;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.preferences.DisplayPreferences;
import eu.isas.reporter.quantificationdetails.PsmQuantificationDetails;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import no.uib.jsparklines.data.JSparklinesDataSeries;

public class PsmTableModel
extends SelfUpdatingTableModel {
    private Identification identification;
    private SpectrumProvider spectrumProvider;
    private DisplayFeaturesGenerator displayFeaturesGenerator;
    private InputMap inputMap;
    private IdentificationParameters identificationParameters;
    private QuantificationFeaturesGenerator quantificationFeaturesGenerator;
    private ReporterIonQuantification reporterIonQuantification;
    private ArrayList<String> sampleIndexes;
    private long[] psmKeys = null;
    private boolean showScores = false;
    private int batchSize = 20;
    private ExceptionHandler exceptionHandler;
    private DisplayPreferences displayPreferences;

    public PsmTableModel() {
    }

    public PsmTableModel(Identification identification, SpectrumProvider spectrumProvider, DisplayFeaturesGenerator displayFeaturesGenerator, DisplayPreferences displayPreferences, IdentificationParameters identificationParameters, ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, long[] psmKeys, boolean displayScores, ExceptionHandler exceptionHandler) {
        this.identification = identification;
        this.spectrumProvider = spectrumProvider;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.displayPreferences = displayPreferences;
        this.reporterIonQuantification = reporterIonQuantification;
        this.quantificationFeaturesGenerator = quantificationFeaturesGenerator;
        this.identificationParameters = identificationParameters;
        this.psmKeys = psmKeys;
        this.showScores = displayScores;
        this.exceptionHandler = exceptionHandler;
        PSMaps pSMaps = new PSMaps();
        pSMaps = (PSMaps)identification.getUrParam((UrParameter)pSMaps);
        this.inputMap = pSMaps.getInputMap();
        this.sampleIndexes = new ArrayList(reporterIonQuantification.getSampleIndexes());
        Collections.sort(this.sampleIndexes);
    }

    public void updateDataModel(Identification identification, SpectrumProvider spectrumProvider, DisplayFeaturesGenerator displayFeaturesGenerator, DisplayPreferences displayPreferences, IdentificationParameters identificationParameters, ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, long[] psmKeys, boolean displayScores) {
        this.identification = identification;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.displayPreferences = displayPreferences;
        this.reporterIonQuantification = reporterIonQuantification;
        this.quantificationFeaturesGenerator = quantificationFeaturesGenerator;
        this.identificationParameters = identificationParameters;
        this.psmKeys = psmKeys;
        this.showScores = displayScores;
        PSMaps pSMaps = new PSMaps();
        pSMaps = (PSMaps)identification.getUrParam((UrParameter)pSMaps);
        this.inputMap = pSMaps.getInputMap();
        this.sampleIndexes = new ArrayList(reporterIonQuantification.getSampleIndexes());
        Collections.sort(this.sampleIndexes);
    }

    public void reset() {
        this.psmKeys = null;
    }

    public int getRowCount() {
        return this.psmKeys == null ? 0 : this.psmKeys.length;
    }

    public int getColumnCount() {
        return 8;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Quant";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "Sequence";
            }
            case 4: {
                return "Charge";
            }
            case 5: {
                return "m/z Error";
            }
            case 6: {
                if (this.showScores) {
                    return "Score";
                }
                return "Confidence";
            }
            case 7: {
                return "";
            }
        }
        return "";
    }

    public Object getValueAt(int row, int column) {
        int viewIndex = this.getViewIndex(row);
        if (viewIndex < this.psmKeys.length) {
            if (column == 0) {
                return viewIndex + 1;
            }
            long psmKey = this.psmKeys[viewIndex];
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(psmKey);
            switch (column) {
                case 1: {
                    ArrayList<Double> data = new ArrayList<Double>();
                    PsmQuantificationDetails quantificationDetails = this.quantificationFeaturesGenerator.getPSMQuantificationDetails(this.spectrumProvider, spectrumMatch.getKey());
                    ArrayList<String> reagentsOrder = this.displayPreferences.getReagents();
                    for (String tempReagent : reagentsOrder) {
                        int sampleIndex = this.sampleIndexes.indexOf(tempReagent);
                        Double ratio = quantificationDetails.getRatio(this.sampleIndexes.get(sampleIndex), this.reporterIonQuantification.getNormalizationFactors());
                        if (ratio == null) continue;
                        if (ratio != 0.0) {
                            ratio = BasicMathFunctions.log((double)ratio, (double)2.0);
                        }
                        data.add(ratio);
                    }
                    return new JSparklinesDataSeries(data, Color.BLACK, null);
                }
                case 2: {
                    return SpectrumIdentificationPanel.isBestPsmEqualForAllIdSoftware((SpectrumMatch)spectrumMatch, (SequenceMatchingParameters)this.identificationParameters.getSequenceMatchingParameters(), (Integer)this.inputMap.getInputAlgorithmsSorted().size());
                }
                case 3: {
                    return this.displayFeaturesGenerator.getTaggedPeptideSequence(spectrumMatch, true, true, true);
                }
                case 4: {
                    if (spectrumMatch.getBestPeptideAssumption() != null) {
                        return spectrumMatch.getBestPeptideAssumption().getIdentificationCharge();
                    }
                    if (spectrumMatch.getBestTagAssumption() != null) {
                        return spectrumMatch.getBestTagAssumption().getIdentificationCharge();
                    }
                    throw new IllegalArgumentException("No best assumption found for spectrum " + psmKey + ".");
                }
                case 5: {
                    Precursor precursor = this.spectrumProvider.getPrecursor(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
                    SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
                    if (spectrumMatch.getBestPeptideAssumption() != null) {
                        return Math.abs(spectrumMatch.getBestPeptideAssumption().getDeltaMz(precursor.mz, searchParameters.isPrecursorAccuracyTypePpm().booleanValue(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection()));
                    }
                    if (spectrumMatch.getBestTagAssumption() != null) {
                        return Math.abs(spectrumMatch.getBestTagAssumption().getDeltaMz(precursor.mz, searchParameters.isPrecursorAccuracyTypePpm().booleanValue(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection()));
                    }
                    throw new IllegalArgumentException("No best assumption found for spectrum " + psmKey + ".");
                }
                case 6: {
                    PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
                    return this.showScores ? psParameter.getTransformedScore() : psParameter.getConfidence();
                }
                case 7: {
                    PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
                    return psParameter.getMatchValidationLevel().getIndex();
                }
            }
            return null;
        }
        return null;
    }

    public boolean isInstantiated() {
        return this.identification != null;
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    protected void catchException(Exception e) {
        this.setSelfUpdating(false);
        this.exceptionHandler.catchException(e);
    }

    protected int loadDataForRows(ArrayList<Integer> rows, WaitingHandler waitingHandler) {
        boolean canceled = rows.stream().map(i -> this.identification.getSpectrumMatch(this.psmKeys[i])).anyMatch(dummy -> waitingHandler.isRunCanceled());
        return canceled ? rows.get(0) : rows.get(rows.size() - 1);
    }
}

