/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.io;

import com.compomics.util.db.object.ObjectsDB;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.Quantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethodFactory;
import com.compomics.util.io.IoUtil;
import com.compomics.util.math.clustering.settings.KMeansClusteringSettings;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.utils.PsdbParent;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.calculation.clustering.keys.PeptideClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.ProteinClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.PsmClusterClassKey;
import eu.isas.reporter.preferences.DisplayPreferences;
import eu.isas.reporter.settings.ClusteringSettings;
import eu.isas.reporter.settings.ReporterIonSelectionSettings;
import eu.isas.reporter.settings.ReporterSettings;
import java.awt.Color;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.compress.archivers.ArchiveException;

public class ProjectImporter {
    private Dialog owner;
    private ReporterSettings reporterSettings;
    private ReporterIonQuantification reporterIonQuantification;
    private DisplayPreferences displayPreferences;
    private SpectrumProvider spectrumProvider;
    public static final double DEFAULT_REPORTER_ION_TOLERANCE_TMT = 0.0016;
    public static final double DEFAULT_REPORTER_ION_TOLERANCE_ITRAQ = 0.05;

    public ProjectImporter(Dialog owner) {
        this.owner = owner;
    }

    public ProjectImporter() {
        this(null);
    }

    public void importPeptideShakerProject(PsdbParent psdbParent, ArrayList<File> mgfFiles, WaitingHandler waitingHandler) throws IOException, ClassNotFoundException, SQLException, InterruptedException, ArchiveException {
        File psdbFile = psdbParent.getPsdbFile();
        if (IoUtil.getExtension((File)psdbFile).equalsIgnoreCase(".zip")) {
            psdbParent.loadPsdbFromZipFile(psdbFile, Reporter.getMatchesFolder(), waitingHandler);
        } else {
            waitingHandler.setWaitingText("Opening PeptideShaker Project. Please Wait...");
            psdbParent.loadPsdbFile(Reporter.getMatchesFolder(), waitingHandler, false);
        }
        if (waitingHandler.isRunCanceled()) {
            waitingHandler.setRunFinished();
            return;
        }
        waitingHandler.setWaitingText("Loading FASTA File. Please Wait...");
        if (this.owner != null) {
            try {
                psdbParent.loadFastaFile(waitingHandler);
            }
            catch (Exception exception) {}
        } else if (psdbParent.loadFastaFile(waitingHandler) == null) {
            throw new IllegalArgumentException("The FASTA file was not found. Please provide its location in the command line parameters.");
        }
        if (waitingHandler.isRunCanceled()) {
            waitingHandler.setRunFinished();
            return;
        }
        Set spectrumFiles = psdbParent.getProjectDetails().getSpectrumFileNames();
        waitingHandler.setWaitingText("Loading Spectrum Files. Please Wait...");
        waitingHandler.setPrimaryProgressCounterIndeterminate(true);
        int cpt = 0;
        int total = spectrumFiles.size();
        for (String spectrumFileName : spectrumFiles) {
            waitingHandler.setWaitingText("Loading Spectrum Files (" + ++cpt + " of " + total + "). Please Wait...");
            if (this.owner != null) {
                try {
                    psdbParent.loadSpectrumFile(spectrumFileName, mgfFiles, waitingHandler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!waitingHandler.isRunCanceled()) continue;
                waitingHandler.setRunFinished();
                break;
            }
            if (psdbParent.loadSpectrumFile(spectrumFileName, mgfFiles, waitingHandler)) continue;
            throw new IllegalArgumentException(spectrumFileName + " was not found. Please provide its location in the command line parameters.");
        }
        if (waitingHandler.isRunCanceled()) {
            waitingHandler.setRunFinished();
            return;
        }
        waitingHandler.setPrimaryProgressCounterIndeterminate(true);
    }

    public void importReporterProject(PsdbParent psdbParent, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        Identification identification = psdbParent.getIdentification();
        this.spectrumProvider = psdbParent.getSpectrumProvider();
        IdentificationParameters identificationParameters = psdbParent.getIdentificationParameters();
        ObjectsDB objectsDB = identification.getObjectsDB();
        waitingHandler.setWaitingText("Inferring Quantification Parameters. Please Wait...");
        if (this.reporterIonQuantification == null) {
            this.reporterIonQuantification = ProjectImporter.getDefaultReporterIonQuantification(identificationParameters);
        }
        if (this.reporterSettings == null) {
            this.reporterSettings = ProjectImporter.getDefaultReporterSettings(this.reporterIonQuantification.getReporterMethod(), identificationParameters);
        }
        if (this.displayPreferences == null) {
            this.displayPreferences = new DisplayPreferences();
            ClusteringSettings clusteringSettings = ProjectImporter.getDefaultClusterMetrics(identificationParameters, identification);
            KMeansClusteringSettings kMeansClusteringSettings = new KMeansClusteringSettings();
            clusteringSettings.setKMeansClusteringSettings(kMeansClusteringSettings);
            this.displayPreferences.setClusteringSettings(clusteringSettings);
        }
    }

    public static ReporterSettings getDefaultReporterSettings(ReporterMethod reporterMethod, IdentificationParameters identificationParameters) {
        ReporterSettings reporterSettings = new ReporterSettings();
        return ProjectImporter.getDefaultReporterSettings(reporterMethod, identificationParameters, reporterSettings);
    }

    public static ReporterSettings getDefaultReporterSettings(ReporterMethod reporterMethod, IdentificationParameters identificationParameters, ReporterSettings reporterSettings) {
        ReporterIonSelectionSettings reporterIonSelectionSettings = reporterSettings.getReporterIonSelectionSettings();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        if (reporterMethod.getName().contains("iTRAQ")) {
            if (reporterMethod.getName().contains("4")) {
                double massTolerance = searchParameters.getFragmentIonAccuracyInDaltons(ReporterIon.iTRAQ4Plex_117.getTheoreticMz(Integer.valueOf(1)));
                reporterIonSelectionSettings.setReporterIonsMzTolerance(massTolerance);
                reporterIonSelectionSettings.setMostAccurate(massTolerance < 0.05);
            } else {
                double massTolerance = searchParameters.getFragmentIonAccuracyInDaltons(ReporterIon.iTRAQ8Plex_121.getTheoreticMz(Integer.valueOf(1)));
                reporterIonSelectionSettings.setReporterIonsMzTolerance(massTolerance);
                reporterIonSelectionSettings.setMostAccurate(massTolerance < 0.05);
            }
        } else if (reporterMethod.getName().contains("TMT") && reporterIonSelectionSettings.getReporterIonsMzTolerance() > 0.0016) {
            reporterIonSelectionSettings.setReporterIonsMzTolerance(0.0016);
            reporterIonSelectionSettings.setMostAccurate(true);
        }
        return reporterSettings;
    }

    public static ReporterIonQuantification getDefaultReporterIonQuantification(IdentificationParameters identificationParameters) {
        ReporterMethod selectedMethod = null;
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        ReporterMethodFactory reporterMethodFactory = ReporterMethodFactory.getInstance();
        for (String ptmName : searchParameters.getModificationParameters().getAllModifications()) {
            if (ptmName.contains("iTRAQ 4-plex")) {
                selectedMethod = reporterMethodFactory.getReporterMethod("iTRAQ 4-plex");
                break;
            }
            if (ptmName.contains("iTRAQ 8-plex")) {
                selectedMethod = reporterMethodFactory.getReporterMethod("iTRAQ 8-plex");
                break;
            }
            if (ptmName.contains("TMT 2-plex")) {
                selectedMethod = reporterMethodFactory.getReporterMethod("TMT 2-plex");
                break;
            }
            if (ptmName.contains("TMT") && ptmName.contains("6-plex")) {
                if (searchParameters.getForwardIons().contains(4) || searchParameters.getRewindIons().contains(4)) {
                    selectedMethod = reporterMethodFactory.getReporterMethod("TMT 6-plex (HCD)");
                    break;
                }
                selectedMethod = reporterMethodFactory.getReporterMethod("TMT 6-plex (ETD)");
                break;
            }
            if (ptmName.contains("TMT") && ptmName.contains("10-plex")) {
                selectedMethod = reporterMethodFactory.getReporterMethod("TMT 10-plex");
                break;
            }
            if (ptmName.contains("TMT") && ptmName.contains("11-plex")) {
                selectedMethod = reporterMethodFactory.getReporterMethod("TMT 11-plex");
                break;
            }
            if (ptmName.contains("iodoTMT")) {
                selectedMethod = reporterMethodFactory.getReporterMethod("iodoTMT 6-plex (HCD)");
                break;
            }
            if (!ptmName.contains("TMTpro")) continue;
            selectedMethod = reporterMethodFactory.getReporterMethod("TMTpro");
            break;
        }
        ReporterIonQuantification reporterIonQuantification = new ReporterIonQuantification(Quantification.QuantificationMethod.REPORTER_IONS);
        if (selectedMethod == null) {
            selectedMethod = reporterMethodFactory.getReporterMethod("TMT 10-plex");
        }
        reporterIonQuantification.setMethod(selectedMethod);
        return reporterIonQuantification;
    }

    public static ClusteringSettings getDefaultClusterMetrics(IdentificationParameters identificationParameters, Identification identification) {
        ClusteringSettings clusteringSettings = new ClusteringSettings();
        ArrayList<ProteinClusterClassKey> proteinClasses = new ArrayList<ProteinClusterClassKey>(1);
        ProteinClusterClassKey proteinClusterClassKey = new ProteinClusterClassKey();
        proteinClasses.add(proteinClusterClassKey);
        clusteringSettings.setColor(proteinClusterClassKey.toString(), Color.BLACK);
        ProteinClusterClassKey defaultClusterClass = proteinClusterClassKey;
        proteinClusterClassKey = new ProteinClusterClassKey();
        proteinClusterClassKey.setStarred(Boolean.TRUE);
        proteinClasses.add(proteinClusterClassKey);
        clusteringSettings.setColor(proteinClusterClassKey.toString(), Color.yellow);
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        ArrayList<PeptideClusterClassKey> peptideClasses = new ArrayList<PeptideClusterClassKey>(4);
        PeptideClusterClassKey peptidelusterClassKey = new PeptideClusterClassKey();
        peptideClasses.add(peptidelusterClassKey);
        clusteringSettings.setColor(peptidelusterClassKey.toString(), Color.DARK_GRAY);
        peptidelusterClassKey = new PeptideClusterClassKey();
        peptidelusterClassKey.setStarred(Boolean.TRUE);
        peptideClasses.add(peptidelusterClassKey);
        clusteringSettings.setColor(peptidelusterClassKey.toString(), Color.yellow);
        peptidelusterClassKey = new PeptideClusterClassKey();
        peptidelusterClassKey.setnTerm(Boolean.TRUE);
        peptideClasses.add(peptidelusterClassKey);
        clusteringSettings.setColor(peptidelusterClassKey.toString(), Color.MAGENTA);
        peptidelusterClassKey = new PeptideClusterClassKey();
        peptidelusterClassKey.setcTerm(Boolean.TRUE);
        peptideClasses.add(peptidelusterClassKey);
        clusteringSettings.setColor(peptidelusterClassKey.toString(), Color.CYAN);
        peptidelusterClassKey = new PeptideClusterClassKey();
        peptidelusterClassKey.setNotModified(Boolean.TRUE);
        clusteringSettings.setColor(peptidelusterClassKey.toString(), Color.LIGHT_GRAY);
        peptideClasses.add(peptidelusterClassKey);
        ModificationFactory ptmFactory = ModificationFactory.getInstance();
        ArrayList<Double> ptmMasses = new ArrayList<Double>();
        HashMap<Double, ArrayList<String>> modificationsMap = new HashMap<Double, ArrayList<String>>();
        HashMap<Double, Color> ptmColorMap = new HashMap<Double, Color>();
        for (String ptmName : modificationParameters.getAllNotFixedModifications()) {
            Modification modification = ptmFactory.getModification(ptmName);
            Double ptmMass = modification.getMass();
            ArrayList<String> modifications = (ArrayList<String>)modificationsMap.get(ptmMass);
            if (modifications == null) {
                ptmMasses.add(ptmMass);
                modifications = new ArrayList<String>(2);
                modificationsMap.put(ptmMass, modifications);
                Color ptmColor = new Color(modificationParameters.getColor(ptmName));
                ptmColorMap.put(ptmMass, ptmColor);
            }
            modifications.add(ptmName);
        }
        for (Double ptmMass : ptmMasses) {
            ArrayList ptms = (ArrayList)modificationsMap.get(ptmMass);
            Collections.sort(ptms);
            peptidelusterClassKey = new PeptideClusterClassKey();
            peptidelusterClassKey.setPossiblePtms(ptms);
            peptideClasses.add(peptidelusterClassKey);
            Color color = (Color)ptmColorMap.get(ptmMass);
            clusteringSettings.setColor(peptidelusterClassKey.toString(), color);
        }
        ArrayList<PsmClusterClassKey> psmClasses = new ArrayList<PsmClusterClassKey>(1);
        PsmClusterClassKey psmClusterClassKey = new PsmClusterClassKey();
        psmClasses.add(psmClusterClassKey);
        clusteringSettings.setColor(psmClusterClassKey.toString(), Color.GRAY);
        psmClusterClassKey = new PsmClusterClassKey();
        psmClusterClassKey.setStarred(Boolean.TRUE);
        psmClasses.add(psmClusterClassKey);
        clusteringSettings.setColor(psmClusterClassKey.toString(), Color.yellow);
        TreeSet spectrumFiles = new TreeSet(identification.getSpectrumIdentification().keySet());
        if (spectrumFiles.size() > 1) {
            for (String spectrumFile : spectrumFiles) {
                psmClusterClassKey = new PsmClusterClassKey();
                psmClusterClassKey.setFile(spectrumFile);
                psmClasses.add(psmClusterClassKey);
                clusteringSettings.setColor(psmClusterClassKey.toString(), Color.LIGHT_GRAY);
            }
        }
        clusteringSettings.setProteinClassKeys(proteinClasses);
        clusteringSettings.setPeptideClassKeys(peptideClasses);
        clusteringSettings.setPsmClassKeys(psmClasses);
        clusteringSettings.addProteinClass(defaultClusterClass.toString());
        return clusteringSettings;
    }

    public ReporterSettings getReporterSettings() {
        return this.reporterSettings;
    }

    public ReporterIonQuantification getReporterIonQuantification() {
        return this.reporterIonQuantification;
    }

    public DisplayPreferences getDisplayPreferences() {
        return this.displayPreferences;
    }

    public SpectrumProvider getSpectrumProvider() {
        return this.spectrumProvider;
    }
}

