/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.quantificationdetails;

import com.compomics.util.experiment.normalization.NormalizationFactors;
import java.util.HashMap;

public class ProteinQuantificationDetails {
    private HashMap<String, Double> rawRatios = null;
    private HashMap<String, Double> uniqueRawRatios = null;
    private HashMap<String, Double> sharedRawRatios = null;

    public Double getRatio(String reporterIonName, NormalizationFactors normalizationFactors) {
        if (this.rawRatios == null) {
            return null;
        }
        Double ratio = this.rawRatios.get(reporterIonName);
        if (normalizationFactors.hasProteinNormalisationFactors() && ratio != null && ratio != Double.NaN) {
            ratio = ratio / normalizationFactors.getProteinNormalisationFactor(reporterIonName);
        }
        return ratio;
    }

    public Double getUniqueRatio(String reporterIonName, NormalizationFactors normalizationFactors) {
        if (this.uniqueRawRatios == null) {
            return null;
        }
        Double ratio = this.uniqueRawRatios.get(reporterIonName);
        if (normalizationFactors.hasProteinNormalisationFactors() && ratio != null && ratio != Double.NaN) {
            ratio = ratio / normalizationFactors.getProteinNormalisationFactor(reporterIonName);
        }
        return ratio;
    }

    public Double getSharedRatio(String reporterIonName, NormalizationFactors normalizationFactors) {
        if (this.sharedRawRatios == null) {
            return null;
        }
        Double ratio = this.sharedRawRatios.get(reporterIonName);
        if (normalizationFactors.hasProteinNormalisationFactors() && ratio != null && ratio != Double.NaN) {
            ratio = ratio / normalizationFactors.getProteinNormalisationFactor(reporterIonName);
        }
        return ratio;
    }

    public void setRawRatio(String reporterIonName, double value) {
        if (this.rawRatios == null) {
            this.rawRatios = new HashMap();
        }
        this.rawRatios.put(reporterIonName, value);
    }

    public Double getRawRatio(String reporterIonName) {
        if (this.rawRatios == null) {
            return null;
        }
        return this.rawRatios.get(reporterIonName);
    }

    public void setUniqueRawRatio(String reporterIonName, double value) {
        if (this.uniqueRawRatios == null) {
            this.uniqueRawRatios = new HashMap();
        }
        this.uniqueRawRatios.put(reporterIonName, value);
    }

    public Double getUniqueRawRatio(String reporterIonName) {
        if (this.uniqueRawRatios == null) {
            return null;
        }
        return this.uniqueRawRatios.get(reporterIonName);
    }

    public void setSharedRawRatio(String reporterIonName, double value) {
        if (this.sharedRawRatios == null) {
            this.sharedRawRatios = new HashMap();
        }
        this.sharedRawRatios.put(reporterIonName, value);
    }

    public Double getSharedRawRatio(String reporterIonName) {
        if (this.sharedRawRatios == null) {
            return null;
        }
        return this.sharedRawRatios.get(reporterIonName);
    }
}

