/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.settings;

import com.compomics.util.math.clustering.settings.KMeansClusteringSettings;
import eu.isas.reporter.calculation.clustering.keys.PeptideClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.ProteinClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.PsmClusterClassKey;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class ClusteringSettings
implements Serializable {
    private ArrayList<String> possibleProteinClassesNames;
    private HashMap<String, ProteinClusterClassKey> possibleProteinClassesKeys;
    private ArrayList<String> possiblePeptideClassesNames;
    private HashMap<String, PeptideClusterClassKey> possiblePeptideClassesKeys;
    private ArrayList<String> possiblePsmClassesNames;
    private HashMap<String, PsmClusterClassKey> possiblePsmClassesKeys;
    private ArrayList<String> selectedProteinClasses = new ArrayList();
    private ArrayList<String> selectedPeptideClasses = new ArrayList();
    private ArrayList<String> selectedPsmClasses = new ArrayList();
    private HashMap<String, Color> classesColors = new HashMap();
    private KMeansClusteringSettings kMeansClusteringSettings;

    public ArrayList<String> getSelectedProteinClasses() {
        return this.selectedProteinClasses;
    }

    public void setSelectedProteinClasses(ArrayList<String> selectedProteinClasses) {
        this.selectedProteinClasses = selectedProteinClasses;
    }

    public void addProteinClass(String className) {
        this.selectedProteinClasses.add(className);
    }

    public void clearProteinClasses() {
        this.selectedProteinClasses.clear();
    }

    public ArrayList<String> getSelectedPeptideClasses() {
        return this.selectedPeptideClasses;
    }

    public void setSelectedPeptideClasses(ArrayList<String> selectedPeptideClasses) {
        this.selectedPeptideClasses = selectedPeptideClasses;
    }

    public void addPeptideClass(String className) {
        this.selectedPeptideClasses.add(className);
    }

    public void clearPeptideClasses() {
        this.selectedPeptideClasses.clear();
    }

    public ArrayList<String> getSelectedPsmClasses() {
        return this.selectedPsmClasses;
    }

    public void setSelectedPsmClasses(ArrayList<String> selectedPsmClasses) {
        this.selectedPsmClasses = selectedPsmClasses;
    }

    public void addPsmClass(String className) {
        this.selectedPsmClasses.add(className);
    }

    public void clearPsmClasses() {
        this.selectedPsmClasses.clear();
    }

    public Color getColor(String clusterClass) {
        Color result = this.classesColors.get(clusterClass);
        if (result == null) {
            result = Color.GRAY;
            this.classesColors.put(clusterClass, result);
        }
        return result;
    }

    public Color getNonSelectedColor(String clusterClass) {
        Color refColor = this.getColor(clusterClass);
        refColor = refColor.brighter();
        Color unselectedColor = new Color(refColor.getRed(), refColor.getGreen(), refColor.getBlue(), refColor.getAlpha() / 10);
        return unselectedColor;
    }

    public void setColor(String clusterClass, Color color) {
        this.classesColors.put(clusterClass, color);
    }

    public KMeansClusteringSettings getKMeansClusteringSettings() {
        return this.kMeansClusteringSettings;
    }

    public void setKMeansClusteringSettings(KMeansClusteringSettings kMeansClusteringSettings) {
        this.kMeansClusteringSettings = kMeansClusteringSettings;
    }

    public ArrayList<String> getPossibleProteinClasses() {
        return this.possibleProteinClassesNames;
    }

    public ProteinClusterClassKey getProteinClassKey(String name) {
        if (this.possibleProteinClassesKeys == null) {
            return null;
        }
        return this.possibleProteinClassesKeys.get(name);
    }

    public void setProteinClassKeys(ArrayList<ProteinClusterClassKey> clusterClassKeys) {
        this.possibleProteinClassesNames = new ArrayList(clusterClassKeys.size());
        this.possibleProteinClassesKeys = new HashMap(clusterClassKeys.size());
        for (ProteinClusterClassKey clusterClassKey : clusterClassKeys) {
            String key = clusterClassKey.toString();
            this.possibleProteinClassesNames.add(key);
            this.possibleProteinClassesKeys.put(key, clusterClassKey);
        }
    }

    public HashMap<String, ProteinClusterClassKey> getProteinKeysMap() {
        return this.possibleProteinClassesKeys;
    }

    public ArrayList<String> getPossiblePeptideClasses() {
        return this.possiblePeptideClassesNames;
    }

    public PeptideClusterClassKey getPeptideClassKey(String name) {
        if (this.possiblePeptideClassesKeys == null) {
            return null;
        }
        return this.possiblePeptideClassesKeys.get(name);
    }

    public void setPeptideClassKeys(ArrayList<PeptideClusterClassKey> clusterClassKeys) {
        this.possiblePeptideClassesNames = new ArrayList(clusterClassKeys.size());
        this.possiblePeptideClassesKeys = new HashMap(clusterClassKeys.size());
        for (PeptideClusterClassKey clusterClassKey : clusterClassKeys) {
            String key = clusterClassKey.toString();
            this.possiblePeptideClassesNames.add(key);
            this.possiblePeptideClassesKeys.put(key, clusterClassKey);
        }
    }

    public HashMap<String, PeptideClusterClassKey> getPeptideKeysMap() {
        return this.possiblePeptideClassesKeys;
    }

    public ArrayList<String> getPossiblePsmClasses() {
        return this.possiblePsmClassesNames;
    }

    public PsmClusterClassKey getPsmClassKey(String name) {
        if (this.possiblePsmClassesKeys == null) {
            return null;
        }
        return this.possiblePsmClassesKeys.get(name);
    }

    public void setPsmClassKeys(ArrayList<PsmClusterClassKey> clusterClassKeys) {
        this.possiblePsmClassesNames = new ArrayList(clusterClassKeys.size());
        this.possiblePsmClassesKeys = new HashMap(clusterClassKeys.size());
        for (PsmClusterClassKey clusterClassKey : clusterClassKeys) {
            String key = clusterClassKey.toString();
            this.possiblePsmClassesNames.add(key);
            this.possiblePsmClassesKeys.put(key, clusterClassKey);
        }
    }

    public HashMap<String, PsmClusterClassKey> getPsmKeysMap() {
        return this.possiblePsmClassesKeys;
    }

    public HashMap<String, Color> getClassesColors() {
        return this.classesColors;
    }

    public void setClassesColors(HashMap<String, Color> classesColors) {
        this.classesColors = classesColors;
    }
}

