/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.settings;

import eu.isas.reporter.settings.ReporterIonsLocationType;
import java.io.Serializable;

public class ReporterIonSelectionSettings
implements Serializable {
    private ReporterIonsLocationType reporterIonsLocation = ReporterIonsLocationType.ms2Spectra;
    private double reporterIonsMzTolerance = 0.0016;
    private boolean mostAccurate = true;
    private double precursorMzTolerance = 1.0;
    private boolean precursorMzPpm;
    private double precursorRTTolerance = 10.0;

    public ReporterIonSelectionSettings clone() {
        ReporterIonSelectionSettings clone = new ReporterIonSelectionSettings();
        clone.setReporterIonsMzTolerance(this.reporterIonsMzTolerance);
        clone.setMostAccurate(this.mostAccurate);
        clone.setReporterIonsLocation(this.reporterIonsLocation);
        clone.setPrecursorMzTolerance(this.precursorMzTolerance);
        clone.setPrecursorMzPpm(this.precursorMzPpm);
        clone.setPrecursorRTTolerance(this.precursorRTTolerance);
        return clone;
    }

    public boolean isSameAs(ReporterIonSelectionSettings anotherSetting) {
        return this.reporterIonsMzTolerance == anotherSetting.getPrecursorMzTolerance() && this.mostAccurate == anotherSetting.isMostAccurate() && this.reporterIonsLocation == anotherSetting.getReporterIonsLocation() && this.precursorMzTolerance == anotherSetting.getPrecursorMzTolerance() && this.precursorMzPpm == anotherSetting.isPrecursorMzPpm() && this.precursorRTTolerance == anotherSetting.getPrecursorRTTolerance();
    }

    public double getReporterIonsMzTolerance() {
        return this.reporterIonsMzTolerance;
    }

    public void setReporterIonsMzTolerance(double ReporterIonsMzTolerance) {
        this.reporterIonsMzTolerance = ReporterIonsMzTolerance;
    }

    public boolean isMostAccurate() {
        return this.mostAccurate;
    }

    public void setMostAccurate(boolean mostAccurate) {
        this.mostAccurate = mostAccurate;
    }

    public double getPrecursorMzTolerance() {
        return this.precursorMzTolerance;
    }

    public void setPrecursorMzTolerance(double precursorMzTolerance) {
        this.precursorMzTolerance = precursorMzTolerance;
    }

    public double getPrecursorRTTolerance() {
        return this.precursorRTTolerance;
    }

    public void setPrecursorRTTolerance(double precursorRTTolerance) {
        this.precursorRTTolerance = precursorRTTolerance;
    }

    public ReporterIonsLocationType getReporterIonsLocation() {
        return this.reporterIonsLocation;
    }

    public void setReporterIonsLocation(ReporterIonsLocationType reporterIonsLocation) {
        this.reporterIonsLocation = reporterIonsLocation;
    }

    public boolean isPrecursorMzPpm() {
        return this.precursorMzPpm;
    }

    public void setPrecursorMzPpm(boolean precursorMzPpm) {
        this.precursorMzPpm = precursorMzPpm;
    }
}

