/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.settings;

public enum ReporterIonsLocationType {
    ms2Spectra(0, "MS2 Spectra"),
    ms3Spectra(1, "MS3 Spectra"),
    precursorMatching(2, "Precursor Matching");

    public final int index;
    public final String name;

    private ReporterIonsLocationType(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public static ReporterIonsLocationType getReporterIonsLocationType(int index) {
        for (ReporterIonsLocationType reporterIonsLocationType : ReporterIonsLocationType.values()) {
            if (reporterIonsLocationType.index != index) continue;
            return reporterIonsLocationType;
        }
        throw new IllegalArgumentException("No reporter ions location type found for index " + index + ".");
    }

    public static ReporterIonsLocationType getReporterIonsLocationType(String name) {
        for (ReporterIonsLocationType reporterIonsLocationType : ReporterIonsLocationType.values()) {
            if (!reporterIonsLocationType.name.equals(name)) continue;
            return reporterIonsLocationType;
        }
        throw new IllegalArgumentException("No reporter ions location type found for name " + name + ".");
    }

    public static String getCommandLineDescription() {
        StringBuilder sb = new StringBuilder();
        for (ReporterIonsLocationType reporterIonsLocationType : ReporterIonsLocationType.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(reporterIonsLocationType.index).append(": ").append(reporterIonsLocationType.name);
        }
        return sb.toString();
    }
}

