/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.settings;

import com.compomics.util.io.file.SerializationUtils;
import eu.isas.reporter.settings.ReporterSettings;
import java.io.File;
import java.io.Serializable;

public class ReporterPreferences
implements Serializable {
    private static String USER_PREFERENCES_FILE = System.getProperty("user.home") + "/.reporter/reporter_user_preferences.cup";
    private ReporterSettings defaultSettings = null;

    private ReporterPreferences() {
    }

    public ReporterPreferences clone() throws CloneNotSupportedException {
        ReporterPreferences clone = new ReporterPreferences();
        clone.setDefaultSettings(this.defaultSettings.clone());
        return clone;
    }

    public boolean isSameAs(ReporterPreferences anotherSetting) {
        return this.defaultSettings.isSameAs(anotherSetting.getDefaultSettings());
    }

    public ReporterSettings getDefaultSettings() {
        if (this.defaultSettings == null) {
            this.defaultSettings = new ReporterSettings();
        }
        return this.defaultSettings;
    }

    public void setDefaultSettings(ReporterSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    public static void saveUserPreferences(ReporterPreferences userPreferences) {
        try {
            File file = new File(USER_PREFERENCES_FILE);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            SerializationUtils.writeObject((Object)userPreferences, (File)file);
        }
        catch (Exception e) {
            System.err.println("An error occurred while saving " + USER_PREFERENCES_FILE + ".");
            e.printStackTrace();
        }
    }

    public static ReporterPreferences getUserPreferences() {
        ReporterPreferences userPreferences;
        File file = new File(USER_PREFERENCES_FILE);
        if (!file.exists()) {
            userPreferences = new ReporterPreferences();
            ReporterPreferences.saveUserPreferences(userPreferences);
        } else {
            try {
                userPreferences = (ReporterPreferences)SerializationUtils.readObject((File)file);
            }
            catch (Exception e) {
                System.err.println("An error occurred while loading " + USER_PREFERENCES_FILE + ". Preferences set back to default.");
                e.printStackTrace();
                userPreferences = new ReporterPreferences();
                ReporterPreferences.saveUserPreferences(userPreferences);
            }
        }
        return userPreferences;
    }

    public static String getUserPreferencesFile() {
        return USER_PREFERENCES_FILE;
    }

    public static String getUserPreferencesFolder() {
        File tempFile = new File(ReporterPreferences.getUserPreferencesFile());
        return tempFile.getParent();
    }

    public static void setUserPreferencesFolder(String userPreferencesFile) {
        USER_PREFERENCES_FILE = userPreferencesFile + "/reporter_user_preferences.cup";
    }
}

