/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.utils;

import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.statistics.Distribution;
import com.compomics.util.math.statistics.distributions.NonSymmetricalNormalDistribution;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.math.util.FastMath;

public class ReporterMerger {
    private static final String SEPARATOR = "\t";

    public static void main(String[] args) {
        ReporterMerger rm = new ReporterMerger();
        try {
            rm.testReporterGrouping();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testReporterGrouping() throws FileNotFoundException, IOException {
        try {
            void var56_198;
            void var56_196;
            void var56_194;
            void var56_192;
            void var56_190;
            void var56_188;
            void var56_186;
            void var56_184;
            void var56_182;
            void var56_180;
            void var56_178;
            void var56_176;
            int i;
            void var56_174;
            ArrayList<Double> controlIntensities;
            int i2;
            String path = "C:\\Users\\hba041\\Desktop\\heidrun\\reporter_test\\new_tmt_masses_2";
            int nFiles = 3;
            int nProteins = 20000;
            int nRatios = 6;
            int ratioIndex = 15;
            String[] orderedExperiments = new String[]{"Mix 1", "Mix 2", "Mix 3"};
            HashMap<String, String> fileMap = new HashMap<String, String>(nFiles);
            fileMap.put(orderedExperiments[0], "Mix1.txt");
            fileMap.put(orderedExperiments[1], "Mix2.txt");
            fileMap.put(orderedExperiments[2], "Mix3.txt");
            HashMap ratios = new HashMap(nFiles);
            HashMap<String, String> keyToMainMatchMap = new HashMap<String, String>(nProteins);
            HashMap<String, String> keyToOtherMatchesMap = new HashMap<String, String>(nProteins);
            HashMap<String, String> groupClassMap = new HashMap<String, String>(nProteins);
            HashMap<String, String> mwMap = new HashMap<String, String>(nProteins);
            HashMap<String, String> descriptionMap = new HashMap<String, String>(nProteins);
            HashMap<String, Integer> decoyMap = new HashMap<String, Integer>(nProteins);
            HashMap proteinKeysMap = new HashMap(nFiles);
            HashMap peptidesMap = new HashMap(nFiles);
            HashMap spectraMap = new HashMap(nFiles);
            HashMap validatedPeptidesMap = new HashMap(nFiles);
            HashMap validatedSpectraMap = new HashMap(nFiles);
            HashMap pepMap = new HashMap(nFiles);
            HashMap scoreMap = new HashMap(nFiles);
            HashMap validatedMap = new HashMap(nFiles);
            HashMap ratiosMap = new HashMap(nFiles);
            HashMap ratiosMapNormalized = new HashMap(nFiles);
            for (String experiment : orderedExperiments) {
                ratios.put(experiment, new ArrayList(nRatios));
                proteinKeysMap.put(experiment, new ArrayList(nProteins));
                peptidesMap.put(experiment, new HashMap(nProteins));
                spectraMap.put(experiment, new HashMap(nProteins));
                validatedPeptidesMap.put(experiment, new HashMap(nProteins));
                validatedSpectraMap.put(experiment, new HashMap(nProteins));
                pepMap.put(experiment, new HashMap(nProteins));
                scoreMap.put(experiment, new HashMap(nProteins));
                validatedMap.put(experiment, new HashMap(nProteins));
                ratiosMap.put(experiment, new HashMap(nProteins));
                ratiosMapNormalized.put(experiment, new HashMap(nProteins));
                String fileName = (String)fileMap.get(experiment);
                File myFile = new File(path, fileName);
                BufferedReader br = new BufferedReader(new FileReader(myFile));
                Object line = br.readLine();
                String[] split = ((String)line).split(SEPARATOR);
                for (int i3 = ratioIndex; i3 < split.length; ++i3) {
                    String value = split[i3];
                    ((ArrayList)ratios.get(experiment)).add(value);
                    ((HashMap)ratiosMap.get(experiment)).put(value, new HashMap());
                    ((HashMap)ratiosMapNormalized.get(experiment)).put(value, new HashMap());
                }
                while ((line = br.readLine()) != null && !((String)line).equals("")) {
                    split = ((String)line).split(SEPARATOR);
                    String completeProteinGroup = split[2];
                    Integer numberOfValidatedPeptides = Integer.valueOf(split[6]);
                    Integer numberOfValidatedSpectra = Integer.valueOf(split[7]);
                    Integer decoyIntegerValue = Integer.valueOf(split[12]);
                    decoyMap.put(completeProteinGroup, decoyIntegerValue);
                    keyToMainMatchMap.put(completeProteinGroup, split[0]);
                    keyToOtherMatchesMap.put(completeProteinGroup, split[1]);
                    groupClassMap.put(completeProteinGroup, split[3]);
                    mwMap.put(completeProteinGroup, split[8]);
                    descriptionMap.put(completeProteinGroup, split[14]);
                    Integer numberOfPeptides = Integer.valueOf(split[4]);
                    ((HashMap)peptidesMap.get(experiment)).put(completeProteinGroup, numberOfPeptides);
                    Integer numberOfSpectra = Integer.valueOf(split[5]);
                    ((HashMap)spectraMap.get(experiment)).put(completeProteinGroup, numberOfSpectra);
                    ((HashMap)validatedPeptidesMap.get(experiment)).put(completeProteinGroup, numberOfValidatedPeptides);
                    ((HashMap)validatedSpectraMap.get(experiment)).put(completeProteinGroup, numberOfValidatedSpectra);
                    Double pScore = Double.valueOf(split[10]);
                    ((HashMap)scoreMap.get(experiment)).put(completeProteinGroup, pScore);
                    Double p = Double.valueOf(split[11]);
                    ((HashMap)pepMap.get(experiment)).put(completeProteinGroup, p);
                    String validatedStatus = split[13];
                    ((HashMap)validatedMap.get(experiment)).put(completeProteinGroup, validatedStatus);
                    for (int i4 = ratioIndex; i4 < split.length; ++i4) {
                        int index = i4 - ratioIndex;
                        String ratioTitle = (String)((ArrayList)ratios.get(experiment)).get(index);
                        Double ratioValue = Double.valueOf(split[i4]);
                        ((HashMap)((HashMap)ratiosMap.get(experiment)).get(ratioTitle)).put(completeProteinGroup, ratioValue);
                    }
                }
                br.close();
            }
            int nKeys = keyToMainMatchMap.size();
            HashMap<String, Double> keyToScoreMap = new HashMap<String, Double>(nKeys);
            HashMap<Double, Integer> nDecoy = new HashMap<Double, Integer>();
            HashMap<Double, Integer> nTarget = new HashMap<Double, Integer>();
            for (String key : keyToMainMatchMap.keySet()) {
                double score = 1.0;
                for (String experiment : pepMap.keySet()) {
                    Double pep = (Double)((HashMap)pepMap.get(experiment)).get(key);
                    if (pep == null) continue;
                    score *= pep.doubleValue();
                }
                keyToScoreMap.put(key, score);
                if (!nDecoy.containsKey(score)) {
                    nDecoy.put(score, 0);
                    nTarget.put(score, 0);
                }
                if ((Integer)decoyMap.get(key) == 1) {
                    nDecoy.put(score, (Integer)nDecoy.get(score) + 1);
                    continue;
                }
                nTarget.put(score, (Integer)nTarget.get(score) + 1);
            }
            ArrayList scores = new ArrayList(nDecoy.keySet());
            Collections.sort(scores);
            int nMax = 0;
            int cpt = -1;
            for (Double score : scores) {
                if ((Integer)nDecoy.get(score) > 0) {
                    if (cpt > nMax) {
                        nMax = cpt;
                    }
                    if (cpt == -1) {
                        cpt = 0;
                    }
                }
                if (cpt == -1) continue;
                cpt += ((Integer)nTarget.get(score)).intValue();
            }
            HashMap<Double, Double> peps = new HashMap<Double, Double>();
            HashMap<Double, Double> fdr = new HashMap<Double, Double>();
            double totalDecoy = 0.0;
            double lastValidatedScore = 0.0;
            int nValidated = 0;
            int totalTarget = 0;
            for (int i5 = 0; i5 < scores.size(); ++i5) {
                double tempScore;
                double score = (Double)scores.get(i5);
                double nt = ((Integer)nTarget.get(score)).intValue();
                double nd = ((Integer)nDecoy.get(score)).intValue();
                int j = i5;
                double limit = ((double)nMax - nt) / 2.0;
                while (--j >= 0 && nt < limit) {
                    tempScore = (Double)scores.get(j);
                    nt += (double)((Integer)nTarget.get(tempScore)).intValue();
                    nd += (double)((Integer)nDecoy.get(tempScore)).intValue();
                }
                j = i5;
                while (++j < scores.size() && nt < limit) {
                    tempScore = (Double)scores.get(j);
                    nt += (double)((Integer)nTarget.get(tempScore)).intValue();
                    nd += (double)((Integer)nDecoy.get(tempScore)).intValue();
                }
                double pep = nd / nt;
                peps.put(score, pep);
                totalTarget = (int)((double)totalTarget + nt);
                double tempFdr = (totalDecoy += nd) / (double)totalTarget;
                if (tempFdr <= 0.01) {
                    lastValidatedScore = score;
                    nValidated = totalTarget;
                }
                fdr.put(score, tempFdr);
            }
            System.out.println("Score threshold: " + lastValidatedScore + ", # validated: " + nValidated);
            File outputFile = new File(path, "quanification_raw_results.txt");
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write("Protein\tDescription\tMW\tOther Protein(s) (alphabetical order)\tComplete Protein Group (alphabetical order)\tGroup Class\t#Peptides");
            for (int i22 = 0; i22 < nFiles; ++i22) {
                writer.write(SEPARATOR);
            }
            writer.write("#Spectra");
            for (i2 = 0; i2 < nFiles; ++i2) {
                writer.write(SEPARATOR);
            }
            writer.write("#Validated Peptides");
            for (i2 = 0; i2 < nFiles; ++i2) {
                writer.write(SEPARATOR);
            }
            writer.write("#Validated Spectra");
            for (i2 = 0; i2 < nFiles; ++i2) {
                writer.write(SEPARATOR);
            }
            writer.write("Confidence");
            for (i2 = 0; i2 < nFiles; ++i2) {
                writer.write(SEPARATOR);
            }
            writer.write("Validated in mix");
            for (i2 = 0; i2 < nFiles; ++i2) {
                writer.write(SEPARATOR);
            }
            writer.write("score\tOverall Confidence\tdecoy\tFDR\tValidated\t");
            for (String experiment : orderedExperiments) {
                writer.write(experiment + " ratios");
                for (int i6 = 0; i6 < nRatios; ++i6) {
                    writer.write(SEPARATOR);
                }
            }
            writer.newLine();
            writer.write("\t\t\t\t\t\t");
            for (String experiment : orderedExperiments) {
                writer.write(experiment + SEPARATOR);
            }
            for (String experiment : orderedExperiments) {
                writer.write(experiment + SEPARATOR);
            }
            for (String experiment : orderedExperiments) {
                writer.write(experiment + SEPARATOR);
            }
            for (String experiment : orderedExperiments) {
                writer.write(experiment + SEPARATOR);
            }
            for (String experiment : orderedExperiments) {
                writer.write(experiment + SEPARATOR);
            }
            for (String experiment : orderedExperiments) {
                writer.write(experiment + SEPARATOR);
            }
            writer.write("\t\t\t\t\t");
            for (String experiment : orderedExperiments) {
                for (String ratioName : (ArrayList)ratios.get(experiment)) {
                    writer.write(ratioName + SEPARATOR);
                }
            }
            writer.newLine();
            for (String key : keyToMainMatchMap.keySet()) {
                Object value;
                writer.write((String)keyToMainMatchMap.get(key) + SEPARATOR);
                writer.write((String)descriptionMap.get(key) + SEPARATOR);
                writer.write((String)mwMap.get(key) + SEPARATOR);
                writer.write((String)keyToOtherMatchesMap.get(key) + SEPARATOR);
                writer.write(key + SEPARATOR);
                writer.write((String)groupClassMap.get(key) + SEPARATOR);
                for (String experiment : orderedExperiments) {
                    value = ((HashMap)peptidesMap.get(experiment)).get(key);
                    if (value != null) {
                        writer.write(value.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    value = ((HashMap)spectraMap.get(experiment)).get(key);
                    if (value != null) {
                        writer.write(value.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    value = ((HashMap)validatedPeptidesMap.get(experiment)).get(key);
                    if (value != null) {
                        writer.write(value.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    value = ((HashMap)validatedSpectraMap.get(experiment)).get(key);
                    if (value != null) {
                        writer.write(value.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    value = (Double)((HashMap)pepMap.get(experiment)).get(key);
                    if (value != null) {
                        value = 1.0 - (Double)value;
                        writer.write(((Double)value).toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    value = (String)((HashMap)validatedMap.get(experiment)).get(key);
                    if (value != null) {
                        writer.write((String)value);
                    }
                    writer.write(SEPARATOR);
                }
                double score = (Double)keyToScoreMap.get(key);
                writer.write(score + SEPARATOR);
                double pep = (Double)peps.get(score);
                double confidence = 1.0 - pep;
                writer.write(confidence + SEPARATOR);
                writer.write(decoyMap.get(key) + SEPARATOR);
                writer.write(fdr.get(score) + SEPARATOR);
                if (score <= lastValidatedScore) {
                    writer.write("1\t");
                } else {
                    writer.write("0\t");
                }
                for (String experiment : orderedExperiments) {
                    for (String ratio : (ArrayList)ratios.get(experiment)) {
                        Double d = (Double)((HashMap)((HashMap)ratiosMap.get(experiment)).get(ratio)).get(key);
                        if (d != null && !d.isNaN()) {
                            writer.write(d.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                }
                writer.newLine();
            }
            writer.close();
            String[] pathwayFiles = new String[]{"jak-stat", "stem cell maintenance"};
            HashMap pathways = new HashMap(nFiles);
            for (String pathway : pathwayFiles) {
                ArrayList<String> accessions = new ArrayList<String>();
                File pathwayFile = new File(path, pathway + ".txt");
                BufferedReader reader = new BufferedReader(new FileReader(pathwayFile));
                String line = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    String[] content = line.split(SEPARATOR);
                    accessions.add(content[1]);
                }
                pathways.put(pathway, accessions);
                reader.close();
            }
            ArrayList<String> quantificationMatches = new ArrayList<String>();
            HashMap validatedRatios = new HashMap();
            HashMap pathwaysRatios = new HashMap();
            for (String key : keyToMainMatchMap.keySet()) {
                int decoy = (Integer)decoyMap.get(key);
                if (decoy != 0) continue;
                double score = (Double)keyToScoreMap.get(key);
                if (score < lastValidatedScore) {
                    for (String experiment : orderedExperiments) {
                        HashMap<String, ArrayList<Double>> tempRatiosMap;
                        Integer n = (Integer)((HashMap)validatedPeptidesMap.get(experiment)).get(key);
                        if (n == null || n <= 1) continue;
                        if (!quantificationMatches.contains(key)) {
                            quantificationMatches.add(key);
                        }
                        if ((tempRatiosMap = (HashMap<String, ArrayList<Double>>)validatedRatios.get(experiment)) == null) {
                            tempRatiosMap = new HashMap<String, ArrayList<Double>>();
                            validatedRatios.put(experiment, tempRatiosMap);
                        }
                        for (String ratio : (ArrayList)ratios.get(experiment)) {
                            Double value = (Double)((HashMap)((HashMap)ratiosMap.get(experiment)).get(ratio)).get(key);
                            if (value == null || value.isNaN()) continue;
                            ArrayList<Double> tempRatios = (ArrayList<Double>)tempRatiosMap.get(ratio);
                            if (tempRatios == null) {
                                tempRatios = new ArrayList<Double>();
                                tempRatiosMap.put(ratio, tempRatios);
                            }
                            tempRatios.add(value);
                        }
                    }
                }
                throw new IOException("ProteinMatch.getAccessions(key) not yet remplemented!");
            }
            outputFile = new File(path, "medians.txt");
            writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write(SEPARATOR);
            for (String experiment : orderedExperiments) {
                writer.write(experiment);
                for (String ratio : (ArrayList)ratios.get(experiment)) {
                    writer.write(SEPARATOR);
                }
            }
            writer.newLine();
            writer.write(SEPARATOR);
            for (String experiment : orderedExperiments) {
                for (String ratio : (ArrayList)ratios.get(experiment)) {
                    writer.write(ratio + SEPARATOR);
                }
            }
            writer.newLine();
            writer.write("Median\t");
            HashMap medianes = new HashMap();
            for (String experiment : orderedExperiments) {
                medianes.put(experiment, new HashMap());
                for (String ratio : (ArrayList)ratios.get(experiment)) {
                    double median = BasicMathFunctions.median((ArrayList)((ArrayList)((HashMap)validatedRatios.get(experiment)).get(ratio)));
                    writer.write(median + SEPARATOR);
                    ((HashMap)medianes.get(experiment)).put(ratio, median);
                }
            }
            writer.close();
            HashMap medianNormalizedValidatedRatiosMap = new HashMap(nFiles);
            for (String key : quantificationMatches) {
                HashMap proteinRatios = new HashMap();
                medianNormalizedValidatedRatiosMap.put(key, proteinRatios);
                for (String experiment : orderedExperiments) {
                    HashMap<Object, Double> hashMap = new HashMap<Object, Double>();
                    proteinRatios.put(experiment, hashMap);
                    for (Object ratio : (ArrayList)ratios.get(experiment)) {
                        Double value = (Double)((HashMap)((HashMap)ratiosMap.get(experiment)).get(ratio)).get(key);
                        if (value == null || value.isNaN()) continue;
                        double median = (Double)((HashMap)medianes.get(experiment)).get(ratio);
                        double normalizedValue = value / median;
                        hashMap.put(ratio, normalizedValue);
                    }
                }
            }
            HashMap normalizedValidatedRatiosMap = new HashMap(nFiles);
            for (String key : quantificationMatches) {
                HashMap proteinRatios = new HashMap();
                normalizedValidatedRatiosMap.put(key, proteinRatios);
                for (String string : orderedExperiments) {
                    controlIntensities = new ArrayList<Double>();
                    for (String ratio : (ArrayList)ratios.get(string)) {
                        Double value;
                        if (!ratio.contains("126") && !ratio.contains("127") || (value = (Double)((HashMap)((HashMap)medianNormalizedValidatedRatiosMap.get(key)).get(string)).get(ratio)) == null || value.isNaN()) continue;
                        controlIntensities.add(value);
                    }
                    HashMap<String, Double> experimentRatios = new HashMap<String, Double>();
                    proteinRatios.put(string, experimentRatios);
                    if (controlIntensities.isEmpty()) continue;
                    double normalizationValue = BasicMathFunctions.median(controlIntensities);
                    for (String ratio : (ArrayList)ratios.get(string)) {
                        Double value = (Double)((HashMap)((HashMap)medianNormalizedValidatedRatiosMap.get(key)).get(string)).get(ratio);
                        if (value == null || value.isNaN()) continue;
                        double normalizedValue = value / normalizationValue;
                        experimentRatios.put(ratio, normalizedValue);
                    }
                }
            }
            HashMap normalizedPathwaysRatiosMap = new HashMap(nFiles);
            for (String pathway : pathwaysRatios.keySet()) {
                for (String key : ((HashMap)pathwaysRatios.get(pathway)).keySet()) {
                    for (String string : ((HashMap)((HashMap)pathwaysRatios.get(pathway)).get(key)).keySet()) {
                        HashMap<String, Double> experimentRatios;
                        HashMap proteinRatios;
                        double normalizationIntensity;
                        controlIntensities = new ArrayList();
                        HashMap<String, Double> allIntensities = new HashMap<String, Double>();
                        for (String channel : ((HashMap)((HashMap)((HashMap)pathwaysRatios.get(pathway)).get(key)).get(string)).keySet()) {
                            Double value = (Double)((HashMap)((HashMap)((HashMap)pathwaysRatios.get(pathway)).get(key)).get(string)).get(channel);
                            if (value == null || value.isNaN()) continue;
                            double median = (Double)((HashMap)medianes.get(string)).get(channel);
                            value = value / median;
                            if (channel.contains("126") || channel.contains("127")) {
                                controlIntensities.add(value);
                            }
                            allIntensities.put(channel, value);
                        }
                        if (allIntensities.isEmpty()) continue;
                        if (!controlIntensities.isEmpty()) {
                            normalizationIntensity = BasicMathFunctions.median(controlIntensities);
                        } else {
                            ArrayList intensities = new ArrayList(allIntensities.values());
                            normalizationIntensity = BasicMathFunctions.median(intensities);
                        }
                        HashMap pathwayRatios = (HashMap)normalizedPathwaysRatiosMap.get(pathway);
                        if (pathwayRatios == null) {
                            pathwayRatios = new HashMap();
                            normalizedPathwaysRatiosMap.put(pathway, pathwayRatios);
                        }
                        if ((proteinRatios = (HashMap)pathwayRatios.get(key)) == null) {
                            proteinRatios = new HashMap();
                            pathwayRatios.put(key, proteinRatios);
                        }
                        if ((experimentRatios = (HashMap<String, Double>)proteinRatios.get(string)) == null) {
                            experimentRatios = new HashMap<String, Double>();
                            proteinRatios.put(string, experimentRatios);
                        }
                        for (String channel : allIntensities.keySet()) {
                            double value = (Double)allIntensities.get(channel);
                            experimentRatios.put(channel, value /= normalizationIntensity);
                        }
                    }
                }
            }
            HashMap logNormalizedValidatedRatiosMap = new HashMap(nFiles);
            HashMap logNormalizedValidatedRatios = new HashMap();
            for (String key : quantificationMatches) {
                HashMap proteinRatios = new HashMap();
                logNormalizedValidatedRatiosMap.put(key, proteinRatios);
                for (String experiment : orderedExperiments) {
                    HashMap<String, Double> experimentRatios = new HashMap<String, Double>();
                    proteinRatios.put(experiment, experimentRatios);
                    HashMap<String, ArrayList<Double>> experimentRatiosList = (HashMap<String, ArrayList<Double>>)logNormalizedValidatedRatios.get(experiment);
                    if (experimentRatiosList == null) {
                        experimentRatiosList = new HashMap<String, ArrayList<Double>>();
                        logNormalizedValidatedRatios.put(experiment, experimentRatiosList);
                    }
                    for (String ratio : (ArrayList)ratios.get(experiment)) {
                        Double value = (Double)((HashMap)((HashMap)normalizedValidatedRatiosMap.get(key)).get(experiment)).get(ratio);
                        if (value == null || value.isNaN()) continue;
                        double normalizedLogValue = FastMath.log10((double)value);
                        Object tempRatios = (ArrayList<Double>)experimentRatiosList.get(ratio);
                        if (tempRatios == null) {
                            tempRatios = new ArrayList<Double>();
                            experimentRatiosList.put(ratio, (ArrayList<Double>)tempRatios);
                        }
                        ((ArrayList)tempRatios).add(normalizedLogValue);
                        experimentRatios.put(ratio, normalizedLogValue);
                    }
                }
            }
            HashMap distributionsMap = new HashMap();
            String[] key = orderedExperiments;
            int proteinRatios = key.length;
            boolean bl = false;
            while (var56_174 < proteinRatios) {
                String experiment = key[var56_174];
                distributionsMap.put(experiment, new HashMap());
                for (String ratio : (ArrayList)ratios.get(experiment)) {
                    ArrayList input = (ArrayList)((HashMap)logNormalizedValidatedRatios.get(experiment)).get(ratio);
                    ((HashMap)distributionsMap.get(experiment)).put(ratio, NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistribution((ArrayList)input));
                }
                ++var56_174;
            }
            outputFile = new File(path, "quanification_results.txt");
            writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write("Protein\tDescription\tMW\tOther Protein(s) (alphabetical order)\tComplete Protein Group (alphabetical order)\tGroup Class\t#Peptides");
            for (i = 0; i < nFiles; ++i) {
                writer.write(SEPARATOR);
            }
            writer.write("#Spectra");
            for (i = 0; i < nFiles; ++i) {
                writer.write(SEPARATOR);
            }
            writer.write("#Validated Peptides");
            for (i = 0; i < nFiles; ++i) {
                writer.write(SEPARATOR);
            }
            writer.write("#Validated Spectra");
            for (i = 0; i < nFiles; ++i) {
                writer.write(SEPARATOR);
            }
            writer.write("Confidence");
            for (i = 0; i < nFiles; ++i) {
                writer.write(SEPARATOR);
            }
            writer.write("Validated in mix");
            for (i = 0; i < nFiles; ++i) {
                writer.write(SEPARATOR);
            }
            writer.write("score\tOverall Confidence\tValidated\t");
            Object object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl2 = false;
            while (var56_176 < proteinRatios) {
                String experiment = object[var56_176];
                writer.write(experiment + " raw ratios");
                for (int i7 = 0; i7 < nRatios; ++i7) {
                    writer.write(SEPARATOR);
                }
                ++var56_176;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl3 = false;
            while (var56_178 < proteinRatios) {
                String experiment = object[var56_178];
                writer.write(experiment + " normalized ratios");
                for (int i8 = 0; i8 < nRatios; ++i8) {
                    writer.write(SEPARATOR);
                }
                ++var56_178;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl4 = false;
            while (var56_180 < proteinRatios) {
                String experiment = object[var56_180];
                writer.write(experiment + " p");
                for (int i9 = 0; i9 < nRatios; ++i9) {
                    writer.write(SEPARATOR);
                }
                ++var56_180;
            }
            writer.newLine();
            writer.write("\t\t\t\t\t\t");
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl5 = false;
            while (var56_182 < proteinRatios) {
                String experiment = object[var56_182];
                writer.write(experiment + SEPARATOR);
                ++var56_182;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl6 = false;
            while (var56_184 < proteinRatios) {
                String experiment = object[var56_184];
                writer.write(experiment + SEPARATOR);
                ++var56_184;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl7 = false;
            while (var56_186 < proteinRatios) {
                String experiment = object[var56_186];
                writer.write(experiment + SEPARATOR);
                ++var56_186;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl8 = false;
            while (var56_188 < proteinRatios) {
                String experiment = object[var56_188];
                writer.write(experiment + SEPARATOR);
                ++var56_188;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl9 = false;
            while (var56_190 < proteinRatios) {
                String experiment = object[var56_190];
                writer.write(experiment + SEPARATOR);
                ++var56_190;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl10 = false;
            while (var56_192 < proteinRatios) {
                String experiment = object[var56_192];
                writer.write(experiment + SEPARATOR);
                ++var56_192;
            }
            writer.write("\t\t\t");
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl11 = false;
            while (var56_194 < proteinRatios) {
                String experiment = object[var56_194];
                for (String ratioName : (ArrayList)ratios.get(experiment)) {
                    writer.write(ratioName + SEPARATOR);
                }
                ++var56_194;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl12 = false;
            while (var56_196 < proteinRatios) {
                String experiment = object[var56_196];
                for (String ratioName : (ArrayList)ratios.get(experiment)) {
                    writer.write(ratioName + SEPARATOR);
                }
                ++var56_196;
            }
            object = orderedExperiments;
            proteinRatios = ((String[])object).length;
            boolean bl13 = false;
            while (var56_198 < proteinRatios) {
                String experiment = object[var56_198];
                for (String ratioName : (ArrayList)ratios.get(experiment)) {
                    writer.write(ratioName + SEPARATOR);
                }
                ++var56_198;
            }
            writer.newLine();
            for (String key2 : quantificationMatches) {
                Double value;
                Integer nValidatedPeptides;
                writer.write((String)keyToMainMatchMap.get(key2) + SEPARATOR);
                writer.write((String)descriptionMap.get(key2) + SEPARATOR);
                writer.write((String)mwMap.get(key2) + SEPARATOR);
                writer.write((String)keyToOtherMatchesMap.get(key2) + SEPARATOR);
                writer.write(key2 + SEPARATOR);
                writer.write((String)groupClassMap.get(key2) + SEPARATOR);
                for (String experiment : orderedExperiments) {
                    Object value3 = ((HashMap)peptidesMap.get(experiment)).get(key2);
                    if (value3 != null) {
                        writer.write(value3.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    Object value4 = ((HashMap)spectraMap.get(experiment)).get(key2);
                    if (value4 != null) {
                        writer.write(value4.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    Object value5 = ((HashMap)validatedPeptidesMap.get(experiment)).get(key2);
                    if (value5 != null) {
                        writer.write(value5.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    Object value6 = ((HashMap)validatedSpectraMap.get(experiment)).get(key2);
                    if (value6 != null) {
                        writer.write(value6.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    Double value7 = (Double)((HashMap)pepMap.get(experiment)).get(key2);
                    if (value7 != null) {
                        value7 = 1.0 - value7;
                        writer.write(value7.toString());
                    }
                    writer.write(SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    String value8 = (String)((HashMap)validatedMap.get(experiment)).get(key2);
                    if (value8 != null) {
                        writer.write(value8);
                    }
                    writer.write(SEPARATOR);
                }
                double d = (Double)keyToScoreMap.get(key2);
                writer.write(d + SEPARATOR);
                double pep = (Double)peps.get(d);
                double confidence = 1.0 - pep;
                writer.write(confidence + SEPARATOR);
                if (d <= lastValidatedScore) {
                    writer.write("1\t");
                } else {
                    writer.write("0\t");
                }
                for (String experiment : orderedExperiments) {
                    nValidatedPeptides = (Integer)((HashMap)validatedPeptidesMap.get(experiment)).get(key2);
                    for (String ratio : (ArrayList)ratios.get(experiment)) {
                        if (nValidatedPeptides != null && nValidatedPeptides > 1 && (value = (Double)((HashMap)((HashMap)ratiosMap.get(experiment)).get(ratio)).get(key2)) != null && !value.isNaN()) {
                            writer.write(value.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                }
                for (String experiment : orderedExperiments) {
                    nValidatedPeptides = (Integer)((HashMap)validatedPeptidesMap.get(experiment)).get(key2);
                    for (String ratio : (ArrayList)ratios.get(experiment)) {
                        if (nValidatedPeptides != null && nValidatedPeptides > 1 && (value = (Double)((HashMap)((HashMap)normalizedValidatedRatiosMap.get(key2)).get(experiment)).get(ratio)) != null && !value.isNaN()) {
                            writer.write(value.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                }
                for (String experiment : orderedExperiments) {
                    nValidatedPeptides = (Integer)((HashMap)validatedPeptidesMap.get(experiment)).get(key2);
                    for (String ratio : (ArrayList)ratios.get(experiment)) {
                        if (nValidatedPeptides == null || nValidatedPeptides <= 1) continue;
                        Double logValue = (Double)((HashMap)((HashMap)logNormalizedValidatedRatiosMap.get(key2)).get(experiment)).get(ratio);
                        if (logValue != null && !logValue.isNaN()) {
                            Distribution distribution = (Distribution)((HashMap)distributionsMap.get(experiment)).get(ratio);
                            Double p = distribution.getProbabilityAt(logValue.doubleValue());
                            writer.write(p.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                }
                writer.newLine();
            }
            writer.close();
            for (String pathway : normalizedPathwaysRatiosMap.keySet()) {
                void var56_217;
                void var56_215;
                void var56_213;
                void var56_211;
                void var56_209;
                void var56_207;
                outputFile = new File(path, pathway + "_quantification.txt");
                writer = new BufferedWriter(new FileWriter(outputFile));
                writer.write("Protein\tDescription\tMW\tOther Protein(s) (alphabetical order)\tComplete Protein Group (alphabetical order)\tGroup Class\t#Peptides");
                boolean bl14 = false;
                while (var56_207 < nFiles) {
                    writer.write(SEPARATOR);
                    ++var56_207;
                }
                writer.write("#Spectra");
                boolean bl15 = false;
                while (var56_209 < nFiles) {
                    writer.write(SEPARATOR);
                    ++var56_209;
                }
                writer.write("#Validated Peptides");
                boolean bl16 = false;
                while (var56_211 < nFiles) {
                    writer.write(SEPARATOR);
                    ++var56_211;
                }
                writer.write("#Validated Spectra");
                boolean bl17 = false;
                while (var56_213 < nFiles) {
                    writer.write(SEPARATOR);
                    ++var56_213;
                }
                writer.write("Confidence");
                boolean bl18 = false;
                while (var56_215 < nFiles) {
                    writer.write(SEPARATOR);
                    ++var56_215;
                }
                writer.write("Validated in mix");
                boolean bl19 = false;
                while (var56_217 < nFiles) {
                    writer.write(SEPARATOR);
                    ++var56_217;
                }
                writer.write("score\tOverall Confidence\tValidated\t");
                for (String experiment : orderedExperiments) {
                    writer.write(experiment + " raw ratios");
                    for (int i11 = 0; i11 < nRatios; ++i11) {
                        writer.write(SEPARATOR);
                    }
                }
                for (String experiment : orderedExperiments) {
                    writer.write(experiment + " normalized ratios");
                    for (int i12 = 0; i12 < nRatios; ++i12) {
                        writer.write(SEPARATOR);
                    }
                }
                writer.newLine();
                writer.write("\t\t\t\t\t\t");
                for (String experiment : orderedExperiments) {
                    writer.write(experiment + SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    writer.write(experiment + SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    writer.write(experiment + SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    writer.write(experiment + SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    writer.write(experiment + SEPARATOR);
                }
                for (String experiment : orderedExperiments) {
                    writer.write(experiment + SEPARATOR);
                }
                writer.write("\t\t\t");
                for (String experiment : orderedExperiments) {
                    for (String ratioName : (ArrayList)ratios.get(experiment)) {
                        writer.write(ratioName + SEPARATOR);
                    }
                }
                for (String experiment : orderedExperiments) {
                    for (String ratioName : (ArrayList)ratios.get(experiment)) {
                        writer.write(ratioName + SEPARATOR);
                    }
                }
                writer.newLine();
                for (String key3 : ((HashMap)normalizedPathwaysRatiosMap.get(pathway)).keySet()) {
                    Double value;
                    writer.write((String)keyToMainMatchMap.get(key3) + SEPARATOR);
                    writer.write((String)descriptionMap.get(key3) + SEPARATOR);
                    writer.write((String)mwMap.get(key3) + SEPARATOR);
                    writer.write((String)keyToOtherMatchesMap.get(key3) + SEPARATOR);
                    writer.write(key3 + SEPARATOR);
                    writer.write((String)groupClassMap.get(key3) + SEPARATOR);
                    for (String experiment : orderedExperiments) {
                        Object value9 = ((HashMap)peptidesMap.get(experiment)).get(key3);
                        if (value9 != null) {
                            writer.write(value9.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                    for (String experiment : orderedExperiments) {
                        Object value10 = ((HashMap)spectraMap.get(experiment)).get(key3);
                        if (value10 != null) {
                            writer.write(value10.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                    for (String experiment : orderedExperiments) {
                        Object value11 = ((HashMap)validatedPeptidesMap.get(experiment)).get(key3);
                        if (value11 != null) {
                            writer.write(value11.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                    for (String experiment : orderedExperiments) {
                        Object value12 = ((HashMap)validatedSpectraMap.get(experiment)).get(key3);
                        if (value12 != null) {
                            writer.write(value12.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                    for (String experiment : orderedExperiments) {
                        Double value13 = (Double)((HashMap)pepMap.get(experiment)).get(key3);
                        if (value13 != null) {
                            value13 = 1.0 - value13;
                            writer.write(value13.toString());
                        }
                        writer.write(SEPARATOR);
                    }
                    for (String experiment : orderedExperiments) {
                        String value14 = (String)((HashMap)validatedMap.get(experiment)).get(key3);
                        if (value14 != null) {
                            writer.write(value14);
                        }
                        writer.write(SEPARATOR);
                    }
                    double score = (Double)keyToScoreMap.get(key3);
                    writer.write(score + SEPARATOR);
                    double pep = (Double)peps.get(score);
                    double confidence = 1.0 - pep;
                    writer.write(confidence + SEPARATOR);
                    if (score <= lastValidatedScore) {
                        writer.write("1\t");
                    } else {
                        writer.write("0\t");
                    }
                    for (String experiment : orderedExperiments) {
                        for (String ratio : (ArrayList)ratios.get(experiment)) {
                            value = (Double)((HashMap)((HashMap)ratiosMap.get(experiment)).get(ratio)).get(key3);
                            if (value != null && !value.isNaN()) {
                                writer.write(value.toString());
                            }
                            writer.write(SEPARATOR);
                        }
                    }
                    for (String experiment : orderedExperiments) {
                        for (String ratio : (ArrayList)ratios.get(experiment)) {
                            if (((HashMap)((HashMap)normalizedPathwaysRatiosMap.get(pathway)).get(key3)).get(experiment) != null && (value = (Double)((HashMap)((HashMap)((HashMap)normalizedPathwaysRatiosMap.get(pathway)).get(key3)).get(experiment)).get(ratio)) != null && !value.isNaN()) {
                                writer.write(value.toString());
                            }
                            writer.write(SEPARATOR);
                        }
                    }
                    writer.newLine();
                }
                writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

