/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util;

import com.compomics.util.enumeration.ImageType;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JComponent;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class Export {
    public static void exportChart(JFreeChart chart, Rectangle bounds, File exportFile, ImageType imageType) throws IOException, TranscoderException {
        SVGGraphics2D svgGenerator = Export.drawSvgGraphics(chart, bounds);
        Export.exportPlot(exportFile, imageType, svgGenerator);
    }

    public static void exportComponent(Component component, Rectangle bounds, File exportFile, ImageType imageType) throws IOException, TranscoderException {
        SVGGraphics2D svgGenerator = Export.drawSvgGraphics(component, bounds);
        Export.exportPlot(exportFile, imageType, svgGenerator);
    }

    private static SVGGraphics2D drawSvgGraphics(Object component, Rectangle bounds) {
        DOMImplementation domImpl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGDocument svgDocument = (SVGDocument)domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D((Document)svgDocument);
        svgGenerator.setSVGCanvasSize(bounds.getSize());
        if (component instanceof JFreeChart) {
            ((JFreeChart)component).draw((Graphics2D)svgGenerator, (Rectangle2D)bounds);
        } else if (component instanceof JComponent) {
            ((JComponent)component).paintAll((Graphics)svgGenerator);
        }
        return svgGenerator;
    }

    private static void exportPlot(File exportFile, ImageType imageType, SVGGraphics2D svgGenerator) throws IOException, TranscoderException {
        File svgFile = exportFile;
        if (imageType != ImageType.SVG) {
            svgFile = new File(exportFile.getAbsolutePath() + ".temp");
        }
        FileOutputStream outputStream = new FileOutputStream(svgFile);
        BufferedOutputStream bos = new BufferedOutputStream(outputStream);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        svgGenerator.stream((Writer)out, true);
        outputStream.flush();
        ((OutputStream)outputStream).close();
        bos.close();
        if (imageType != ImageType.SVG) {
            String svgURI = svgFile.toURI().toString();
            TranscoderInput svgInputFile = new TranscoderInput(svgURI);
            FileOutputStream outstream = new FileOutputStream(exportFile);
            bos = new BufferedOutputStream(outstream);
            TranscoderOutput output = new TranscoderOutput((OutputStream)bos);
            if (imageType == ImageType.PDF) {
                PDFTranscoder pdfTranscoder = new PDFTranscoder();
                pdfTranscoder.addTranscodingHint(PDFTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)Float.valueOf(0.084666f));
                pdfTranscoder.transcode(svgInputFile, output);
            } else if (imageType == ImageType.JPEG) {
                JPEGTranscoder jpegTranscoder = new JPEGTranscoder();
                jpegTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)1.0);
                jpegTranscoder.transcode(svgInputFile, output);
            } else if (imageType == ImageType.TIFF) {
                TIFFTranscoder tiffTranscoder = new TIFFTranscoder();
                tiffTranscoder.addTranscodingHint(TIFFTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)Float.valueOf(0.084666f));
                tiffTranscoder.addTranscodingHint(TIFFTranscoder.KEY_FORCE_TRANSPARENT_WHITE, (Object)true);
                tiffTranscoder.transcode(svgInputFile, output);
            } else if (imageType == ImageType.PNG) {
                PNGTranscoder pngTranscoder = new PNGTranscoder();
                pngTranscoder.addTranscodingHint(PNGTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)Float.valueOf(0.084666f));
                pngTranscoder.transcode(svgInputFile, output);
            }
            outstream.flush();
            ((OutputStream)outstream).close();
            bos.close();
            if (svgFile.exists()) {
                svgFile.delete();
            }
        }
    }
}

