/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.genes.go;

import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class GoMapping {
    public static final String SEPARATOR = "\t";
    private final HashMap<String, HashSet<String>> proteinToGoMap = new HashMap();
    private final HashMap<String, HashSet<String>> goToProteinMap = new HashMap();
    private final HashMap<String, String> goAccessionsToNamesMap = new HashMap();
    private final HashMap<String, String> goNamesToAccessionsMap = new HashMap();
    private ArrayList<String> sortedTermNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMappingsFromFile(File file, WaitingHandler waitingHandler) throws IOException {
        this.sortedTermNames = null;
        try (FileReader r = new FileReader(file);
             BufferedReader br = new BufferedReader(r);){
            while (true) {
                String line;
                if ((line = br.readLine()) != null) {
                    String[] splittedLine = line.split(SEPARATOR);
                    if (splittedLine.length == 3 && !splittedLine[0].equals("") && !splittedLine[1].equals("")) {
                        String proteinAccession = splittedLine[0];
                        String goTermAccession = splittedLine[1];
                        String goTermName = splittedLine[2].toLowerCase();
                        HashSet<String> goTerms = this.proteinToGoMap.get(proteinAccession);
                        if (goTerms == null) {
                            goTerms = new HashSet();
                            this.proteinToGoMap.put(proteinAccession, goTerms);
                        }
                        goTerms.add(goTermAccession);
                        HashSet<String> proteinAccessions = this.goToProteinMap.get(goTermAccession);
                        if (proteinAccessions == null) {
                            proteinAccessions = new HashSet();
                            this.goToProteinMap.put(goTermAccession, proteinAccessions);
                        }
                        proteinAccessions.add(proteinAccession);
                        this.goAccessionsToNamesMap.put(goTermAccession, goTermName);
                        this.goNamesToAccessionsMap.put(goTermName, goTermAccession);
                    }
                    if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                    return;
                    continue;
                }
                break;
            }
        }
    }

    public HashSet<String> getGoAccessions(String proteinAccession) {
        return this.proteinToGoMap.get(proteinAccession);
    }

    public HashSet<String> getProteinAccessions(String goTermAccession) {
        return this.goToProteinMap.get(goTermAccession);
    }

    public String getTermName(String goAccession) {
        return this.goAccessionsToNamesMap.get(goAccession);
    }

    public String getTermAccession(String goName) {
        return this.goNamesToAccessionsMap.get(goName);
    }

    public HashMap<String, String> getGoNamesMap() {
        return this.goAccessionsToNamesMap;
    }

    public HashMap<String, HashSet<String>> getProteinToGoMap() {
        return this.proteinToGoMap;
    }

    public HashMap<String, HashSet<String>> getGoToProteinMap() {
        return this.goToProteinMap;
    }

    public ArrayList<String> getSortedTermNames() {
        if (this.sortedTermNames == null) {
            HashSet<String> goNames = new HashSet<String>(this.goAccessionsToNamesMap.size());
            for (HashSet<String> goAccessions : this.proteinToGoMap.values()) {
                for (String goAccession : goAccessions) {
                    String goName = this.getTermName(goAccession);
                    if (goName == null) continue;
                    goNames.add(goName);
                }
            }
            this.sortedTermNames = new ArrayList(goNames);
            Collections.sort(this.sortedTermNames);
        }
        return this.sortedTermNames;
    }
}

