/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification.peptide_mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.MatchingAlgorithm;
import org.jgrapht.alg.matching.KuhnMunkresMinimalWeightBipartitePerfectMatching;
import org.jgrapht.alg.matching.MaximumWeightBipartiteMatching;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class ModificationPeptideMapping {
    public static final String SEPARATOR = "_";

    public static HashMap<Double, TreeSet<Integer>> mapModificationsDeprecated(HashMap<Double, int[]> modificationToPossibleSiteMap, HashMap<Double, Integer> modificationOccurrenceMap, HashMap<Double, HashMap<Integer, Double>> modificationToSiteToScore) {
        SimpleWeightedGraph g = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        HashSet<String> sitesVertices = new HashSet<String>();
        HashSet<String> modificationsVertices = new HashSet<String>();
        for (Map.Entry<Double, int[]> modificationEntry : modificationToPossibleSiteMap.entrySet()) {
            int[] sites;
            double modID = modificationEntry.getKey();
            int modOccNum = modificationOccurrenceMap.get(modID);
            for (int i = 0; i < modOccNum; ++i) {
                String vertexName = String.join((CharSequence)SEPARATOR, String.valueOf(modID), String.valueOf(i));
                g.addVertex((Object)vertexName);
                modificationsVertices.add(vertexName);
            }
            HashMap<Integer, Double> localizationScores = modificationToSiteToScore.get(modID);
            for (int site : sites = modificationEntry.getValue()) {
                String siteVertexName = String.valueOf(site);
                if (!g.vertexSet().contains(siteVertexName)) {
                    g.addVertex((Object)siteVertexName);
                    sitesVertices.add(siteVertexName);
                }
                double locScore = localizationScores.get(site);
                for (int i = 0; i < modOccNum; ++i) {
                    String modVertexName = String.join((CharSequence)SEPARATOR, String.valueOf(modID), String.valueOf(i));
                    DefaultWeightedEdge e = (DefaultWeightedEdge)g.addEdge((Object)modVertexName, (Object)siteVertexName);
                    if (e == null) {
                        System.out.println("vertex " + modVertexName);
                    }
                    g.setEdgeWeight((Object)e, locScore);
                }
            }
        }
        MaximumWeightBipartiteMatching matching = new MaximumWeightBipartiteMatching((Graph)g, modificationsVertices, sitesVertices);
        MatchingAlgorithm.Matching matchingInfo = matching.getMatching();
        Set matchingEdges = matchingInfo.getEdges();
        HashMap<Double, TreeSet<Integer>> matchedSiteToModification = new HashMap<Double, TreeSet<Integer>>(1);
        for (DefaultWeightedEdge e : matchingEdges) {
            String eInfo = e.toString();
            String[] eVertices = eInfo.split(":");
            double modVertex = Double.parseDouble(eVertices[0].substring(1, eVertices[0].length() - 1).split(SEPARATOR)[0]);
            int siteVertex = Integer.parseInt(eVertices[1].substring(1, eVertices[1].length() - 1));
            TreeSet<Integer> modificationSites = matchedSiteToModification.get(modVertex);
            if (modificationSites == null) {
                modificationSites = new TreeSet();
                matchedSiteToModification.put(modVertex, modificationSites);
            }
            modificationSites.add(siteVertex);
        }
        return matchedSiteToModification;
    }

    public static HashMap<Double, TreeSet<Integer>> mapModifications(HashMap<Double, int[]> modificationToPossibleSiteMap, HashMap<Double, Integer> modificationOccurrenceMap, HashMap<Double, HashMap<Integer, Double>> modificationToSiteToScore) {
        double modID;
        SimpleWeightedGraph g = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        HashSet<String> sitesVertices = new HashSet<String>();
        HashSet<String> modificationsVertices = new HashSet<String>();
        double maxScore = 0.0;
        for (Map.Entry<Double, int[]> modificationEntry : modificationToPossibleSiteMap.entrySet()) {
            modID = modificationEntry.getKey();
            HashMap<Integer, Double> localizationScores = modificationToSiteToScore.get(modID);
            for (Double score : localizationScores.values()) {
                if (!(score > maxScore)) continue;
                maxScore = score;
            }
        }
        for (Map.Entry<Double, int[]> modificationEntry : modificationToPossibleSiteMap.entrySet()) {
            int[] sites;
            modID = modificationEntry.getKey();
            int modOccNum = modificationOccurrenceMap.get(modID);
            for (int i = 0; i < modOccNum; ++i) {
                String vertexName = String.join((CharSequence)SEPARATOR, String.valueOf(modID), String.valueOf(i));
                g.addVertex((Object)vertexName);
                modificationsVertices.add(vertexName);
            }
            HashMap<Integer, Double> localizationScores = modificationToSiteToScore.get(modID);
            for (int site : sites = modificationEntry.getValue()) {
                String siteVertexName = String.valueOf(site);
                if (!g.vertexSet().contains(siteVertexName)) {
                    g.addVertex((Object)siteVertexName);
                    sitesVertices.add(siteVertexName);
                }
                double locScore = maxScore - localizationScores.get(site) + 0.1;
                for (int i = 0; i < modOccNum; ++i) {
                    String modVertexName = String.join((CharSequence)SEPARATOR, String.valueOf(modID), String.valueOf(i));
                    DefaultWeightedEdge e = (DefaultWeightedEdge)g.addEdge((Object)modVertexName, (Object)siteVertexName);
                    if (e == null) {
                        System.out.println("vertex " + modVertexName);
                    }
                    g.setEdgeWeight((Object)e, locScore);
                }
            }
        }
        HashSet<String> dummyVertices = new HashSet<String>();
        if (sitesVertices.size() > modificationsVertices.size()) {
            for (int i = 1; i < sitesVertices.size() - modificationsVertices.size() + 1; ++i) {
                String vertexName = String.join((CharSequence)SEPARATOR, "dummy_vertex", String.valueOf(i));
                g.addVertex((Object)vertexName);
                dummyVertices.add(vertexName);
            }
        }
        double dummyEdgeWeight = (maxScore + 50.0) * 10.0;
        ArrayList sitesVerticesList = new ArrayList(sitesVertices);
        ArrayList<String> modsVerticesList = new ArrayList<String>(modificationsVertices);
        modsVerticesList.addAll(dummyVertices);
        for (int i = 0; i < sitesVerticesList.size(); ++i) {
            for (int j = 0; j < modsVerticesList.size(); ++j) {
                DefaultWeightedEdge e = (DefaultWeightedEdge)g.getEdge((Object)((String)sitesVerticesList.get(i)), (Object)((String)modsVerticesList.get(j)));
                if (e != null) continue;
                e = (DefaultWeightedEdge)g.addEdge((Object)((String)sitesVerticesList.get(i)), (Object)((String)modsVerticesList.get(j)));
                g.setEdgeWeight((Object)e, dummyEdgeWeight);
            }
        }
        HashSet<String> modsPlusDummyVertices = new HashSet<String>();
        modsPlusDummyVertices.addAll(modificationsVertices);
        modsPlusDummyVertices.addAll(dummyVertices);
        KuhnMunkresMinimalWeightBipartitePerfectMatching matching = new KuhnMunkresMinimalWeightBipartitePerfectMatching((Graph)g, modsPlusDummyVertices, sitesVertices);
        MatchingAlgorithm.Matching matchingInfo = matching.getMatching();
        Set matchingEdges = matchingInfo.getEdges();
        HashMap<Double, TreeSet<Integer>> matchedSiteToModification = new HashMap<Double, TreeSet<Integer>>(1);
        for (DefaultWeightedEdge e : matchingEdges) {
            int siteVertex;
            double modVertex;
            String eInfo = e.toString();
            String[] eVertices = eInfo.split(":");
            int isDummy1 = eVertices[0].indexOf("dummy");
            int isDummy2 = eVertices[1].indexOf("dummy");
            if (isDummy1 != -1 || isDummy2 != -1) continue;
            if (eVertices[0].indexOf(SEPARATOR) != -1) {
                modVertex = Double.parseDouble(eVertices[0].substring(1, eVertices[0].length() - 1).split(SEPARATOR)[0]);
                siteVertex = Integer.parseInt(eVertices[1].substring(1, eVertices[1].length() - 1));
            } else {
                modVertex = Double.parseDouble(eVertices[1].substring(1, eVertices[1].length() - 1).split(SEPARATOR)[0]);
                siteVertex = Integer.parseInt(eVertices[0].substring(1, eVertices[0].length() - 1));
            }
            TreeSet<Integer> modificationSites = matchedSiteToModification.get(modVertex);
            if (modificationSites == null) {
                modificationSites = new TreeSet();
                matchedSiteToModification.put(modVertex, modificationSites);
            }
            modificationSites.add(siteVertex);
        }
        return matchedSiteToModification;
    }
}

