/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.mass_spectrometry.indexes.SpectrumIndex;
import java.util.ArrayList;

public class ReporterIonAnnotator {
    private final double[] reporterIonsMz;
    private final ReporterIon[] reporterIons;

    public ReporterIonAnnotator() {
        this.reporterIonsMz = null;
        this.reporterIons = null;
    }

    public ReporterIonAnnotator(ReporterIon[] reporterIons) {
        this.reporterIons = reporterIons;
        this.reporterIonsMz = new double[reporterIons.length];
        for (int i = 0; i < reporterIons.length; ++i) {
            this.reporterIonsMz[i] = reporterIons[i].getTheoreticMass() + ElementaryIon.proton.getTheoreticMass();
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex) {
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(this.reporterIons.length);
        for (int i = 0; i < this.reporterIons.length; ++i) {
            double ionMz = this.reporterIonsMz[i];
            int[] indexes = spectrumIndex.getMatchingPeaks(ionMz);
            if (indexes.length <= 0) continue;
            ReporterIon ion = this.reporterIons[i];
            for (int index : indexes) {
                results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, 1));
            }
        }
        return results;
    }
}

