/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.utils;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideVariantMatches;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PeptideUtils {
    public static boolean isDecoy(Peptide peptide, SequenceProvider sequenceProvider) {
        return peptide.getProteinMapping().navigableKeySet().stream().anyMatch(accession -> sequenceProvider.getDecoyAccessions().contains(accession));
    }

    public static String getAaBefore(Peptide peptide, String accession, int index, int nAa, SequenceProvider sequenceProvider) {
        return sequenceProvider.getSubsequence(accession, index - nAa, index);
    }

    public static TreeMap<String, String[]> getAaBefore(Peptide peptide, int nAa, SequenceProvider sequenceProvider) {
        return peptide.getProteinMapping().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String[])Arrays.stream((int[])entry.getValue()).mapToObj(index -> PeptideUtils.getAaBefore(peptide, (String)entry.getKey(), index, nAa, sequenceProvider)).toArray(String[]::new), (a, b) -> {
            throw new IllegalArgumentException("Duplicate key.");
        }, TreeMap::new));
    }

    public static String getAaAfter(Peptide peptide, String accession, int index, int nAa, SequenceProvider sequenceProvider) {
        return sequenceProvider.getSubsequence(accession, index + peptide.getSequence().length(), index + peptide.getSequence().length() + nAa);
    }

    public static TreeMap<String, String[]> getAaAfter(Peptide peptide, int nAa, SequenceProvider sequenceProvider) {
        return peptide.getProteinMapping().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String[])Arrays.stream((int[])entry.getValue()).mapToObj(index -> PeptideUtils.getAaAfter(peptide, (String)entry.getKey(), index, nAa, sequenceProvider)).toArray(String[]::new), (a, b) -> {
            throw new IllegalArgumentException("Duplicate key.");
        }, TreeMap::new));
    }

    public static String getVariableModificationsAsString(ModificationMatch[] modificationMatches) {
        TreeMap modMap = Arrays.stream(modificationMatches).collect(Collectors.groupingBy(ModificationMatch::getModification, TreeMap::new, Collectors.mapping(ModificationMatch::getSite, Collectors.toCollection(TreeSet::new))));
        return modMap.entrySet().stream().map(entry -> PeptideUtils.getModificationString((String)entry.getKey(), (TreeSet)entry.getValue())).collect(Collectors.joining(";"));
    }

    public static String getVariableModificationsAsString(Peptide peptide) {
        return PeptideUtils.getVariableModificationsAsString(peptide.getVariableModifications());
    }

    public static String getFixedModificationsAsString(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        final String[] fixedModifications = peptide.getFixedModifications(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
        TreeMap modMap = IntStream.range(0, fixedModifications.length).mapToObj(i -> new Object(){
            Integer position;
            String modification;
            {
                this.position = i;
                this.modification = fixedModifications[i];
            }
        }).filter(obj -> obj.modification != null).collect(Collectors.groupingBy(obj -> obj.modification, TreeMap::new, Collectors.mapping(obj -> obj.position, Collectors.toCollection(TreeSet::new))));
        return modMap.entrySet().stream().map(entry -> PeptideUtils.getModificationString((String)entry.getKey(), (TreeSet)entry.getValue())).collect(Collectors.joining(";"));
    }

    private static String getModificationString(String modificationName, TreeSet<Integer> sites) {
        String sitesString = sites.stream().map(site -> site.toString()).collect(Collectors.joining(","));
        StringBuilder sb = new StringBuilder(modificationName.length() + sitesString.length() + 3);
        sb.append(modificationName).append(" (").append(sitesString).append(")");
        return sb.toString();
    }

    public static String getTaggedModifiedSequence(Peptide peptide, ModificationParameters modificationParameters, String[] allFixedModifications, String[] allVariableModifications, String[] confidentModificationSites, String[] representativeAmbiguousModificationSites, String[] secondaryAmbiguousModificationSites, String[] fixedModificationSites, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName) {
        String peptideSequence = peptide.getSequence();
        if (confidentModificationSites == null) {
            confidentModificationSites = new String[peptideSequence.length() + 2];
        }
        if (representativeAmbiguousModificationSites == null) {
            representativeAmbiguousModificationSites = new String[peptideSequence.length() + 2];
        }
        if (secondaryAmbiguousModificationSites == null) {
            secondaryAmbiguousModificationSites = new String[peptideSequence.length() + 2];
        }
        if (fixedModificationSites == null) {
            fixedModificationSites = new String[peptideSequence.length() + 2];
        }
        StringBuilder modifiedSequence = new StringBuilder(peptideSequence.length());
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence.append("<html>");
        }
        String nTermAsString = PeptideUtils.getNtermAsString(useShortName, allFixedModifications, allVariableModifications);
        String cTermAsString = PeptideUtils.getCtermAsString(useShortName, peptideSequence.length(), allFixedModifications, allVariableModifications);
        modifiedSequence.append(nTermAsString).append('-').append(ModificationUtils.getTaggedModifiedSequence(modificationParameters, peptideSequence, confidentModificationSites, representativeAmbiguousModificationSites, secondaryAmbiguousModificationSites, fixedModificationSites, useHtmlColorCoding, useShortName)).append('-').append(cTermAsString);
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence.append("</html>");
        }
        return modifiedSequence.toString();
    }

    public static String getNtermAsString(boolean useShortName, String[] ... modificationArrays) {
        for (String[] modificationArray : modificationArrays) {
            String modName = modificationArray[0];
            if (modName == null) continue;
            if (useShortName) {
                ModificationFactory modificationFactory = ModificationFactory.getInstance();
                Modification modification = modificationFactory.getModification(modName);
                return modification.getShortName();
            }
            return modName.replaceAll(" ", ".");
        }
        return "NH2";
    }

    public static String getCtermAsString(boolean useShortName, int length, String[] ... modificationArrays) {
        for (String[] modificationArray : modificationArrays) {
            String modName = modificationArray[length + 1];
            if (modName == null) continue;
            if (useShortName) {
                ModificationFactory modificationFactory = ModificationFactory.getInstance();
                Modification modification = modificationFactory.getModification(modName);
                return modification.getShortName();
            }
            return modName.replaceAll(" ", ".");
        }
        return "COOH";
    }

    public static boolean isNtermEnzymatic(int peptideStart, int peptideEnd, String proteinSequence, Enzyme enzyme) {
        char aaAfter;
        if (peptideStart < 0 || peptideStart >= proteinSequence.length()) {
            throw new IllegalArgumentException("Start of peptide index (" + peptideStart + ") is outside protein sequence (" + proteinSequence.length() + "). Note that index should be zero-based.");
        }
        if (peptideStart == 0) {
            return true;
        }
        char aaBefore = proteinSequence.charAt(peptideStart - 1);
        return enzyme.isCleavageSite(aaBefore, aaAfter = proteinSequence.charAt(peptideStart));
    }

    public static boolean isCtermEnzymatic(int peptideStart, int peptideEnd, String proteinSequence, Enzyme enzyme) {
        char aaAfter;
        if (peptideEnd < 0 || peptideEnd >= proteinSequence.length()) {
            throw new IllegalArgumentException("End of peptide index (" + peptideEnd + ") is outside protein sequence (" + proteinSequence.length() + "). Note that index should be zero-based.");
        }
        if (peptideEnd == proteinSequence.length() - 1) {
            return true;
        }
        char aaBefore = proteinSequence.charAt(peptideEnd);
        return enzyme.isCleavageSite(aaBefore, aaAfter = proteinSequence.charAt(peptideEnd + 1));
    }

    public static int getNEnzymaticTermini(int peptideStart, int peptideEnd, String proteinSequence, Enzyme enzyme) {
        char aaAfter;
        char aaBefore;
        int nEnzymatic = 0;
        if (peptideStart == 0) {
            ++nEnzymatic;
        } else {
            aaBefore = proteinSequence.charAt(peptideStart - 1);
            if (enzyme.isCleavageSite(aaBefore, aaAfter = proteinSequence.charAt(peptideStart))) {
                ++nEnzymatic;
            }
        }
        if (peptideEnd == proteinSequence.length() - 1) {
            ++nEnzymatic;
        } else {
            aaBefore = proteinSequence.charAt(peptideEnd);
            if (enzyme.isCleavageSite(aaBefore, aaAfter = proteinSequence.charAt(peptideEnd + 1))) {
                ++nEnzymatic;
            }
        }
        return nEnzymatic;
    }

    public static boolean isEnzymatic(Peptide peptide, String proteinAccession, String proteinSequence, ArrayList<Enzyme> enzymes) {
        int[] startIndexes = peptide.getProteinMapping().get(proteinAccession);
        if (startIndexes == null) {
            return false;
        }
        return enzymes.stream().anyMatch(enzyme -> Arrays.stream(startIndexes).map(index -> PeptideUtils.getNEnzymaticTermini(index, peptide.getPeptideEnd(proteinAccession, index), proteinSequence, enzyme)).anyMatch(nTermini -> nTermini == 2));
    }

    public static boolean isEnzymatic(Peptide peptide, SequenceProvider sequenceProvider, ArrayList<Enzyme> enzymes) {
        return peptide.getProteinMapping().entrySet().stream().anyMatch(entry -> PeptideUtils.isEnzymatic(peptide, (String)entry.getKey(), sequenceProvider.getSequence((String)entry.getKey()), enzymes));
    }

    public static boolean isVariant(Peptide peptide, String accession) {
        HashMap<Integer, PeptideVariantMatches> variantOnProtein;
        if (peptide.getVariantMatches() == null) {
            return false;
        }
        int[] indexesOnProtein = peptide.getProteinMapping().get(accession);
        return indexesOnProtein.length == (variantOnProtein = peptide.getVariantMatches().get(accession)).size();
    }

    public static boolean isNterm(Peptide peptide, SequenceProvider sequenceProvider) {
        return peptide.getProteinMapping().keySet().stream().anyMatch(accession -> PeptideUtils.isNterm(peptide, accession, sequenceProvider));
    }

    public static boolean isNterm(Peptide peptide, String proteinAccession, SequenceProvider sequenceProvider) {
        return Arrays.stream(peptide.getProteinMapping().get(proteinAccession)).anyMatch(aa -> aa == 0 || aa == 1 && sequenceProvider.getSequence(proteinAccession).charAt(0) == 'M');
    }

    public static boolean isCterm(Peptide peptide, SequenceProvider sequenceProvider) {
        return peptide.getProteinMapping().keySet().stream().anyMatch(accession -> PeptideUtils.isCterm(peptide, accession, sequenceProvider));
    }

    public static boolean isCterm(Peptide peptide, String proteinAccession, SequenceProvider sequenceProvider) {
        return Arrays.stream(peptide.getProteinMapping().get(proteinAccession)).anyMatch(aa -> sequenceProvider.getSequence(proteinAccession).length() == aa + peptide.getSequence().length());
    }

    public static int getModifiedAaIndex(int modSite, int sequenceLength) {
        if (modSite > 0 & modSite <= sequenceLength) {
            return modSite - 1;
        }
        if (modSite == 0) {
            return 0;
        }
        if (modSite == sequenceLength + 1) {
            return sequenceLength - 1;
        }
        throw new IllegalArgumentException("Modification site " + modSite + " not supported.");
    }
}

