/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.NovorParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.JAXBException;

public class NovorIdfileReader
implements IdfileReader {
    private final String softwareName = "Novor";
    private String softwareVersion = null;
    private File novorCsvFile;
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();

    public NovorIdfileReader() {
    }

    public NovorIdfileReader(File novorCsvFile) throws IOException {
        this(novorCsvFile, null);
    }

    public NovorIdfileReader(File novorCsvFile, WaitingHandler waitingHandler) throws IOException {
        this.novorCsvFile = novorCsvFile;
        this.extractVersionNumber();
    }

    private void extractVersionNumber() throws IOException {
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.novorCsvFile);){
            String line = reader.readLine();
            boolean versionNumberFound = false;
            String versionNumberString = null;
            while (line.startsWith("#") && !versionNumberFound) {
                if (line.contains(" v")) {
                    versionNumberString = line;
                    versionNumberString = versionNumberString.substring(1);
                    versionNumberString = versionNumberString.trim();
                    versionNumberFound = true;
                }
                line = reader.readLine();
            }
            if (versionNumberFound) {
                this.softwareVersion = versionNumberString.trim();
            }
        }
    }

    @Override
    public String getExtension() {
        return ".novor.csv";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, true);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        NovorParameters novorParameters = (NovorParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex());
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.novorCsvFile);){
            String headerString;
            String line;
            String inputFile = null;
            String fixedModificationsLine = null;
            String variableModificationsLine = null;
            while ((line = reader.readLine()) != null && !line.startsWith("# id,")) {
                if (line.startsWith("# input file = ")) {
                    inputFile = line.substring("# input file = ".length()).trim();
                }
                if (line.startsWith("# fixedModifications = ")) {
                    fixedModificationsLine = line.substring("# fixedModifications = ".length()).trim();
                }
                if (!line.startsWith("# variableModifications = ")) continue;
                variableModificationsLine = line.substring("# variableModifications = ".length()).trim();
            }
            if (inputFile == null) {
                throw new IllegalArgumentException("Mandatory header information is missing in the Novor csv file (the input file tag). Please check the file!");
            }
            if (fixedModificationsLine == null) {
                throw new IllegalArgumentException("Mandatory header information is missing in the Novor csv file (the fixedModifications tag). Please check the file!");
            }
            if (variableModificationsLine == null) {
                throw new IllegalArgumentException("Mandatory header information is missing in the Novor csv file (the variableModifications tag). Please check the file!");
            }
            String spectrumFileName = IoUtil.getFileName(inputFile);
            HashMap<Integer, String> variableModificationsMap = new HashMap<Integer, String>();
            if (!variableModificationsLine.isEmpty()) {
                String[] tempVariable = variableModificationsLine.split(", ");
                for (int i = 0; i < tempVariable.length; ++i) {
                    variableModificationsMap.put(i, tempVariable[i]);
                }
            }
            HashMap<Integer, String> fixedModificationsMap = new HashMap<Integer, String>();
            if (!fixedModificationsLine.isEmpty()) {
                String[] tempFixed = fixedModificationsLine.split(", ");
                for (int i = 0; i < tempFixed.length; ++i) {
                    fixedModificationsMap.put(variableModificationsMap.size() + i, tempFixed[i]);
                }
            }
            if ((headerString = line.substring(1).trim()).endsWith(",")) {
                headerString = headerString.substring(0, headerString.length() - 1);
            }
            String[] headers = headerString.split(", ");
            int idIndex = -1;
            int scanNumberIndex = -1;
            int rtIndex = -1;
            int mzIndex = -1;
            int chargeIndex = -1;
            int pepMassIndex = -1;
            int erorrIndex = -1;
            int ppmIndex = -1;
            int scoreIndex = -1;
            int peptideIndex = -1;
            int aaScoreIndex = -1;
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                if (header.equalsIgnoreCase("id")) {
                    idIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("scanNum")) {
                    scanNumberIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("RT")) {
                    rtIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("mz(data)")) {
                    mzIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("z")) {
                    chargeIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("pepMass(denovo)")) {
                    pepMassIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("err(data-denovo)")) {
                    erorrIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("ppm(1e6*err/(mz*z))")) {
                    ppmIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("score")) {
                    scoreIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("peptide")) {
                    peptideIndex = i;
                    continue;
                }
                if (!header.equalsIgnoreCase("aaScore")) continue;
                aaScoreIndex = i;
            }
            if (idIndex == -1 || scanNumberIndex == -1 || rtIndex == -1 || mzIndex == -1 || chargeIndex == -1 || pepMassIndex == -1 || erorrIndex == -1 || ppmIndex == -1 || scoreIndex == -1 || peptideIndex == -1 || aaScoreIndex == -1) {
                throw new IllegalArgumentException("Mandatory columns are missing in the Novor csv file. Please check the file!");
            }
            String currentSpectrumTitle = null;
            SpectrumMatch currentMatch = null;
            while ((line = reader.readLine()) != null) {
                String peptideSequence;
                String[] elements = line.split(", ");
                if (line.trim().isEmpty()) continue;
                int id = Integer.parseInt(elements[idIndex]);
                int charge = Integer.parseInt(elements[chargeIndex]);
                String peptideSequenceWithMods = elements[peptideIndex];
                String scoreAsText = elements[scoreIndex];
                double novorScore = Util.readDoubleAsString(scoreAsText);
                double novorEValue = Math.pow(10.0, -novorScore);
                String aminoAcidScoresAsString = elements[aaScoreIndex];
                String[] tempAminoAcidScores = aminoAcidScoresAsString.split("-");
                double[] aminoAcidScoresAsList = new double[tempAminoAcidScores.length];
                for (int i = 0; i < tempAminoAcidScores.length; ++i) {
                    aminoAcidScoresAsList[i] = Double.valueOf(tempAminoAcidScores[i]);
                }
                ArrayList<double[]> aminoAcidScores = new ArrayList<double[]>(1);
                aminoAcidScores.add(aminoAcidScoresAsList);
                String spectrumTitle = spectrumProvider.getSpectrumTitles(IoUtil.removeExtension(spectrumFileName))[id - 1];
                if (currentMatch == null || currentSpectrumTitle != null && !currentSpectrumTitle.equalsIgnoreCase(spectrumTitle)) {
                    if (currentMatch != null) {
                        result.add(currentMatch);
                    }
                    currentMatch = new SpectrumMatch(spectrumFileName, spectrumTitle);
                    currentSpectrumTitle = spectrumTitle;
                }
                HashMap utilitiesModificationsMap = new HashMap();
                if (peptideSequenceWithMods.contains("(") || peptideSequenceWithMods.contains("[")) {
                    peptideSequence = "";
                    for (int i = 0; i < peptideSequenceWithMods.length(); ++i) {
                        char currentChar = peptideSequenceWithMods.charAt(i);
                        if (currentChar == '(') {
                            int currentModAsInt;
                            int modStart = i + 1;
                            int modEnd = peptideSequenceWithMods.indexOf(")", i + 1);
                            String currentMod = peptideSequenceWithMods.substring(modStart, modEnd);
                            if (currentMod.toLowerCase().startsWith("n-term|")) {
                                currentModAsInt = Integer.valueOf(currentMod.substring("n-term|".length()));
                                if (variableModificationsMap.containsKey(currentModAsInt)) {
                                    if (!utilitiesModificationsMap.containsKey(1)) {
                                        utilitiesModificationsMap.put(1, new ArrayList());
                                    }
                                    ((ArrayList)utilitiesModificationsMap.get(1)).add((String)variableModificationsMap.get(currentModAsInt));
                                } else if (novorParameters.getNovorPtmMap() == null) {
                                    throw new IllegalArgumentException("Unknown PTM! Please check the Novor results file.");
                                }
                            } else if (currentMod.toLowerCase().startsWith("c-term|")) {
                                currentModAsInt = Integer.valueOf(currentMod.substring("c-term|".length()));
                                if (variableModificationsMap.containsKey(currentModAsInt)) {
                                    if (!utilitiesModificationsMap.containsKey(peptideSequence.length())) {
                                        utilitiesModificationsMap.put(peptideSequence.length(), new ArrayList());
                                    }
                                    ((ArrayList)utilitiesModificationsMap.get(peptideSequence.length())).add((String)variableModificationsMap.get(currentModAsInt));
                                } else if (novorParameters.getNovorPtmMap() == null) {
                                    throw new IllegalArgumentException("Unknown PTM! Please check the Novor results file.");
                                }
                            } else {
                                currentModAsInt = Integer.valueOf(currentMod);
                                if (variableModificationsMap.containsKey(currentModAsInt)) {
                                    if (!utilitiesModificationsMap.containsKey(peptideSequence.length())) {
                                        utilitiesModificationsMap.put(peptideSequence.length(), new ArrayList());
                                    }
                                    ((ArrayList)utilitiesModificationsMap.get(peptideSequence.length())).add((String)variableModificationsMap.get(currentModAsInt));
                                } else if (novorParameters.getNovorPtmMap() == null) {
                                    throw new IllegalArgumentException("Unknown PTM! Please check the Novor results file.");
                                }
                            }
                            i = modEnd;
                            continue;
                        }
                        peptideSequence = peptideSequence + currentChar;
                    }
                } else {
                    peptideSequence = peptideSequenceWithMods;
                }
                Tag tag = new Tag();
                boolean hasAminoAcids = false;
                boolean hasMassGaps = false;
                int maxAminoAcidTagLength = 0;
                String currentSequence = "";
                Boolean lastIndexWasAminoAcid = null;
                for (int i = 0; i < aminoAcidScoresAsList.length; ++i) {
                    double aaScore = aminoAcidScoresAsList[i];
                    if (aaScore >= (double)sequenceMatchingPreferences.getMinAminoAcidScore()) {
                        hasAminoAcids = true;
                    }
                    if (aaScore < (double)sequenceMatchingPreferences.getMinAminoAcidScore()) {
                        hasMassGaps = true;
                    }
                    if (lastIndexWasAminoAcid == null || aaScore >= (double)sequenceMatchingPreferences.getMinAminoAcidScore() && lastIndexWasAminoAcid != false || aaScore < (double)sequenceMatchingPreferences.getMinAminoAcidScore() && !lastIndexWasAminoAcid.booleanValue()) {
                        currentSequence = currentSequence + peptideSequence.charAt(i);
                    } else if (lastIndexWasAminoAcid.booleanValue()) {
                        boolean isModified = false;
                        ArrayList<ModificationMatch> modMatches = new ArrayList<ModificationMatch>();
                        for (int j = i - currentSequence.length(); j < i; ++j) {
                            if (!utilitiesModificationsMap.containsKey(j + 1)) continue;
                            for (String tempMod : (ArrayList)utilitiesModificationsMap.get(j + 1)) {
                                modMatches.add(new ModificationMatch(tempMod, j + 1 - (i - currentSequence.length())));
                            }
                            isModified = true;
                        }
                        if (isModified) {
                            ModificationMatch[] tempList = modMatches.toArray(new ModificationMatch[modMatches.size()]);
                            tag.addAminoAcidSequence(new AminoAcidSequence(currentSequence, tempList));
                        } else {
                            tag.addAminoAcidSequence(new AminoAcidSequence(currentSequence));
                        }
                        if (currentSequence.length() > maxAminoAcidTagLength) {
                            maxAminoAcidTagLength = currentSequence.length();
                        }
                        currentSequence = "" + peptideSequence.charAt(i);
                    } else {
                        double modMass = 0.0;
                        for (int j = i - currentSequence.length(); j < i; ++j) {
                            if (!utilitiesModificationsMap.containsKey(j + 1)) continue;
                            for (String tempMod : (ArrayList)utilitiesModificationsMap.get(j + 1)) {
                                modMass += this.modificationFactory.getModification(tempMod).getMass();
                            }
                        }
                        tag.addMassGap(new AminoAcidSequence(currentSequence).getMass() + modMass);
                        currentSequence = "" + peptideSequence.charAt(i);
                    }
                    lastIndexWasAminoAcid = aaScore >= (double)sequenceMatchingPreferences.getMinAminoAcidScore();
                }
                if (!currentSequence.isEmpty()) {
                    if (lastIndexWasAminoAcid.booleanValue()) {
                        boolean isModified = false;
                        ArrayList<ModificationMatch> modMatches = new ArrayList<ModificationMatch>();
                        for (int i = 0; i < currentSequence.length(); ++i) {
                            if (!utilitiesModificationsMap.containsKey(i + 1)) continue;
                            for (Object tempMod : (ArrayList)utilitiesModificationsMap.get(i + 1)) {
                                modMatches.add(new ModificationMatch((String)tempMod, i + 1));
                            }
                            isModified = true;
                        }
                        if (isModified) {
                            ModificationMatch[] tempList = modMatches.toArray(new ModificationMatch[modMatches.size()]);
                            tag.addAminoAcidSequence(new AminoAcidSequence(currentSequence, tempList));
                        } else {
                            tag.addAminoAcidSequence(new AminoAcidSequence(currentSequence));
                        }
                        if (currentSequence.length() > maxAminoAcidTagLength) {
                            maxAminoAcidTagLength = currentSequence.length();
                        }
                        currentSequence = "";
                    } else {
                        double modMass = 0.0;
                        for (int i = 0; i < currentSequence.length(); ++i) {
                            if (!utilitiesModificationsMap.containsKey(i + 1)) continue;
                            for (Object tempMod : (ArrayList)utilitiesModificationsMap.get(i + 1)) {
                                modMass += this.modificationFactory.getModification((String)tempMod).getMass();
                            }
                        }
                        tag.addMassGap(new AminoAcidSequence(currentSequence).getMass() + modMass);
                        currentSequence = "";
                    }
                }
                if (hasAminoAcids && hasMassGaps && maxAminoAcidTagLength >= sequenceMatchingPreferences.getMinTagLength()) {
                    TagAssumption tagAssumption = new TagAssumption(Advocate.novor.getIndex(), 1, tag, charge, novorScore, novorEValue);
                    currentMatch.addTagAssumption(Advocate.novor.getIndex(), tagAssumption);
                    continue;
                }
                ArrayList<ModificationMatch> utilitiesModificationMatches = new ArrayList<ModificationMatch>();
                Iterator iterator = utilitiesModificationsMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Object tempMod;
                    int target = (Integer)iterator.next();
                    ArrayList tempMods = (ArrayList)utilitiesModificationsMap.get(target);
                    tempMod = tempMods.iterator();
                    while (tempMod.hasNext()) {
                        String tempMod2 = (String)tempMod.next();
                        utilitiesModificationMatches.add(new ModificationMatch(tempMod2, target));
                    }
                }
                Peptide peptide = new Peptide(peptideSequence, utilitiesModificationMatches.toArray(new ModificationMatch[utilitiesModificationsMap.size()]), true);
                PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, 1, Advocate.novor.getIndex(), charge, novorScore, novorEValue, this.novorCsvFile.getName());
                peptideAssumption.setAminoAcidScores(aminoAcidScores);
                if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideAssumption.getPeptide().getSequence())) {
                    ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                    for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                        ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                        Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                        PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getRawScore(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                        currentMatch.addPeptideAssumption(Advocate.novor.getIndex(), newAssumption);
                    }
                    continue;
                }
                currentMatch.addPeptideAssumption(Advocate.novor.getIndex(), peptideAssumption);
            }
            if (currentMatch != null) {
                result.add(currentMatch);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.novorCsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put("Novor", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return true;
    }
}

