/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.JAXBException;

public class OnyaseIdfileReader
implements IdfileReader {
    public static final char separator = ' ';
    public static final char comment = '#';
    public static final String versionTag = "Version:";
    public static final String spectraTag = "Spectrum File:";
    public static final String fastaTag = "Fasta File:";
    public static final String paramsTag = "Parameters File:";
    private File resultsFile;
    private String mgfFile;
    private String fastaFile;
    private String parametersFile;
    private String fileName;
    private HashMap<String, ArrayList<String>> version;
    public static final String ENCODING = "UTF-8";

    public OnyaseIdfileReader() {
    }

    public OnyaseIdfileReader(File resultsFile) throws IOException {
        this.resultsFile = resultsFile;
        this.fileName = IoUtil.getFileName(resultsFile);
        FileInputStream fileStream = new FileInputStream(resultsFile);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, ENCODING);
        BufferedReader br = new BufferedReader(decoder);
        String fileVersion = "test";
        this.version = new HashMap(1);
        ArrayList<String> versions = new ArrayList<String>(1);
        versions.add(fileVersion);
        this.version.put(Advocate.onyaseEngine.getName(), versions);
        this.mgfFile = "bla\\qExactive01819.mgf";
    }

    @Override
    public String getExtension() {
        return ".psm";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, false);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        String line;
        HashMap<String, SpectrumMatch> spectrumMatchesMap = new HashMap<String, SpectrumMatch>();
        String spectrumFileName = IoUtil.getFileName(this.mgfFile);
        String resultFileName = IoUtil.getFileName(this.resultsFile);
        FileInputStream fileStream = new FileInputStream(this.resultsFile);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, ENCODING);
        BufferedReader br = new BufferedReader(decoder);
        br.readLine();
        String separatorString = " ";
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] lineSplit = line.split(separatorString);
            String spectrumTitle = lineSplit[0].trim();
            SpectrumMatch spectrumMatch = (SpectrumMatch)spectrumMatchesMap.get(spectrumTitle = URLDecoder.decode(spectrumTitle, ENCODING));
            if (spectrumMatch == null) {
                spectrumMatch = new SpectrumMatch(spectrumFileName, spectrumTitle);
                spectrumMatchesMap.put(spectrumTitle, spectrumMatch);
            }
            String sequence = lineSplit[3];
            ModificationMatch[] modificationMatches = this.getModificationMatches(lineSplit[4]);
            Peptide peptide = new Peptide(sequence, modificationMatches);
            Integer charge = Integer.valueOf(lineSplit[5]);
            Double score = Double.valueOf(lineSplit[6]);
            Double eValue = Double.valueOf(lineSplit[7]);
            PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, -1, Advocate.onyaseEngine.getIndex(), charge, score, eValue, resultFileName);
            spectrumMatch.addPeptideAssumption(Advocate.onyaseEngine.getIndex(), peptideAssumption);
        }
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        for (SpectrumMatch spectrumMatch : spectrumMatchesMap.values()) {
            TreeMap<Double, ArrayList<PeptideAssumption>> assumptionsMap = spectrumMatch.getAllPeptideAssumptions(Advocate.onyaseEngine.getIndex());
            ArrayList<Double> eValues = new ArrayList<Double>(assumptionsMap.keySet());
            Collections.sort(eValues);
            int rank = 1;
            int cpt = 1;
            for (Double eValue : eValues) {
                ArrayList<PeptideAssumption> spectrumIdentificationAssumptions = assumptionsMap.get(eValue);
                for (SpectrumIdentificationAssumption spectrumIdentificationAssumption : spectrumIdentificationAssumptions) {
                    spectrumIdentificationAssumption.setRank(rank);
                    ++cpt;
                }
                rank = cpt;
            }
            result.add(spectrumMatch);
        }
        return result;
    }

    private ModificationMatch[] getModificationMatches(String modificationsString) throws UnsupportedEncodingException {
        if (modificationsString.length() == 0) {
            return null;
        }
        String decodedString = URLDecoder.decode(modificationsString, "utf-8");
        String[] modifications = decodedString.split("_");
        ModificationMatch[] modificationMatches = (ModificationMatch[])Arrays.stream(modifications).map(modification -> modification.split("-ATAA-")).map(modificationSplit -> new ModificationMatch(modificationSplit[0], Integer.parseInt(modificationSplit[1]))).toArray(ModificationMatch[]::new);
        return modificationMatches;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        return this.version;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

