/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.io.mass_spectrometry.apl.AplFileWriter;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfFileWriter;
import com.compomics.util.experiment.io.mass_spectrometry.ms2.Ms2FileWriter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.AndromedaParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.IntStream;

public class MsFileExporter {
    public static void writeMsFile(SpectrumProvider spectrumProvider, boolean includeAllSpectrumLevels, String fileNameWithoutExtension, File destinationFile, Format format, SearchParameters searchParameters, WaitingHandler waitingHandler) {
        switch (format.ordinal()) {
            case 0: {
                MsFileExporter.writeMgfFile(spectrumProvider, includeAllSpectrumLevels, fileNameWithoutExtension, destinationFile, waitingHandler);
                return;
            }
            case 1: {
                MsFileExporter.writeAplFile(spectrumProvider, includeAllSpectrumLevels, fileNameWithoutExtension, destinationFile, searchParameters, waitingHandler);
                return;
            }
            case 2: {
                MsFileExporter.writeMs2File(spectrumProvider, includeAllSpectrumLevels, fileNameWithoutExtension, destinationFile, waitingHandler);
                return;
            }
        }
        throw new UnsupportedOperationException("Format " + (Object)((Object)format) + " not supported.");
    }

    public static void writeAplFile(SpectrumProvider spectrumProvider, boolean includeAllSpectrumLevels, String fileNameWithoutExtension, File destinationFile, SearchParameters searchParameters, WaitingHandler waitingHandler) {
        AndromedaParameters andromedaParameters = (AndromedaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex());
        String[] spectrumTitles = spectrumProvider.getSpectrumTitles(fileNameWithoutExtension);
        if (spectrumTitles == null) {
            throw new IllegalArgumentException(fileNameWithoutExtension + " not loaded.");
        }
        HashMap<Double, HashMap<String, Integer>> precursorMassToTitleMap = new HashMap<Double, HashMap<String, Integer>>(spectrumTitles.length);
        for (String spectrumTitle : spectrumTitles) {
            Spectrum spectrum = spectrumProvider.getSpectrum(fileNameWithoutExtension, spectrumTitle);
            Precursor precursor = spectrum.getPrecursor();
            int[] charges = spectrum.getPrecursor().possibleCharges;
            if (charges.length == 0) {
                charges = IntStream.rangeClosed(searchParameters.getMinChargeSearched(), searchParameters.getMaxChargeSearched()).toArray();
            }
            for (int charge : charges) {
                double mass = precursor.getMass(charge);
                HashMap<String, Integer> titlesAtMass = (HashMap<String, Integer>)precursorMassToTitleMap.get(mass);
                if (titlesAtMass == null) {
                    titlesAtMass = new HashMap<String, Integer>(1);
                    precursorMassToTitleMap.put(mass, titlesAtMass);
                }
                titlesAtMass.put(spectrumTitle, charge);
            }
        }
        ArrayList masses = new ArrayList(precursorMassToTitleMap.keySet());
        Collections.sort(masses);
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(masses.size());
        AplFileWriter writer = new AplFileWriter(destinationFile);
        for (Double mass : masses) {
            HashMap tempSpectrumTitles = (HashMap)precursorMassToTitleMap.get(mass);
            for (String spectrumTitle : tempSpectrumTitles.keySet()) {
                Spectrum spectrum = spectrumProvider.getSpectrum(fileNameWithoutExtension, spectrumTitle);
                if (!includeAllSpectrumLevels && (includeAllSpectrumLevels || spectrum.getSpectrumLevel() != 2)) continue;
                writer.writeSpectrum(spectrumTitle, spectrum, andromedaParameters.getFragmentationMethod(), (Integer)tempSpectrumTitles.get(spectrumTitle));
            }
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        writer.close();
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public static void writeMgfFile(SpectrumProvider spectrumProvider, boolean includeAllSpectrumLevels, String fileNameWithoutExtension, File destinationFile, WaitingHandler waitingHandler) {
        String[] spectrumTitles = spectrumProvider.getSpectrumTitles(fileNameWithoutExtension);
        if (spectrumTitles == null) {
            throw new IllegalArgumentException(fileNameWithoutExtension + " not loaded.");
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(spectrumTitles.length);
        MgfFileWriter writer = new MgfFileWriter(destinationFile);
        for (String spectrumTitle : spectrumTitles) {
            Spectrum spectrum = spectrumProvider.getSpectrum(fileNameWithoutExtension, spectrumTitle);
            if (includeAllSpectrumLevels || !includeAllSpectrumLevels && spectrum.getSpectrumLevel() == 2) {
                writer.writeSpectrum(spectrumTitle, spectrum);
            }
            waitingHandler.increaseSecondaryProgressCounter();
            if (waitingHandler.isRunCanceled()) break;
        }
        writer.close();
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public static void writeMs2File(SpectrumProvider spectrumProvider, boolean includeAllSpectrumLevels, String fileNameWithoutExtension, File destinationFile, WaitingHandler waitingHandler) {
        String[] spectrumTitles = spectrumProvider.getSpectrumTitles(fileNameWithoutExtension);
        if (spectrumTitles == null) {
            throw new IllegalArgumentException(fileNameWithoutExtension + " not loaded.");
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(spectrumTitles.length);
        Ms2FileWriter writer = new Ms2FileWriter(destinationFile);
        writer.writeHeader();
        for (int i = 0; i < spectrumTitles.length; ++i) {
            String spectrumTitle = spectrumTitles[i];
            Spectrum spectrum = spectrumProvider.getSpectrum(fileNameWithoutExtension, spectrumTitle);
            if (includeAllSpectrumLevels || !includeAllSpectrumLevels && spectrum.getSpectrumLevel() == 2) {
                writer.writeSpectrum(spectrum, i);
            }
            waitingHandler.increaseSecondaryProgressCounter();
            if (waitingHandler.isRunCanceled()) break;
        }
        writer.close();
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public static enum Format {
        mgf,
        apl,
        ms2;

    }
}

