/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.cms;

import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileUtils;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileWriter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.ZstdUtils;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class CmsFileReader
implements SpectrumProvider {
    private final double minMz;
    private final double maxMz;
    private final double maxInt;
    private final double maxRt;
    public final String[] titles;
    private final HashMap<String, ArrayList<String>> postcursorMap;
    private final HashMap<String, Long> indexMap;
    private final HashMap<String, Double> precursorMzMap;
    private ArrayList<Long> bufferStartIndexes = new ArrayList();
    private final SimpleSemaphore mutex = new SimpleSemaphore(1);
    private final RandomAccessFile raf;
    private final FileChannel fc;
    private ArrayList<MappedByteBuffer> mappedByteBuffers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsFileReader(File file, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        this.raf = new RandomAccessFile(file, "r");
        try {
            String[] bufferStartIndexesSplit;
            byte[] fileMagicNumber = new byte[CmsFileUtils.MAGIC_NUMBER.length];
            this.raf.read(fileMagicNumber);
            if (!Arrays.equals(CmsFileUtils.MAGIC_NUMBER, fileMagicNumber)) {
                this.raf.close();
                throw new IOException("File format of " + file + " not supported.");
            }
            long footerPosition = this.raf.readLong();
            this.minMz = this.raf.readDouble();
            this.maxMz = this.raf.readDouble();
            this.maxInt = this.raf.readDouble();
            this.maxRt = this.raf.readDouble();
            this.raf.seek(footerPosition);
            int length = this.raf.readInt();
            int uncompressedLength = this.raf.readInt();
            byte[] compressedFooter = new byte[length];
            this.raf.read(compressedFooter);
            byte[] footerByteArray = CmsFileReader.uncompress(compressedFooter, uncompressedLength);
            String footerAsString = new String(footerByteArray, 0, footerByteArray.length, "UTF-8");
            String[] footerAsStringSplit = footerAsString.split("\t");
            int nTitles = (footerAsStringSplit.length - 1) / 2;
            this.indexMap = new HashMap(nTitles);
            this.titles = new String[nTitles];
            for (int i = 0; i < nTitles; ++i) {
                String title = footerAsStringSplit[i];
                long index = Long.parseLong(footerAsStringSplit[i + nTitles]);
                this.indexMap.put(title, index);
                this.titles[i] = title;
            }
            this.postcursorMap = new HashMap();
            String postcursorMapAsText = footerAsStringSplit[footerAsStringSplit.length - 2];
            if (!postcursorMapAsText.equalsIgnoreCase("null")) {
                String[] postcursorMapAsTextSplit;
                for (String temp : postcursorMapAsTextSplit = postcursorMapAsText.split(" # ")) {
                    String[] precusorAndList = temp.split(" \\{");
                    String precusorKey = precusorAndList[0];
                    String postcursors = precusorAndList[1].substring(0, precusorAndList[1].length() - 1);
                    String[] postcursorsSplit = postcursors.split(",");
                    if (!this.postcursorMap.containsKey(precusorKey)) {
                        this.postcursorMap.put(precusorKey, new ArrayList());
                    }
                    this.postcursorMap.get(precusorKey).addAll(Arrays.asList(postcursorsSplit));
                }
            }
            this.precursorMzMap = new HashMap(nTitles);
            String bufferStartIndexesAsText = footerAsStringSplit[footerAsStringSplit.length - 1];
            bufferStartIndexesAsText = bufferStartIndexesAsText.substring(1, bufferStartIndexesAsText.length() - 1);
            for (String indexAsString : bufferStartIndexesSplit = bufferStartIndexesAsText.split(", ")) {
                this.bufferStartIndexes.add(Long.valueOf(indexAsString));
            }
            long maxIndex = footerPosition - (long)CmsFileWriter.HEADER_LENGTH;
            this.fc = this.raf.getChannel();
            if (this.bufferStartIndexes.size() == 1) {
                long startIndex = CmsFileWriter.HEADER_LENGTH;
                this.mappedByteBuffers.add(this.fc.map(FileChannel.MapMode.READ_ONLY, startIndex, maxIndex));
            } else {
                for (int i = 0; i < this.bufferStartIndexes.size() - 1; ++i) {
                    long startIndex = this.bufferStartIndexes.get(i);
                    long size = this.bufferStartIndexes.get(i + 1) - startIndex;
                    this.mappedByteBuffers.add(this.fc.map(FileChannel.MapMode.READ_ONLY, startIndex, size));
                }
                long startIndex = this.bufferStartIndexes.get(this.bufferStartIndexes.size() - 1);
                long size = footerPosition - startIndex;
                this.mappedByteBuffers.add(this.fc.map(FileChannel.MapMode.READ_ONLY, startIndex, size));
            }
        }
        finally {
            this.raf.close();
        }
    }

    private Spectrum getSpectrum(long spectrumIndex) {
        this.mutex.acquire();
        MappedByteBuffer mappedByteBuffer = this.getMappedByteBuffer(spectrumIndex);
        double precursorMz = mappedByteBuffer.getDouble();
        double precursorRt = mappedByteBuffer.getDouble();
        double precursorIntensity = mappedByteBuffer.getDouble();
        int spectrumLevel = mappedByteBuffer.getInt();
        int compressedDataLength = mappedByteBuffer.getInt();
        int nPeaks = mappedByteBuffer.getInt();
        byte[] compressedSpectrum = new byte[compressedDataLength];
        mappedByteBuffer.get(compressedSpectrum);
        int nCharges = mappedByteBuffer.getInt();
        int[] charges = new int[nCharges];
        for (int i = 0; i < nCharges; ++i) {
            charges[i] = mappedByteBuffer.getInt();
        }
        this.mutex.release();
        double[] mz = new double[nPeaks];
        double[] intensity = new double[nPeaks];
        if (nPeaks > 0) {
            int uncompressedLength = nPeaks * 2 * 8;
            byte[] uncompressedSpectrum = CmsFileReader.uncompress(compressedSpectrum, uncompressedLength);
            ByteBuffer byteBuffer = ByteBuffer.wrap(uncompressedSpectrum);
            for (int i = 0; i < nPeaks; ++i) {
                mz[i] = byteBuffer.getDouble();
                intensity[i] = byteBuffer.getDouble();
            }
        }
        Precursor precursor = new Precursor(precursorRt, precursorMz, precursorIntensity, charges);
        return new Spectrum(precursor, mz, intensity, spectrumLevel);
    }

    public Spectrum getSpectrum(String spectrumTitle) {
        long index = this.indexMap.get(spectrumTitle);
        return this.getSpectrum(index);
    }

    public Precursor getPrecursor(String spectrumTitle) {
        long spectrumIndex = this.indexMap.get(spectrumTitle);
        this.mutex.acquire();
        MappedByteBuffer mappedByteBuffer = this.getMappedByteBuffer(spectrumIndex);
        double precursorMz = mappedByteBuffer.getDouble();
        double precursorRt = mappedByteBuffer.getDouble();
        double precursorIntensity = mappedByteBuffer.getDouble();
        mappedByteBuffer.getInt();
        int compressedDataLength = mappedByteBuffer.getInt();
        mappedByteBuffer.position(mappedByteBuffer.position() + compressedDataLength + 4);
        int nCharges = mappedByteBuffer.getInt();
        int[] charges = new int[nCharges];
        for (int i = 0; i < nCharges; ++i) {
            charges[i] = mappedByteBuffer.getInt();
        }
        this.mutex.release();
        Precursor precursor = new Precursor(precursorRt, precursorMz, precursorIntensity, charges);
        return precursor;
    }

    public double getPrecursorMz(String spectrumTitle) {
        Double precursorMz = this.precursorMzMap.get(spectrumTitle);
        if (precursorMz == null) {
            long spectrumIndex = this.indexMap.get(spectrumTitle);
            this.mutex.acquire();
            MappedByteBuffer mappedByteBuffer = this.getMappedByteBuffer(spectrumIndex);
            precursorMz = mappedByteBuffer.getDouble();
            this.precursorMzMap.put(spectrumTitle, precursorMz);
            this.mutex.release();
        }
        return precursorMz;
    }

    public double getPrecursorRt(String spectrumTitle) {
        long spectrumIndex = this.indexMap.get(spectrumTitle);
        this.mutex.acquire();
        MappedByteBuffer mappedByteBuffer = this.getMappedByteBuffer(spectrumIndex);
        mappedByteBuffer.getDouble();
        double precursorRt = mappedByteBuffer.getDouble();
        this.mutex.release();
        return precursorRt;
    }

    public int getSpectrumLevel(String spectrumTitle) {
        long spectrumIndex = this.indexMap.get(spectrumTitle);
        this.mutex.acquire();
        MappedByteBuffer mappedByteBuffer = this.getMappedByteBuffer(spectrumIndex);
        mappedByteBuffer.getDouble();
        mappedByteBuffer.getDouble();
        mappedByteBuffer.getDouble();
        int spectrumLevel = mappedByteBuffer.getInt();
        this.mutex.release();
        return spectrumLevel;
    }

    public double[][] getPeaks(String spectrumTitle) {
        long spectrumIndex = this.indexMap.get(spectrumTitle);
        this.mutex.acquire();
        MappedByteBuffer mappedByteBuffer = this.getMappedByteBuffer(spectrumIndex);
        mappedByteBuffer.getDouble();
        mappedByteBuffer.getDouble();
        mappedByteBuffer.getDouble();
        int compressedDataLength = mappedByteBuffer.getInt();
        int nPeaks = mappedByteBuffer.getInt();
        byte[] compressedSpectrum = new byte[compressedDataLength];
        mappedByteBuffer.get(compressedSpectrum);
        this.mutex.release();
        int uncompressedLength = nPeaks * 2 * 8;
        byte[] uncompressedSpectrum = CmsFileReader.uncompress(compressedSpectrum, uncompressedLength);
        ByteBuffer byteBuffer = ByteBuffer.wrap(uncompressedSpectrum);
        double[][] peaks = new double[nPeaks][2];
        for (int i = 0; i < nPeaks; ++i) {
            peaks[i][0] = byteBuffer.getDouble();
            peaks[i][1] = byteBuffer.getDouble();
        }
        return peaks;
    }

    public static byte[] uncompress(byte[] compressedByteArray, int uncompressedLength) {
        ZstdDecompressor decompressor = new ZstdDecompressor();
        byte[] uncompressedByteAray = ZstdUtils.zstdDecompress(decompressor, compressedByteArray, uncompressedLength);
        return uncompressedByteAray;
    }

    @Override
    public Spectrum getSpectrum(String fileName, String spectrumTitle) {
        return this.getSpectrum(spectrumTitle);
    }

    @Override
    public Precursor getPrecursor(String fileName, String spectrumTitle) {
        return this.getPrecursor(spectrumTitle);
    }

    @Override
    public double getPrecursorMz(String fileName, String spectrumTitle) {
        return this.getPrecursorMz(spectrumTitle);
    }

    @Override
    public double getPrecursorRt(String fileName, String spectrumTitle) {
        return this.getPrecursorRt(spectrumTitle);
    }

    @Override
    public int getSpectrumLevel(String fileName, String spectrumTitle) {
        return this.getSpectrumLevel(spectrumTitle);
    }

    @Override
    public double[][] getPeaks(String fileName, String spectrumTitle) {
        return this.getPeaks(spectrumTitle);
    }

    @Override
    public double getMinPrecMz(String fileName) {
        return this.minMz;
    }

    @Override
    public double getMaxPrecMz(String fileName) {
        return this.maxMz;
    }

    @Override
    public double getMaxPrecInt(String fileName) {
        return this.maxInt;
    }

    @Override
    public double getMaxPrecRT(String fileName) {
        return this.maxRt;
    }

    @Override
    public double getMinPrecMz() {
        return this.minMz;
    }

    @Override
    public double getMaxPrecMz() {
        return this.maxMz;
    }

    @Override
    public double getMaxPrecInt() {
        return this.maxInt;
    }

    @Override
    public double getMaxPrecRT() {
        return this.maxRt;
    }

    @Override
    public String[] getOrderedFileNamesWithoutExtensions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HashMap<String, String> getFilePaths() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HashMap<String, String> getCmsFilePaths() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        try {
            for (MappedByteBuffer mappedByteBuffer : this.mappedByteBuffers) {
                IoUtil.closeBuffer(mappedByteBuffer);
            }
            this.raf.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getSpectrumTitles(String fileName) {
        return this.titles;
    }

    @Override
    public ArrayList<String> getPostcursorSpectrumTitles(String fileNameWithoutExtension, String spectrumTitle) {
        if (this.postcursorMap == null || !this.postcursorMap.containsKey(spectrumTitle)) {
            return null;
        }
        return this.postcursorMap.get(spectrumTitle);
    }

    private MappedByteBuffer getMappedByteBuffer(long spectrumIndex) {
        MappedByteBuffer mappedByteBuffer = null;
        if (this.bufferStartIndexes.size() == 1) {
            long startIndex = this.bufferStartIndexes.get(0);
            mappedByteBuffer = this.mappedByteBuffers.get(0);
            mappedByteBuffer.position((int)(spectrumIndex - startIndex));
            return mappedByteBuffer;
        }
        for (int i = 1; i < this.bufferStartIndexes.size(); ++i) {
            long startIndex = this.bufferStartIndexes.get(i - 1);
            long endIndex = this.bufferStartIndexes.get(i);
            if (spectrumIndex < startIndex || spectrumIndex >= endIndex) continue;
            mappedByteBuffer = this.mappedByteBuffers.get(i - 1);
            mappedByteBuffer.position((int)(spectrumIndex - startIndex));
            return mappedByteBuffer;
        }
        if (mappedByteBuffer == null) {
            long startIndex = this.bufferStartIndexes.get(this.bufferStartIndexes.size() - 1);
            mappedByteBuffer = this.mappedByteBuffers.get(this.bufferStartIndexes.size() - 1);
            mappedByteBuffer.position((int)(spectrumIndex - startIndex));
            return mappedByteBuffer;
        }
        return null;
    }
}

