/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.mgf;

import com.compomics.util.experiment.io.mass_spectrometry.mgf.IndexedMgfReader;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfIndex;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class MgfFileUtils {
    public static final String[] EXTENSIONS = new String[]{".mgf", ".mgf.gz"};

    public static void removeDuplicateSpectrumTitles(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        String lineBreak = System.getProperty("line.separator");
        try (BufferedRandomAccessFile br = new BufferedRandomAccessFile(mgfFile, "r", 102400);){
            long progressUnit = br.length() / 100L;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(tempSpectrumFile));){
                String line;
                String currentSpectrum = "";
                boolean includeSpectrum = true;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("BEGIN IONS")) {
                        currentSpectrum = line + lineBreak;
                        if (waitingHandler == null) continue;
                        if (waitingHandler.isRunCanceled()) {
                            break;
                        }
                        waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                        continue;
                    }
                    if (line.startsWith("TITLE")) {
                        currentSpectrum = currentSpectrum + line + lineBreak;
                        String title = line.substring(line.indexOf(61) + 1).trim();
                        if (!spectrumTitles.contains(title)) {
                            spectrumTitles.add(title);
                            includeSpectrum = true;
                            continue;
                        }
                        includeSpectrum = false;
                        continue;
                    }
                    if (line.startsWith("END IONS")) {
                        currentSpectrum = currentSpectrum + line + lineBreak;
                        if (!includeSpectrum) continue;
                        bw.write(currentSpectrum);
                        bw.newLine();
                        continue;
                    }
                    currentSpectrum = currentSpectrum + line + lineBreak;
                }
            }
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    public static void addMissingSpectrumTitles(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        try (BufferedRandomAccessFile br = new BufferedRandomAccessFile(mgfFile, "r", 102400);){
            String lineBreak = System.getProperty("line.separator");
            long progressUnit = br.length() / 100L;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(tempSpectrumFile));){
                String line;
                String currentSpectrum = "";
                String title = null;
                int spectrumCounter = 0;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("BEGIN IONS")) {
                        ++spectrumCounter;
                        if (waitingHandler == null) continue;
                        if (waitingHandler.isRunCanceled()) {
                            break;
                        }
                        waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                        continue;
                    }
                    if (line.startsWith("TITLE")) {
                        currentSpectrum = currentSpectrum + line + lineBreak;
                        title = line.substring(line.indexOf(61) + 1).trim();
                        spectrumTitles.add(title);
                        continue;
                    }
                    if (line.startsWith("END IONS")) {
                        bw.write("BEGIN IONS" + lineBreak);
                        if (title == null) {
                            title = "Spectrum " + spectrumCounter;
                            while (spectrumTitles.contains(title)) {
                                title = "Spectrum " + ++spectrumCounter;
                            }
                            spectrumTitles.add(title);
                            bw.write("TITLE=" + title + lineBreak);
                        }
                        bw.write(currentSpectrum);
                        bw.write("END IONS" + lineBreak);
                        currentSpectrum = "";
                        title = null;
                        continue;
                    }
                    currentSpectrum = currentSpectrum + line + lineBreak;
                }
            }
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    public static void addMissingPrecursorCharges(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        UtilitiesUserParameters userPreferences = UtilitiesUserParameters.loadUserParameters();
        try (BufferedRandomAccessFile br = new BufferedRandomAccessFile(mgfFile, "r", 102400);){
            String lineBreak = System.getProperty("line.separator");
            long progressUnit = br.length() / 100L;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(tempSpectrumFile));){
                String line;
                boolean chargeFound = false;
                boolean insideSpectrum = false;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("BEGIN IONS")) {
                        insideSpectrum = true;
                        chargeFound = false;
                        if (waitingHandler != null) {
                            if (waitingHandler.isRunCanceled()) {
                                break;
                            }
                            waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                        }
                    } else if (line.startsWith("END IONS")) {
                        insideSpectrum = false;
                    } else if (line.startsWith("CHARGE")) {
                        chargeFound = true;
                    } else if (!line.equals("") && insideSpectrum && !chargeFound) {
                        try {
                            String[] values = line.split("\\s+");
                            Double.parseDouble(values[0]);
                            Double.parseDouble(values[1]);
                            bw.write("CHARGE=");
                            for (int i = userPreferences.getMinSpectrumChargeRange(); i <= userPreferences.getMaxSpectrumChargeRange(); ++i) {
                                if (i > userPreferences.getMinSpectrumChargeRange()) {
                                    bw.write(" and ");
                                }
                                bw.write(i + "+");
                            }
                            bw.write(lineBreak);
                            chargeFound = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    bw.write(line);
                    bw.write(lineBreak);
                }
            }
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    public static void removeZeroes(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        try (BufferedRandomAccessFile br = new BufferedRandomAccessFile(mgfFile, "r", 102400);){
            long progressUnit = br.length() / 100L;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(tempSpectrumFile));){
                String line;
                boolean spectrum = false;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("BEGIN IONS")) {
                        spectrum = true;
                        if (waitingHandler != null) {
                            if (waitingHandler.isRunCanceled()) {
                                break;
                            }
                            waitingHandler.setSecondaryProgressCounter((int)(br.getFilePointer() / progressUnit));
                        }
                    } else if (line.startsWith("END IONS")) {
                        spectrum = false;
                    }
                    boolean peak = true;
                    boolean zero = false;
                    String[] split = line.split(" ");
                    if (split.length != 2 && split.length != 3 && (split = line.split("\t")).length != 2 && split.length != 3) {
                        peak = false;
                    }
                    if (peak) {
                        try {
                            Double.parseDouble(split[0]);
                        }
                        catch (Exception e) {
                            peak = false;
                        }
                        if (peak) {
                            try {
                                Double intensity = Double.valueOf(split[1]);
                                if (intensity == 0.0) {
                                    zero = true;
                                }
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("Line not recognized:\n" + line);
                            }
                        }
                    }
                    if (spectrum && peak && zero) continue;
                    bw.write(line);
                    bw.newLine();
                }
            }
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    public static void renameDuplicateSpectrumTitles(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        File tempSpectrumFile = new File(mgfFile.getParentFile(), mgfFile.getName() + "_temp");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(tempSpectrumFile));
             BufferedReader br = new BufferedReader(new FileReader(mgfFile));){
            String lineBreak = System.getProperty("line.separator");
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("TITLE")) {
                    String originalTitle;
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                        break;
                    }
                    String tempTitle = originalTitle = line.substring(line.indexOf(61) + 1).trim();
                    int counter = 2;
                    while (spectrumTitles.contains(tempTitle)) {
                        tempTitle = originalTitle + " (" + counter++ + ")";
                    }
                    spectrumTitles.add(tempTitle);
                    bw.write("TITLE=" + tempTitle + lineBreak);
                } else {
                    bw.write(line + lineBreak);
                }
                line = br.readLine();
            }
        }
        String orignalFilePath = mgfFile.getAbsolutePath();
        boolean fileDeleted = mgfFile.delete();
        if (!fileDeleted) {
            throw new IOException("Failed to delete the original spectrum file.");
        }
        boolean fileRenamed = tempSpectrumFile.renameTo(new File(orignalFilePath));
        if (!fileRenamed) {
            throw new IOException("Failed to replace the original spectrum file.");
        }
    }

    public static ArrayList<MgfIndex> splitFile(File mgfFile, int nSpectra, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String fileName = mgfFile.getName();
        if (fileName.toLowerCase().endsWith(".mgf")) {
            String line;
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(100);
                waitingHandler.setSecondaryProgressCounter(0);
            }
            String splittedName = fileName.substring(0, fileName.lastIndexOf("."));
            ArrayList<File> splittedFiles = new ArrayList<File>();
            int fileCounter = 1;
            int spectrumCounter = 0;
            String currentName = splittedName + "_" + fileCounter + ".mgf";
            File testFile = new File(mgfFile.getParent(), currentName);
            splittedFiles.add(testFile);
            BufferedRandomAccessFile writeBufferedRandomAccessFile = new BufferedRandomAccessFile(testFile, "rw", 102400);
            BufferedRandomAccessFile readBufferedRandomAccessFile = new BufferedRandomAccessFile(mgfFile, "r", 102400);
            String lineBreak = System.getProperty("line.separator");
            long sizeOfReadAccessFile = readBufferedRandomAccessFile.length();
            long lastIndex = 0L;
            long progressUnit = sizeOfReadAccessFile / 100L;
            while ((line = readBufferedRandomAccessFile.getNextLine()) != null) {
                if (line.endsWith("\r")) {
                    line = line.replace("\r", "");
                }
                if (line.startsWith("BEGIN IONS")) {
                    long readIndex = readBufferedRandomAccessFile.getFilePointer();
                    if (++spectrumCounter > nSpectra && sizeOfReadAccessFile - readIndex > (readIndex - lastIndex) / 2L) {
                        writeBufferedRandomAccessFile.close();
                        currentName = splittedName + "_" + ++fileCounter + ".mgf";
                        testFile = new File(mgfFile.getParent(), currentName);
                        splittedFiles.add(testFile);
                        lastIndex = readIndex;
                        spectrumCounter = 0;
                        writeBufferedRandomAccessFile = new BufferedRandomAccessFile(testFile, "rw", 102400);
                    }
                    if (waitingHandler != null) {
                        if (waitingHandler.isRunCanceled()) break;
                        waitingHandler.setSecondaryProgressCounter((int)(readIndex / progressUnit));
                    }
                }
                writeBufferedRandomAccessFile.writeBytes(line + lineBreak);
            }
            writeBufferedRandomAccessFile.close();
            readBufferedRandomAccessFile.close();
            ArrayList<MgfIndex> mgfIndexes = new ArrayList<MgfIndex>();
            for (int i = 0; i < splittedFiles.size(); ++i) {
                File newFile = (File)splittedFiles.get(i);
                if (waitingHandler != null) {
                    waitingHandler.setWaitingText("Indexing New Files " + (i + 1) + "/" + splittedFiles.size() + ". Please Wait...");
                }
                mgfIndexes.add(IndexedMgfReader.getMgfIndex(newFile, waitingHandler));
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
            }
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
            return mgfIndexes;
        }
        throw new IllegalArgumentException("Spectrum file format not supported.");
    }
}

