/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.mgf;

import com.compomics.util.experiment.biology.ions.Charge;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.flat.SimpleFileWriter;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MgfFileWriter
implements AutoCloseable {
    private final SimpleFileWriter writer;

    public MgfFileWriter() {
        this.writer = null;
    }

    public MgfFileWriter(File destinationFile) {
        this.writer = new SimpleFileWriter(destinationFile, false);
    }

    public void writeSpectrum(String spectrumTitle, Spectrum spectrum) {
        String toWrite = MgfFileWriter.asMgf(spectrumTitle, spectrum);
        this.writer.write(toWrite, true);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public static String asMgf(String spectrumTitle, Spectrum spectrum) {
        return MgfFileWriter.asMgf(spectrumTitle, spectrum, null);
    }

    public static String asMgf(String spectrumTitle, Spectrum spectrum, TreeMap<String, String> additionalTags) {
        StringBuilder result = new StringBuilder();
        String lineBreak = System.getProperty("line.separator");
        result.append("BEGIN IONS").append(lineBreak);
        if (additionalTags != null) {
            for (Map.Entry<String, String> tag : additionalTags.entrySet()) {
                result.append(tag.getKey()).append("=").append(tag.getValue()).append(lineBreak);
            }
        }
        result.append("TITLE=").append(spectrumTitle).append(lineBreak);
        Precursor precursor = spectrum.precursor;
        result.append("RTINSECONDS=").append(precursor.rt).append(lineBreak);
        result.append("PEPMASS=").append(precursor.mz);
        if (precursor.intensity > 0.0) {
            result.append(" ").append(precursor.intensity);
        }
        result.append(lineBreak);
        if (precursor.possibleCharges.length > 0) {
            result.append("CHARGE=");
            result.append(Arrays.stream(precursor.possibleCharges).sorted().mapToObj(charge -> Charge.toString(charge)).collect(Collectors.joining(" and ")));
            result.append(lineBreak);
        }
        IntStream.range(0, spectrum.getNPeaks()).forEach(i -> result.append(spectrum.mz[i]).append(' ').append(spectrum.intensity[i]).append(lineBreak));
        result.append("END IONS").append(lineBreak);
        return result.toString();
    }
}

