/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.spectrumcounting;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ScalingFactorsEstimators {
    private final SpectrumCountingParameters spectrumCountingParameters;

    public ScalingFactorsEstimators() {
        this.spectrumCountingParameters = null;
    }

    public ScalingFactorsEstimators(SpectrumCountingParameters spectrumCountingParameters) {
        this.spectrumCountingParameters = spectrumCountingParameters;
    }

    public void estimateScalingFactors(Identification identification, Metrics metrics, SequenceProvider sequenceProvider, IdentificationFeaturesGenerator identificationFeaturesGenerator, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, ProcessingParameters processingParameters) throws InterruptedException, TimeoutException {
        ExecutorService pool = Executors.newFixedThreadPool(processingParameters.getnThreads());
        ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(waitingHandler);
        ArrayList<ScalingRunnable> runnables = new ArrayList<ScalingRunnable>(processingParameters.getnThreads());
        for (int i = 1; i <= processingParameters.getnThreads(); ++i) {
            ScalingRunnable runnable = new ScalingRunnable(proteinMatchesIterator, sequenceProvider, identificationFeaturesGenerator, waitingHandler, exceptionHandler);
            pool.submit(runnable);
            runnables.add(runnable);
        }
        if (waitingHandler.isRunCanceled()) {
            pool.shutdownNow();
            return;
        }
        pool.shutdown();
        if (!pool.awaitTermination(identification.getProteinIdentification().size(), TimeUnit.MINUTES)) {
            throw new InterruptedException("Protein matches validation timed out. Please contact the developers.");
        }
        metrics.setTotalSpectrumCounting(runnables.stream().mapToDouble(ScalingRunnable::getTotalSpectrumCounting).sum());
        metrics.setTotalSpectrumCountingMass(runnables.stream().mapToDouble(ScalingRunnable::getTotalSpectrumCountingMass).sum());
    }

    private class ScalingRunnable
    implements Runnable {
        private final ProteinMatchesIterator proteinMatchesIterator;
        private final SequenceProvider sequenceProvider;
        private final IdentificationFeaturesGenerator identificationFeaturesGenerator;
        private final WaitingHandler waitingHandler;
        private final ExceptionHandler exceptionHandler;
        private double totalSpectrumCountingMass = 0.0;
        private double totalSpectrumCounting = 0.0;

        public ScalingRunnable(ProteinMatchesIterator proteinMatchesIterator, SequenceProvider sequenceProvider, IdentificationFeaturesGenerator identificationFeaturesGenerator, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
            this.proteinMatchesIterator = proteinMatchesIterator;
            this.sequenceProvider = sequenceProvider;
            this.identificationFeaturesGenerator = identificationFeaturesGenerator;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void run() {
            try {
                ProteinMatch proteinMatch;
                while ((proteinMatch = this.proteinMatchesIterator.next()) != null && !this.waitingHandler.isRunCanceled()) {
                    long proteinKey = proteinMatch.getKey();
                    PSParameter psParameter = new PSParameter();
                    psParameter = (PSParameter)proteinMatch.getUrParam(psParameter);
                    if (!proteinMatch.isDecoy() && psParameter.getMatchValidationLevel().getIndex() >= ScalingFactorsEstimators.this.spectrumCountingParameters.getMatchValidationLevel()) {
                        double tempSpectrumCounting = this.identificationFeaturesGenerator.getSpectrumCounting(proteinKey);
                        this.totalSpectrumCounting += tempSpectrumCounting;
                        double molecularWeight = ProteinUtils.computeMolecularWeight(this.sequenceProvider.getSequence(proteinMatch.getLeadingAccession()));
                        double massContribution = molecularWeight * tempSpectrumCounting;
                        this.totalSpectrumCountingMass += massContribution;
                    }
                    if (!this.waitingHandler.isRunCanceled()) continue;
                    return;
                }
            }
            catch (Exception e) {
                this.exceptionHandler.catchException(e);
            }
        }

        public double getTotalSpectrumCountingMass() {
            return this.totalSpectrumCountingMass;
        }

        public double getTotalSpectrumCounting() {
            return this.totalSpectrumCounting;
        }
    }
}

