/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import java.awt.Color;

public class ReferenceArea {
    private String identifier;
    private String label;
    private double start;
    private double end;
    private Color areaColor;
    private float alpha;
    private boolean drawOnTop;
    private boolean drawLabel;
    private Color labelColor = Color.BLACK;
    private boolean boldFont = true;
    private Color borderColor = Color.LIGHT_GRAY;
    private float borderWidth = 0.2f;
    private double percentLength = 1.0;
    private boolean aboveXAxis = true;

    public ReferenceArea() {
    }

    public ReferenceArea(String identifier, String label, double start, double end, Color areaColor, float alpha, boolean drawOnTop, boolean drawLabel, boolean aboveXAxis) throws IllegalArgumentException {
        this.identifier = identifier;
        this.label = label;
        this.start = start;
        this.end = end;
        this.areaColor = areaColor;
        this.drawOnTop = drawOnTop;
        this.drawLabel = drawLabel;
        this.aboveXAxis = aboveXAxis;
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("The alpha transparency must be in the range 0.0f to 1.0f!");
        }
        this.alpha = alpha;
    }

    public ReferenceArea(String identifier, String label, double start, double end, Color areaColor, float alpha, boolean drawOnTop, boolean drawLabel, Color labelColor, boolean boldFont, Color borderColor, float borderWidth, double percentLength, boolean aboveXAxis) throws IllegalArgumentException {
        this.identifier = identifier;
        this.label = label;
        this.start = start;
        this.end = end;
        this.areaColor = areaColor;
        this.drawOnTop = drawOnTop;
        this.drawLabel = drawLabel;
        this.labelColor = labelColor;
        this.boldFont = boldFont;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
        this.percentLength = percentLength;
        this.aboveXAxis = aboveXAxis;
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("The alpha transparency has to be in the range 0.0f to 1.0f!");
        }
        this.alpha = alpha;
        if (percentLength < 0.0 || percentLength > 1.0) {
            throw new IllegalArgumentException("The percent length has to be in the range [0 - 100]!");
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public double getEnd() {
        return this.end;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    public Color getAreaColor() {
        return this.areaColor;
    }

    public void setAreaColor(Color areaColor) {
        this.areaColor = areaColor;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public boolean drawOnTop() {
        return this.drawOnTop;
    }

    public void setDrawOnTop(boolean drawOnTop) {
        this.drawOnTop = drawOnTop;
    }

    public boolean drawLabel() {
        return this.drawLabel;
    }

    public void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public boolean useBoldFont() {
        return this.boldFont;
    }

    public void setBoldFont(boolean boldFont) {
        this.boldFont = boldFont;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public double getPercentLength() {
        return this.percentLength;
    }

    public void setPercentLength(double percentLength) {
        this.percentLength = percentLength;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean isAboveXAxis() {
        return this.aboveXAxis;
    }

    public void setAboveXAxis(boolean aboveXAxis) {
        this.aboveXAxis = aboveXAxis;
    }
}

