/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.utils.user_choice;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public abstract class ListChooser
extends JDialog {
    public ArrayList<String> items;
    private boolean canceled = false;
    private final ArrayList<String> tableToolTips = new ArrayList();
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel itemsLabel;
    private JPanel itemsPanel;
    private JTable itemsTable;
    private JScrollPane itemsTableScrollPane;
    private JButton okButton;

    public ListChooser() {
    }

    protected ListChooser(Frame parent, ArrayList<String> items, String dialogTitle, String panelTitle, String instructionsLabel, boolean multipleSelection) {
        super(parent, true);
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("No item to select.");
        }
        this.initComponents();
        this.items = items;
        this.setUpGui(dialogTitle, panelTitle, instructionsLabel, multipleSelection);
        this.setLocationRelativeTo(parent);
    }

    protected ListChooser(JDialog parent, ArrayList<String> items, String dialogTitle, String panelTitle, String instructionsLabel, boolean multipleSelection) {
        super((Dialog)parent, true);
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("No item to select.");
        }
        this.initComponents();
        this.items = items;
        this.setUpGui(dialogTitle, panelTitle, instructionsLabel, multipleSelection);
        this.setLocationRelativeTo(parent);
    }

    private void setUpGui(String dialogTitle, String panelTitle, String instructionsLabel, boolean multipleSelection) {
        if (dialogTitle != null) {
            this.setTitle(dialogTitle);
        } else {
            this.setTitle("Selection");
        }
        if (panelTitle != null) {
            ((TitledBorder)this.itemsPanel.getBorder()).setTitle(panelTitle);
        }
        if (instructionsLabel != null) {
            this.itemsLabel.setText(instructionsLabel);
        }
        this.itemsTableScrollPane.getViewport().setOpaque(false);
        if (multipleSelection) {
            this.itemsTable.setSelectionMode(2);
        } else {
            this.itemsTable.setSelectionMode(0);
        }
    }

    protected abstract void formatTable();

    protected ArrayList<String> getTableTooltips() {
        return this.tableToolTips;
    }

    protected JTable getTable() {
        return this.itemsTable;
    }

    public void setUpTable() {
        this.formatTable();
        ((DefaultTableModel)this.itemsTable.getModel()).fireTableDataChanged();
        this.itemsTable.setRowSelectionInterval(0, 0);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getSelectedItem() {
        int row = this.itemsTable.getSelectedRow();
        String itemName = this.items.get(row);
        return itemName;
    }

    public HashSet<String> getSelectedItems() {
        return Arrays.stream(this.itemsTable.getSelectedRows()).mapToObj(row -> this.items.get(row)).collect(Collectors.toCollection(HashSet::new));
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.itemsPanel = new JPanel();
        this.itemsLabel = new JLabel();
        this.itemsTableScrollPane = new JScrollPane();
        this.itemsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ListChooser.this.tableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.setDefaultCloseOperation(2);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListChooser.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListChooser.this.okButtonActionPerformed(evt);
            }
        });
        this.itemsPanel.setBorder(BorderFactory.createTitledBorder("Possibilities"));
        this.itemsPanel.setOpaque(false);
        this.itemsLabel.setText("Please select one of the following items:");
        this.itemsTable.setModel(new DefaultItemsTableModel());
        this.itemsTableScrollPane.setViewportView(this.itemsTable);
        GroupLayout itemsPanelLayout = new GroupLayout(this.itemsPanel);
        this.itemsPanel.setLayout(itemsPanelLayout);
        itemsPanelLayout.setHorizontalGroup(itemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(itemsPanelLayout.createSequentialGroup().addContainerGap().addGroup(itemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(itemsPanelLayout.createSequentialGroup().addComponent(this.itemsLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.itemsTableScrollPane, -1, 620, Short.MAX_VALUE)).addContainerGap()));
        itemsPanelLayout.setVerticalGroup(itemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(itemsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.itemsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.itemsTableScrollPane, -1, 211, Short.MAX_VALUE).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.itemsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.itemsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private class DefaultItemsTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (ListChooser.this.items == null) {
                return 0;
            }
            return ListChooser.this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ListChooser.this.items.get(row);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

