/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.enumeration.CompomicsTools;
import com.compomics.util.io.file.FileSystemAccessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesManager {
    Logger logger = LogManager.getLogger(PropertiesManager.class);
    private static PropertiesManager singleton = null;
    private final File iHomeFolder;

    private PropertiesManager() {
        File lHome = FileSystemAccessor.getHomeFolder();
        this.iHomeFolder = new File(lHome, ".compomics");
        if (!this.iHomeFolder.exists()) {
            this.iHomeFolder.mkdir();
        }
    }

    public File getApplicationFolder(CompomicsTools aTool) {
        File iApplicationFolder = new File(this.iHomeFolder, aTool.getName());
        if (!iApplicationFolder.exists()) {
            iApplicationFolder.mkdir();
        }
        return iApplicationFolder;
    }

    public static PropertiesManager getInstance() {
        if (singleton == null) {
            singleton = new PropertiesManager();
        }
        return singleton;
    }

    public static void main(String[] args) {
        new PropertiesManager();
    }

    public Properties getProperties(CompomicsTools aTool, String aPropertiesFileName) {
        Properties lProperties = new Properties();
        try {
            InputStream is = this.getResource(aPropertiesFileName);
            Properties lClassPathProperties = new Properties();
            lClassPathProperties.load(is);
            is.close();
            Object lVersion = lClassPathProperties.get("version");
            String lClassPathVersion = null;
            if (lVersion != null) {
                lClassPathVersion = lVersion.toString();
            }
            FilenameFilter lPropertiesFileNameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            };
            File lApplicationFolder = this.getApplicationFolder(aTool);
            File[] lPropertiesFiles = lApplicationFolder.listFiles(lPropertiesFileNameFilter);
            File lRequestedPropertiesFile = null;
            boolean lPropertiesFound = false;
            for (int i = 0; i < lPropertiesFiles.length; ++i) {
                File lLastFile = lPropertiesFiles[i];
                if (!lLastFile.getName().equals(aPropertiesFileName)) continue;
                lRequestedPropertiesFile = lLastFile;
                lPropertiesFound = true;
                break;
            }
            if (lPropertiesFound) {
                is = new FileInputStream(lRequestedPropertiesFile);
                lProperties.load(is);
                is.close();
            } else {
                try {
                    File lOutput = this.getFile(aTool, aPropertiesFileName);
                    if (!lOutput.exists()) {
                        lOutput.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(lOutput);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    lClassPathProperties.store(bos, aPropertiesFileName + " properties file");
                    fos.flush();
                    fos.close();
                    bos.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
            Set<Object> lClassPathPropertyKeySet = lClassPathProperties.keySet();
            boolean lRequireDiskUpdate = false;
            for (Object lClasspathKey : lClassPathPropertyKeySet) {
                if (lProperties.get(lClasspathKey) != null) continue;
                lProperties.put(lClasspathKey, lClassPathProperties.get(lClasspathKey));
                lRequireDiskUpdate = true;
            }
            if (lClassPathVersion != null) {
                lProperties.put("version", lClassPathVersion);
                lRequireDiskUpdate = true;
            }
            if (lRequireDiskUpdate) {
                this.storeProperties(aPropertiesFileName, aTool, lProperties);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return lProperties;
    }

    private InputStream getResource(String aResourceFilename) {
        InputStream is = ClassLoader.getSystemResourceAsStream(aResourceFilename);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(aResourceFilename);
        }
        return is;
    }

    public void updateProperties(CompomicsTools aTool, String aPropertiesFileName, Properties aNewProperties) {
        Properties lProperties = this.getProperties(aTool, aPropertiesFileName);
        for (Object aKey : aNewProperties.keySet()) {
            lProperties.put(aKey, aNewProperties.get(aKey));
        }
        this.storeProperties(aPropertiesFileName, aTool, lProperties);
    }

    private File getFile(CompomicsTools aTool, String aPropertiesFileName) {
        return new File(this.getApplicationFolder(aTool), aPropertiesFileName);
    }

    private void storeProperties(String aPropertiesFileName, CompomicsTools aTool, Properties lProperties) {
        File lOutput = this.getFile(aTool, aPropertiesFileName);
        try {
            if (!lOutput.exists()) {
                lOutput.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(lOutput);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            lProperties.store(bos, aPropertiesFileName + " properties file");
            fos.flush();
            fos.close();
            bos.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void updateLog4jConfiguration(Logger aLogger, CompomicsTools aCompomicsTools) throws IOException {
        throw new IOException("Method not implemented in utilities 5.0.16 and newer. Please reimplement if used.");
    }
}

