/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.features.peptideshaker;

import com.compomics.util.io.export.ExportFeature;
import java.util.ArrayList;
import java.util.Arrays;

public enum PsFragmentFeature implements ExportFeature
{
    annotation("Peak Annotation", "The fragment annotation as it would appear in the GUI.", false),
    fragment_type("Type", "The type of fragment ion, for example 'Peptide Fragment Ion'.", false),
    fragment_subType("Subtype", "The subtype of fragment if existing, for example 'b ion'.", false),
    fragment_number("Number", "The fragment ion number, for example '5' for b5.", false),
    fragment_losses("Neutral losses", "The fragment ion neutral losses, for example '-H2O' for b5-H2O.", false),
    fragment_name("Name", "The name of the fragment ion, for example b5.", false),
    fragment_charge("Fragment Charge", "The charge of the fragment ion according to the identification process.", false),
    theoretic_mz("Theoretic m/z", "The theoretic m/z of the fragment ion.", false),
    mz("m/z", "The m/z of the peak.", false),
    intensity("Intensity", "The intensity of the peak.", false),
    error_Da("m/z Error (Da)", "The absolute m/z error.", false),
    error_ppm("m/z Error (ppm)", "The relative m/z error (in ppm).", false);

    public String title;
    public String description;
    public static final String type = "Fragment Ions Summary";
    private final boolean advanced;

    private PsFragmentFeature(String title, String description, boolean advanced) {
        this.title = title;
        this.description = description;
        this.advanced = advanced;
    }

    @Override
    public ArrayList<ExportFeature> getExportFeatures(boolean includeSubFeatures) {
        ArrayList<ExportFeature> result = new ArrayList<ExportFeature>();
        result.addAll(Arrays.asList(PsFragmentFeature.values()));
        return result;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFeatureFamily() {
        return type;
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }
}

