/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math;

import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.BigMathUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashMap;
import org.apache.commons.math.util.FastMath;

public class BigFunctions {
    private static double logBase = 0.0;
    private static BigDecimal logBaseValue;
    private static final HashMap<BigInteger, BigInteger> factorialsCache;

    public static BigInteger factorial(BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) == -1) {
            throw new ArithmeticException("Attempting to calculate the factorial of a negative number.");
        }
        if (n.compareTo(BigInteger.ONE) != 1) {
            return BigInteger.ONE;
        }
        if (n.compareTo(new BigInteger("21")) == -1) {
            return new BigInteger(BasicMathFunctions.factorial(n.intValue()) + "");
        }
        if (n.compareTo(BigMathUtils.thousand.toBigInteger()) == -1) {
            BigInteger result = factorialsCache.get(n);
            if (result == null) {
                result = BigFunctions.estimateFactorial(n);
            }
            return result;
        }
        BigInteger nMinusOne = BigFunctions.factorial(n.subtract(BigInteger.ONE));
        return nMinusOne.multiply(n);
    }

    private static synchronized BigInteger estimateFactorial(BigInteger n) {
        BigInteger result = factorialsCache.get(n);
        if (result == null) {
            result = BigFunctions.factorial(n.subtract(BigInteger.ONE)).multiply(n);
            factorialsCache.put(n, result);
        }
        return result;
    }

    public static BigInteger factorial(BigInteger n, BigInteger k) {
        if (n.compareTo(k) == -1) {
            throw new ArithmeticException("n < k in n!/k!.");
        }
        if (n.compareTo(k) == 0) {
            return BigInteger.ONE;
        }
        return BigFunctions.factorial(n.subtract(BigInteger.ONE), k).multiply(n);
    }

    public static BigInteger getCombination(BigInteger k, BigInteger n) {
        if (k.compareTo(BigInteger.ZERO) == 0) {
            return BigInteger.ONE;
        }
        if (k.compareTo(n) == -1) {
            BigInteger numerator = BigFunctions.factorial(n, k);
            BigInteger denominator = BigFunctions.factorial(n.subtract(k));
            BigInteger result = numerator.divide(denominator);
            return result;
        }
        if (k.compareTo(n) == 0) {
            return BigInteger.ONE;
        }
        throw new IllegalArgumentException("n>k in combination.");
    }

    public static BigDecimal ln(BigDecimal bigDecimal, MathContext mathContext) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) != 1) {
            throw new IllegalArgumentException("Attempting to estimate the log of 0.");
        }
        if (bigDecimal.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        if (bigDecimal.compareTo(BigMathUtils.E) == 0) {
            return BigDecimal.ZERO;
        }
        int precision = mathContext.getPrecision();
        boolean inRange = false;
        double deltaInf = FastMath.pow((double)10.0, (double)(-precision - 1));
        if (precision < 300) {
            double deltaSup = FastMath.pow((double)10.0, (double)(-precision + 1));
            if (bigDecimal.compareTo(BigDecimal.ONE) == 1) {
                BigDecimal maxValue = new BigDecimal(Double.MAX_VALUE * (1.0 - deltaSup));
                if (bigDecimal.compareTo(maxValue) == -1) {
                    inRange = true;
                }
            } else {
                BigDecimal minValue = new BigDecimal(Double.MIN_NORMAL * (1.0 + deltaSup));
                if (bigDecimal.compareTo(minValue) == 1) {
                    inRange = true;
                }
            }
        }
        if (inRange) {
            double doubleValue = bigDecimal.doubleValue();
            double log = FastMath.log((double)doubleValue);
            double resolution = Math.abs(FastMath.pow((double)2.0, (double)-60.0) / log);
            if (resolution < deltaInf) {
                return new BigDecimal(log);
            }
        }
        return BigFunctions.lnBD(bigDecimal, mathContext);
    }

    public static BigDecimal lnBD(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal x;
        if (bigDecimal.compareTo(BigDecimal.ONE) == -1) {
            return BigFunctions.lnBD(BigDecimal.ONE.divide(bigDecimal, mathContext), mathContext).negate();
        }
        if (bigDecimal.compareTo(BigDecimal.TEN) == 1) {
            int k = -bigDecimal.scale();
            BigDecimal reducedDecimal = bigDecimal.movePointLeft(k);
            while (reducedDecimal.compareTo(BigDecimal.TEN) == 1) {
                reducedDecimal = reducedDecimal.movePointLeft(1);
                ++k;
            }
            MathContext lnMathContext = new MathContext(mathContext.getPrecision() + 1, mathContext.getRoundingMode());
            BigDecimal reducedLog = BigFunctions.lnBD(reducedDecimal, lnMathContext);
            int precisionIncrease = (int)FastMath.log10((double)k) + 1;
            int lnTenPrecisionNeeded = mathContext.getPrecision() + precisionIncrease;
            MathContext tenMathContext = new MathContext(lnTenPrecisionNeeded, mathContext.getRoundingMode());
            return BigMathUtils.getLn10(tenMathContext).multiply(new BigDecimal(k)).add(reducedLog);
        }
        if (bigDecimal.compareTo(BigMathUtils.E) == 1) {
            MathContext lnMathContext = new MathContext(mathContext.getPrecision() + 1, mathContext.getRoundingMode());
            BigDecimal logByE = BigFunctions.lnBD(bigDecimal.divide(BigMathUtils.E, lnMathContext), lnMathContext);
            return BigDecimal.ONE.add(logByE);
        }
        int precision = mathContext.getPrecision();
        MathContext tailorMathContext = new MathContext(precision + 2, mathContext.getRoundingMode());
        BigDecimal tailorDevelopment = BigDecimal.ZERO;
        BigDecimal xK = x = bigDecimal.subtract(BigDecimal.ONE).divide(bigDecimal.add(BigDecimal.ONE), mathContext);
        BigDecimal x2 = x.multiply(x);
        BigDecimal limit = new BigDecimal(BigInteger.ONE, precision);
        BigDecimal tailorFactor = BigDecimal.ONE;
        tailorDevelopment = tailorDevelopment.add(x);
        int n = 1;
        if (tailorFactor.compareTo(limit) == -1) {
            throw new IllegalArgumentException("Method not implemented for precision " + precision + ".");
        }
        while (tailorFactor.abs().compareTo(limit) != -1) {
            xK = xK.multiply(x2);
            tailorFactor = xK.divide(new BigDecimal(n += 2), tailorMathContext);
            tailorDevelopment = tailorDevelopment.add(tailorFactor);
        }
        tailorDevelopment = tailorDevelopment.multiply(BigMathUtils.two);
        return tailorDevelopment;
    }

    public static BigDecimal log(BigDecimal input, double base, MathContext mathContext) {
        if (base <= 0.0) {
            throw new IllegalArgumentException("Attempting to comupute logarithm of base " + base + ".");
        }
        if (base != logBase) {
            logBase = base;
            logBaseValue = BigFunctions.ln(new BigDecimal(base), mathContext);
        }
        return BigFunctions.ln(input, mathContext).divide(logBaseValue, mathContext);
    }

    public static BigDecimal exp(BigDecimal bigDecimal, MathContext mathContext) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ONE;
        }
        if (bigDecimal.compareTo(BigDecimal.ONE) == 0) {
            return BigMathUtils.E;
        }
        int precision = mathContext.getPrecision();
        boolean inRange = false;
        double deltaInf = FastMath.pow((double)10.0, (double)(-precision - 1));
        if (precision < 300) {
            double deltaSup = FastMath.pow((double)10.0, (double)(-precision + 1));
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 1) {
                double maxValue = FastMath.log((double)(Double.MAX_VALUE * (1.0 - deltaSup)));
                BigDecimal maxValueBD = new BigDecimal(maxValue);
                if (bigDecimal.compareTo(maxValueBD) == -1) {
                    inRange = true;
                }
            } else {
                double minValue = FastMath.log((double)(Double.MIN_NORMAL * (1.0 + deltaSup)));
                BigDecimal minValueBD = new BigDecimal(minValue);
                if (bigDecimal.compareTo(minValueBD) == 1) {
                    inRange = true;
                }
            }
        }
        if (inRange) {
            double doubleValue = bigDecimal.doubleValue();
            double exp = FastMath.exp((double)doubleValue);
            double resolution = Math.abs(FastMath.pow((double)2.0, (double)-60.0) / exp);
            if (resolution < deltaInf) {
                return new BigDecimal(exp);
            }
        }
        return BigFunctions.expBD(bigDecimal, mathContext);
    }

    public static BigDecimal getMaxExp(MathContext mathContext) {
        return BigMathUtils.getLn10(mathContext).multiply(new BigDecimal(Integer.MAX_VALUE));
    }

    public static BigDecimal expBD(BigDecimal x, MathContext mathContext) {
        int precision = mathContext.getPrecision();
        if (x.compareTo(BigDecimal.ZERO) == -1) {
            return BigDecimal.ONE.divide(BigFunctions.expBD(x.negate(), mathContext), mathContext);
        }
        if (x.compareTo(BigDecimal.ONE) == 1) {
            int k;
            BigDecimal powerTwo = BigDecimal.ONE;
            for (k = 1; k < 30 && powerTwo.compareTo(x) == -1; k *= 2) {
                powerTwo = powerTwo.multiply(BigMathUtils.two);
            }
            MathContext subExpMathContext = new MathContext(precision + 1, mathContext.getRoundingMode());
            BigDecimal reduced = x.divide(powerTwo, subExpMathContext);
            BigDecimal subExp = BigFunctions.expBD(reduced, subExpMathContext);
            BigDecimal result = subExp.pow(k);
            return result;
        }
        MathContext tailorMathContext = new MathContext(precision + 2, mathContext.getRoundingMode());
        BigDecimal tailorDevelopment = BigDecimal.ONE;
        BigDecimal xK = BigDecimal.ONE;
        BigDecimal tailorFactor = BigDecimal.ONE;
        BigDecimal limit = new BigDecimal(BigInteger.ONE, precision);
        BigDecimal factorial = BigDecimal.ONE;
        int n = 0;
        if (tailorFactor.compareTo(limit) == -1) {
            throw new IllegalArgumentException("Method not implemented for precision " + precision + ".");
        }
        while (tailorFactor.abs().compareTo(limit) != -1) {
            factorial = factorial.multiply(new BigDecimal(++n));
            xK = xK.multiply(x);
            tailorFactor = xK.divide(factorial, tailorMathContext);
            tailorDevelopment = tailorDevelopment.add(tailorFactor);
        }
        return tailorDevelopment;
    }

    public static BigDecimal pow(BigDecimal x1, BigDecimal x2, MathContext mathContext) {
        BigDecimal lnBigDecimal1 = BigFunctions.ln(x1, mathContext);
        BigDecimal x = lnBigDecimal1.multiply(x2);
        return BigFunctions.exp(x, mathContext);
    }

    static {
        factorialsCache = new HashMap(1000);
    }
}

