/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.advanced;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.ValidationQcParameters;

public class IdMatchValidationParameters
extends ExperimentObject {
    private double defaultProteinFDR = 1.0;
    private double defaultPeptideFDR = 1.0;
    private double defaultPsmFDR = 1.0;
    private ValidationQcParameters validationQCPreferences = new ValidationQcParameters();

    public IdMatchValidationParameters() {
    }

    public IdMatchValidationParameters(IdMatchValidationParameters idMatchValidationPreferences) {
        this.defaultProteinFDR = idMatchValidationPreferences.getDefaultProteinFDR();
        this.defaultPeptideFDR = idMatchValidationPreferences.getDefaultPeptideFDR();
        this.defaultPsmFDR = idMatchValidationPreferences.getDefaultPsmFDR();
        this.validationQCPreferences = new ValidationQcParameters(idMatchValidationPreferences.getValidationQCParameters());
    }

    public double getDefaultProteinFDR() {
        return this.defaultProteinFDR;
    }

    public void setDefaultProteinFDR(double defaultProteinFDR) {
        this.defaultProteinFDR = defaultProteinFDR;
    }

    public double getDefaultPeptideFDR() {
        return this.defaultPeptideFDR;
    }

    public void setDefaultPeptideFDR(double defaultPeptideFDR) {
        this.defaultPeptideFDR = defaultPeptideFDR;
    }

    public double getDefaultPsmFDR() {
        return this.defaultPsmFDR;
    }

    public void setDefaultPsmFDR(double defaultPsmFDR) {
        this.defaultPsmFDR = defaultPsmFDR;
    }

    public ValidationQcParameters getValidationQCParameters() {
        return this.validationQCPreferences;
    }

    public void setValidationQCParameters(ValidationQcParameters validationQCPreferences) {
        this.validationQCPreferences = validationQCPreferences;
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Protein FDR: ").append(this.defaultProteinFDR).append(".").append(newLine);
        output.append("Peptide FDR: ").append(this.defaultPeptideFDR).append(".").append(newLine);
        output.append("PSM FDR: ").append(this.defaultPsmFDR).append(".").append(newLine);
        return output.toString();
    }

    public boolean equals(IdMatchValidationParameters otherIdMatchValidationPreferences) {
        if (otherIdMatchValidationPreferences == null) {
            return false;
        }
        if (this.defaultProteinFDR != otherIdMatchValidationPreferences.getDefaultProteinFDR()) {
            return false;
        }
        if (this.defaultPeptideFDR != otherIdMatchValidationPreferences.getDefaultProteinFDR()) {
            return false;
        }
        if (this.defaultPsmFDR != otherIdMatchValidationPreferences.getDefaultProteinFDR()) {
            return false;
        }
        if (this.validationQCPreferences == null && otherIdMatchValidationPreferences.getValidationQCParameters() != null || this.validationQCPreferences != null && otherIdMatchValidationPreferences.getValidationQCParameters() == null) {
            return false;
        }
        return this.validationQCPreferences == null || otherIdMatchValidationPreferences.getValidationQCParameters() == null || this.validationQCPreferences.isSameAs(otherIdMatchValidationPreferences.getValidationQCParameters());
    }
}

