/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.software.cli.CommandLineUtils;
import eu.isas.peptideshaker.cmd.FollowUpCLIParams;
import eu.isas.peptideshaker.cmd.PathSettingsCLIInputBean;
import eu.isas.peptideshaker.followup.ProgenesisExport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public class FollowUpCLIInputBean {
    private File psdbFile = null;
    private File zipFile = null;
    private File recalibrationFolder = null;
    private int recalibrationMode = 0;
    private File spectrumExportFolder = null;
    private int spectrumExportTypeIndex = 0;
    private File accessionsExportFile = null;
    private int accessionsExportTypeIndex = 0;
    private File proteinSequencesExportFile = null;
    private int proteinSequencesExportTypeIndex = 0;
    private File progenesisExportFile = null;
    private int progenesisExportTypeIndex = 0;
    private File inclusionFile;
    private int inclusionFormat = 0;
    private ArrayList<Integer> inclusionProteinFilter;
    private ArrayList<Integer> inclusionPeptideFilter;
    private Double inclusionRtWindow = 20.0;
    private HashSet<String> progenesisTargetedPTMs = new HashSet();
    private File proteoformsFile = null;
    private String deepLcStem = null;
    private File percBenchResultsFile = null;
    private File ms2pipFile = null;
    private File percolatorRtFile = null;
    private File percolatorFragmentationFile = null;
    private File percolatorFile = null;
    private File rtPredsObsFile = null;
    private File peaksIntensitiesFile = null;
    private File psmIDsPeaksExportFile = null;
    private File psmIdentifiersFile = null;
    private String[] ms2pipModels = new String[]{"CID", "HCD", "HCDch2", "CIDch2"};
    private final PathSettingsCLIInputBean pathSettingsCLIInputBean;

    public FollowUpCLIInputBean(CommandLine aLine) {
        if (aLine.hasOption(FollowUpCLIParams.PSDB_FILE.id)) {
            String file = aLine.getOptionValue(FollowUpCLIParams.PSDB_FILE.id);
            if (file.toLowerCase().endsWith(".psdb")) {
                this.psdbFile = new File(file);
            } else if (file.toLowerCase().endsWith(".zip")) {
                this.zipFile = new File(file);
            } else {
                throw new IllegalArgumentException("Unknown file format '" + file + "' for PeptideShaker project input.");
            }
        }
        if (aLine.hasOption(FollowUpCLIParams.RECALIBRATION_FOLDER.id)) {
            this.recalibrationFolder = new File(aLine.getOptionValue(FollowUpCLIParams.RECALIBRATION_FOLDER.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.RECALIBRATION_MODE.id)) {
            this.recalibrationMode = Integer.valueOf(aLine.getOptionValue(FollowUpCLIParams.RECALIBRATION_MODE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.SPECTRUM_FOLDER.id)) {
            this.spectrumExportFolder = new File(aLine.getOptionValue(FollowUpCLIParams.SPECTRUM_FOLDER.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.PSM_TYPE.id)) {
            this.spectrumExportTypeIndex = Integer.valueOf(aLine.getOptionValue(FollowUpCLIParams.PSM_TYPE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.ACCESSIONS_FILE.id)) {
            this.accessionsExportFile = new File(aLine.getOptionValue(FollowUpCLIParams.ACCESSIONS_FILE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.ACCESSIONS_TYPE.id)) {
            this.accessionsExportTypeIndex = Integer.valueOf(aLine.getOptionValue(FollowUpCLIParams.ACCESSIONS_TYPE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.SEQUENCES_FILE.id)) {
            this.proteinSequencesExportFile = new File(aLine.getOptionValue(FollowUpCLIParams.SEQUENCES_FILE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.SEQUENCES_TYPE.id)) {
            this.proteinSequencesExportTypeIndex = Integer.valueOf(aLine.getOptionValue(FollowUpCLIParams.SEQUENCES_TYPE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.PROGENESIS_FILE.id)) {
            this.progenesisExportFile = new File(aLine.getOptionValue(FollowUpCLIParams.PROGENESIS_FILE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.PROGENESIS_TYPE.id)) {
            this.progenesisExportTypeIndex = Integer.valueOf(aLine.getOptionValue(FollowUpCLIParams.PROGENESIS_TYPE.id));
            if (this.progenesisExportTypeIndex == ProgenesisExport.ExportType.confident_ptms.index && aLine.hasOption(FollowUpCLIParams.PROGENESIS_TARGETED_PTMS.id)) {
                this.progenesisTargetedPTMs = this.getModificationNames(aLine.getOptionValue(FollowUpCLIParams.PROGENESIS_TARGETED_PTMS.id));
            }
        }
        if (aLine.hasOption(FollowUpCLIParams.INCLUSION_LIST_FILE.id)) {
            this.inclusionFile = new File(aLine.getOptionValue(FollowUpCLIParams.INCLUSION_LIST_FILE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.INCLUSION_LIST_FORMAT.id)) {
            this.inclusionFormat = Integer.valueOf(aLine.getOptionValue(FollowUpCLIParams.INCLUSION_LIST_FORMAT.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.INCLUSION_LIST_PROTEIN_FILTERS.id)) {
            this.inclusionProteinFilter = CommandLineUtils.getIntegerListFromString((String)aLine.getOptionValue(FollowUpCLIParams.INCLUSION_LIST_PROTEIN_FILTERS.id), (String)",");
        }
        if (aLine.hasOption(FollowUpCLIParams.INCLUSION_LIST_PEPTIDE_FILTERS.id)) {
            this.inclusionPeptideFilter = CommandLineUtils.getIntegerListFromString((String)aLine.getOptionValue(FollowUpCLIParams.INCLUSION_LIST_PEPTIDE_FILTERS.id), (String)",");
        }
        if (aLine.hasOption(FollowUpCLIParams.INCLUSION_LIST_RT_WINDOW.id)) {
            this.inclusionRtWindow = Double.valueOf(aLine.getOptionValue(FollowUpCLIParams.INCLUSION_LIST_RT_WINDOW.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.PROTEOFORMS_FILE.id)) {
            this.proteoformsFile = new File(aLine.getOptionValue(FollowUpCLIParams.PROTEOFORMS_FILE.id));
        }
        if (aLine.hasOption(FollowUpCLIParams.DEEPLC_FILE.id)) {
            this.deepLcStem = aLine.getOptionValue(FollowUpCLIParams.DEEPLC_FILE.id);
        }
        if (aLine.hasOption(FollowUpCLIParams.MS2PIP_FILE.id)) {
            String path = aLine.getOptionValue(FollowUpCLIParams.MS2PIP_FILE.id);
            if (!path.endsWith(".gz")) {
                path = path + ".gz";
            }
            this.ms2pipFile = new File(path);
        }
        if (aLine.hasOption(FollowUpCLIParams.MS2PIP_MODELS.id)) {
            this.ms2pipModels = aLine.getOptionValue(FollowUpCLIParams.MS2PIP_FILE.id).split(",");
        }
        if (aLine.hasOption(FollowUpCLIParams.PERCOLATOR_RT.id)) {
            this.percolatorRtFile = new File(aLine.getOptionValue(FollowUpCLIParams.PERCOLATOR_RT.id));
            if (!this.percolatorRtFile.exists()) {
                throw new IllegalArgumentException("Percolator RT file '" + this.percolatorRtFile + "' not found.");
            }
        }
        if (aLine.hasOption(FollowUpCLIParams.PERCOLATOR_FRAGMENTATION.id)) {
            this.percolatorFragmentationFile = new File(aLine.getOptionValue(FollowUpCLIParams.PERCOLATOR_FRAGMENTATION.id));
            if (!this.percolatorFragmentationFile.exists()) {
                throw new IllegalArgumentException("Percolator RT file '" + this.percolatorFragmentationFile + "' not found.");
            }
        }
        if (aLine.hasOption(FollowUpCLIParams.PERCOLATOR_FILE.id)) {
            this.percolatorFile = new File(aLine.getOptionValue(FollowUpCLIParams.PERCOLATOR_FILE.id));
            if (!this.percolatorFile.getParentFile().exists()) {
                throw new IllegalArgumentException("Folder where to write the percolator RT file '" + this.percolatorFile + "' not found.");
            }
        }
        if (aLine.hasOption(FollowUpCLIParams.RT_OBS_PRED.id)) {
            this.rtPredsObsFile = new File(aLine.getOptionValue(FollowUpCLIParams.RT_OBS_PRED.id));
            if (!this.rtPredsObsFile.getParentFile().exists()) {
                throw new IllegalArgumentException("Folder where to write the RT observed and predicted values file '" + this.rtPredsObsFile + "' not found.");
            }
        }
        if (aLine.hasOption(FollowUpCLIParams.PEAK_INTS_OBS_PRED.id)) {
            this.peaksIntensitiesFile = new File(aLine.getOptionValue(FollowUpCLIParams.PEAK_INTS_OBS_PRED.id));
            this.psmIDsPeaksExportFile = new File(aLine.getOptionValue(FollowUpCLIParams.PSM_IDS_FOR_PEAKS_EXPORT.id));
            if (!this.peaksIntensitiesFile.getParentFile().exists()) {
                throw new IllegalArgumentException("Folder where to write the peaks intensities observed values file '" + this.peaksIntensitiesFile + "' not found.");
            }
            if (!this.psmIDsPeaksExportFile.exists()) {
                throw new IllegalArgumentException("PSM identifiers file '" + this.psmIDsPeaksExportFile + "' not found.");
            }
        }
        if (aLine.hasOption(FollowUpCLIParams.PERCOLATOR_BENCHMARK_RESULTS.id)) {
            this.percBenchResultsFile = new File(aLine.getOptionValue(FollowUpCLIParams.PERCOLATOR_BENCHMARK_RESULTS.id));
            if (!this.percBenchResultsFile.getParentFile().exists()) {
                throw new IllegalArgumentException("Percolator results file '" + this.percBenchResultsFile + "' not found.");
            }
        }
        if (aLine.hasOption(FollowUpCLIParams.PSM_IDENTIFIERS_EXPORT.id)) {
            this.psmIdentifiersFile = new File(aLine.getOptionValue(FollowUpCLIParams.PSM_IDENTIFIERS_EXPORT.id));
            if (!this.psmIdentifiersFile.getParentFile().exists()) {
                throw new IllegalArgumentException("Percolator results file '" + this.psmIdentifiersFile + "' not found.");
            }
        }
        this.pathSettingsCLIInputBean = new PathSettingsCLIInputBean(aLine);
    }

    private HashSet<String> getModificationNames(String commandLineInput) {
        return Arrays.stream(commandLineInput.split(",")).map(name -> name.trim()).collect(Collectors.toCollection(HashSet::new));
    }

    public File getPsdbFile() {
        return this.psdbFile;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public File getRecalibrationFolder() {
        return this.recalibrationFolder;
    }

    public int getRecalibrationMode() {
        return this.recalibrationMode;
    }

    public File getSpectrumExportFolder() {
        return this.spectrumExportFolder;
    }

    public int getSpectrumExportTypeIndex() {
        return this.spectrumExportTypeIndex;
    }

    public File getAccessionsExportFile() {
        return this.accessionsExportFile;
    }

    public int getAccessionsExportTypeIndex() {
        return this.accessionsExportTypeIndex;
    }

    public File getProteinSequencesExportFile() {
        return this.proteinSequencesExportFile;
    }

    public int getProteinSequencesExportTypeIndex() {
        return this.proteinSequencesExportTypeIndex;
    }

    public File getProgenesisExportFile() {
        return this.progenesisExportFile;
    }

    public File getProteoformsFile() {
        return this.proteoformsFile;
    }

    public String getDeepLcStem() {
        return this.deepLcStem;
    }

    public File getMs2pipFile() {
        return this.ms2pipFile;
    }

    public String[] getMs2pipModels() {
        return this.ms2pipModels;
    }

    public File getPercolatorRtFile() {
        return this.percolatorRtFile;
    }

    public File getPercolatorFragmentationFile() {
        return this.percolatorFragmentationFile;
    }

    public File getPercolatorFile() {
        return this.percolatorFile;
    }

    public File getRTObsPredsFile() {
        return this.rtPredsObsFile;
    }

    public File getPeaksIntensitiesObsFile() {
        return this.peaksIntensitiesFile;
    }

    public File getPSMIDsPeaksExportFile() {
        return this.psmIDsPeaksExportFile;
    }

    public File getPercolatorBenchmarkResultsFile() {
        return this.percBenchResultsFile;
    }

    public File getPSMIdentifiersFile() {
        return this.psmIdentifiersFile;
    }

    public int getProgenesisExportTypeIndex() {
        return this.progenesisExportTypeIndex;
    }

    public HashSet<String> getProgenesisTargetedPTMs() {
        return this.progenesisTargetedPTMs;
    }

    public File getInclusionFile() {
        return this.inclusionFile;
    }

    public int getInclusionFormat() {
        return this.inclusionFormat;
    }

    public ArrayList<Integer> getInclusionProteinFilter() {
        if (this.inclusionProteinFilter == null) {
            this.inclusionProteinFilter = new ArrayList();
            this.inclusionProteinFilter.add(3);
        }
        return this.inclusionProteinFilter;
    }

    public ArrayList<Integer> getInclusionPeptideFilter() {
        if (this.inclusionPeptideFilter == null) {
            this.inclusionPeptideFilter = new ArrayList();
            this.inclusionPeptideFilter.add(0);
            this.inclusionPeptideFilter.add(1);
            this.inclusionPeptideFilter.add(2);
        }
        return this.inclusionPeptideFilter;
    }

    public Double getInclusionRtWindow() {
        return this.inclusionRtWindow;
    }

    public boolean followUpNeeded() {
        return this.recalibrationNeeded() || this.spectrumExportNeeded() || this.accessionExportNeeded() || this.proteinSequencesExportNeeded() || this.progenesisExportNeeded() || this.inclusionListNeeded() || this.proteoformsNeeded() || this.deepLcExportNeeded() || this.ms2pipExportNeeded();
    }

    public boolean recalibrationNeeded() {
        return this.recalibrationFolder != null;
    }

    public boolean spectrumExportNeeded() {
        return this.spectrumExportFolder != null;
    }

    public boolean accessionExportNeeded() {
        return this.accessionsExportFile != null;
    }

    public boolean proteinSequencesExportNeeded() {
        return this.proteinSequencesExportFile != null;
    }

    public boolean progenesisExportNeeded() {
        return this.progenesisExportFile != null;
    }

    public boolean inclusionListNeeded() {
        return this.inclusionFile != null;
    }

    public boolean proteoformsNeeded() {
        return this.proteoformsFile != null;
    }

    public boolean deepLcExportNeeded() {
        return this.deepLcStem != null;
    }

    public boolean ms2pipExportNeeded() {
        return this.ms2pipFile != null;
    }

    public boolean percolatorExportNeeded() {
        return this.percolatorFile != null;
    }

    public boolean RTValuesExportNeeded() {
        return this.rtPredsObsFile != null;
    }

    public boolean peaksIntensitiesObsExportNeeded() {
        return this.peaksIntensitiesFile != null;
    }

    public boolean PSMIdentifiersExportNeeded() {
        return this.psmIdentifiersFile != null;
    }

    public PathSettingsCLIInputBean getPathSettingsCLIInputBean() {
        return this.pathSettingsCLIInputBean;
    }
}

