/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.util.experiment.io.identification.MzIdentMLVersion;
import eu.isas.peptideshaker.cmd.FollowUpCLIParams;
import eu.isas.peptideshaker.cmd.MzidCLIParams;
import eu.isas.peptideshaker.cmd.PathSettingsCLIInputBean;
import java.io.File;
import org.apache.commons.cli.CommandLine;

public class MzidCLIInputBean {
    private File psdbFile;
    private File zipFile = null;
    private String contactFirstName;
    private String contactLastName;
    private String contactEmail;
    private String contactAddress;
    private String contactUrl;
    private String organizationName;
    private String organizationMail;
    private String organizationAddress;
    private String organizationUrl;
    private File outputFile = null;
    private Boolean includeProteinSequences;
    private final PathSettingsCLIInputBean pathSettingsCLIInputBean;
    private MzIdentMLVersion mzIdentMLVersion = MzIdentMLVersion.v1_1;
    private boolean gzip = false;

    public MzidCLIInputBean(CommandLine aLine) {
        int index;
        String input;
        if (aLine.hasOption(MzidCLIParams.PSDB_FILE.id)) {
            String file = aLine.getOptionValue(FollowUpCLIParams.PSDB_FILE.id);
            if (file.toLowerCase().endsWith(".psdb")) {
                this.psdbFile = new File(file);
            } else if (file.toLowerCase().endsWith(".zip")) {
                this.zipFile = new File(file);
            } else {
                throw new IllegalArgumentException("Unknown file format '" + file + "' for PeptideShaker project input.");
            }
        }
        if (aLine.hasOption(MzidCLIParams.CONTACT_FIRST_NAME.id)) {
            this.contactFirstName = aLine.getOptionValue(MzidCLIParams.CONTACT_FIRST_NAME.id);
        }
        if (aLine.hasOption(MzidCLIParams.CONTACT_LAST_NAME.id)) {
            this.contactLastName = aLine.getOptionValue(MzidCLIParams.CONTACT_LAST_NAME.id);
        }
        if (aLine.hasOption(MzidCLIParams.CONTACT_EMAIL.id)) {
            this.contactEmail = aLine.getOptionValue(MzidCLIParams.CONTACT_EMAIL.id);
        }
        if (aLine.hasOption(MzidCLIParams.CONTACT_ADDRESS.id)) {
            this.contactAddress = aLine.getOptionValue(MzidCLIParams.CONTACT_ADDRESS.id);
        }
        if (aLine.hasOption(MzidCLIParams.CONTACT_URL.id)) {
            this.contactUrl = aLine.getOptionValue(MzidCLIParams.CONTACT_URL.id);
        }
        if (aLine.hasOption(MzidCLIParams.ORGANIZATION_NAME.id)) {
            this.organizationName = aLine.getOptionValue(MzidCLIParams.ORGANIZATION_NAME.id);
        }
        if (aLine.hasOption(MzidCLIParams.ORGANIZATION_EMAIL.id)) {
            this.organizationMail = aLine.getOptionValue(MzidCLIParams.ORGANIZATION_EMAIL.id);
        }
        if (aLine.hasOption(MzidCLIParams.ORGANIZATION_ADDRESS.id)) {
            this.organizationAddress = aLine.getOptionValue(MzidCLIParams.ORGANIZATION_ADDRESS.id);
        }
        if (aLine.hasOption(MzidCLIParams.ORGANIZATION_URL.id)) {
            this.organizationUrl = aLine.getOptionValue(MzidCLIParams.ORGANIZATION_URL.id);
        }
        if (aLine.hasOption(MzidCLIParams.INCLUDE_PROTEIN_SEQUENCES.id)) {
            input = aLine.getOptionValue(MzidCLIParams.INCLUDE_PROTEIN_SEQUENCES.id);
            this.includeProteinSequences = input.trim().equals("1");
        }
        if (aLine.hasOption(MzidCLIParams.VERSION.id)) {
            input = aLine.getOptionValue(MzidCLIParams.VERSION.id);
            index = Integer.parseInt(input.trim());
            this.mzIdentMLVersion = MzIdentMLVersion.getMzIdentMLVersion((int)index);
        }
        if (aLine.hasOption(MzidCLIParams.OUTPUT_FILE.id)) {
            this.outputFile = new File(aLine.getOptionValue(MzidCLIParams.OUTPUT_FILE.id));
        }
        if (aLine.hasOption(MzidCLIParams.GZIP.id)) {
            input = aLine.getOptionValue(MzidCLIParams.GZIP.id);
            index = Integer.parseInt(input.trim());
            this.gzip = index == 1;
        }
        this.pathSettingsCLIInputBean = new PathSettingsCLIInputBean(aLine);
    }

    public File getPsdbFile() {
        return this.psdbFile;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public String getContactFirstName() {
        return this.contactFirstName;
    }

    public String getContactLastName() {
        return this.contactLastName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public String getContactAddress() {
        return this.contactAddress;
    }

    public String getContactUrl() {
        return this.contactUrl;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getOrganizationMail() {
        return this.organizationMail;
    }

    public String getOrganizationAddress() {
        return this.organizationAddress;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public boolean getIncludeProteinSequences() {
        if (this.includeProteinSequences == null) {
            this.includeProteinSequences = false;
        }
        return this.includeProteinSequences;
    }

    public MzIdentMLVersion getMzIdentMLVersion() {
        return this.mzIdentMLVersion;
    }

    public PathSettingsCLIInputBean getPathSettingsCLIInputBean() {
        return this.pathSettingsCLIInputBean;
    }

    public boolean isGzip() {
        return this.gzip;
    }
}

