/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsInputFilterFeature;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;

public class PsInputFilterSection {
    private final EnumSet<PsInputFilterFeature> exportFeatures;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsInputFilterSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        this.exportFeatures = EnumSet.noneOf(PsInputFilterFeature.class);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsInputFilterFeature) {
                this.exportFeatures.add((PsInputFilterFeature)exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Impossible to export " + exportFeature.getClass().getName() + " as input filter feature.");
        }
    }

    public void writeSection(PeptideAssumptionFilter idFilter, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            if (this.indexes) {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText("Parameter");
            this.writer.addSeparator();
            this.writer.writeHeaderText("Value");
            this.writer.newLine();
        }
        int line = 1;
        for (ExportFeature exportFeature : this.exportFeatures) {
            if (this.indexes) {
                this.writer.write(Integer.toString(line));
                this.writer.addSeparator();
            }
            this.writer.write(exportFeature.getTitle());
            this.writer.addSeparator();
            PsInputFilterFeature inputFilterFeatures = (PsInputFilterFeature)exportFeature;
            switch (inputFilterFeatures) {
                case max_mz_deviation: {
                    double value = idFilter.getMaxMzDeviation();
                    if (value == -1.0) {
                        this.writer.write("none");
                        break;
                    }
                    this.writer.write(Double.toString(value));
                    break;
                }
                case max_mz_deviation_unit: {
                    if (idFilter.isIsPpm()) {
                        this.writer.write("Yes");
                        break;
                    }
                    this.writer.write("No");
                    break;
                }
                case max_peptide_length: {
                    this.writer.write(Integer.toString(idFilter.getMaxPepLength()));
                    break;
                }
                case min_peptide_length: {
                    this.writer.write(Integer.toString(idFilter.getMinPepLength()));
                    break;
                }
                case unknown_PTM: {
                    if (idFilter.removeUnknownModifications()) {
                        this.writer.write("Yes");
                        break;
                    }
                    this.writer.write("No");
                    break;
                }
                default: {
                    this.writer.write("Not implemented");
                }
            }
            this.writer.newLine();
            ++line;
        }
    }
}

