/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.util.HashSet;

public class FastaExport {
    public static void export(File destinationFile, SequenceProvider sequenceProvider, Identification identification, ExportType exportType, WaitingHandler waitingHandler, boolean accessionOnly) {
        try (SimpleFileWriter writer = new SimpleFileWriter(destinationFile, false);){
            if (accessionOnly) {
                sequenceProvider.getAccessions().stream().filter(accession -> !ProteinUtils.isDecoy((String)accession, (SequenceProvider)sequenceProvider) && FastaExport.include(accession, exportType, identification)).forEach(accession -> {
                    writer.writeLine(accession);
                    waitingHandler.increaseSecondaryProgressCounter();
                });
            } else {
                sequenceProvider.getAccessions().stream().filter(accession -> !ProteinUtils.isDecoy((String)accession, (SequenceProvider)sequenceProvider) && FastaExport.include(accession, exportType, identification)).forEach(accession -> {
                    writer.writeLine(String.join((CharSequence)"", ">", sequenceProvider.getHeaderAsString(accession)));
                    writer.write(sequenceProvider.getSequence(accession), true);
                    waitingHandler.increaseSecondaryProgressCounter();
                });
            }
        }
    }

    private static boolean include(String accession, ExportType exportType, Identification identification) {
        HashSet proteinGroups = (HashSet)identification.getProteinMap().get(accession);
        if (proteinGroups == null) {
            return false;
        }
        switch (exportType.ordinal()) {
            case 2: {
                return proteinGroups.stream().map(key -> (PSParameter)identification.getProteinMatch(key.longValue()).getUrParam((UrParameter)PSParameter.dummy)).allMatch(psParameter -> !psParameter.getMatchValidationLevel().isValidated());
            }
            case 1: {
                return proteinGroups.stream().map(key -> (PSParameter)identification.getProteinMatch(key.longValue()).getUrParam((UrParameter)PSParameter.dummy)).anyMatch(psParameter -> psParameter.getMatchValidationLevel().isValidated());
            }
            case 0: {
                return proteinGroups.stream().map(key -> identification.getProteinMatch(key.longValue())).filter(proteinMatch -> proteinMatch.getLeadingAccession().equals(accession)).map(proteinMatch -> (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy)).anyMatch(psParameter -> psParameter.getMatchValidationLevel().isValidated());
            }
        }
        throw new UnsupportedOperationException("Export not implemented for " + (Object)((Object)exportType) + ".");
    }

    public static enum ExportType {
        validated_main_accession(0, "Main Accession of Validated Protein Groups"),
        validated_all_accessions(1, "All Accessions of Validated Protein Groups"),
        non_validated(2, "Non-Validated Accessions");

        public final int index;
        public final String description;

        private ExportType(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public static ExportType getTypeFromIndex(int index) {
            if (index == ExportType.validated_main_accession.index) {
                return validated_main_accession;
            }
            if (index == ExportType.validated_all_accessions.index) {
                return validated_all_accessions;
            }
            if (index == ExportType.non_validated.index) {
                return non_validated;
            }
            throw new IllegalArgumentException("Export type " + index + " not implemented.");
        }

        public static String[] getPossibilities() {
            return new String[]{ExportType.validated_main_accession.description, ExportType.validated_all_accessions.description, ExportType.non_validated.description};
        }

        public static String getCommandLineOptions() {
            return ExportType.validated_main_accession.index + ": " + ExportType.validated_main_accession.description + " (default), " + ExportType.validated_all_accessions.index + ": " + ExportType.validated_all_accessions.description + ", " + ExportType.non_validated.index + ": " + ExportType.non_validated.description + ".";
        }
    }
}

