/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.software.ToolFactory;
import com.compomics.software.autoupdater.DownloadLatestZipFromRepo;
import com.compomics.software.autoupdater.FileDAO;
import com.compomics.software.autoupdater.GUIFileDAO;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.autoupdater.WebDAO;
import com.compomics.software.dialogs.JavaHomeOrMemoryDialogParent;
import com.compomics.software.dialogs.JavaParametersDialog;
import com.compomics.software.dialogs.SearchGuiSetupDialog;
import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.DummyFrame;
import com.compomics.util.gui.error_handlers.BugReport;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.gui.NewDialog;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.pride.PrideReshakeGUI;
import eu.isas.peptideshaker.gui.start.GettingStartedDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.xml.stream.XMLStreamException;

public class WelcomeDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private static final DummyFrame DUMMY_PARENT_FRAME = new DummyFrame("", "/icons/peptide-shaker.gif");
    private ProgressDialogX progressDialog;
    private JMenuItem aboutMenuItem;
    private JPanel backgroundPanel;
    private JMenuItem bugReportMenuItem;
    private JButton compomicsButton;
    private JButton gettingStartedJButton1;
    private JMenuItem gettingStartedMenuItem;
    private JMenu helpMenu;
    private JButton isasButton;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JMenuItem javaSettingsMenuItem;
    private JLabel lowMemoryWarningLabel;
    private JButton newJButton;
    private JButton openExampleDatasetJButton;
    private JButton openJButton;
    private JMenuItem pathSettingsMenu;
    private JButton probeButton;
    private JButton quantifyJButton;
    private JLabel recentProjectsLabel;
    private JButton reshakeJButton;
    private JMenuItem searchGUISettingsMenuItem;
    private JButton searchJButton;
    private JLabel settingsLabel;
    private JMenu settingsMenu;
    private JPopupMenu settingsPopupMenu;
    private JMenu toolsMenu;

    public WelcomeDialog(PeptideShakerGUI peptideShakerGUI, boolean showLowMemoryWarning, boolean showJavaVersionWarning, boolean modal) {
        super((Frame)DUMMY_PARENT_FRAME.setNewTitle(peptideShakerGUI.getTitle()), modal);
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        if (!showLowMemoryWarning && !showJavaVersionWarning) {
            this.lowMemoryWarningLabel.setVisible(false);
        }
        if (showJavaVersionWarning) {
            this.lowMemoryWarningLabel.setText("<html><u>Java Version Warning!</u>");
        }
        if (peptideShakerGUI.getUtilitiesUserParameters().isAutoUpdate()) {
            Util.sendGAUpdate((String)"UA-36198780-1", (String)"toolstart", (String)("peptide-shaker-" + PeptideShaker.getVersion()));
        }
        this.setTitle(this.getTitle() + " " + PeptideShaker.getVersion());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.quantifyJButton = new JButton();
        this.settingsPopupMenu = new JPopupMenu();
        this.settingsMenu = new JMenu();
        this.javaSettingsMenuItem = new JMenuItem();
        this.pathSettingsMenu = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.searchGUISettingsMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.gettingStartedMenuItem = new JMenuItem();
        this.bugReportMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.aboutMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.openJButton = new JButton();
        this.newJButton = new JButton();
        this.compomicsButton = new JButton();
        this.probeButton = new JButton();
        this.isasButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.searchJButton = new JButton();
        this.recentProjectsLabel = new JLabel();
        this.reshakeJButton = new JButton();
        this.gettingStartedJButton1 = new JButton();
        this.openExampleDatasetJButton = new JButton();
        this.settingsLabel = new JLabel();
        this.lowMemoryWarningLabel = new JLabel();
        this.quantifyJButton.setFont(this.quantifyJButton.getFont().deriveFont(this.quantifyJButton.getFont().getStyle() | 1, this.quantifyJButton.getFont().getSize() + 3));
        this.quantifyJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/reporter_logo.png")));
        this.quantifyJButton.setText("Reporter Ions");
        this.quantifyJButton.setToolTipText("<html>\nQuantify your proteins using reporter ions<br>\n(Coming soon...)\n</html>");
        this.quantifyJButton.setFocusPainted(false);
        this.quantifyJButton.setHorizontalAlignment(2);
        this.quantifyJButton.setIconTextGap(11);
        this.quantifyJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.quantifyJButtonActionPerformed(evt);
            }
        });
        this.settingsMenu.setText("Settings");
        this.javaSettingsMenuItem.setText("Java Settings");
        this.javaSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.javaSettingsMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.javaSettingsMenuItem);
        this.pathSettingsMenu.setText("Resource Settings");
        this.pathSettingsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.pathSettingsMenuActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.pathSettingsMenu);
        this.toolsMenu.setText("Tools");
        this.searchGUISettingsMenuItem.setText("SearchGUI Settings");
        this.searchGUISettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.searchGUISettingsMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.searchGUISettingsMenuItem);
        this.settingsMenu.add(this.toolsMenu);
        this.settingsPopupMenu.add(this.settingsMenu);
        this.helpMenu.setText("Help");
        this.gettingStartedMenuItem.setText("Getting Started");
        this.gettingStartedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.gettingStartedMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.gettingStartedMenuItem);
        this.bugReportMenuItem.setText("Bug Report");
        this.bugReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.bugReportMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.bugReportMenuItem);
        this.helpMenu.add(this.jSeparator2);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.settingsPopupMenu.add(this.helpMenu);
        this.setDefaultCloseOperation(0);
        this.setTitle("Welcome to PeptideShaker");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WelcomeDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.openJButton.setFont(this.openJButton.getFont().deriveFont(this.openJButton.getFont().getStyle() | 1, this.openJButton.getFont().getSize() + 3));
        this.openJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/peptide-shaker-medium-blue-shadow.png")));
        this.openJButton.setText("Open Project");
        this.openJButton.setToolTipText("Open an existing PeptideShaker project");
        this.openJButton.setFocusPainted(false);
        this.openJButton.setHorizontalAlignment(2);
        this.openJButton.setIconTextGap(20);
        this.openJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.openJButtonActionPerformed(evt);
            }
        });
        this.newJButton.setFont(this.newJButton.getFont().deriveFont(this.newJButton.getFont().getStyle() | 1, this.newJButton.getFont().getSize() + 3));
        this.newJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/peptide-shaker-medium-orange-shadow.png")));
        this.newJButton.setText("New Project");
        this.newJButton.setToolTipText("Create a new PeptideShaker project");
        this.newJButton.setFocusPainted(false);
        this.newJButton.setHorizontalAlignment(2);
        this.newJButton.setIconTextGap(24);
        this.newJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.newJButtonActionPerformed(evt);
            }
        });
        this.compomicsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/compomics.png")));
        this.compomicsButton.setToolTipText("Computational Omics and Systems Biology Group");
        this.compomicsButton.setBorder(null);
        this.compomicsButton.setBorderPainted(false);
        this.compomicsButton.setContentAreaFilled(false);
        this.compomicsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WelcomeDialog.this.compomicsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WelcomeDialog.this.compomicsButtonMouseExited(evt);
            }
        });
        this.compomicsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.compomicsButtonActionPerformed(evt);
            }
        });
        this.probeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/probe-new.png")));
        this.probeButton.setToolTipText("Proteomics Unit at the University of Bergen");
        this.probeButton.setBorder(null);
        this.probeButton.setBorderPainted(false);
        this.probeButton.setContentAreaFilled(false);
        this.probeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WelcomeDialog.this.probeButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WelcomeDialog.this.probeButtonMouseExited(evt);
            }
        });
        this.probeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.probeButtonActionPerformed(evt);
            }
        });
        this.isasButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/isas-cropped.png")));
        this.isasButton.setToolTipText("<html>ISAS - Institute for Analytical Science</html>");
        this.isasButton.setBorder(null);
        this.isasButton.setBorderPainted(false);
        this.isasButton.setContentAreaFilled(false);
        this.isasButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WelcomeDialog.this.isasButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WelcomeDialog.this.isasButtonMouseExited(evt);
            }
        });
        this.isasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.isasButtonActionPerformed(evt);
            }
        });
        this.searchJButton.setFont(this.searchJButton.getFont().deriveFont(this.searchJButton.getFont().getStyle() | 1, this.searchJButton.getFont().getSize() + 3));
        this.searchJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/searchgui-medium-shadow.png")));
        this.searchJButton.setText("Start Search");
        this.searchJButton.setToolTipText("Start a SearchGUI protein identification search");
        this.searchJButton.setFocusPainted(false);
        this.searchJButton.setHorizontalAlignment(2);
        this.searchJButton.setIconTextGap(20);
        this.searchJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.searchJButtonActionPerformed(evt);
            }
        });
        this.recentProjectsLabel.setFont(this.recentProjectsLabel.getFont().deriveFont(this.recentProjectsLabel.getFont().getStyle() | 1));
        this.recentProjectsLabel.setText("<html><a href style=\"text-decoration: none\">Recent Projects</html>");
        this.recentProjectsLabel.setToolTipText("Open recently opened projects");
        this.recentProjectsLabel.setHorizontalTextPosition(10);
        this.recentProjectsLabel.setIconTextGap(-4);
        this.recentProjectsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WelcomeDialog.this.recentProjectsLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                WelcomeDialog.this.recentProjectsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WelcomeDialog.this.recentProjectsLabelMouseExited(evt);
            }
        });
        this.reshakeJButton.setFont(this.reshakeJButton.getFont().deriveFont(this.reshakeJButton.getFont().getStyle() | 1, this.reshakeJButton.getFont().getSize() + 3));
        this.reshakeJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/relims_logo.png")));
        this.reshakeJButton.setText("PRIDE Reshake");
        this.reshakeJButton.setToolTipText("<html>\nReanalyze PRIDE projects<br>\n</html>");
        this.reshakeJButton.setFocusPainted(false);
        this.reshakeJButton.setHorizontalAlignment(2);
        this.reshakeJButton.setIconTextGap(19);
        this.reshakeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.reshakeJButtonActionPerformed(evt);
            }
        });
        this.gettingStartedJButton1.setFont(this.gettingStartedJButton1.getFont().deriveFont(this.gettingStartedJButton1.getFont().getStyle() | 1, this.gettingStartedJButton1.getFont().getSize() + 3));
        this.gettingStartedJButton1.setIcon(new ImageIcon(this.getClass().getResource("/icons/help-medium-shadow.png")));
        this.gettingStartedJButton1.setText("Getting Started");
        this.gettingStartedJButton1.setToolTipText("Open the Getting Started tutorial");
        this.gettingStartedJButton1.setFocusPainted(false);
        this.gettingStartedJButton1.setHorizontalAlignment(2);
        this.gettingStartedJButton1.setIconTextGap(20);
        this.gettingStartedJButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.gettingStartedJButton1ActionPerformed(evt);
            }
        });
        this.openExampleDatasetJButton.setFont(this.openExampleDatasetJButton.getFont().deriveFont(this.openExampleDatasetJButton.getFont().getStyle() | 1, this.openExampleDatasetJButton.getFont().getSize() + 3));
        this.openExampleDatasetJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/peptideshaker_example_dataset.png")));
        this.openExampleDatasetJButton.setText("Open Example");
        this.openExampleDatasetJButton.setToolTipText("Opens a PeptideShaker example dataset");
        this.openExampleDatasetJButton.setFocusPainted(false);
        this.openExampleDatasetJButton.setHorizontalAlignment(2);
        this.openExampleDatasetJButton.setIconTextGap(19);
        this.openExampleDatasetJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WelcomeDialog.this.openExampleDatasetJButtonActionPerformed(evt);
            }
        });
        this.settingsLabel.setFont(this.settingsLabel.getFont().deriveFont(this.settingsLabel.getFont().getStyle() | 1));
        this.settingsLabel.setText("<html><a href style=\"text-decoration: none\">Settings & Help</html>");
        this.settingsLabel.setToolTipText("Edit the general settings or see the basic help");
        this.settingsLabel.setHorizontalTextPosition(10);
        this.settingsLabel.setIconTextGap(-4);
        this.settingsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WelcomeDialog.this.settingsLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                WelcomeDialog.this.settingsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WelcomeDialog.this.settingsLabelMouseExited(evt);
            }
        });
        this.lowMemoryWarningLabel.setFont(this.lowMemoryWarningLabel.getFont().deriveFont(this.lowMemoryWarningLabel.getFont().getStyle() | 1));
        this.lowMemoryWarningLabel.setForeground(new Color(255, 0, 0));
        this.lowMemoryWarningLabel.setText("<html>Low Memory Warning!</html>");
        this.lowMemoryWarningLabel.setToolTipText("Click to see details");
        this.lowMemoryWarningLabel.setHorizontalTextPosition(10);
        this.lowMemoryWarningLabel.setIconTextGap(-4);
        this.lowMemoryWarningLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                WelcomeDialog.this.lowMemoryWarningLabelMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                WelcomeDialog.this.lowMemoryWarningLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                WelcomeDialog.this.lowMemoryWarningLabelMouseExited(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(27, 27, 27).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.newJButton, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openJButton, -1, -1, Short.MAX_VALUE)).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.openExampleDatasetJButton, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gettingStartedJButton1, -1, -1, Short.MAX_VALUE)).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.searchJButton, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reshakeJButton, -1, 254, Short.MAX_VALUE))).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.settingsLabel, -2, -1, -2).addGap(92, 92, 92).addComponent(this.lowMemoryWarningLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.recentProjectsLabel, -2, -1, -2).addGap(19, 19, 19))).addGap(27, 27, 27)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.compomicsButton, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.probeButton, -2, 178, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isasButton, -2, 161, -2)).addComponent(this.jSeparator1, -2, 546, -2)).addGap(6, 6, 6)));
        backgroundPanelLayout.linkSize(0, this.compomicsButton, this.isasButton, this.probeButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(30, 30, 30).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newJButton, -2, 75, -2).addComponent(this.openJButton, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchJButton, -2, 75, -2).addComponent(this.reshakeJButton, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gettingStartedJButton1, -2, 75, -2).addComponent(this.openExampleDatasetJButton, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.recentProjectsLabel, -2, -1, -2).addComponent(this.settingsLabel, -2, -1, -2).addComponent(this.lowMemoryWarningLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.compomicsButton).addComponent(this.probeButton, -2, 65, -2).addComponent(this.isasButton)).addContainerGap(-1, Short.MAX_VALUE)));
        backgroundPanelLayout.linkSize(1, this.newJButton, this.openJButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void newJButtonActionPerformed(ActionEvent evt) {
        new NewDialog(this, this.peptideShakerGUI, true);
    }

    private void openJButtonActionPerformed(ActionEvent evt) {
        String psdbFileFilterDescription = "PeptideShaker Database (.psdb)";
        String zipFileFilterDescription = "Zipped PeptideShaker (.zip)";
        String lastSelectedFolderPath = this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".psdb", ".zip"}, (String[])new String[]{psdbFileFilterDescription, zipFileFilterDescription}, (String)"Open PeptideShaker Project", (String)lastSelectedFolderPath, null, (boolean)true, (boolean)false, (boolean)false, (int)0);
        if (selectedFileAndFilter != null) {
            File selectedFile = selectedFileAndFilter.getFile();
            this.peptideShakerGUI.getLastSelectedFolder().setLastSelectedFolder(selectedFile.getParent());
            if (selectedFile.getName().toLowerCase().endsWith(".zip")) {
                this.setVisible(false);
                this.peptideShakerGUI.setVisible(true);
                this.peptideShakerGUI.importPeptideShakerZipFile(selectedFile);
                this.dispose();
            } else if (selectedFile.getName().toLowerCase().endsWith(".psdb")) {
                this.setVisible(false);
                this.peptideShakerGUI.setVisible(true);
                this.peptideShakerGUI.importPeptideShakerFile(selectedFile, false);
                this.peptideShakerGUI.getUserParameters().addRecentProject(selectedFile);
                this.peptideShakerGUI.updateRecentProjectsList();
                LastSelectedFolder lastSelectedFolder = this.peptideShakerGUI.getLastSelectedFolder();
                lastSelectedFolder.setLastSelectedFolder(selectedFile.getAbsolutePath());
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "Not a PeptideShaker file (.psdb).", "Unsupported File.", 2);
            }
        }
    }

    private void compomicsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void compomicsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void compomicsButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://compomics.com");
        this.setCursor(new Cursor(0));
    }

    private void probeButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void probeButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void probeButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"http://probe.uib.no");
        this.setCursor(new Cursor(0));
    }

    private void isasButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void isasButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void isasButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.isas.de");
        this.setCursor(new Cursor(0));
    }

    private void searchJButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.peptideShakerGUI.setVisible(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ToolFactory.startSearchGUI((JFrame)DUMMY_PARENT_FRAME, null, null, null, null, null, null, null, null, null);
                    WelcomeDialog.this.peptideShakerGUI.close();
                }
                catch (Exception e) {
                    WelcomeDialog.this.peptideShakerGUI.catchException(e);
                }
            }
        }, "StartSearchGUI").start();
    }

    private void quantifyJButtonActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "In development. Coming soon...", "In Developement...", 1, new ImageIcon(this.getClass().getResource("/icons/reporter_logo.png")));
    }

    private void recentProjectsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void recentProjectsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void recentProjectsLabelMouseClicked(MouseEvent evt) {
        JPopupMenu popupMenu = new JPopupMenu();
        this.peptideShakerGUI.loadRecentProjectsList(popupMenu, this);
        popupMenu.show(this.recentProjectsLabel, evt.getX(), evt.getY());
    }

    private void reshakeJButtonActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (WelcomeDialog.this.peptideShakerGUI.getUtilitiesUserParameters().getSearchGuiPath() == null || !new File(WelcomeDialog.this.peptideShakerGUI.getUtilitiesUserParameters().getSearchGuiPath()).exists()) {
                    try {
                        SearchGuiSetupDialog searchGuiSetupDialog = new SearchGuiSetupDialog((JDialog)WelcomeDialog.this, true);
                        boolean canceled = searchGuiSetupDialog.isDialogCanceled();
                        if (!canceled) {
                            WelcomeDialog.this.setCursor(new Cursor(3));
                            WelcomeDialog.this.setVisible(false);
                            new PrideReshakeGUI(WelcomeDialog.this.peptideShakerGUI);
                            WelcomeDialog.this.setCursor(new Cursor(0));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    boolean newVersion = WelcomeDialog.this.checkForNewSearchGUIVersion(WelcomeDialog.this.peptideShakerGUI.getUtilitiesUserParameters().getSearchGuiPath());
                    boolean openReshake = true;
                    if (newVersion) {
                        int option = JOptionPane.showConfirmDialog(null, "A newer version of SearchGUI is available.\nDo you want to update?", "Update Available", 1);
                        if (option == 0) {
                            boolean success = WelcomeDialog.this.downloadSearchGUI();
                            if (success) {
                                WelcomeDialog.this.peptideShakerGUI.setUtilitiesUserParameters(UtilitiesUserParameters.loadUserParameters());
                            } else {
                                openReshake = false;
                            }
                        } else if (option == 2 || option == -1) {
                            openReshake = false;
                        }
                    }
                    if (openReshake) {
                        WelcomeDialog.this.setCursor(new Cursor(3));
                        WelcomeDialog.this.setVisible(false);
                        new PrideReshakeGUI(WelcomeDialog.this.peptideShakerGUI);
                        WelcomeDialog.this.setCursor(new Cursor(0));
                    }
                }
            }
        }, "Reshake").start();
    }

    private void gettingStartedJButton1ActionPerformed(ActionEvent evt) {
        new GettingStartedDialog(this.peptideShakerGUI, this, true);
    }

    private void openExampleDatasetJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        this.setVisible(false);
        this.peptideShakerGUI.setVisible(true);
        this.dispose();
        this.peptideShakerGUI.openExampleFile();
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
        this.peptideShakerGUI.close();
    }

    private void settingsLabelMouseClicked(MouseEvent evt) {
        this.settingsPopupMenu.show(this.settingsLabel, evt.getX(), evt.getY());
    }

    private void settingsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void settingsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchGUISettingsMenuItemActionPerformed(ActionEvent evt) {
        try {
            new SearchGuiSetupDialog((JFrame)this.peptideShakerGUI, true);
            this.peptideShakerGUI.loadUserParameters();
        }
        catch (Exception ex) {
            this.peptideShakerGUI.catchException(ex);
        }
    }

    private void javaSettingsMenuItemActionPerformed(ActionEvent evt) {
        new JavaParametersDialog((JFrame)DUMMY_PARENT_FRAME, (JavaHomeOrMemoryDialogParent)this.peptideShakerGUI, (JDialog)this, "PeptideShaker", true);
    }

    private void gettingStartedMenuItemActionPerformed(ActionEvent evt) {
        this.gettingStartedJButton1ActionPerformed(null);
    }

    private void bugReportMenuItemActionPerformed(ActionEvent evt) {
        new BugReport((JDialog)this, this.peptideShakerGUI.getLastSelectedFolder(), "PeptideShaker", "peptide-shaker", PeptideShaker.getVersion(), "peptide-shaker", "PeptideShaker", new File(PeptideShaker.getConfigFolder() + "/resources/PeptideShaker.log"));
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/AboutPeptideShaker.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "About PeptideShaker");
    }

    private void lowMemoryWarningLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void lowMemoryWarningLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void lowMemoryWarningLabelMouseReleased(MouseEvent evt) {
        new JavaParametersDialog((JFrame)DUMMY_PARENT_FRAME, (JavaHomeOrMemoryDialogParent)this.peptideShakerGUI, (JDialog)this, "PeptideShaker", true);
    }

    private void pathSettingsMenuActionPerformed(ActionEvent evt) {
        this.peptideShakerGUI.editPathSettings(this);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            ((DummyFrame)this.getParent()).dispose();
        }
    }

    @Override
    public void setIconImage(Image image) {
        super.setIconImage(image);
        DUMMY_PARENT_FRAME.setIconImage(image);
    }

    public boolean checkForNewSearchGUIVersion(String searchGuiJarPath) {
        try {
            File jarFile = new File(searchGuiJarPath);
            MavenJarFile oldMavenJarFile = new MavenJarFile(jarFile.toURI());
            URL jarRepository = new URL("https", "genesis.ugent.be", "/archiva/repository/maven2/");
            return WebDAO.newVersionReleased((MavenJarFile)oldMavenJarFile, (URL)jarRepository);
        }
        catch (UnknownHostException ex) {
            System.out.println("Checking for new version failed. No internet connection.");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean downloadSearchGUI() {
        File downloadFolder;
        boolean firstTimeInstall = true;
        String installPath = null;
        UtilitiesUserParameters utilitiesUserPreferences = this.peptideShakerGUI.getUtilitiesUserParameters();
        if (utilitiesUserPreferences.getSearchGuiPath() != null && new File(utilitiesUserPreferences.getSearchGuiPath()).getParentFile() != null && new File(utilitiesUserPreferences.getSearchGuiPath()).getParentFile().getParentFile() != null) {
            installPath = new File(utilitiesUserPreferences.getSearchGuiPath()).getParentFile().getParent();
        }
        if (installPath == null) {
            installPath = "user.home";
            downloadFolder = FileChooserUtil.getUserSelectedFolder((Component)this, (String)"Select SearchGUI Folder", (String)installPath, (String)"SearchGUI Folder", (String)"Select", (boolean)false);
        } else {
            firstTimeInstall = false;
            downloadFolder = new File(installPath);
        }
        final boolean finalFirstTimeInstall = firstTimeInstall;
        if (downloadFolder != null) {
            this.progressDialog = new ProgressDialogX((Frame)DUMMY_PARENT_FRAME, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Downloading SearchGUI. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WelcomeDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            Thread thread = new Thread("DownloadThread"){

                @Override
                public void run() {
                    try {
                        URL jarRepository = new URL("http", "genesis.ugent.be", "/maven2/");
                        if (finalFirstTimeInstall) {
                            DownloadLatestZipFromRepo.downloadLatestZipFromRepo((File)downloadFolder, (String)"SearchGUI", (String)"eu.isas.searchgui", (String)"SearchGUI", (String)"searchgui.ico", null, (URL)jarRepository, (boolean)false, (boolean)true, (FileDAO)new GUIFileDAO(), (WaitingHandler)WelcomeDialog.this.progressDialog);
                        } else {
                            DownloadLatestZipFromRepo.downloadLatestZipFromRepo((URL)new File(WelcomeDialog.this.peptideShakerGUI.getUtilitiesUserParameters().getSearchGuiPath()).toURI().toURL(), (String)"SearchGUI", (boolean)false, (String)"searchgui.ico", null, (URL)jarRepository, (boolean)false, (boolean)true, (FileDAO)new GUIFileDAO(), (WaitingHandler)WelcomeDialog.this.progressDialog);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.progressDialog.isRunCanceled()) {
                this.progressDialog.setRunFinished();
                return false;
            }
            if (!this.progressDialog.isRunFinished()) {
                this.progressDialog.setRunFinished();
            }
            return true;
        }
        return false;
    }
}

