/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.io.biology.protein.ProteinDatabase;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AnnotationPanel
extends JPanel {
    private String currentAccessionNumber = "";
    private final PeptideShakerGUI peptideShakerGUI;
    private static ProgressDialogX progressDialog;
    private JTextField accessionNumberJTextField;
    private JLabel accessionNumberLabel;
    private JPanel basicAnnotationJPanel;
    private JTextField chromosomeJTextField;
    private JLabel chromosomeLabel;
    private JLabel dastyLabel;
    private JPanel dastyLinkJPanel;
    private JTextField databaseJTextField;
    private JLabel databaseLabel;
    private JLabel davidLabel;
    private JPanel davidLinkJPanel;
    private JLabel descriptionLabel;
    private JTextField geneNameJTextField;
    private JLabel geneNameLabel;
    private JEditorPane helpEditorPane;
    private JPanel helpPanel;
    private JScrollPane helpScrollPane;
    private JPanel intActLinkJPanel;
    private JLabel intactLabel;
    private JLabel interProLabel;
    private JPanel interProLinkJPanel;
    private JButton loadDastyJButton;
    private JButton loadDavidJButton;
    private JButton loadIntActJButton;
    private JButton loadInterProJButton;
    private JButton loadNextProtJButton;
    private JButton loadPdbJButton;
    private JButton loadQuickGOJButton;
    private JButton loadReactomeJButton;
    private JButton loadStringJButton;
    private JButton loadUniProtJButton;
    private JLabel nextProtLabel;
    private JPanel nextProtLinkJPanel;
    private JLabel pdbLabel;
    private JPanel pdbLinkJPanel;
    private JLabel picrLinkJLabel;
    private JScrollPane proteinDescriptionScrollPane;
    private JTextArea proteinDescriptionTextArea;
    private JPanel quickGOLinkJPanel;
    private JLabel quickGoLabel;
    private JLabel reactomeLabel;
    private JPanel reactomeLinkJPanel;
    private JLabel stringLabel;
    private JPanel stringLinkJPanel;
    private JTextField taxonomyJTextField;
    private JLabel texonomyLabel;
    private JLabel uniprotLabel;
    private JPanel uniprotLinkJPanel;
    private JLabel webDastyLabel;
    private JLabel webDavidLabel;
    private JLabel webIntActLabel;
    private JLabel webInterProLabel;
    private JLabel webNextProtLabel;
    private JLabel webPdbLabel;
    private JLabel webQuickGOLabel;
    private JLabel webReactomeLabel;
    private JLabel webStringLabel;
    private JLabel webUniProtLabel;

    public AnnotationPanel(PeptideShakerGUI peptideShakerGUI) {
        this.initComponents();
        this.peptideShakerGUI = peptideShakerGUI;
    }

    private void initComponents() {
        this.basicAnnotationJPanel = new JPanel();
        this.accessionNumberLabel = new JLabel();
        this.accessionNumberJTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.geneNameLabel = new JLabel();
        this.geneNameJTextField = new JTextField();
        this.texonomyLabel = new JLabel();
        this.taxonomyJTextField = new JTextField();
        this.databaseLabel = new JLabel();
        this.databaseJTextField = new JTextField();
        this.proteinDescriptionScrollPane = new JScrollPane();
        this.proteinDescriptionTextArea = new JTextArea();
        this.chromosomeLabel = new JLabel();
        this.chromosomeJTextField = new JTextField();
        this.uniprotLinkJPanel = new JPanel();
        this.uniprotLabel = new JLabel();
        this.loadUniProtJButton = new JButton();
        this.webUniProtLabel = new JLabel();
        this.dastyLinkJPanel = new JPanel();
        this.dastyLabel = new JLabel();
        this.loadDastyJButton = new JButton();
        this.webDastyLabel = new JLabel();
        this.reactomeLinkJPanel = new JPanel();
        this.reactomeLabel = new JLabel();
        this.loadReactomeJButton = new JButton();
        this.webReactomeLabel = new JLabel();
        this.stringLinkJPanel = new JPanel();
        this.stringLabel = new JLabel();
        this.loadStringJButton = new JButton();
        this.webStringLabel = new JLabel();
        this.davidLinkJPanel = new JPanel();
        this.davidLabel = new JLabel();
        this.loadDavidJButton = new JButton();
        this.webDavidLabel = new JLabel();
        this.intActLinkJPanel = new JPanel();
        this.intactLabel = new JLabel();
        this.loadIntActJButton = new JButton();
        this.webIntActLabel = new JLabel();
        this.quickGOLinkJPanel = new JPanel();
        this.quickGoLabel = new JLabel();
        this.loadQuickGOJButton = new JButton();
        this.webQuickGOLabel = new JLabel();
        this.interProLinkJPanel = new JPanel();
        this.interProLabel = new JLabel();
        this.loadInterProJButton = new JButton();
        this.webInterProLabel = new JLabel();
        this.helpPanel = new JPanel();
        this.helpScrollPane = new JScrollPane();
        this.helpEditorPane = new JEditorPane();
        this.picrLinkJLabel = new JLabel();
        this.nextProtLinkJPanel = new JPanel();
        this.nextProtLabel = new JLabel();
        this.loadNextProtJButton = new JButton();
        this.webNextProtLabel = new JLabel();
        this.pdbLinkJPanel = new JPanel();
        this.pdbLabel = new JLabel();
        this.loadPdbJButton = new JButton();
        this.webPdbLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.basicAnnotationJPanel.setBorder(BorderFactory.createTitledBorder(null, "Basic Protein Annotation", 0, 0, new Font("sansserif", 1, 14)));
        this.basicAnnotationJPanel.setOpaque(false);
        this.accessionNumberLabel.setText("Accession");
        this.accessionNumberJTextField.setEditable(false);
        this.descriptionLabel.setText("Description");
        this.geneNameLabel.setText("Gene Name");
        this.geneNameJTextField.setEditable(false);
        this.texonomyLabel.setText("Taxonomy");
        this.taxonomyJTextField.setEditable(false);
        this.databaseLabel.setText("Database");
        this.databaseJTextField.setEditable(false);
        this.proteinDescriptionTextArea.setEditable(false);
        this.proteinDescriptionTextArea.setColumns(20);
        this.proteinDescriptionTextArea.setLineWrap(true);
        this.proteinDescriptionTextArea.setRows(2);
        this.proteinDescriptionTextArea.setTabSize(4);
        this.proteinDescriptionTextArea.setWrapStyleWord(true);
        this.proteinDescriptionScrollPane.setViewportView(this.proteinDescriptionTextArea);
        this.chromosomeLabel.setText("Chromosome");
        this.chromosomeJTextField.setEditable(false);
        this.chromosomeJTextField.setHorizontalAlignment(0);
        GroupLayout basicAnnotationJPanelLayout = new GroupLayout(this.basicAnnotationJPanel);
        this.basicAnnotationJPanel.setLayout(basicAnnotationJPanelLayout);
        basicAnnotationJPanelLayout.setHorizontalGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicAnnotationJPanelLayout.createSequentialGroup().addContainerGap().addGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.accessionNumberLabel).addComponent(this.descriptionLabel).addComponent(this.geneNameLabel).addComponent(this.texonomyLabel).addComponent(this.databaseLabel)).addGap(38, 38, 38).addGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.accessionNumberJTextField, GroupLayout.Alignment.TRAILING, -1, 494, Short.MAX_VALUE).addComponent(this.proteinDescriptionScrollPane).addComponent(this.taxonomyJTextField).addComponent(this.databaseJTextField).addGroup(basicAnnotationJPanelLayout.createSequentialGroup().addComponent(this.geneNameJTextField).addGap(18, 18, 18).addComponent(this.chromosomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chromosomeJTextField, -2, 131, -2))).addContainerGap()));
        basicAnnotationJPanelLayout.linkSize(0, this.accessionNumberLabel, this.descriptionLabel, this.texonomyLabel);
        basicAnnotationJPanelLayout.setVerticalGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicAnnotationJPanelLayout.createSequentialGroup().addContainerGap().addGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accessionNumberJTextField, -2, -1, -2).addComponent(this.accessionNumberLabel)).addGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicAnnotationJPanelLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.descriptionLabel).addGap(25, 25, 25)).addComponent(this.proteinDescriptionScrollPane, GroupLayout.Alignment.TRAILING, -2, 53, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.geneNameJTextField, -2, -1, -2).addComponent(this.geneNameLabel).addComponent(this.chromosomeLabel).addComponent(this.chromosomeJTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taxonomyJTextField, -2, -1, -2).addComponent(this.texonomyLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicAnnotationJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseJTextField, -2, -1, -2).addComponent(this.databaseLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.uniprotLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "UniProt - protein knowledgebase", 0, 0, new Font("sansserif", 1, 14)));
        this.uniprotLinkJPanel.setOpaque(false);
        this.uniprotLabel.setText("High-quality protein sequence and functional information.");
        this.loadUniProtJButton.setText("Search UniProt");
        this.loadUniProtJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadUniProtJButtonActionPerformed(evt);
            }
        });
        this.webUniProtLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webUniProtLabel.setToolTipText("Open the UniProt web page");
        this.webUniProtLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webUniProtLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webUniProtLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webUniProtLabelMouseExited(evt);
            }
        });
        GroupLayout uniprotLinkJPanelLayout = new GroupLayout(this.uniprotLinkJPanel);
        this.uniprotLinkJPanel.setLayout(uniprotLinkJPanelLayout);
        uniprotLinkJPanelLayout.setHorizontalGroup(uniprotLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(uniprotLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadUniProtJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.uniprotLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.webUniProtLabel, -2, -1, -2).addContainerGap()));
        uniprotLinkJPanelLayout.setVerticalGroup(uniprotLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(uniprotLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(uniprotLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadUniProtJButton).addComponent(this.uniprotLabel).addComponent(this.webUniProtLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.dastyLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "DASty - protein sequence features", 0, 0, new Font("sansserif", 1, 14)));
        this.dastyLinkJPanel.setOpaque(false);
        this.dastyLabel.setText("Web client for visualizing protein sequence feature information.");
        this.loadDastyJButton.setText("Search DASty");
        this.loadDastyJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadDastyJButtonActionPerformed(evt);
            }
        });
        this.webDastyLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webDastyLabel.setToolTipText("Open the DASty web page");
        this.webDastyLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webDastyLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webDastyLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webDastyLabelMouseExited(evt);
            }
        });
        GroupLayout dastyLinkJPanelLayout = new GroupLayout(this.dastyLinkJPanel);
        this.dastyLinkJPanel.setLayout(dastyLinkJPanelLayout);
        dastyLinkJPanelLayout.setHorizontalGroup(dastyLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dastyLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadDastyJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.dastyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.webDastyLabel, -2, -1, -2).addContainerGap()));
        dastyLinkJPanelLayout.setVerticalGroup(dastyLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dastyLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(dastyLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadDastyJButton, -1, -1, Short.MAX_VALUE).addComponent(this.dastyLabel).addComponent(this.webDastyLabel, -2, -1, -2)).addContainerGap()));
        this.reactomeLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "Reactome - pathway database", 0, 0, new Font("sansserif", 1, 14)));
        this.reactomeLinkJPanel.setOpaque(false);
        this.reactomeLabel.setText("Manually curated and peer-reviewed pathway database.");
        this.loadReactomeJButton.setText("Search Reactome");
        this.loadReactomeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadReactomeJButtonActionPerformed(evt);
            }
        });
        this.webReactomeLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webReactomeLabel.setToolTipText("Open the Reactome web page");
        this.webReactomeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webReactomeLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webReactomeLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webReactomeLabelMouseExited(evt);
            }
        });
        GroupLayout reactomeLinkJPanelLayout = new GroupLayout(this.reactomeLinkJPanel);
        this.reactomeLinkJPanel.setLayout(reactomeLinkJPanelLayout);
        reactomeLinkJPanelLayout.setHorizontalGroup(reactomeLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reactomeLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadReactomeJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.reactomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.webReactomeLabel, -2, -1, -2).addContainerGap()));
        reactomeLinkJPanelLayout.setVerticalGroup(reactomeLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reactomeLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(reactomeLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reactomeLabel).addComponent(this.loadReactomeJButton).addComponent(this.webReactomeLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.stringLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "STRING - protein interaction", 0, 0, new Font("sansserif", 1, 14)));
        this.stringLinkJPanel.setOpaque(false);
        this.stringLabel.setText("Known and Predicted Protein-Protein Interactions.");
        this.loadStringJButton.setText("Search STRING");
        this.loadStringJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadStringJButtonActionPerformed(evt);
            }
        });
        this.webStringLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webStringLabel.setToolTipText("Open the STRING web page");
        this.webStringLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webStringLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webStringLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webStringLabelMouseExited(evt);
            }
        });
        GroupLayout stringLinkJPanelLayout = new GroupLayout(this.stringLinkJPanel);
        this.stringLinkJPanel.setLayout(stringLinkJPanelLayout);
        stringLinkJPanelLayout.setHorizontalGroup(stringLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(stringLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadStringJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.stringLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 178, Short.MAX_VALUE).addComponent(this.webStringLabel, -2, -1, -2).addContainerGap()));
        stringLinkJPanelLayout.setVerticalGroup(stringLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(stringLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(stringLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stringLabel).addComponent(this.loadStringJButton).addComponent(this.webStringLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.davidLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "DAVID - functional annotation", 0, 0, new Font("sansserif", 1, 14)));
        this.davidLinkJPanel.setOpaque(false);
        this.davidLabel.setText("Database for Annotation, Visualization and Integrated Discovery.");
        this.loadDavidJButton.setText("Search DAVID");
        this.loadDavidJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadDavidJButtonActionPerformed(evt);
            }
        });
        this.webDavidLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webDavidLabel.setToolTipText("Open the DAVID web page");
        this.webDavidLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webDavidLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webDavidLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webDavidLabelMouseExited(evt);
            }
        });
        GroupLayout davidLinkJPanelLayout = new GroupLayout(this.davidLinkJPanel);
        this.davidLinkJPanel.setLayout(davidLinkJPanelLayout);
        davidLinkJPanelLayout.setHorizontalGroup(davidLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(davidLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadDavidJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.davidLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.webDavidLabel, -2, -1, -2).addContainerGap()));
        davidLinkJPanelLayout.setVerticalGroup(davidLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(davidLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(davidLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.davidLabel).addComponent(this.loadDavidJButton).addComponent(this.webDavidLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.intActLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "IntAct - protein interaction", 0, 0, new Font("sansserif", 1, 14)));
        this.intActLinkJPanel.setOpaque(false);
        this.intactLabel.setText("Analysis tools for protein interaction data.");
        this.loadIntActJButton.setText("Search IntAct");
        this.loadIntActJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadIntActJButtonActionPerformed(evt);
            }
        });
        this.webIntActLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webIntActLabel.setToolTipText("Open the IntAct web page");
        this.webIntActLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webIntActLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webIntActLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webIntActLabelMouseExited(evt);
            }
        });
        GroupLayout intActLinkJPanelLayout = new GroupLayout(this.intActLinkJPanel);
        this.intActLinkJPanel.setLayout(intActLinkJPanelLayout);
        intActLinkJPanelLayout.setHorizontalGroup(intActLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intActLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadIntActJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.intactLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.webIntActLabel, -2, -1, -2).addContainerGap()));
        intActLinkJPanelLayout.setVerticalGroup(intActLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intActLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(intActLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.intactLabel).addComponent(this.loadIntActJButton).addComponent(this.webIntActLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.quickGOLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "QuickGO - gene ontology terms and annotations", 0, 0, new Font("sansserif", 1, 14)));
        this.quickGOLinkJPanel.setOpaque(false);
        this.quickGoLabel.setText("Web-based browser for Gene Ontology terms.");
        this.loadQuickGOJButton.setText("Search QuickGO");
        this.loadQuickGOJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadQuickGOJButtonActionPerformed(evt);
            }
        });
        this.webQuickGOLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webQuickGOLabel.setToolTipText("Open the QuickGO web page");
        this.webQuickGOLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webQuickGOLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webQuickGOLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webQuickGOLabelMouseExited(evt);
            }
        });
        GroupLayout quickGOLinkJPanelLayout = new GroupLayout(this.quickGOLinkJPanel);
        this.quickGOLinkJPanel.setLayout(quickGOLinkJPanelLayout);
        quickGOLinkJPanelLayout.setHorizontalGroup(quickGOLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quickGOLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadQuickGOJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.quickGoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 196, Short.MAX_VALUE).addComponent(this.webQuickGOLabel, -2, -1, -2).addContainerGap()));
        quickGOLinkJPanelLayout.setVerticalGroup(quickGOLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quickGOLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(quickGOLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.quickGoLabel).addComponent(this.loadQuickGOJButton).addComponent(this.webQuickGOLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.interProLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "InterPro - predictive protein signatures", 0, 0, new Font("sansserif", 1, 14)));
        this.interProLinkJPanel.setOpaque(false);
        this.interProLabel.setText("Integrated database of predictive protein signatures.");
        this.loadInterProJButton.setText("Search InterPro");
        this.loadInterProJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadInterProJButtonActionPerformed(evt);
            }
        });
        this.webInterProLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webInterProLabel.setToolTipText("Open the InterPro web page");
        this.webInterProLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webInterProLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webInterProLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webInterProLabelMouseExited(evt);
            }
        });
        GroupLayout interProLinkJPanelLayout = new GroupLayout(this.interProLinkJPanel);
        this.interProLinkJPanel.setLayout(interProLinkJPanelLayout);
        interProLinkJPanelLayout.setHorizontalGroup(interProLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(interProLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadInterProJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.interProLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.webInterProLabel, -2, -1, -2).addContainerGap()));
        interProLinkJPanelLayout.setVerticalGroup(interProLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(interProLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(interProLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.interProLabel).addComponent(this.loadInterProJButton).addComponent(this.webInterProLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpPanel.setBorder(BorderFactory.createTitledBorder(null, "Protein Annotation - Help", 0, 0, new Font("sansserif", 1, 14)));
        this.helpPanel.setOpaque(false);
        this.helpScrollPane.setBorder(null);
        this.helpScrollPane.setHorizontalScrollBarPolicy(31);
        this.helpScrollPane.setVerticalScrollBarPolicy(21);
        this.helpEditorPane.setEditable(false);
        this.helpEditorPane.setContentType("text/html");
        this.helpEditorPane.setText("<html>\n<b>Single Protein</b><br>\nTo access the annotations for the currently selected protein, simply click the button corresponding to the \nwanted resource.\n<br><br>\n<b>Multiple Proteins</b><br>\nTo get the list of all validated proteins in your project click <a href=\"validated_proteins\">here</a>.<br>\nAdvanced export options: <i>Export</i> > <i>Identification Features</i>. \n<br><br>\nTo querry using multiple proteins, click the <a href=\"dummy_link\">web</a> link next to the resource and \nfollow the instructions provided at the resource web page.\n</html>");
        this.helpEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AnnotationPanel.this.helpEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.helpScrollPane.setViewportView(this.helpEditorPane);
        GroupLayout helpPanelLayout = new GroupLayout(this.helpPanel);
        this.helpPanel.setLayout(helpPanelLayout);
        helpPanelLayout.setHorizontalGroup(helpPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(helpPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.helpScrollPane, -2, 481, -2).addContainerGap(-1, Short.MAX_VALUE)));
        helpPanelLayout.setVerticalGroup(helpPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(helpPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.helpScrollPane).addContainerGap()));
        this.picrLinkJLabel.setText("<html><a href=\\\"dummy_link\\\">PICR - Protein Identifier Cross-Reference Service</a></html>");
        this.picrLinkJLabel.setToolTipText("<html>\nMap protein identifiers across<br>\nmultiple source databases\n</html>");
        this.picrLinkJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.picrLinkJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.picrLinkJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.picrLinkJLabelMouseExited(evt);
            }
        });
        this.nextProtLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "neXtProt - human protein knowledgebase", 0, 0, new Font("sansserif", 1, 14)));
        this.nextProtLinkJPanel.setOpaque(false);
        this.nextProtLabel.setText("High-quality human protein information and annotation.");
        this.loadNextProtJButton.setText("Search neXtProt");
        this.loadNextProtJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadNextProtJButtonActionPerformed(evt);
            }
        });
        this.webNextProtLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webNextProtLabel.setToolTipText("Open the neXtProt web page");
        this.webNextProtLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webNextProtLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webNextProtLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webNextProtLabelMouseExited(evt);
            }
        });
        GroupLayout nextProtLinkJPanelLayout = new GroupLayout(this.nextProtLinkJPanel);
        this.nextProtLinkJPanel.setLayout(nextProtLinkJPanelLayout);
        nextProtLinkJPanelLayout.setHorizontalGroup(nextProtLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nextProtLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadNextProtJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.nextProtLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.webNextProtLabel, -2, -1, -2).addContainerGap()));
        nextProtLinkJPanelLayout.setVerticalGroup(nextProtLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nextProtLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(nextProtLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadNextProtJButton).addComponent(this.nextProtLabel).addComponent(this.webNextProtLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pdbLinkJPanel.setBorder(BorderFactory.createTitledBorder(null, "PDB - protein data bank", 0, 0, new Font("sansserif", 1, 14)));
        this.pdbLinkJPanel.setOpaque(false);
        this.pdbLabel.setText("Biological macromolecular resource.");
        this.loadPdbJButton.setText("Search PDB");
        this.loadPdbJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationPanel.this.loadPdbJButtonActionPerformed(evt);
            }
        });
        this.webPdbLabel.setText("<html> <a href=\\\"dummy_link\">web</a></html>");
        this.webPdbLabel.setToolTipText("Open the PDB web page");
        this.webPdbLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AnnotationPanel.this.webPdbLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AnnotationPanel.this.webPdbLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AnnotationPanel.this.webPdbLabelMouseExited(evt);
            }
        });
        GroupLayout pdbLinkJPanelLayout = new GroupLayout(this.pdbLinkJPanel);
        this.pdbLinkJPanel.setLayout(pdbLinkJPanelLayout);
        pdbLinkJPanelLayout.setHorizontalGroup(pdbLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pdbLinkJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loadPdbJButton, -2, 130, -2).addGap(18, 18, 18).addComponent(this.pdbLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 240, Short.MAX_VALUE).addComponent(this.webPdbLabel, -2, -1, -2).addContainerGap()));
        pdbLinkJPanelLayout.setVerticalGroup(pdbLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pdbLinkJPanelLayout.createSequentialGroup().addContainerGap().addGroup(pdbLinkJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pdbLabel).addComponent(this.loadPdbJButton).addComponent(this.webPdbLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.picrLinkJLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.nextProtLinkJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.uniprotLinkJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.basicAnnotationJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.quickGOLinkJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.stringLinkJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.dastyLinkJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.helpPanel, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pdbLinkJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.reactomeLinkJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.davidLinkJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.intActLinkJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.interProLinkJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.basicAnnotationJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.helpPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.reactomeLinkJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.davidLinkJPanel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.uniprotLinkJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextProtLinkJPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.stringLinkJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.quickGOLinkJPanel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.intActLinkJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.interProLinkJPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dastyLinkJPanel, -2, -1, -2).addComponent(this.pdbLinkJPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.picrLinkJLabel, -2, -1, -2).addContainerGap(124, Short.MAX_VALUE)));
    }

    private void loadDastyJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://www.ebi.ac.uk/dasty/client/index.html?q=" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void loadUniProtJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://www.uniprot.org/uniprot/" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void loadReactomeJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://www.reactome.org/cgi-bin/link?SOURCE=UNIPROT&ID=" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void loadStringJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://string-db.org/newstring_cgi/show_input_page.pl?identifier=" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void loadDavidJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://david.abcc.ncifcrf.gov/api.jsp?type=UNIPROT_ACCESSION&ids=" + this.accessionNumberJTextField.getText() + "&tool=summary"));
        this.setCursor(new Cursor(0));
    }

    private void loadIntActJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://www.ebi.ac.uk/intact/pages/interactions/interactions.xhtml?query=" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void loadQuickGOJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://www.ebi.ac.uk/QuickGO/annotations?geneProductId=" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void loadInterProJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://www.ebi.ac.uk/interpro/ISearch?query=" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void webDastyLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.ebi.ac.uk/dasty");
        this.setCursor(new Cursor(0));
    }

    private void webDastyLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webDastyLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void webUniProtLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.uniprot.org");
        this.setCursor(new Cursor(0));
    }

    private void webUniProtLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webUniProtLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void webReactomeLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.reactome.org");
        this.setCursor(new Cursor(0));
    }

    private void webReactomeLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webReactomeLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void webStringLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://string-db.org");
        this.setCursor(new Cursor(0));
    }

    private void webStringLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webStringLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void webQuickGOLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.ebi.ac.uk/QuickGO");
        this.setCursor(new Cursor(0));
    }

    private void webQuickGOLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webQuickGOLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void webInterProLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.ebi.ac.uk/interpro");
        this.setCursor(new Cursor(0));
    }

    private void webInterProLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webInterProLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void webIntActLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.ebi.ac.uk/intact");
        this.setCursor(new Cursor(0));
    }

    private void webIntActLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webIntActLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString()) && evt.getDescription().equalsIgnoreCase("validated_proteins")) {
            if (this.peptideShakerGUI.getIdentification() != null) {
                String excelFileFilterDescription = "Excel Workbook (.xls)";
                String textFileFilterDescription = "Tab separated text file (.txt)";
                String gzipFileFilterDescription = "Gzipped tab separated text file (.gz)";
                String lastSelectedFolderPath = this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
                FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".xls", ".txt", ".gz"}, (String[])new String[]{excelFileFilterDescription, textFileFilterDescription, gzipFileFilterDescription}, (String)"Export Report", (String)lastSelectedFolderPath, (String)"All Validated Proteins", (boolean)false, (boolean)true, (boolean)false, (int)1);
                if (selectedFileAndFilter != null) {
                    boolean gzip;
                    ExportFormat exportFormat;
                    final File selectedFile = selectedFileAndFilter.getFile();
                    if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription)) {
                        exportFormat = ExportFormat.text;
                        gzip = false;
                    } else if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(gzipFileFilterDescription)) {
                        exportFormat = ExportFormat.text;
                        gzip = true;
                    } else {
                        exportFormat = ExportFormat.excel;
                        gzip = false;
                    }
                    progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                    progressDialog.setTitle("Exporting Data. Please Wait...");
                    final String filePath = selectedFile.getPath();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                progressDialog.setVisible(true);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                // empty catch block
                            }
                        }
                    }, "ProgressDialog").start();
                    new Thread("ExportThread"){

                        @Override
                        public void run() {
                            try {
                                HashMap exportFeatures = new HashMap();
                                ArrayList<PsProteinFeature> sectionContent = new ArrayList<PsProteinFeature>();
                                sectionContent.add(PsProteinFeature.accession);
                                exportFeatures.put("Protein Identification Summary", sectionContent);
                                ExportScheme validatedProteinReport = new ExportScheme("Validated Proteins", false, exportFeatures, "\t", false, false, 0, false, true, false);
                                PSExportFactory.writeExport(validatedProteinReport, selectedFile, exportFormat, gzip, AnnotationPanel.this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), AnnotationPanel.this.peptideShakerGUI.getProjectDetails(), AnnotationPanel.this.peptideShakerGUI.getIdentification(), AnnotationPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), AnnotationPanel.this.peptideShakerGUI.getGeneMaps(), null, null, null, AnnotationPanel.this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), AnnotationPanel.this.peptideShakerGUI.getIdentificationParameters(), AnnotationPanel.this.peptideShakerGUI.getSequenceProvider(), AnnotationPanel.this.peptideShakerGUI.getProteinDetailsProvider(), AnnotationPanel.this.peptideShakerGUI.getSpectrumProvider(), AnnotationPanel.this.peptideShakerGUI.getSpectrumCountingParameters(), (WaitingHandler)progressDialog);
                                boolean processCancelled = progressDialog.isRunCanceled();
                                progressDialog.setRunFinished();
                                if (!processCancelled) {
                                    JOptionPane.showMessageDialog(AnnotationPanel.this.peptideShakerGUI, "Data copied to file:\n" + filePath, "Data Exported.", 1);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                if (e.getMessage().contains("Invalid row number (65536)")) {
                                    progressDialog.setRunFinished();
                                    JOptionPane.showMessageDialog(AnnotationPanel.this.peptideShakerGUI, "An error occurred while generating the output. This format can contain only 65,535 lines.\nPlease use a text export instead.", "Output Error.", 0);
                                    e.printStackTrace();
                                } else {
                                    progressDialog.setRunFinished();
                                    JOptionPane.showMessageDialog(AnnotationPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", 0);
                                    e.printStackTrace();
                                }
                            }
                            catch (Exception e) {
                                progressDialog.setRunFinished();
                                JOptionPane.showMessageDialog(AnnotationPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", 0);
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            } else {
                JOptionPane.showMessageDialog(this.peptideShakerGUI, "You have to load a project first!", "No Project", 2);
            }
        }
    }

    private void webDavidLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void webDavidLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webDavidLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://david.abcc.ncifcrf.gov");
        this.setCursor(new Cursor(0));
    }

    private void picrLinkJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void picrLinkJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void picrLinkJLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.ebi.ac.uk/Tools/picr/");
        this.setCursor(new Cursor(0));
    }

    private void loadNextProtJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://www.nextprot.org/db/entry/NX_" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void webNextProtLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.nextprot.org/db/");
        this.setCursor(new Cursor(0));
    }

    private void webNextProtLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webNextProtLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void loadPdbJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)("https://www.rcsb.org/pdb/protein/" + this.accessionNumberJTextField.getText()));
        this.setCursor(new Cursor(0));
    }

    private void webPdbLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.rcsb.org/pdb/");
        this.setCursor(new Cursor(0));
    }

    private void webPdbLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void webPdbLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    public void updateBasicProteinAnnotation(String aAccessionNumber) {
        if (aAccessionNumber != null && !aAccessionNumber.equals(ExperimentObject.NO_KEY) && !this.currentAccessionNumber.equalsIgnoreCase(aAccessionNumber)) {
            this.currentAccessionNumber = aAccessionNumber;
            this.accessionNumberJTextField.setText(this.currentAccessionNumber);
            ProteinDetailsProvider proteinDetailsProvider = this.peptideShakerGUI.getProteinDetailsProvider();
            String simpleDescription = proteinDetailsProvider.getSimpleDescription(aAccessionNumber);
            String geneName = proteinDetailsProvider.getGeneName(aAccessionNumber);
            String taxonomy = proteinDetailsProvider.getTaxonomy(aAccessionNumber);
            ProteinDatabase proteinDatabase = proteinDetailsProvider.getProteinDatabase(aAccessionNumber);
            this.proteinDescriptionTextArea.setText(simpleDescription);
            this.geneNameJTextField.setText(geneName);
            if (geneName != null) {
                GeneMaps geneMaps = this.peptideShakerGUI.getGeneMaps();
                this.chromosomeJTextField.setText(geneMaps.getChromosome(geneName));
            } else {
                this.chromosomeJTextField.setText(null);
            }
            this.taxonomyJTextField.setText(taxonomy);
            this.databaseJTextField.setText(proteinDatabase.getFullName());
        }
    }
}

